//--   _____ _____ _______ _____   ____  ____ _____ _______ _____ 
//--  / ____|_   _|__   __|  __ \ / __ \|  _ \_   _|__   __/ ____|
//-- | |      | |    | |  | |__) | |  | | |_) || |    | | | (___  
//-- | |      | |    | |  |  _  /| |  | |  _ < | |    | |  \___ \ 
//-- | |____ _| |_   | |  | | \ \| |__| | |_) || |_   | |  ____) |
//--  \_____|_____|  |_|  |_|  \_\\____/|____/_____|  |_| |_____/ 
//--                                                              
//--
//-- The sample code is provided 'as is' and any express or implied warranties,
//-- including the implied warranties of merchantability and fitness for a particular
//-- purpose are disclaimed. in no event shall any contributors be liable for
//-- any direct, indirect, incidental, special, exemplary, or consequential damages
//-- (including, but not limited to, procurement of substitute goods or services;
//-- loss of use, data, or profits; or business interruption) sustained by you or a
//-- third party, however caused and on any theory of liability, whether in contract,
//-- strict liability, or tort arising in any way out of the use of this sample code,
//-- even if advised of the possibility of such damage.
//--
//-- Device:          Any FPGA
//-- Author:          
//-- Entity Name:     
//-- Purpose:         
//--
//-- Revision History:
//-- 
//-------------------------------------------------------------------------------- 
//-- Module Description:
//-- 
//--------------------------------------------------------------------------------

 
 `default_nettype none
 `timescale 1ps / 1ps
 
 
 module reset_gen #
 (
     parameter integer C_TIMER_CLK_CYCLES = 10000
 )
 (
    input   wire                              rst_i,
    input   wire                              clk_i,
    output   wire                             rst_o,
    output   wire                             rstn_o
 );


 
reg [31:0]                  reset_counter;
reg                         rst_int;
reg                         rstn_int;

initial 
begin
    reset_counter = 31'h0;
end  

assign rst_o    = rst_int;
assign rstn_o   = rstn_int;




 always @(posedge clk_i or posedge rst_i) begin
    if (rst_i) begin
        reset_counter   <= 0;
        rst_int           <= 1'b1;
        rstn_int          <= 1'b0;
        
    end else begin
        if (reset_counter == C_TIMER_CLK_CYCLES) begin
            rst_int           <= 1'b0;
            rstn_int          <= 1'b1;
        end else begin
            reset_counter <= reset_counter + 1;
            rst_int           <= 1'b1;
            rstn_int          <= 1'b0;
        end
    end
end


     

 endmodule
 
 `default_nettype wire
 