//--   _____ _____ _______ _____   ____  ____ _____ _______ _____ 
//--  / ____|_   _|__   __|  __ \ / __ \|  _ \_   _|__   __/ ____|
//-- | |      | |    | |  | |__) | |  | | |_) || |    | | | (___  
//-- | |      | |    | |  |  _  /| |  | |  _ < | |    | |  \___ \ 
//-- | |____ _| |_   | |  | | \ \| |__| | |_) || |_   | |  ____) |
//--  \_____|_____|  |_|  |_|  \_\\____/|____/_____|  |_| |_____/ 
//--                                                              
//--
//-- The sample code is provided 'as is' and any express or implied warranties,
//-- including the implied warranties of merchantability and fitness for a particular
//-- purpose are disclaimed. in no event shall any contributors be liable for
//-- any direct, indirect, incidental, special, exemplary, or consequential damages
//-- (including, but not limited to, procurement of substitute goods or services;
//-- loss of use, data, or profits; or business interruption) sustained by you or a
//-- third party, however caused and on any theory of liability, whether in contract,
//-- strict liability, or tort arising in any way out of the use of this sample code,
//-- even if advised of the possibility of such damage.
//--
//-- Device:          Any FPGA
//-- Author:          
//-- Entity Name:     
//-- Purpose:         
//--
//-- Revision History:
//-- 
//-------------------------------------------------------------------------------- 
//-- Module Description:
//-- 
//--------------------------------------------------------------------------------

`timescale 1ps / 1ps

module ref_design_riscv_top #
(
    parameter integer S_AXI_DATA_WIDTH_C    = 64,
    parameter integer CALIBRATION_MODE      = 1
)
(
    /* HyperBus Interface Port */
    output  wire                            hb_ck_p,
    output  wire                            hb_ck_n,
    output  wire                            hb_reset_n,
    output  wire                            hb_cs_n,
    inout   wire                            hb_rwds, 
    inout   wire [7:0]                      hb_dq,

    output  wire [9:0]                      led_o
);

    // Parameters
    localparam integer DONE_LED_POS_C   = 0;
    localparam integer ERROR_LED_POS_C  = 1;

    // Signals clk & rst
    wire                                    clk_hyperbus_0;
    wire                                    clk_hyperbus_90;
    wire                                    clk_hbmc_half;
    wire                                    clk_25M;
    wire                                    lf_clk;

    wire                                    hbmc_rst;
    wire                                    axi_rst;
    wire                                    axi_rstn;

    wire    [1:0]                           gpio_s;

    assign led_o[0] = gpio_s[DONE_LED_POS_C];
    assign led_o[1] = gpio_s[ERROR_LED_POS_C];
    assign led_o[2] = ~gpio_s[DONE_LED_POS_C];
    assign led_o[3] = ~gpio_s[ERROR_LED_POS_C];
    assign led_o[4] = ~gpio_s[DONE_LED_POS_C];
    assign led_o[5] = 1'b1;
    assign led_o[6] = 1'b1;
    assign led_o[7] = 1'b1;
    assign led_o[8] = ~gpio_s[ERROR_LED_POS_C];
    assign led_o[9] = 1'b1;

    reset_gen # (
        .C_TIMER_CLK_CYCLES(10000)
    )
    reset_gen_axi_inst (
        .rst_i      (1'b0),
        .clk_i      (clk_hbmc_half),
        .rst_o      (axi_rst),
        .rstn_o     (axi_rstn)
    );

    reset_gen # (
        .C_TIMER_CLK_CYCLES(10000)
    )
        reset_gen_hbmc_inst (
        .rst_i      (1'b0),
        .clk_i      (clk_hyperbus_0),
        .rst_o      (hbmc_rst),
        .rstn_o     ()
    );

    oscillator oscillator_inst(
        .hf_out_en_i(1'b1), 
        .hf_clk_out_o(clk_25M),
        .lf_clk_out_o(lf_clk));  /* synthesis syn_black_box syn_declare_black_box=1 */

    gen_pll gpll_inst (
        .clki_i(clk_25M), 
        .rstn_i(1'b1), 
        .clkop_o(clk_hyperbus_0),
        .clkos_o(clk_hyperbus_90),
        .clkos2_o(clk_hbmc_half),
        .lock_o());

    system system_inst (
        .clk_realtime_i             ( lf_clk            ), 
        .rstn_i                     ( axi_rstn          ), 
        .HYPERBUS_hb_dq_portbus     ( hb_dq             ), 
        .sys_clk_i                  ( clk_hbmc_half     ), 
        .reset_hbmc_i               ( hbmc_rst          ), 
        .clk_hbmc_0_i               ( clk_hyperbus_0    ), 
        .clk_hbmc_90_i              ( clk_hyperbus_90   ), 
        .hb_ck_n_o                  ( hb_ck_n           ), 
        .hbmc_init_done_o           (                   ), 
        .HYPERBUS_hb_ck_p_port      ( hb_ck_p           ), 
        .HYPERBUS_hb_cs_n_port      ( hb_cs_n           ), 
        .HYPERBUS_hb_reset_n_port   ( hb_reset_n        ), 
        .HYPERBUS_hb_rwds_port      ( hb_rwds           ),
        .gpio_o                     ( gpio_s            )
    );

endmodule