// >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
// ------------------------------------------------------------------
// Copyright (c) 2019-2025 by Lattice Semiconductor Corporation
// ALL RIGHTS RESERVED
// ------------------------------------------------------------------
//
// IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL
// DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.
//
// Lattice grants permission to use this code pursuant to the
// terms of the Lattice Propel License Agreement.
//
// DISCLAIMER:
//
//  LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER
//  EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE
//  PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE
//  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR
//  FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE
//  FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT
//  LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE
//  OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS
//  HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR 
//  SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE
//  PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE
//  ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE
//  OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL
//  ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR
//  ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
//  SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
//  INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST
//  PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF
//  LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S
//  SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE. 
//  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR
//  USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY
//  RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY
//  THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE
//  USE OF FORMAL SOFTWARE VALIDATION METHODS.
// ------------------------------------------------------------------

/* synthesis translate_off*/
`define SBP_SIMULATION
/* synthesis translate_on*/
`ifndef SBP_SIMULATION
`define SBP_SYNTHESIS
`endif



//
// Verific Verilog Description of module system
//
module system (HYPERBUS_hb_dq_portbus, gpio_o, HYPERBUS_hb_ck_p_port, 
            HYPERBUS_hb_cs_n_port, HYPERBUS_hb_reset_n_port, HYPERBUS_hb_rwds_port, 
            clk_hbmc_0_i, clk_hbmc_90_i, clk_realtime_i, hb_ck_n_o, 
            hbmc_init_done_o, reset_hbmc_i, rstn_i, sys_clk_i);
    inout [7:0]HYPERBUS_hb_dq_portbus;
    output [1:0]gpio_o;
    output HYPERBUS_hb_ck_p_port;
    output HYPERBUS_hb_cs_n_port;
    output HYPERBUS_hb_reset_n_port;
    inout HYPERBUS_hb_rwds_port;
    input clk_hbmc_0_i;
    input clk_hbmc_90_i;
    input clk_realtime_i;
    output hb_ck_n_o;
    output hbmc_init_done_o;
    input reset_hbmc_i;
    input rstn_i;
    input sys_clk_i;
    
    wire [31:0]ahbl_ic_inst_AHBL_M01_interconnect_HADDR;
    wire [2:0]ahbl_ic_inst_AHBL_M01_interconnect_HBURST;
    wire [2:0]ahbl_ic_inst_AHBL_M01_interconnect_HSIZE;
    wire [3:0]ahbl_ic_inst_AHBL_M01_interconnect_HPROT;
    wire [1:0]ahbl_ic_inst_AHBL_M01_interconnect_HTRANS;
    wire [31:0]ahbl_ic_inst_AHBL_M01_interconnect_HWDATA;
    wire [31:0]ahbl_ic_inst_AHBL_M01_interconnect_HRDATA;
    wire [31:0]ahbl2apb_inst_APB_M0_interconnect_PRDATA;
    wire [31:0]ahbl2apb_inst_APB_M0_interconnect_PADDR;
    wire [31:0]ahbl2apb_inst_APB_M0_interconnect_PWDATA;
    
    wire ahbl_ic_inst_AHBL_M01_interconnect_HSELx, ahbl_ic_inst_AHBL_M01_interconnect_HREADY, 
        ahbl_ic_inst_AHBL_M01_interconnect_HMASTLOCK, ahbl_ic_inst_AHBL_M01_interconnect_HWRITE, 
        ahbl_ic_inst_AHBL_M01_interconnect_HREADYOUT, ahbl_ic_inst_AHBL_M01_interconnect_HRESP, 
        ahbl2apb_inst_APB_M0_interconnect_PREADY, ahbl2apb_inst_APB_M0_interconnect_PSLVERR, 
        ahbl2apb_inst_APB_M0_interconnect_PSELx, ahbl2apb_inst_APB_M0_interconnect_PWRITE, 
        ahbl2apb_inst_APB_M0_interconnect_PENABLE;
    wire [31:0]ahbl_ic_inst_AHBL_M02_interconnect_HADDR;
    wire [31:0]ahbl_ic_inst_AHBL_M02_interconnect_HWDATA;
    wire [2:0]ahbl_ic_inst_AHBL_M02_interconnect_HSIZE;
    wire [1:0]ahbl_ic_inst_AHBL_M02_interconnect_HTRANS;
    wire [3:0]ahbl_ic_inst_AHBL_M02_interconnect_HPROT;
    wire [2:0]ahbl_ic_inst_AHBL_M02_interconnect_HBURST;
    wire [31:0]ahbl_ic_inst_AHBL_M02_interconnect_HRDATA;
    wire [3:0]ahbl2axi4_d_inst_AXI4_M_interconnect_AWID;
    wire [31:0]ahbl2axi4_d_inst_AXI4_M_interconnect_AWADDR;
    wire [7:0]ahbl2axi4_d_inst_AXI4_M_interconnect_AWLEN;
    wire [2:0]ahbl2axi4_d_inst_AXI4_M_interconnect_AWSIZE;
    wire [1:0]ahbl2axi4_d_inst_AXI4_M_interconnect_AWBURST;
    wire [3:0]ahbl2axi4_d_inst_AXI4_M_interconnect_AWCACHE;
    wire [2:0]ahbl2axi4_d_inst_AXI4_M_interconnect_AWPROT;
    wire [3:0]ahbl2axi4_d_inst_AXI4_M_interconnect_AWQOS;
    wire [3:0]ahbl2axi4_d_inst_AXI4_M_interconnect_AWREGION;
    wire [31:0]ahbl2axi4_d_inst_AXI4_M_interconnect_WDATA;
    wire [3:0]ahbl2axi4_d_inst_AXI4_M_interconnect_WSTRB;
    wire [3:0]ahbl2axi4_d_inst_AXI4_M_interconnect_BID;
    wire [1:0]ahbl2axi4_d_inst_AXI4_M_interconnect_BRESP;
    wire [3:0]ahbl2axi4_d_inst_AXI4_M_interconnect_ARID;
    wire [31:0]ahbl2axi4_d_inst_AXI4_M_interconnect_ARADDR;
    wire [7:0]ahbl2axi4_d_inst_AXI4_M_interconnect_ARLEN;
    wire [2:0]ahbl2axi4_d_inst_AXI4_M_interconnect_ARSIZE;
    wire [1:0]ahbl2axi4_d_inst_AXI4_M_interconnect_ARBURST;
    wire [3:0]ahbl2axi4_d_inst_AXI4_M_interconnect_ARCACHE;
    wire [2:0]ahbl2axi4_d_inst_AXI4_M_interconnect_ARPROT;
    wire [3:0]ahbl2axi4_d_inst_AXI4_M_interconnect_ARQOS;
    wire [3:0]ahbl2axi4_d_inst_AXI4_M_interconnect_ARREGION;
    wire [3:0]ahbl2axi4_d_inst_AXI4_M_interconnect_RID;
    wire [31:0]ahbl2axi4_d_inst_AXI4_M_interconnect_RDATA;
    wire [1:0]ahbl2axi4_d_inst_AXI4_M_interconnect_RRESP;
    
    wire ahbl_ic_inst_AHBL_M02_interconnect_HSELx, ahbl_ic_inst_AHBL_M02_interconnect_HWRITE, 
        ahbl_ic_inst_AHBL_M02_interconnect_HREADY, ahbl_ic_inst_AHBL_M02_interconnect_HREADYOUT, 
        ahbl_ic_inst_AHBL_M02_interconnect_HRESP, ahbl2axi4_d_inst_AXI4_M_interconnect_AWLOCK, 
        ahbl2axi4_d_inst_AXI4_M_interconnect_AWVALID, ahbl2axi4_d_inst_AXI4_M_interconnect_AWREADY, 
        ahbl2axi4_d_inst_AXI4_M_interconnect_WLAST, ahbl2axi4_d_inst_AXI4_M_interconnect_WVALID, 
        ahbl2axi4_d_inst_AXI4_M_interconnect_WREADY, ahbl2axi4_d_inst_AXI4_M_interconnect_BVALID, 
        ahbl2axi4_d_inst_AXI4_M_interconnect_BREADY, ahbl2axi4_d_inst_AXI4_M_interconnect_ARLOCK, 
        ahbl2axi4_d_inst_AXI4_M_interconnect_ARVALID, ahbl2axi4_d_inst_AXI4_M_interconnect_ARREADY, 
        ahbl2axi4_d_inst_AXI4_M_interconnect_RLAST, ahbl2axi4_d_inst_AXI4_M_interconnect_RVALID, 
        ahbl2axi4_d_inst_AXI4_M_interconnect_RREADY;
    wire [31:0]riscv_proc_inst_AHBL_M1_DATA_interconnect_HADDR;
    wire [2:0]riscv_proc_inst_AHBL_M1_DATA_interconnect_HBURST;
    wire [2:0]riscv_proc_inst_AHBL_M1_DATA_interconnect_HSIZE;
    wire [3:0]riscv_proc_inst_AHBL_M1_DATA_interconnect_HPROT;
    wire [1:0]riscv_proc_inst_AHBL_M1_DATA_interconnect_HTRANS;
    wire [31:0]riscv_proc_inst_AHBL_M1_DATA_interconnect_HWDATA;
    wire [31:0]riscv_proc_inst_AHBL_M1_DATA_interconnect_HRDATA;
    wire [31:0]ahbl_ic_inst_AHBL_M00_interconnect_HRDATA;
    wire [31:0]ahbl_ic_inst_AHBL_M00_interconnect_HADDR;
    wire [2:0]ahbl_ic_inst_AHBL_M00_interconnect_HBURST;
    wire [2:0]ahbl_ic_inst_AHBL_M00_interconnect_HSIZE;
    wire [3:0]ahbl_ic_inst_AHBL_M00_interconnect_HPROT;
    wire [1:0]ahbl_ic_inst_AHBL_M00_interconnect_HTRANS;
    wire [31:0]ahbl_ic_inst_AHBL_M00_interconnect_HWDATA;
    
    wire riscv_proc_inst_AHBL_M1_DATA_interconnect_HMASTLOCK, riscv_proc_inst_AHBL_M1_DATA_interconnect_HWRITE, 
        riscv_proc_inst_AHBL_M1_DATA_interconnect_HREADYOUT, riscv_proc_inst_AHBL_M1_DATA_interconnect_HRESP, 
        ahbl_ic_inst_AHBL_M00_interconnect_HREADYOUT, ahbl_ic_inst_AHBL_M00_interconnect_HRESP, 
        ahbl_ic_inst_AHBL_M00_interconnect_HSELx, ahbl_ic_inst_AHBL_M00_interconnect_HMASTLOCK, 
        ahbl_ic_inst_AHBL_M00_interconnect_HWRITE, ahbl_ic_inst_AHBL_M00_interconnect_HREADY;
    wire [31:0]riscv_proc_inst_AHBL_M0_INSTR_interconnect_HADDR;
    wire [2:0]riscv_proc_inst_AHBL_M0_INSTR_interconnect_HSIZE;
    wire [2:0]riscv_proc_inst_AHBL_M0_INSTR_interconnect_HBURST;
    wire [3:0]riscv_proc_inst_AHBL_M0_INSTR_interconnect_HPROT;
    wire [1:0]riscv_proc_inst_AHBL_M0_INSTR_interconnect_HTRANS;
    wire [31:0]riscv_proc_inst_AHBL_M0_INSTR_interconnect_HWDATA;
    wire [31:0]riscv_proc_inst_AHBL_M0_INSTR_interconnect_HRDATA;
    
    wire riscv_proc_inst_AHBL_M0_INSTR_interconnect_HWRITE, riscv_proc_inst_AHBL_M0_INSTR_interconnect_HMASTLOCK, 
        riscv_proc_inst_AHBL_M0_INSTR_interconnect_HREADYOUT, riscv_proc_inst_AHBL_M0_INSTR_interconnect_HRESP;
    
    
    ahbl2apb ahbl2apb_inst (.ahbl_haddr_i({ahbl_ic_inst_AHBL_M01_interconnect_HADDR}), 
            .ahbl_hburst_i({ahbl_ic_inst_AHBL_M01_interconnect_HBURST}), .ahbl_hsize_i({ahbl_ic_inst_AHBL_M01_interconnect_HSIZE}), 
            .ahbl_hprot_i({ahbl_ic_inst_AHBL_M01_interconnect_HPROT}), .ahbl_htrans_i({ahbl_ic_inst_AHBL_M01_interconnect_HTRANS}), 
            .ahbl_hwdata_i({ahbl_ic_inst_AHBL_M01_interconnect_HWDATA}), .ahbl_hrdata_o({ahbl_ic_inst_AHBL_M01_interconnect_HRDATA}), 
            .apb_prdata_i({ahbl2apb_inst_APB_M0_interconnect_PRDATA}), .apb_paddr_o({ahbl2apb_inst_APB_M0_interconnect_PADDR}), 
            .apb_pwdata_o({ahbl2apb_inst_APB_M0_interconnect_PWDATA}), .clk_i(sys_clk_i), 
            .rst_n_i(rstn_i), .ahbl_hsel_i(ahbl_ic_inst_AHBL_M01_interconnect_HSELx), 
            .ahbl_hready_i(ahbl_ic_inst_AHBL_M01_interconnect_HREADY), .ahbl_hmastlock_i(ahbl_ic_inst_AHBL_M01_interconnect_HMASTLOCK), 
            .ahbl_hwrite_i(ahbl_ic_inst_AHBL_M01_interconnect_HWRITE), .ahbl_hreadyout_o(ahbl_ic_inst_AHBL_M01_interconnect_HREADYOUT), 
            .ahbl_hresp_o(ahbl_ic_inst_AHBL_M01_interconnect_HRESP), .apb_pready_i(ahbl2apb_inst_APB_M0_interconnect_PREADY), 
            .apb_pslverr_i(ahbl2apb_inst_APB_M0_interconnect_PSLVERR), .apb_psel_o(ahbl2apb_inst_APB_M0_interconnect_PSELx), 
            .apb_pwrite_o(ahbl2apb_inst_APB_M0_interconnect_PWRITE), .apb_penable_o(ahbl2apb_inst_APB_M0_interconnect_PENABLE));
    ahbl2axi4_d ahbl2axi4_d_inst (.ahb_s_haddr_i({ahbl_ic_inst_AHBL_M02_interconnect_HADDR}), 
            .ahb_s_hwdata_i({ahbl_ic_inst_AHBL_M02_interconnect_HWDATA}), 
            .ahb_s_hsize_i({ahbl_ic_inst_AHBL_M02_interconnect_HSIZE}), .ahb_s_htrans_i({ahbl_ic_inst_AHBL_M02_interconnect_HTRANS}), 
            .ahb_s_hprot_i({ahbl_ic_inst_AHBL_M02_interconnect_HPROT}), .ahb_s_hburst_i({ahbl_ic_inst_AHBL_M02_interconnect_HBURST}), 
            .ahb_s_hrdata_o({ahbl_ic_inst_AHBL_M02_interconnect_HRDATA}), 
            .axi_m_awid_o({ahbl2axi4_d_inst_AXI4_M_interconnect_AWID}), .axi_m_awaddr_o({ahbl2axi4_d_inst_AXI4_M_interconnect_AWADDR}), 
            .axi_m_awlen_o({ahbl2axi4_d_inst_AXI4_M_interconnect_AWLEN}), 
            .axi_m_awsize_o({ahbl2axi4_d_inst_AXI4_M_interconnect_AWSIZE}), 
            .axi_m_awburst_o({ahbl2axi4_d_inst_AXI4_M_interconnect_AWBURST}), 
            .axi_m_awcache_o({ahbl2axi4_d_inst_AXI4_M_interconnect_AWCACHE}), 
            .axi_m_awprot_o({ahbl2axi4_d_inst_AXI4_M_interconnect_AWPROT}), 
            .axi_m_awqos_o({ahbl2axi4_d_inst_AXI4_M_interconnect_AWQOS}), 
            .axi_m_awregion_o({ahbl2axi4_d_inst_AXI4_M_interconnect_AWREGION}), 
            .axi_m_wdata_o({ahbl2axi4_d_inst_AXI4_M_interconnect_WDATA}), 
            .axi_m_wstrb_o({ahbl2axi4_d_inst_AXI4_M_interconnect_WSTRB}), 
            .axi_m_bid_i({ahbl2axi4_d_inst_AXI4_M_interconnect_BID}), .axi_m_bresp_i({ahbl2axi4_d_inst_AXI4_M_interconnect_BRESP}), 
            .axi_m_arid_o({ahbl2axi4_d_inst_AXI4_M_interconnect_ARID}), .axi_m_araddr_o({ahbl2axi4_d_inst_AXI4_M_interconnect_ARADDR}), 
            .axi_m_arlen_o({ahbl2axi4_d_inst_AXI4_M_interconnect_ARLEN}), 
            .axi_m_arsize_o({ahbl2axi4_d_inst_AXI4_M_interconnect_ARSIZE}), 
            .axi_m_arburst_o({ahbl2axi4_d_inst_AXI4_M_interconnect_ARBURST}), 
            .axi_m_arcache_o({ahbl2axi4_d_inst_AXI4_M_interconnect_ARCACHE}), 
            .axi_m_arprot_o({ahbl2axi4_d_inst_AXI4_M_interconnect_ARPROT}), 
            .axi_m_arqos_o({ahbl2axi4_d_inst_AXI4_M_interconnect_ARQOS}), 
            .axi_m_arregion_o({ahbl2axi4_d_inst_AXI4_M_interconnect_ARREGION}), 
            .axi_m_rid_i({ahbl2axi4_d_inst_AXI4_M_interconnect_RID}), .axi_m_rdata_i({ahbl2axi4_d_inst_AXI4_M_interconnect_RDATA}), 
            .axi_m_rresp_i({ahbl2axi4_d_inst_AXI4_M_interconnect_RRESP}), 
            .clk_i(sys_clk_i), .resetn_i(rstn_i), .ahb_s_hsel_i(ahbl_ic_inst_AHBL_M02_interconnect_HSELx), 
            .ahb_s_hwrite_i(ahbl_ic_inst_AHBL_M02_interconnect_HWRITE), .ahb_s_hready_i(ahbl_ic_inst_AHBL_M02_interconnect_HREADY), 
            .ahb_s_hreadyout_o(ahbl_ic_inst_AHBL_M02_interconnect_HREADYOUT), 
            .ahb_s_hresp_o(ahbl_ic_inst_AHBL_M02_interconnect_HRESP), .axi_m_awlock_o(ahbl2axi4_d_inst_AXI4_M_interconnect_AWLOCK), 
            .axi_m_awvalid_o(ahbl2axi4_d_inst_AXI4_M_interconnect_AWVALID), 
            .axi_m_awready_i(ahbl2axi4_d_inst_AXI4_M_interconnect_AWREADY), 
            .axi_m_wlast_o(ahbl2axi4_d_inst_AXI4_M_interconnect_WLAST), .axi_m_wvalid_o(ahbl2axi4_d_inst_AXI4_M_interconnect_WVALID), 
            .axi_m_wready_i(ahbl2axi4_d_inst_AXI4_M_interconnect_WREADY), 
            .axi_m_bvalid_i(ahbl2axi4_d_inst_AXI4_M_interconnect_BVALID), 
            .axi_m_bready_o(ahbl2axi4_d_inst_AXI4_M_interconnect_BREADY), 
            .axi_m_arlock_o(ahbl2axi4_d_inst_AXI4_M_interconnect_ARLOCK), 
            .axi_m_arvalid_o(ahbl2axi4_d_inst_AXI4_M_interconnect_ARVALID), 
            .axi_m_arready_i(ahbl2axi4_d_inst_AXI4_M_interconnect_ARREADY), 
            .axi_m_rlast_i(ahbl2axi4_d_inst_AXI4_M_interconnect_RLAST), .axi_m_rvalid_i(ahbl2axi4_d_inst_AXI4_M_interconnect_RVALID), 
            .axi_m_rready_o(ahbl2axi4_d_inst_AXI4_M_interconnect_RREADY));
    ahbl_ic ahbl_ic_inst (.ahbl_m02_hrdata_mstr_i({ahbl_ic_inst_AHBL_M02_interconnect_HRDATA}), 
            .ahbl_m02_haddr_mstr_o({ahbl_ic_inst_AHBL_M02_interconnect_HADDR}), 
            .ahbl_m02_hburst_mstr_o({ahbl_ic_inst_AHBL_M02_interconnect_HBURST}), 
            .ahbl_m02_hsize_mstr_o({ahbl_ic_inst_AHBL_M02_interconnect_HSIZE}), 
            .ahbl_m02_hprot_mstr_o({ahbl_ic_inst_AHBL_M02_interconnect_HPROT}), 
            .ahbl_m02_htrans_mstr_o({ahbl_ic_inst_AHBL_M02_interconnect_HTRANS}), 
            .ahbl_m02_hwdata_mstr_o({ahbl_ic_inst_AHBL_M02_interconnect_HWDATA}), 
            .ahbl_m01_hrdata_mstr_i({ahbl_ic_inst_AHBL_M01_interconnect_HRDATA}), 
            .ahbl_m01_haddr_mstr_o({ahbl_ic_inst_AHBL_M01_interconnect_HADDR}), 
            .ahbl_m01_hburst_mstr_o({ahbl_ic_inst_AHBL_M01_interconnect_HBURST}), 
            .ahbl_m01_hsize_mstr_o({ahbl_ic_inst_AHBL_M01_interconnect_HSIZE}), 
            .ahbl_m01_hprot_mstr_o({ahbl_ic_inst_AHBL_M01_interconnect_HPROT}), 
            .ahbl_m01_htrans_mstr_o({ahbl_ic_inst_AHBL_M01_interconnect_HTRANS}), 
            .ahbl_m01_hwdata_mstr_o({ahbl_ic_inst_AHBL_M01_interconnect_HWDATA}), 
            .ahbl_s00_haddr_slv_i({riscv_proc_inst_AHBL_M1_DATA_interconnect_HADDR}), 
            .ahbl_s00_hburst_slv_i({riscv_proc_inst_AHBL_M1_DATA_interconnect_HBURST}), 
            .ahbl_s00_hsize_slv_i({riscv_proc_inst_AHBL_M1_DATA_interconnect_HSIZE}), 
            .ahbl_s00_hprot_slv_i({riscv_proc_inst_AHBL_M1_DATA_interconnect_HPROT}), 
            .ahbl_s00_htrans_slv_i({riscv_proc_inst_AHBL_M1_DATA_interconnect_HTRANS}), 
            .ahbl_s00_hwdata_slv_i({riscv_proc_inst_AHBL_M1_DATA_interconnect_HWDATA}), 
            .ahbl_s00_hrdata_slv_o({riscv_proc_inst_AHBL_M1_DATA_interconnect_HRDATA}), 
            .ahbl_m00_hrdata_mstr_i({ahbl_ic_inst_AHBL_M00_interconnect_HRDATA}), 
            .ahbl_m00_haddr_mstr_o({ahbl_ic_inst_AHBL_M00_interconnect_HADDR}), 
            .ahbl_m00_hburst_mstr_o({ahbl_ic_inst_AHBL_M00_interconnect_HBURST}), 
            .ahbl_m00_hsize_mstr_o({ahbl_ic_inst_AHBL_M00_interconnect_HSIZE}), 
            .ahbl_m00_hprot_mstr_o({ahbl_ic_inst_AHBL_M00_interconnect_HPROT}), 
            .ahbl_m00_htrans_mstr_o({ahbl_ic_inst_AHBL_M00_interconnect_HTRANS}), 
            .ahbl_m00_hwdata_mstr_o({ahbl_ic_inst_AHBL_M00_interconnect_HWDATA}), 
            .ahbl_hclk_i(sys_clk_i), .ahbl_hresetn_i(rstn_i), .ahbl_m02_hready_mstr_i(ahbl_ic_inst_AHBL_M02_interconnect_HREADYOUT), 
            .ahbl_m02_hresp_mstr_i(ahbl_ic_inst_AHBL_M02_interconnect_HRESP), 
            .ahbl_m02_hsel_mstr_o(ahbl_ic_inst_AHBL_M02_interconnect_HSELx), 
            .ahbl_m02_hwrite_mstr_o(ahbl_ic_inst_AHBL_M02_interconnect_HWRITE), 
            .ahbl_m02_hready_mstr_o(ahbl_ic_inst_AHBL_M02_interconnect_HREADY), 
            .ahbl_m01_hready_mstr_i(ahbl_ic_inst_AHBL_M01_interconnect_HREADYOUT), 
            .ahbl_m01_hresp_mstr_i(ahbl_ic_inst_AHBL_M01_interconnect_HRESP), 
            .ahbl_m01_hsel_mstr_o(ahbl_ic_inst_AHBL_M01_interconnect_HSELx), 
            .ahbl_m01_hmastlock_mstr_o(ahbl_ic_inst_AHBL_M01_interconnect_HMASTLOCK), 
            .ahbl_m01_hwrite_mstr_o(ahbl_ic_inst_AHBL_M01_interconnect_HWRITE), 
            .ahbl_m01_hready_mstr_o(ahbl_ic_inst_AHBL_M01_interconnect_HREADY), 
            .ahbl_s00_hsel_slv_i(1'b1), .ahbl_s00_hmastlock_slv_i(riscv_proc_inst_AHBL_M1_DATA_interconnect_HMASTLOCK), 
            .ahbl_s00_hwrite_slv_i(riscv_proc_inst_AHBL_M1_DATA_interconnect_HWRITE), 
            .ahbl_s00_hready_slv_i(riscv_proc_inst_AHBL_M1_DATA_interconnect_HREADYOUT), 
            .ahbl_s00_hreadyout_slv_o(riscv_proc_inst_AHBL_M1_DATA_interconnect_HREADYOUT), 
            .ahbl_s00_hresp_slv_o(riscv_proc_inst_AHBL_M1_DATA_interconnect_HRESP), 
            .ahbl_m00_hready_mstr_i(ahbl_ic_inst_AHBL_M00_interconnect_HREADYOUT), 
            .ahbl_m00_hresp_mstr_i(ahbl_ic_inst_AHBL_M00_interconnect_HRESP), 
            .ahbl_m00_hsel_mstr_o(ahbl_ic_inst_AHBL_M00_interconnect_HSELx), 
            .ahbl_m00_hmastlock_mstr_o(ahbl_ic_inst_AHBL_M00_interconnect_HMASTLOCK), 
            .ahbl_m00_hwrite_mstr_o(ahbl_ic_inst_AHBL_M00_interconnect_HWRITE), 
            .ahbl_m00_hready_mstr_o(ahbl_ic_inst_AHBL_M00_interconnect_HREADY));
    defparam ahbl_ic_inst.FULL_DECODE_EN = 1;
    defparam ahbl_ic_inst.S0_ADDR_RANGE = 32'h00020000;
    defparam ahbl_ic_inst.S0_BASE_ADDR = 32'h00000000;
    defparam ahbl_ic_inst.S1_ADDR_RANGE = 32'h00000400;
    defparam ahbl_ic_inst.S1_BASE_ADDR = 32'h00020000;
    defparam ahbl_ic_inst.S2_ADDR_RANGE = 32'h04000000;
    defparam ahbl_ic_inst.S2_BASE_ADDR = 32'h04000000;
    apb_gpio apb_gpio_inst (.gpio_o({gpio_o}), .apb_paddr_i({ahbl2apb_inst_APB_M0_interconnect_PADDR[5:0]}), 
            .apb_pwdata_i({ahbl2apb_inst_APB_M0_interconnect_PWDATA}), .apb_prdata_o({ahbl2apb_inst_APB_M0_interconnect_PRDATA}), 
            .clk_i(sys_clk_i), .resetn_i(rstn_i), .apb_penable_i(ahbl2apb_inst_APB_M0_interconnect_PENABLE), 
            .apb_psel_i(ahbl2apb_inst_APB_M0_interconnect_PSELx), .apb_pwrite_i(ahbl2apb_inst_APB_M0_interconnect_PWRITE), 
            .apb_pslverr_o(ahbl2apb_inst_APB_M0_interconnect_PSLVERR), .apb_pready_o(ahbl2apb_inst_APB_M0_interconnect_PREADY));
    hyperram hyperram_inst (.s_axi_awaddr({ahbl2axi4_d_inst_AXI4_M_interconnect_AWADDR}), 
            .s_axi_awlen({ahbl2axi4_d_inst_AXI4_M_interconnect_AWLEN}), .s_axi_awsize({ahbl2axi4_d_inst_AXI4_M_interconnect_AWSIZE}), 
            .s_axi_awburst({ahbl2axi4_d_inst_AXI4_M_interconnect_AWBURST}), 
            .s_axi_awregion({ahbl2axi4_d_inst_AXI4_M_interconnect_AWREGION}), 
            .s_axi_awcache({ahbl2axi4_d_inst_AXI4_M_interconnect_AWCACHE}), 
            .s_axi_awqos({ahbl2axi4_d_inst_AXI4_M_interconnect_AWQOS}), .s_axi_awprot({ahbl2axi4_d_inst_AXI4_M_interconnect_AWPROT}), 
            .s_axi_wdata({ahbl2axi4_d_inst_AXI4_M_interconnect_WDATA}), .s_axi_wstrb({ahbl2axi4_d_inst_AXI4_M_interconnect_WSTRB}), 
            .s_axi_bresp({ahbl2axi4_d_inst_AXI4_M_interconnect_BRESP}), .s_axi_araddr({ahbl2axi4_d_inst_AXI4_M_interconnect_ARADDR}), 
            .s_axi_arlen({ahbl2axi4_d_inst_AXI4_M_interconnect_ARLEN}), .s_axi_arsize({ahbl2axi4_d_inst_AXI4_M_interconnect_ARSIZE}), 
            .s_axi_arburst({ahbl2axi4_d_inst_AXI4_M_interconnect_ARBURST}), 
            .s_axi_arregion({ahbl2axi4_d_inst_AXI4_M_interconnect_ARREGION}), 
            .s_axi_arcache({ahbl2axi4_d_inst_AXI4_M_interconnect_ARCACHE}), 
            .s_axi_arqos({ahbl2axi4_d_inst_AXI4_M_interconnect_ARQOS}), .s_axi_arprot({ahbl2axi4_d_inst_AXI4_M_interconnect_ARPROT}), 
            .s_axi_rdata({ahbl2axi4_d_inst_AXI4_M_interconnect_RDATA}), .s_axi_rresp({ahbl2axi4_d_inst_AXI4_M_interconnect_RRESP}), 
            .hb_dq({HYPERBUS_hb_dq_portbus}), .clk_hbmc_0(clk_hbmc_0_i), 
            .clk_hbmc_90(clk_hbmc_90_i), .reset(reset_hbmc_i), .s_axi_aclk(sys_clk_i), 
            .s_axi_aresetn(rstn_i), .s_axi_awid(ahbl2axi4_d_inst_AXI4_M_interconnect_AWID[0]), 
            .s_axi_awuser(1'b0), .s_axi_awlock(ahbl2axi4_d_inst_AXI4_M_interconnect_AWLOCK), 
            .s_axi_awvalid(ahbl2axi4_d_inst_AXI4_M_interconnect_AWVALID), 
            .s_axi_awready(ahbl2axi4_d_inst_AXI4_M_interconnect_AWREADY), 
            .s_axi_wuser(1'b0), .s_axi_wlast(ahbl2axi4_d_inst_AXI4_M_interconnect_WLAST), 
            .s_axi_wvalid(ahbl2axi4_d_inst_AXI4_M_interconnect_WVALID), .s_axi_wready(ahbl2axi4_d_inst_AXI4_M_interconnect_WREADY), 
            .s_axi_bid(ahbl2axi4_d_inst_AXI4_M_interconnect_BID[0]), .s_axi_bvalid(ahbl2axi4_d_inst_AXI4_M_interconnect_BVALID), 
            .s_axi_bready(ahbl2axi4_d_inst_AXI4_M_interconnect_BREADY), .s_axi_arid(ahbl2axi4_d_inst_AXI4_M_interconnect_ARID[0]), 
            .s_axi_aruser(1'b0), .s_axi_arlock(ahbl2axi4_d_inst_AXI4_M_interconnect_ARLOCK), 
            .s_axi_arvalid(ahbl2axi4_d_inst_AXI4_M_interconnect_ARVALID), 
            .s_axi_arready(ahbl2axi4_d_inst_AXI4_M_interconnect_ARREADY), 
            .s_axi_rid(ahbl2axi4_d_inst_AXI4_M_interconnect_RID[0]), .s_axi_rlast(ahbl2axi4_d_inst_AXI4_M_interconnect_RLAST), 
            .s_axi_rvalid(ahbl2axi4_d_inst_AXI4_M_interconnect_RVALID), .s_axi_rready(ahbl2axi4_d_inst_AXI4_M_interconnect_RREADY), 
            .hb_ck_p(HYPERBUS_hb_ck_p_port), .hb_ck_n(hb_ck_n_o), .hb_reset_n(HYPERBUS_hb_reset_n_port), 
            .hb_cs_n(HYPERBUS_hb_cs_n_port), .hb_rwds(HYPERBUS_hb_rwds_port), 
            .init_done(hbmc_init_done_o));
    riscv_proc riscv_proc_inst (.ahbl_m_instr_haddr_o({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HADDR}), 
            .ahbl_m_instr_hsize_o({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HSIZE}), 
            .ahbl_m_instr_hburst_o({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HBURST}), 
            .ahbl_m_instr_hprot_o({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HPROT}), 
            .ahbl_m_instr_htrans_o({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HTRANS}), 
            .ahbl_m_instr_hwdata_o({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HWDATA}), 
            .ahbl_m_instr_hrdata_i({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HRDATA}), 
            .ahbl_m_data_haddr_o({riscv_proc_inst_AHBL_M1_DATA_interconnect_HADDR}), 
            .ahbl_m_data_hsize_o({riscv_proc_inst_AHBL_M1_DATA_interconnect_HSIZE}), 
            .ahbl_m_data_hburst_o({riscv_proc_inst_AHBL_M1_DATA_interconnect_HBURST}), 
            .ahbl_m_data_hprot_o({riscv_proc_inst_AHBL_M1_DATA_interconnect_HPROT}), 
            .ahbl_m_data_htrans_o({riscv_proc_inst_AHBL_M1_DATA_interconnect_HTRANS}), 
            .ahbl_m_data_hwdata_o({riscv_proc_inst_AHBL_M1_DATA_interconnect_HWDATA}), 
            .ahbl_m_data_hrdata_i({riscv_proc_inst_AHBL_M1_DATA_interconnect_HRDATA}), 
            .clk_i(sys_clk_i), .rst_n_i(rstn_i), .ahbl_m_instr_hwrite_o(riscv_proc_inst_AHBL_M0_INSTR_interconnect_HWRITE), 
            .ahbl_m_instr_hmastlock_o(riscv_proc_inst_AHBL_M0_INSTR_interconnect_HMASTLOCK), 
            .ahbl_m_instr_hready_i(riscv_proc_inst_AHBL_M0_INSTR_interconnect_HREADYOUT), 
            .ahbl_m_instr_hresp_i(riscv_proc_inst_AHBL_M0_INSTR_interconnect_HRESP), 
            .ahbl_m_data_hwrite_o(riscv_proc_inst_AHBL_M1_DATA_interconnect_HWRITE), 
            .ahbl_m_data_hmastlock_o(riscv_proc_inst_AHBL_M1_DATA_interconnect_HMASTLOCK), 
            .ahbl_m_data_hready_i(riscv_proc_inst_AHBL_M1_DATA_interconnect_HREADYOUT), 
            .ahbl_m_data_hresp_i(riscv_proc_inst_AHBL_M1_DATA_interconnect_HRESP));
    defparam riscv_proc_inst.DCACHE_ENABLE = 0;
    defparam riscv_proc_inst.DCACHE_RANGE_HIGH = 32'h00000000;
    defparam riscv_proc_inst.DCACHE_RANGE_LOW = 32'hFFFFFFFF;
    defparam riscv_proc_inst.ICACHE_ENABLE = 0;
    defparam riscv_proc_inst.ICACHE_RANGE_HIGH = 32'h00000000;
    defparam riscv_proc_inst.ICACHE_RANGE_LOW = 32'hFFFFFFFF;
    sysmem sysmem_inst (.ahbl_s0_haddr_i({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HADDR}), 
           .ahbl_s0_hburst_i({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HBURST}), 
           .ahbl_s0_hsize_i({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HSIZE}), 
           .ahbl_s0_hprot_i({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HPROT}), 
           .ahbl_s0_htrans_i({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HTRANS}), 
           .ahbl_s0_hwdata_i({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HWDATA}), 
           .ahbl_s0_hrdata_o({riscv_proc_inst_AHBL_M0_INSTR_interconnect_HRDATA}), 
           .ahbl_s1_haddr_i({ahbl_ic_inst_AHBL_M00_interconnect_HADDR}), .ahbl_s1_hburst_i({ahbl_ic_inst_AHBL_M00_interconnect_HBURST}), 
           .ahbl_s1_hsize_i({ahbl_ic_inst_AHBL_M00_interconnect_HSIZE}), .ahbl_s1_hprot_i({ahbl_ic_inst_AHBL_M00_interconnect_HPROT}), 
           .ahbl_s1_htrans_i({ahbl_ic_inst_AHBL_M00_interconnect_HTRANS}), 
           .ahbl_s1_hwdata_i({ahbl_ic_inst_AHBL_M00_interconnect_HWDATA}), 
           .ahbl_s1_hrdata_o({ahbl_ic_inst_AHBL_M00_interconnect_HRDATA}), 
           .ahbl_hclk_i(sys_clk_i), .ahbl_hresetn_i(rstn_i), .ahbl_s0_hsel_i(1'b1), 
           .ahbl_s0_hready_i(riscv_proc_inst_AHBL_M0_INSTR_interconnect_HREADYOUT), 
           .ahbl_s0_hmastlock_i(riscv_proc_inst_AHBL_M0_INSTR_interconnect_HMASTLOCK), 
           .ahbl_s0_hwrite_i(riscv_proc_inst_AHBL_M0_INSTR_interconnect_HWRITE), 
           .ahbl_s0_hreadyout_o(riscv_proc_inst_AHBL_M0_INSTR_interconnect_HREADYOUT), 
           .ahbl_s0_hresp_o(riscv_proc_inst_AHBL_M0_INSTR_interconnect_HRESP), 
           .ahbl_s1_hsel_i(ahbl_ic_inst_AHBL_M00_interconnect_HSELx), .ahbl_s1_hready_i(ahbl_ic_inst_AHBL_M00_interconnect_HREADY), 
           .ahbl_s1_hmastlock_i(ahbl_ic_inst_AHBL_M00_interconnect_HMASTLOCK), 
           .ahbl_s1_hwrite_i(ahbl_ic_inst_AHBL_M00_interconnect_HWRITE), .ahbl_s1_hreadyout_o(ahbl_ic_inst_AHBL_M00_interconnect_HREADYOUT), 
           .ahbl_s1_hresp_o(ahbl_ic_inst_AHBL_M00_interconnect_HRESP));
    defparam sysmem_inst.MEM_ID = "sysmem";
    
endmodule

