
/*******************************************************************************
    Verilog netlist generated by IPGEN Lattice Propel (64-bit)
    2024.2.2412062206
    Soft IP Version: 1.1.2
    2025 03 19 08:48:07
*******************************************************************************/
/*******************************************************************************
    Wrapper Module generated per user settings.
*******************************************************************************/
(* ORIG_MODULE_NAME="ahbl2apb", LATTICE_IP_GENERATED="1" *) module ahbl2apb (clk_i, 
        rst_n_i, 
        ahbl_hsel_i, 
        ahbl_hready_i, 
        ahbl_haddr_i, 
        ahbl_hburst_i, 
        ahbl_hsize_i, 
        ahbl_hmastlock_i, 
        ahbl_hprot_i, 
        ahbl_htrans_i, 
        ahbl_hwdata_i, 
        ahbl_hwrite_i, 
        ahbl_hreadyout_o, 
        ahbl_hresp_o, 
        ahbl_hrdata_o, 
        apb_pready_i, 
        apb_pslverr_i, 
        apb_prdata_i, 
        apb_psel_o, 
        apb_paddr_o, 
        apb_pwrite_o, 
        apb_pwdata_o, 
        apb_penable_o) ;
    input clk_i ; 
    input rst_n_i ; 
    input ahbl_hsel_i ; 
    input ahbl_hready_i ; 
    input [31:0] ahbl_haddr_i ; 
    input [2:0] ahbl_hburst_i ; 
    input [2:0] ahbl_hsize_i ; 
    input ahbl_hmastlock_i ; 
    input [3:0] ahbl_hprot_i ; 
    input [1:0] ahbl_htrans_i ; 
    input [31:0] ahbl_hwdata_i ; 
    input ahbl_hwrite_i ; 
    output ahbl_hreadyout_o ; 
    output ahbl_hresp_o ; 
    output [31:0] ahbl_hrdata_o ; 
    input apb_pready_i ; 
    input apb_pslverr_i ; 
    input [31:0] apb_prdata_i ; 
    output apb_psel_o ; 
    output [31:0] apb_paddr_o ; 
    output apb_pwrite_o ; 
    output [31:0] apb_pwdata_o ; 
    output apb_penable_o ; 
    parameter ADDR_WIDTH = 32 ; 
    ahbl2apb_ipgen_lscc_ahbl2apb #(.ADDR_WIDTH(ADDR_WIDTH),
            .DATA_WIDTH(32),
            .APB_CLK_EN(0),
            .FAMILY("LFD2NX")) lscc_ahbl2apb_inst (.clk_i(clk_i), 
                .rst_n_i(rst_n_i), 
                .pclk_i(1'b0), 
                .presetn_i(1'b1), 
                .ahbl_hsel_i(ahbl_hsel_i), 
                .ahbl_hready_i(ahbl_hready_i), 
                .ahbl_haddr_i(ahbl_haddr_i[31:0]), 
                .ahbl_hburst_i(ahbl_hburst_i[2:0]), 
                .ahbl_hsize_i(ahbl_hsize_i[2:0]), 
                .ahbl_hmastlock_i(ahbl_hmastlock_i), 
                .ahbl_hprot_i(ahbl_hprot_i[3:0]), 
                .ahbl_htrans_i(ahbl_htrans_i[1:0]), 
                .ahbl_hwdata_i(ahbl_hwdata_i[31:0]), 
                .ahbl_hwrite_i(ahbl_hwrite_i), 
                .ahbl_hreadyout_o(ahbl_hreadyout_o), 
                .ahbl_hresp_o(ahbl_hresp_o), 
                .ahbl_hrdata_o(ahbl_hrdata_o[31:0]), 
                .apb_pready_i(apb_pready_i), 
                .apb_pslverr_i(apb_pslverr_i), 
                .apb_prdata_i(apb_prdata_i[31:0]), 
                .apb_psel_o(apb_psel_o), 
                .apb_paddr_o(apb_paddr_o[31:0]), 
                .apb_pwrite_o(apb_pwrite_o), 
                .apb_pwdata_o(apb_pwdata_o[31:0]), 
                .apb_penable_o(apb_penable_o)) ; 
endmodule



`timescale 1ns/1ps
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2022 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
module ahbl2apb_ipgen_lscc_ahbl2apb #(parameter DATA_WIDTH = 32, 
        parameter ADDR_WIDTH = 32, 
        parameter APB_CLK_EN = 0, 
        parameter FAMILY = "LIFCL") (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // 8/16/32
    // 11-32
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input clk_i, 
    input rst_n_i, 
    input pclk_i, 
    input presetn_i, 
    // ------------------------
    // AHB-Lite Interface
    // ------sim:/soc_top/dut/ahbl2apb1_inst/lscc_ahbl2apb_inst/ahbl_hready_i------------------
    input ahbl_hsel_i, 
    input ahbl_hready_i, 
    input [(ADDR_WIDTH - 1):0] ahbl_haddr_i, 
    input [2:0] ahbl_hburst_i,  // n/a - fixed size
    input [2:0] ahbl_hsize_i,  // n/a - fixed size
    input ahbl_hmastlock_i,  // n/a
    input [3:0] ahbl_hprot_i,  // n/a
    input [1:0] ahbl_htrans_i, 
    input ahbl_hwrite_i, 
    input [(DATA_WIDTH - 1):0] ahbl_hwdata_i, 
    output reg ahbl_hreadyout_o, 
    output reg ahbl_hresp_o, 
    output reg [(DATA_WIDTH - 1):0] ahbl_hrdata_o, 
    // -----------------------------------------
    // APB Interface
    // -----------------------------------------
    output apb_psel_o, 
    output [(ADDR_WIDTH - 1):0] apb_paddr_o, 
    output [(DATA_WIDTH - 1):0] apb_pwdata_o, 
    output apb_pwrite_o, 
    output apb_penable_o, 
    input apb_pready_i, 
    input apb_pslverr_i, 
    input [(DATA_WIDTH - 1):0] apb_prdata_i) ;
    // ------------------------------------------------------------------------------
    // Local Parameters
    // ------------------------------------------------------------------------------
    localparam ST_W = 9 ; 
    localparam ST_IDLE = 9'h01, 
        ST_READ = 9'h02, 
        ST_WWAIT = 9'h04, 
        ST_WRITE = 9'h08, 
        ST_WRITEP = 9'h10, 
        ST_RENABLE = 9'h20, 
        ST_WENABLE = 9'h40, 
        ST_WENABLEP = 9'h80, 
        ST_ERROR = 9'h100 ; 
    localparam IDLE = 2'b00 ; 
    localparam BUSY = 2'b01 ; 
    localparam NSEQ = 2'b10 ; 
    localparam SEQ = 2'b11 ; 
    localparam ST_APB_W = 3 ; 
    localparam ST_APB_IDLE = 3'h1 ; 
    localparam ST_APB_SETUP = 3'h2 ; 
    localparam ST_APB_ACCESS = 3'h4 ; 
    // ------------------------------------------------------------------------------
    // Register Declarations
    // ------------------------------------------------------------------------------
    reg [(ST_W - 1):0] cs_ahbl_sm ; 
    reg [(ST_W - 1):0] ns_ahbl_sm ; 
    reg [(ADDR_WIDTH - 1):0] haddr_r ; 
    reg hwrite_r ; 
    reg [1:0] buff_valid_r ; 
    reg apb_psel_r ; 
    reg [(ADDR_WIDTH - 1):0] apb_paddr_r ; 
    reg [(DATA_WIDTH - 1):0] apb_pwdata_r ; 
    reg apb_pwrite_r ; 
    reg apb_penable_r ; 
    reg [2:0] hsize_r ; 
    reg [2:0] apb_psize_r ; 
    wire ahbl_req_w ; 
    wire ahbl_ready_w ; 
    wire ahbl_req_rdy_w ; 
    wire apb_pready_w ; 
    wire apb_pslverr_w ; 
    wire [(DATA_WIDTH - 1):0] apb_prdata_w ; 
    assign ahbl_req_w = (ahbl_hsel_i && ((ahbl_htrans_i == NSEQ) || (ahbl_htrans_i == SEQ))) ; 
    assign ahbl_ready_w = (ahbl_hreadyout_o && ahbl_hready_i) ; 
    assign ahbl_req_rdy_w = (ahbl_ready_w && ahbl_req_w) ; 
    // -----------------------------------------------------------------------------
    // Read Function for HSIZE assignment
    // -----------------------------------------------------------------------------
    function [(DATA_WIDTH - 1):0] read_data_int ; 
        input [4:0] full_haddr_hsize ; 
        input [(DATA_WIDTH - 1):0] data_in ; 
        case (full_haddr_hsize)
        5'b00_000 : 
            // HSIZE = 8bits
            read_data_int = {8'b0,
                    8'b0,
                    8'b0,
                    data_in[7:0]} ;
        5'b01_000 : 
            read_data_int = {8'b0,
                    8'b0,
                    data_in[7:0],
                    8'b0} ;
        5'b10_000 : 
            read_data_int = {8'b0,
                    data_in[7:0],
                    8'b0,
                    8'b0} ;
        5'b11_000 : 
            read_data_int = {data_in[7:0],
                    8'b0,
                    8'b0,
                    8'b0} ;
        5'b00_001 : 
            // HSIZE = 16 bits
            read_data_int = {16'b0,
                    data_in[15:0]} ;
        5'b10_001 : 
            read_data_int = {data_in[15:0],
                    16'b0} ;
        5'b00_010 : 
            // HSIZE = 32 bits
            read_data_int = data_in[(DATA_WIDTH - 1):0] ;
        default : 
            read_data_int = data_in[(DATA_WIDTH - 1):0] ;
        endcase 
    endfunction
    // -----------------------------------------------------------------------------
    // Write Function for HSIZE assignment
    // -----------------------------------------------------------------------------
    function [(DATA_WIDTH - 1):0] write_data_int ; 
        input [4:0] full_haddr_hsize ; 
        case (full_haddr_hsize)
        5'b00_000 : 
            // HSIZE = 8bits
            write_data_int = {24'b0,
                    ahbl_hwdata_i[7:0]} ;
        5'b01_000 : 
            write_data_int = {24'b0,
                    ahbl_hwdata_i[15:8]} ;
        5'b10_000 : 
            write_data_int = {24'b0,
                    ahbl_hwdata_i[23:16]} ;
        5'b11_000 : 
            write_data_int = {24'b0,
                    ahbl_hwdata_i[31:24]} ;
        5'b00_001 : 
            // HSIZE = 16 bits
            write_data_int = {16'b0,
                    ahbl_hwdata_i[15:0]} ;
        5'b10_001 : 
            write_data_int = {16'b0,
                    ahbl_hwdata_i[31:16]} ;
        5'b00_010 : 
            // HSIZE = 32 bits
            write_data_int = ahbl_hwdata_i[(DATA_WIDTH - 1):0] ;
        default : 
            write_data_int = ahbl_hwdata_i[(DATA_WIDTH - 1):0] ;
        endcase 
    endfunction
    // -----------------------
    // AHB-Lite State Machine
    // -----------------------
    always
        @(*)
        begin
            ns_ahbl_sm = cs_ahbl_sm ;
            case (cs_ahbl_sm)
            ST_IDLE : 
                begin
                    if (ahbl_req_rdy_w) 
                        ns_ahbl_sm = (ahbl_hwrite_i ? ST_WWAIT : ST_READ) ;
                    else
                        ns_ahbl_sm = ST_IDLE ;
                end
            ST_WWAIT : 
                begin
                    // data is available in next cyle after address phase
                    ns_ahbl_sm = ST_WRITE ;
                end
            ST_WRITE : 
                begin
                    ns_ahbl_sm = ST_WENABLE ;
                end
            ST_WRITEP : 
                begin
                    ns_ahbl_sm = ST_WENABLEP ;
                end
            ST_WENABLEP : 
                begin
                    if (apb_pslverr_w) 
                        ns_ahbl_sm = ST_ERROR ;
                    else
                        if ((ahbl_hreadyout_o && hwrite_r)) 
                            ns_ahbl_sm = (ahbl_req_rdy_w ? ST_WRITEP : ST_WRITE) ;
                        else
                            if ((apb_pready_w && (~hwrite_r))) 
                                ns_ahbl_sm = ST_READ ;
                            else
                                ns_ahbl_sm = ST_WENABLEP ;
                end
            ST_WENABLE : 
                begin
                    if (apb_pslverr_w) 
                        ns_ahbl_sm = ST_ERROR ;
                    else
                        if (apb_pready_w) 
                            if (ahbl_req_rdy_w) 
                                ns_ahbl_sm = (ahbl_hwrite_i ? ST_WWAIT : ST_READ) ;
                            else
                                if (buff_valid_r[1]) 
                                    ns_ahbl_sm = (hwrite_r ? ST_WWAIT : ST_READ) ;
                                else
                                    ns_ahbl_sm = ST_IDLE ;
                        else
                            if ((buff_valid_r[1] || ahbl_req_rdy_w)) 
                                ns_ahbl_sm = ST_WENABLEP ;
                            else
                                ns_ahbl_sm = ST_WENABLE ;
                end
            ST_READ : 
                begin
                    ns_ahbl_sm = ST_RENABLE ;
                end
            ST_RENABLE : 
                begin
                    // if (apb_pslverr_w)
                    //   ns_ahbl_sm = ST_ERROR;
                    // else if (apb_pready_w)
                    if (apb_pready_w) 
                        begin
                            if (apb_pslverr_w) 
                                ns_ahbl_sm = ST_ERROR ;
                            else
                                if (ahbl_req_rdy_w) 
                                    ns_ahbl_sm = (ahbl_hwrite_i ? ST_WWAIT : ST_READ) ;
                                else
                                    ns_ahbl_sm = ST_IDLE ;
                        end
                    else
                        ns_ahbl_sm = ST_RENABLE ;
                end
            ST_ERROR : 
                begin
                    ns_ahbl_sm = ST_IDLE ;
                end
            default : 
                begin
                    ns_ahbl_sm = ST_IDLE ;
                end
            endcase 
        end
    // State register and state outputs
    always
        @(posedge clk_i or 
            negedge rst_n_i)
        begin
            if ((~rst_n_i)) 
                begin
                    cs_ahbl_sm <=  ST_IDLE ;
                    ahbl_hreadyout_o <=  1'b1 ;
                    ahbl_hresp_o <=  1'b0 ;
                    ahbl_hrdata_o <=  {DATA_WIDTH{1'b0}} ;
                    apb_psel_r <=  1'b0 ;
                    apb_penable_r <=  1'b0 ;
                    apb_pwrite_r <=  1'b0 ;
                    apb_paddr_r <=  {ADDR_WIDTH{1'b0}} ;
                    apb_psize_r <=  3'b111 ;
                    apb_pwdata_r <=  {DATA_WIDTH{1'b0}} ;
                end
            else
                begin
                    cs_ahbl_sm <=  ns_ahbl_sm ;
                    ahbl_hresp_o <=  1'b0 ;//apb_pslverr_w;
                    apb_psel_r <=  1'b0 ;
                    apb_penable_r <=  1'b0 ;
                    case (ns_ahbl_sm)
                    ST_IDLE : 
                        begin
                            ahbl_hreadyout_o <=  1'b1 ;
                            if ((cs_ahbl_sm == ST_ERROR)) 
                                ahbl_hresp_o <=  1'b1 ;
                            else
                                ahbl_hresp_o <=  1'b0 ;
                        end
                    ST_WWAIT : 
                        begin
                            ahbl_hreadyout_o <=  1'b0 ;
                        end
                    ST_WRITE : 
                        begin
                            apb_psel_r <=  1'b1 ;
                            apb_pwrite_r <=  1'b1 ;
                            apb_paddr_r <=  haddr_r ;
                            apb_psize_r <=  hsize_r ;
                            apb_pwdata_r <=  ((DATA_WIDTH == 32) ? write_data_int({haddr_r[1:0],
                                        hsize_r}) : ((DATA_WIDTH == 16) ? write_data_int({{1'b0},
                                        haddr_r[0],
                                        hsize_r}) : ahbl_hwdata_i)) ;//ahbl_hwdata_i
                            //apb_pwdata_r       <=     ahbl_hwdata_i;
                            if ((cs_ahbl_sm == ST_WENABLE)) 
                                ahbl_hreadyout_o <=  1'b1 ;
                            else
                                ahbl_hreadyout_o <=  1'b0 ;
                        end
                    ST_WRITEP : 
                        begin
                            apb_psel_r <=  1'b1 ;
                            apb_pwrite_r <=  1'b1 ;
                            apb_paddr_r <=  haddr_r ;
                            apb_psize_r <=  hsize_r ;
                            apb_pwdata_r <=  ((DATA_WIDTH == 32) ? write_data_int({haddr_r[1:0],
                                        hsize_r}) : ((DATA_WIDTH == 16) ? write_data_int({{1'b0},
                                        haddr_r[0],
                                        hsize_r}) : ahbl_hwdata_i)) ;//ahbl_hwdata_i
                            //apb_pwdata_r       <=     ahbl_hwdata_i;
                            ahbl_hreadyout_o <=  1'b0 ;
                        end
                    ST_WENABLEP : 
                        begin
                            if (((cs_ahbl_sm == ST_WENABLEP) && apb_pready_w)) 
                                begin
                                    apb_penable_r <=  1'b0 ;// PSEL and PENABLE should negate in next cycle after apb_pready_w=1
                                    apb_psel_r <=  1'b0 ;
                                end
                            else
                                begin
                                    apb_penable_r <=  1'b1 ;
                                    apb_psel_r <=  1'b1 ;
                                end
                            if (((ahbl_req_rdy_w && (~ahbl_hwrite_i)) || (buff_valid_r[1] && (~hwrite_r)))) 
                                // if next Tx is Read, negate HREADY
                                ahbl_hreadyout_o <=  1'b0 ;
                            else
                                ahbl_hreadyout_o <=  ((~apb_pslverr_w) && apb_pready_w) ;
                            ahbl_hresp_o <=  apb_pslverr_w ;
                        end
                    ST_WENABLE : 
                        begin
                            apb_psel_r <=  1'b1 ;
                            apb_penable_r <=  1'b1 ;
                            if ((apb_pslverr_w || (cs_ahbl_sm != ST_WENABLE))) 
                                // HREADY should be negated on 1st cycle of ST_RENABLE
                                ahbl_hreadyout_o <=  1'b0 ;
                            else
                                ahbl_hreadyout_o <=  apb_pready_w ;
                            ahbl_hresp_o <=  apb_pslverr_w ;
                        end
                    ST_READ : 
                        begin
                            if ((cs_ahbl_sm == ST_WENABLEP)) 
                                begin
                                    apb_paddr_r <=  haddr_r ;
                                    apb_psize_r <=  hsize_r ;
                                end
                            else
                                begin
                                    apb_paddr_r <=  (buff_valid_r[1] ? haddr_r : ahbl_haddr_i) ;
                                    apb_psize_r <=  (buff_valid_r[1] ? hsize_r : ahbl_hsize_i) ;
                                end
                            apb_psel_r <=  1'b1 ;
                            apb_pwrite_r <=  1'b0 ;
                            if ((cs_ahbl_sm == ST_RENABLE)) 
                                // Data is available in the PRDATA
                                ahbl_hreadyout_o <=  1'b1 ;
                            else
                                ahbl_hreadyout_o <=  1'b0 ;
                        end
                    ST_RENABLE : 
                        begin
                            apb_psel_r <=  1'b1 ;
                            apb_penable_r <=  1'b1 ;
                            if ((apb_pslverr_w || (cs_ahbl_sm != ST_RENABLE))) 
                            // ahbl_hresp_o       <= apb_pslverr_w;
                                // HREADY should be negated on 1st cycle of ST_RENABLE
                                ahbl_hreadyout_o <=  1'b0 ;
                            else
                                ahbl_hreadyout_o <=  apb_pready_w ;
                        end
                    ST_ERROR : 
                        begin
                            apb_psel_r <=  1'b0 ;
                            apb_penable_r <=  1'b0 ;
                            apb_pwrite_r <=  1'b0 ;
                            apb_paddr_r <=  {ADDR_WIDTH{1'b0}} ;
                            apb_psize_r <=  3'b111 ;
                            apb_pwdata_r <=  {DATA_WIDTH{1'b0}} ;
                            ahbl_hrdata_o <=  {DATA_WIDTH{1'b0}} ;
                            ahbl_hreadyout_o <=  1'b0 ;
                            ahbl_hresp_o <=  1'b1 ;
                        end
                    default : 
                        begin
                            ahbl_hreadyout_o <=  1'b1 ;
                        end
                    endcase 
                    if (((cs_ahbl_sm == ST_RENABLE) && apb_pready_w)) 
                        ahbl_hrdata_o <=  apb_prdata_w ;
                end
        end
    wire apb_tx_ok = (apb_pready_w & apb_penable_r) ; 
    // Register the memory inputs except for HWDATA to add 1 cycle delay
    always
        @(posedge clk_i or 
            negedge rst_n_i)
        begin
            if ((~rst_n_i)) 
                begin
                    hwrite_r <=  1'b0 ;
                    haddr_r <=  {ADDR_WIDTH{1'b0}} ;
                    buff_valid_r <=  2'b00 ;
                    hsize_r <=  3'b111 ;
                end
            else
                begin
                    if (ahbl_req_rdy_w) 
                        begin
                            hwrite_r <=  ahbl_hwrite_i ;
                            haddr_r <=  ahbl_haddr_i ;
                            hsize_r <=  ahbl_hsize_i ;
                        end
                    //    if (ahbl_ready_w)
                    //      buff_valid_r  <= ahbl_req_w;
                    if ((ahbl_req_rdy_w && (~apb_tx_ok))) 
                        buff_valid_r <=  ((buff_valid_r == 2'b00) ? 2'b01 : 2'b11) ;
                    else
                        if (((~ahbl_req_rdy_w) && apb_tx_ok)) 
                            buff_valid_r <=  ((buff_valid_r == 2'b11) ? 2'b01 : 2'b00) ;
                end
        end
    generate
        if ((APB_CLK_EN == 0)) 
            begin : single_clk
                assign apb_psel_o = apb_psel_r ; 
                assign apb_paddr_o = apb_paddr_r ; 
                assign apb_pwdata_o = apb_pwdata_r ; 
                assign apb_pwrite_o = apb_pwrite_r ; 
                assign apb_penable_o = apb_penable_r ; 
                assign apb_pready_w = apb_pready_i ; 
                assign apb_pslverr_w = (((apb_psel_r && apb_penable_r) && apb_pready_w) ? apb_pslverr_i : 1'b0) ; 
                assign apb_prdata_w = ((DATA_WIDTH == 32) ? read_data_int({apb_paddr_r[1:0],
                                hsize_r},
                            apb_prdata_i) : ((DATA_WIDTH == 16) ? read_data_int({{1'b0},
                                apb_paddr_r[0],
                                hsize_r},
                            apb_prdata_i) : apb_prdata_i)) ; 
            end
        else
            begin : dual_clk
                // HCLK registers
                reg h_pend_r ; 
                reg h_done_d1_r ; 
                reg h_done_d2_r ; 
                reg h_done_d3_r ; 
                reg h_done_d4_r ; 
                reg h_pslverr_d1_r ; 
                reg h_pslverr_d2_r ; 
                // PLCK registers
                reg p_pend_d1_r ; 
                reg p_pend_d2_r ; 
                reg p_pend_d3_r ; 
                reg p_done_r ; 
                reg [(ST_APB_W - 1):0] cs_apb_sm ; 
                reg [(ST_APB_W - 1):0] ns_apb_sm ; 
                reg [(DATA_WIDTH - 1):0] p_prdata_r ; 
                reg p_pslverr_r ; 
                reg p_psel_r ; 
                reg [(ADDR_WIDTH - 1):0] p_paddr_r ; 
                reg [(DATA_WIDTH - 1):0] p_pwdata_r ; 
                reg p_pwrite_r ; 
                reg p_penable_r ; 
                reg [2:0] p_psize_r ; 
                wire p_new_tx_w ; 
                // Note: p_pend_d1_r can be metastable
                //    assign    p_new_tx_w = (p_pend_d2_r  != p_pend_d1_r); // This toggles for new transaction
                assign p_new_tx_w = (p_pend_d2_r != p_pend_d3_r) ; // This toggles for new transaction
                // HCLK registering
                always
                    @(posedge clk_i or 
                        negedge rst_n_i)
                    begin
                        if ((~rst_n_i)) 
                            begin
                                h_pend_r <=  1'b0 ;
                                h_done_d1_r <=  1'b0 ;
                                h_done_d2_r <=  1'b0 ;
                                h_done_d3_r <=  1'b0 ;
                                h_done_d4_r <=  1'b0 ;
                                // h_pslverr_d1_r <=  1'b0 ;
                                // h_pslverr_d2_r <=  1'b0 ;
                            end
                        else
                            begin
                                // Invert h_pend_r during APB setup state
                                if ((((ns_ahbl_sm == ST_WRITE) || (ns_ahbl_sm == ST_WRITEP)) || (ns_ahbl_sm == ST_READ))) 
                                    h_pend_r <=  (~h_pend_r) ;
                                // 2FF synchronizer
                                h_done_d1_r <=  p_done_r ;
                                h_done_d2_r <=  h_done_d1_r ;
                                h_done_d3_r <=  h_done_d2_r ;
                                h_done_d4_r <=  h_done_d3_r ;
                                // h_pslverr_d1_r <= p_pslverr_r;
                                // h_pslverr_d2_r <= h_pslverr_d1_r;
                            end
                    end
                ahbl2apb_ipgen_lscc_toggle_pulsesync slverr_sync (.src_clk(pclk_i), 
                            .src_rstn(presetn_i), 
                            .dst_clk(clk_i), 
                            .dst_rstn(rst_n_i), 
                            .din(p_pslverr_r), 
                            .dout(h_pslverr_d2_r)) ; 
                always
                    @(*)
                    begin
                        //      ns_apb_sm = cs_apb_sm;
                        case (cs_apb_sm)
                        ST_APB_IDLE : 
                            begin
                                ns_apb_sm = (p_new_tx_w ? ST_APB_SETUP : ST_APB_IDLE) ;
                            end
                        ST_APB_SETUP : 
                            begin
                                // data is available in next cyle after address phase
                                ns_apb_sm = ST_APB_ACCESS ;
                            end
                        ST_APB_ACCESS : 
                            begin
                                ns_apb_sm = (apb_pready_i ? ST_APB_IDLE : ST_APB_ACCESS) ;
                            end
                        default : 
                            begin
                                ns_apb_sm = ST_APB_IDLE ;
                            end
                        endcase 
                    end
                // PCLK registering
                always
                    @(posedge pclk_i or 
                        negedge presetn_i)
                    begin
                        if ((~presetn_i)) 
                            begin
                                p_done_r <=  1'b0 ;
                                p_pend_d1_r <=  1'b0 ;
                                p_pend_d2_r <=  1'b0 ;
                                p_pend_d3_r <=  1'b0 ;
                                cs_apb_sm <=  ST_APB_IDLE ;
                                p_prdata_r <=  {DATA_WIDTH{1'b0}} ;
                                p_pslverr_r <=  1'b0 ;
                                p_psel_r <=  1'b0 ;
                                p_penable_r <=  1'b0 ;
                                p_paddr_r <=  {ADDR_WIDTH{1'b0}} ;
                                p_psize_r <=  3'b111 ;
                                p_pwdata_r <=  {DATA_WIDTH{1'b0}} ;
                                p_pwrite_r <=  1'b0 ;
                            end
                        else
                            begin
                                cs_apb_sm <=  ns_apb_sm ;
                                // Invert h_pend_r during APB setup state
                                if (((cs_apb_sm == ST_APB_ACCESS) && apb_pready_i)) 
                                    begin
                                        p_done_r <=  (~p_done_r) ;
                                        p_prdata_r <=  ((DATA_WIDTH == 32) ? read_data_int({p_paddr_r[1:0],
                                                    p_psize_r},
                                                apb_prdata_i) : ((DATA_WIDTH == 16) ? read_data_int({{1'b0},
                                                    p_paddr_r[0],
                                                    p_psize_r},
                                                apb_prdata_i) : apb_prdata_i)) ;
                                        // p_pslverr_r <= apb_pslverr_i;
                                    end
                                // else if (cs_apb_sm == ST_APB_SETUP)
                                //   p_pslverr_r <= 1'b0;
                                p_pslverr_r <=  (((apb_psel_r && apb_penable_r) && apb_pready_w) ? apb_pslverr_i : 1'b0) ;
                                // 2FF synchronizer
                                p_pend_d1_r <=  h_pend_r ;
                                p_pend_d2_r <=  p_pend_d1_r ;
                                p_pend_d3_r <=  p_pend_d2_r ;
                                case (ns_apb_sm)
                                ST_APB_SETUP : 
                                    begin
                                        // data is available in next cyle after address phase
                                        p_psel_r <=  1'b1 ;
                                        p_penable_r <=  1'b0 ;
                                        p_paddr_r <=  apb_paddr_r ;
                                        p_psize_r <=  apb_psize_r ;
                                        p_pwdata_r <=  apb_pwdata_r ;
                                        p_pwrite_r <=  apb_pwrite_r ;
                                    end
                                ST_APB_ACCESS : 
                                    begin
                                        p_psel_r <=  1'b1 ;
                                        p_penable_r <=  1'b1 ;
                                    end
                                default : 
                                    begin
                                        p_psel_r <=  1'b0 ;
                                        p_penable_r <=  1'b0 ;
                                    end
                                endcase 
                            end
                    end
                assign apb_psel_o = p_psel_r ; 
                assign apb_penable_o = p_penable_r ; 
                assign apb_paddr_o = p_paddr_r ; 
                assign apb_pwdata_o = p_pwdata_r ; 
                assign apb_pwrite_o = p_pwrite_r ; 
                //    assign apb_pready_w  = (h_done_d2_r != h_done_d1_r); // h_done_d1_r could be metastable
                assign apb_pready_w = (h_done_d3_r != h_done_d4_r) ; 
                assign apb_pslverr_w = h_pslverr_d2_r ; 
                assign apb_prdata_w = p_prdata_r ; 
            end
    endgenerate
endmodule



`timescale 1ns/1ps
module ahbl2apb_ipgen_lscc_toggle_pulsesync (
    // clocks and resets
    input src_clk,  // source clk domain
    input src_rstn,  // source resetn
    input dst_clk,  // destination clk domain
    input dst_rstn,  // destination resetn
    input din, 
    output dout // output pulse in dst_clk
        ) ;
    reg pls_toggle ; 
    reg pls_toggle_dstclk ; 
    wire pls_toggle_sync ; 
    // ----------
    // -- Main --
    //-----------
    always
        @(posedge src_clk or 
            negedge src_rstn)
        begin
            if ((~src_rstn)) 
                begin
                    pls_toggle <=  1'b0 ;
                end
            else
                if (din) 
                    begin
                        pls_toggle <=  (~pls_toggle) ;
                    end
        end
    always
        @(posedge dst_clk or 
            negedge dst_rstn)
        begin
            if ((~dst_rstn)) 
                begin
                    pls_toggle_dstclk <=  1'b0 ;
                end
            else
                begin
                    pls_toggle_dstclk <=  pls_toggle_sync ;
                end
        end
    // output
    assign dout = (pls_toggle_dstclk ^ pls_toggle_sync) ; 
    // ------------------
    // -- synchronizer --
    //-------------------
    ahbl2apb_ipgen_lscc_sync #(.SYNC_STAGE(2),
            .DEST_RST_MODE("ASYNC"),
            .RST_INIT(1'b0),
            .REGMODE(1'b0)) u_pls_toggle_sync (.dest_rst_n(dst_rstn), 
                .dest_clk(dst_clk), 
                .in_data(pls_toggle), 
                .out_data(pls_toggle_sync)) ; 
endmodule



`timescale 1ns/1ps
(* LATTICE_IP_MODULE=1 *) module ahbl2apb_ipgen_lscc_sync #(parameter SYNC_STAGE = 2, 
        parameter DEST_RST_MODE = "ASYNC", 
        parameter RST_INIT = 1'b0, 
        parameter REGMODE = 1'b0) (
    input logic in_data, 
    input logic dest_rst_n, 
    input logic dest_clk, 
    output logic out_data) ;
    //------------------------------------------------------------------------------
    // CDC
    //------------------------------------------------------------------------------
    logic dout_meta ; 
    logic [(SYNC_STAGE - 2):0] dout ; 
    generate
        if ((SYNC_STAGE == 2)) 
            begin : genblk1
                (* syn_preserve=1, CDC_Register=2 *) logic dout_cc ; 
                if ((DEST_RST_MODE == "ASYNC")) 
                    begin : genblk1
                        always_ff
                            @(posedge dest_clk or 
                                negedge dest_rst_n)
                            begin
                                if ((~dest_rst_n)) 
                                    begin
                                        dout_cc <=  RST_INIT ;
                                    end
                                else
                                    begin
                                        dout_cc <=  in_data ;
                                    end
                            end
                    end
                else
                    begin : genblk1
                        always_ff
                            @(posedge dest_clk)
                            begin
                                if ((~dest_rst_n)) 
                                    begin
                                        dout_cc <=  RST_INIT ;
                                    end
                                else
                                    begin
                                        dout_cc <=  in_data ;
                                    end
                            end
                    end
                assign dout_meta = dout_cc ; 
            end
        else
            if ((SYNC_STAGE == 3)) 
                begin : genblk1
                    (* syn_preserve=1, CDC_Register=3 *) logic dout_cc ; 
                    if ((DEST_RST_MODE == "ASYNC")) 
                        begin : genblk1
                            always_ff
                                @(posedge dest_clk or 
                                    negedge dest_rst_n)
                                begin
                                    if ((~dest_rst_n)) 
                                        begin
                                            dout_cc <=  RST_INIT ;
                                        end
                                    else
                                        begin
                                            dout_cc <=  in_data ;
                                        end
                                end
                        end
                    else
                        begin : genblk1
                            always_ff
                                @(posedge dest_clk)
                                begin
                                    if ((~dest_rst_n)) 
                                        begin
                                            dout_cc <=  RST_INIT ;
                                        end
                                    else
                                        begin
                                            dout_cc <=  in_data ;
                                        end
                                end
                        end
                    assign dout_meta = dout_cc ; 
                end
            else
                begin : genblk1
                    (* syn_preserve=1, CDC_Register=4 *) logic dout_cc ; 
                    if ((DEST_RST_MODE == "ASYNC")) 
                        begin : genblk1
                            always_ff
                                @(posedge dest_clk or 
                                    negedge dest_rst_n)
                                begin
                                    if ((~dest_rst_n)) 
                                        begin
                                            dout_cc <=  RST_INIT ;
                                        end
                                    else
                                        begin
                                            dout_cc <=  in_data ;
                                        end
                                end
                        end
                    else
                        begin : genblk1
                            always_ff
                                @(posedge dest_clk)
                                begin
                                    if ((~dest_rst_n)) 
                                        begin
                                            dout_cc <=  RST_INIT ;
                                        end
                                    else
                                        begin
                                            dout_cc <=  in_data ;
                                        end
                                end
                        end
                    assign dout_meta = dout_cc ; 
                end
    endgenerate
    generate
        if ((DEST_RST_MODE == "ASYNC")) 
            begin : genblk2
                always_ff
                    @(posedge dest_clk or 
                        negedge dest_rst_n)
                    begin
                        if ((~dest_rst_n)) 
                            begin
                                dout <=  {(SYNC_STAGE - 1){RST_INIT}} ;
                            end
                        else
                            begin
                                dout <=  ((SYNC_STAGE > 2) ? {dout[(SYNC_STAGE - 3):0],
                                        dout_meta} : dout_meta) ;
                            end
                    end
            end
        else
            begin : genblk2
                always_ff
                    @(posedge dest_clk)
                    begin
                        if ((~dest_rst_n)) 
                            begin
                                dout <=  {(SYNC_STAGE - 1){RST_INIT}} ;
                            end
                        else
                            begin
                                dout <=  ((SYNC_STAGE > 2) ? {dout[(SYNC_STAGE - 3):0],
                                        dout_meta} : dout_meta) ;
                            end
                    end
            end
    endgenerate
    generate
        if (REGMODE) 
            begin : genblk3
                if ((DEST_RST_MODE == "ASYNC")) 
                    begin : genblk1
                        always_ff
                            @(posedge dest_clk or 
                                negedge dest_rst_n)
                            begin
                                if ((~dest_rst_n)) 
                                    out_data <=  RST_INIT ;
                                else
                                    out_data <=  dout[(SYNC_STAGE - 2)] ;
                            end
                    end
                else
                    begin : genblk1
                        always_ff
                            @(posedge dest_clk)
                            begin
                                if ((~dest_rst_n)) 
                                    out_data <=  RST_INIT ;
                                else
                                    out_data <=  dout[(SYNC_STAGE - 2)] ;
                            end
                    end
            end
        else
            begin : genblk3
                assign out_data = dout[(SYNC_STAGE - 2)] ; 
            end
    endgenerate
endmodule


