
/*******************************************************************************
    Verilog netlist generated by IPGEN Lattice Propel (64-bit)
    2024.2.2412062206
    Soft IP Version: 2.3.0
    2025 03 19 08:48:00
*******************************************************************************/
/*******************************************************************************
    Wrapper Module generated per user settings.
*******************************************************************************/
(* ORIG_MODULE_NAME="sysmem", LATTICE_IP_GENERATED="1" *) module sysmem (ahbl_hclk_i, 
        ahbl_hresetn_i, 
        ahbl_s0_hsel_i, 
        ahbl_s0_hready_i, 
        ahbl_s0_haddr_i, 
        ahbl_s0_hburst_i, 
        ahbl_s0_hsize_i, 
        ahbl_s0_hmastlock_i, 
        ahbl_s0_hprot_i, 
        ahbl_s0_htrans_i, 
        ahbl_s0_hwrite_i, 
        ahbl_s0_hwdata_i, 
        ahbl_s0_hreadyout_o, 
        ahbl_s0_hresp_o, 
        ahbl_s0_hrdata_o, 
        ahbl_s1_hsel_i, 
        ahbl_s1_hready_i, 
        ahbl_s1_haddr_i, 
        ahbl_s1_hburst_i, 
        ahbl_s1_hsize_i, 
        ahbl_s1_hmastlock_i, 
        ahbl_s1_hprot_i, 
        ahbl_s1_htrans_i, 
        ahbl_s1_hwrite_i, 
        ahbl_s1_hwdata_i, 
        ahbl_s1_hreadyout_o, 
        ahbl_s1_hresp_o, 
        ahbl_s1_hrdata_o) ;
    input ahbl_hclk_i ; 
    input ahbl_hresetn_i ; 
    input ahbl_s0_hsel_i ; 
    input ahbl_s0_hready_i ; 
    input [31:0] ahbl_s0_haddr_i ; 
    input [2:0] ahbl_s0_hburst_i ; 
    input [2:0] ahbl_s0_hsize_i ; 
    input ahbl_s0_hmastlock_i ; 
    input [3:0] ahbl_s0_hprot_i ; 
    input [1:0] ahbl_s0_htrans_i ; 
    input ahbl_s0_hwrite_i ; 
    input [31:0] ahbl_s0_hwdata_i ; 
    output ahbl_s0_hreadyout_o ; 
    output ahbl_s0_hresp_o ; 
    output [31:0] ahbl_s0_hrdata_o ; 
    input ahbl_s1_hsel_i ; 
    input ahbl_s1_hready_i ; 
    input [31:0] ahbl_s1_haddr_i ; 
    input [2:0] ahbl_s1_hburst_i ; 
    input [2:0] ahbl_s1_hsize_i ; 
    input ahbl_s1_hmastlock_i ; 
    input [3:0] ahbl_s1_hprot_i ; 
    input [1:0] ahbl_s1_htrans_i ; 
    input ahbl_s1_hwrite_i ; 
    input [31:0] ahbl_s1_hwdata_i ; 
    output ahbl_s1_hreadyout_o ; 
    output ahbl_s1_hresp_o ; 
    output [31:0] ahbl_s1_hrdata_o ; 
    parameter MEM_ID = "sysmem" ; 
    sysmem_ipgen_lscc_sys_mem #(.FAMILY("LFD2NX"),
            .DEVICE("LFD2NX-40"),
            .INTERFACE("AHBL"),
            .ADDR_DEPTH(32768),
            .MEM_ID(MEM_ID),
            .MEM_SIZE("32,32768"),
            .DATA_WIDTH(32),
            .MEMORY_TYPE("EBR"),
            .PORT_COUNT(2),
            .ECC_ENABLE(0),
            .ARBITER_EN(0),
            .ID_WIDTH(4),
            .DATA_STREAMER_EN(0),
            .STREAMER_INTF("FIFO"),
            .STREAMER_CLK_BYPASS(0),
            .STREAMER_START_ADDR(0),
            .INIT_FILE_FORMAT("none"),
            .INIT_FILE("none"),
            .INIT_VALUE_00("0"),
            .INIT_VALUE_01("0"),
            .INIT_VALUE_02("0"),
            .INIT_VALUE_03("0"),
            .INIT_VALUE_04("0"),
            .INIT_VALUE_05("0"),
            .INIT_VALUE_06("0"),
            .INIT_VALUE_07("0"),
            .INIT_VALUE_08("0"),
            .INIT_VALUE_09("0"),
            .INIT_VALUE_0A("0"),
            .INIT_VALUE_0B("0"),
            .INIT_VALUE_0C("0"),
            .INIT_VALUE_0D("0"),
            .INIT_VALUE_0E("0"),
            .INIT_VALUE_0F("0"),
            .INIT_VALUE_10("0"),
            .INIT_VALUE_11("0"),
            .INIT_VALUE_12("0"),
            .INIT_VALUE_13("0"),
            .INIT_VALUE_14("0"),
            .INIT_VALUE_15("0"),
            .INIT_VALUE_16("0"),
            .INIT_VALUE_17("0"),
            .INIT_VALUE_18("0"),
            .INIT_VALUE_19("0"),
            .INIT_VALUE_1A("0"),
            .INIT_VALUE_1B("0"),
            .INIT_VALUE_1C("0"),
            .INIT_VALUE_1D("0"),
            .INIT_VALUE_1E("0"),
            .INIT_VALUE_1F("0"),
            .INIT_VALUE_20("0"),
            .INIT_VALUE_21("0"),
            .INIT_VALUE_22("0"),
            .INIT_VALUE_23("0"),
            .INIT_VALUE_24("0"),
            .INIT_VALUE_25("0"),
            .INIT_VALUE_26("0"),
            .INIT_VALUE_27("0"),
            .INIT_VALUE_28("0"),
            .INIT_VALUE_29("0"),
            .INIT_VALUE_2A("0"),
            .INIT_VALUE_2B("0"),
            .INIT_VALUE_2C("0"),
            .INIT_VALUE_2D("0"),
            .INIT_VALUE_2E("0"),
            .INIT_VALUE_2F("0"),
            .INIT_VALUE_30("0"),
            .INIT_VALUE_31("0"),
            .INIT_VALUE_32("0"),
            .INIT_VALUE_33("0"),
            .INIT_VALUE_34("0"),
            .INIT_VALUE_35("0"),
            .INIT_VALUE_36("0"),
            .INIT_VALUE_37("0"),
            .INIT_VALUE_38("0"),
            .INIT_VALUE_39("0"),
            .INIT_VALUE_3A("0"),
            .INIT_VALUE_3B("0"),
            .INIT_VALUE_3C("0"),
            .INIT_VALUE_3D("0"),
            .INIT_VALUE_3E("0"),
            .INIT_VALUE_3F("0"),
            .INIT_VALUE_40("0"),
            .INIT_VALUE_41("0"),
            .INIT_VALUE_42("0"),
            .INIT_VALUE_43("0"),
            .INIT_VALUE_44("0"),
            .INIT_VALUE_45("0"),
            .INIT_VALUE_46("0"),
            .INIT_VALUE_47("0"),
            .INIT_VALUE_48("0"),
            .INIT_VALUE_49("0"),
            .INIT_VALUE_4A("0"),
            .INIT_VALUE_4B("0"),
            .INIT_VALUE_4C("0"),
            .INIT_VALUE_4D("0"),
            .INIT_VALUE_4E("0"),
            .INIT_VALUE_4F("0"),
            .INIT_VALUE_50("0"),
            .INIT_VALUE_51("0"),
            .INIT_VALUE_52("0"),
            .INIT_VALUE_53("0"),
            .INIT_VALUE_54("0"),
            .INIT_VALUE_55("0"),
            .INIT_VALUE_56("0"),
            .INIT_VALUE_57("0"),
            .INIT_VALUE_58("0"),
            .INIT_VALUE_59("0"),
            .INIT_VALUE_5A("0"),
            .INIT_VALUE_5B("0"),
            .INIT_VALUE_5C("0"),
            .INIT_VALUE_5D("0"),
            .INIT_VALUE_5E("0"),
            .INIT_VALUE_5F("0"),
            .INIT_VALUE_60("0"),
            .INIT_VALUE_61("0"),
            .INIT_VALUE_62("0"),
            .INIT_VALUE_63("0"),
            .INIT_VALUE_64("0"),
            .INIT_VALUE_65("0"),
            .INIT_VALUE_66("0"),
            .INIT_VALUE_67("0"),
            .INIT_VALUE_68("0"),
            .INIT_VALUE_69("0"),
            .INIT_VALUE_6A("0"),
            .INIT_VALUE_6B("0"),
            .INIT_VALUE_6C("0"),
            .INIT_VALUE_6D("0"),
            .INIT_VALUE_6E("0"),
            .INIT_VALUE_6F("0"),
            .INIT_VALUE_70("0"),
            .INIT_VALUE_71("0"),
            .INIT_VALUE_72("0"),
            .INIT_VALUE_73("0"),
            .INIT_VALUE_74("0"),
            .INIT_VALUE_75("0"),
            .INIT_VALUE_76("0"),
            .INIT_VALUE_77("0"),
            .INIT_VALUE_78("0"),
            .INIT_VALUE_79("0"),
            .INIT_VALUE_7A("0"),
            .INIT_VALUE_7B("0"),
            .INIT_VALUE_7C("0"),
            .INIT_VALUE_7D("0"),
            .INIT_VALUE_7E("0"),
            .INIT_VALUE_7F("0"),
            .REGMODE_S0("reg"),
            .READ_PIPELINE_S0(0),
            .RESET_MODE_S0("sync"),
            .BYTE_ENABLE_S0(1),
            .UNALIGNED_ACCESS_EN_S0(0),
            .SHIFT_DIRECTION_S0("none"),
            .S0_START_ADDR(0),
            .S0_END_ADDR(131071),
            .ACCESS_TYPE_S0("R/W"),
            .REGMODE_S1("noreg"),
            .READ_PIPELINE_S1(0),
            .RESET_MODE_S1("sync"),
            .BYTE_ENABLE_S1(1),
            .UNALIGNED_ACCESS_EN_S1(0),
            .SHIFT_DIRECTION_S1("none"),
            .S1_START_ADDR(0),
            .S1_END_ADDR(131071),
            .ACCESS_TYPE_S1("R/W")) lscc_sys_mem_inst (.ahbl_hclk_i(ahbl_hclk_i), 
                .ahbl_hresetn_i(ahbl_hresetn_i), 
                .axi_aclk_i(1'b0), 
                .axi_resetn_i(1'b0), 
                .ahbl_s0_hsel_i(ahbl_s0_hsel_i), 
                .ahbl_s0_hready_i(ahbl_s0_hready_i), 
                .ahbl_s0_haddr_i(ahbl_s0_haddr_i[31:0]), 
                .ahbl_s0_hburst_i(ahbl_s0_hburst_i[2:0]), 
                .ahbl_s0_hsize_i(ahbl_s0_hsize_i[2:0]), 
                .ahbl_s0_hmastlock_i(ahbl_s0_hmastlock_i), 
                .ahbl_s0_hprot_i(ahbl_s0_hprot_i[3:0]), 
                .ahbl_s0_htrans_i(ahbl_s0_htrans_i[1:0]), 
                .ahbl_s0_hwrite_i(ahbl_s0_hwrite_i), 
                .ahbl_s0_hwdata_i(ahbl_s0_hwdata_i[31:0]), 
                .ahbl_s0_hreadyout_o(ahbl_s0_hreadyout_o), 
                .ahbl_s0_hresp_o(ahbl_s0_hresp_o), 
                .ahbl_s0_hrdata_o(ahbl_s0_hrdata_o[31:0]), 
                .axi_s0_awaddr_i(32'b00000000000000000000000000000000), 
                .axi_s0_awvalid_i(1'b0), 
                .axi_s0_awprot_i(3'b000), 
                .axi_s0_awready_o(), 
                .axi_s0_awid_i(4'b0000), 
                .axi_s0_awlen_i(8'b00000000), 
                .axi_s0_awsize_i(3'b000), 
                .axi_s0_awburst_i(2'b00), 
                .axi_s0_awlock_i(1'b0), 
                .axi_s0_awcache_i(4'b0000), 
                .axi_s0_awqos_i(4'b0000), 
                .axi_s0_awregion_i(4'b0000), 
                .axi_s0_wdata_i(32'b00000000000000000000000000000000), 
                .axi_s0_wstrb_i(4'b0000), 
                .axi_s0_wvalid_i(1'b0), 
                .axi_s0_wready_o(), 
                .axi_s0_wlast_i(1'b0), 
                .axi_s0_bready_i(1'b0), 
                .axi_s0_bresp_o(), 
                .axi_s0_bvalid_o(), 
                .axi_s0_bid_o(), 
                .axi_s0_araddr_i(32'b00000000000000000000000000000000), 
                .axi_s0_arvalid_i(1'b0), 
                .axi_s0_arprot_i(3'b000), 
                .axi_s0_arready_o(), 
                .axi_s0_arid_i(4'b0000), 
                .axi_s0_arlen_i(8'b00000000), 
                .axi_s0_arsize_i(3'b000), 
                .axi_s0_arburst_i(2'b00), 
                .axi_s0_arlock_i(1'b0), 
                .axi_s0_arcache_i(4'b0000), 
                .axi_s0_arqos_i(4'b0000), 
                .axi_s0_arregion_i(4'b0000), 
                .axi_s0_rdata_o(), 
                .axi_s0_rready_i(1'b0), 
                .axi_s0_rresp_o(), 
                .axi_s0_rvalid_o(), 
                .axi_s0_rid_o(), 
                .axi_s0_rlast_o(), 
                .ahbl_s1_hsel_i(ahbl_s1_hsel_i), 
                .ahbl_s1_hready_i(ahbl_s1_hready_i), 
                .ahbl_s1_haddr_i(ahbl_s1_haddr_i[31:0]), 
                .ahbl_s1_hburst_i(ahbl_s1_hburst_i[2:0]), 
                .ahbl_s1_hsize_i(ahbl_s1_hsize_i[2:0]), 
                .ahbl_s1_hmastlock_i(ahbl_s1_hmastlock_i), 
                .ahbl_s1_hprot_i(ahbl_s1_hprot_i[3:0]), 
                .ahbl_s1_htrans_i(ahbl_s1_htrans_i[1:0]), 
                .ahbl_s1_hwrite_i(ahbl_s1_hwrite_i), 
                .ahbl_s1_hwdata_i(ahbl_s1_hwdata_i[31:0]), 
                .ahbl_s1_hreadyout_o(ahbl_s1_hreadyout_o), 
                .ahbl_s1_hresp_o(ahbl_s1_hresp_o), 
                .ahbl_s1_hrdata_o(ahbl_s1_hrdata_o[31:0]), 
                .axi_s1_awaddr_i(32'b00000000000000000000000000000000), 
                .axi_s1_awvalid_i(1'b0), 
                .axi_s1_awprot_i(3'b000), 
                .axi_s1_awready_o(), 
                .axi_s1_awid_i(4'b0000), 
                .axi_s1_awlen_i(8'b00000000), 
                .axi_s1_awsize_i(3'b000), 
                .axi_s1_awburst_i(2'b00), 
                .axi_s1_awlock_i(1'b0), 
                .axi_s1_awcache_i(4'b0000), 
                .axi_s1_awqos_i(4'b0000), 
                .axi_s1_awregion_i(4'b0000), 
                .axi_s1_wdata_i(32'b00000000000000000000000000000000), 
                .axi_s1_wstrb_i(4'b0000), 
                .axi_s1_wvalid_i(1'b0), 
                .axi_s1_wready_o(), 
                .axi_s1_wlast_i(1'b0), 
                .axi_s1_bready_i(1'b0), 
                .axi_s1_bresp_o(), 
                .axi_s1_bvalid_o(), 
                .axi_s1_bid_o(), 
                .axi_s1_araddr_i(32'b00000000000000000000000000000000), 
                .axi_s1_arvalid_i(1'b0), 
                .axi_s1_arprot_i(3'b000), 
                .axi_s1_arready_o(), 
                .axi_s1_arid_i(4'b0000), 
                .axi_s1_arlen_i(8'b00000000), 
                .axi_s1_arsize_i(3'b000), 
                .axi_s1_arburst_i(2'b00), 
                .axi_s1_arlock_i(1'b0), 
                .axi_s1_arcache_i(4'b0000), 
                .axi_s1_arqos_i(4'b0000), 
                .axi_s1_arregion_i(4'b0000), 
                .axi_s1_rdata_o(), 
                .axi_s1_rready_i(1'b0), 
                .axi_s1_rresp_o(), 
                .axi_s1_rvalid_o(), 
                .axi_s1_rid_o(), 
                .axi_s1_rlast_o(), 
                .ecc_sec_s0_o(), 
                .ecc_ded_s0_o(), 
                .ecc_sec_s1_o(), 
                .ecc_ded_s1_o(), 
                .fifo_clk_i(1'b0), 
                .fifo_wr_en_i(1'b0), 
                .fifo_interface_en_i(1'b0), 
                .fifo_wr_data_i(8'b00000000), 
                .fifo_address_rst_i(1'b0), 
                .fifo_full_o(), 
                .axis_rx_aclk_i(1'b0), 
                .axi_rx_tvalid_i(1'b0), 
                .axi_rx_tdata_i(32'b00000000000000000000000000000000), 
                .axi_rx_tstrb_i(4'b0000), 
                .axi_rx_tlast_i(1'b0), 
                .axi_rx_tready_o()) ; 
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
module sysmem_ipgen_lscc_axi4stream_rx #(parameter ADDR_DEPTH = 16384, 
        parameter ADDR_WIDTH = 32, 
        parameter FIFO_START = 0, 
        parameter DATA_WIDTH = 32, 
        parameter BYTE_WIDTH = (DATA_WIDTH / 8), 
        parameter MEM_TYPE = "EBR") (
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input axis_rx_aclk_i, 
    input axis_rx_aresetn_i, 
    input axis_rx_tvalid_i, 
    input [(DATA_WIDTH - 1):0] axis_rx_tdata_i, 
    input [((DATA_WIDTH / 8) - 1):0] axis_rx_tstrb_i, 
    input axis_rx_tlast_i, 
    output axis_rx_wr_en_o, 
    output [(DATA_WIDTH - 1):0] axis_rx_wr_data_o, 
    output [(BYTE_WIDTH - 1):0] axis_rx_byte_en_o, 
    output [(ADDR_WIDTH - 1):0] axis_rx_wr_addr_o, 
    output axis_rx_arb_hold_o, 
    output axis_rx_tready_o) ;
    localparam ADDR_INCR_SIZE_WIDTH = clog2((DATA_WIDTH / 8)) ; 
    // ------------------------------------------------------------------------------
    // Register Declarations
    // ------------------------------------------------------------------------------
    reg axis_rx_wr_en_reg ; 
    reg [(DATA_WIDTH - 1):0] axis_rx_wr_data_reg ; 
    reg [(BYTE_WIDTH - 1):0] axis_rx_byte_en_reg ; 
    reg [31:0] axis_rx_wr_addr_reg ; 
    reg axis_rx_tready_reg ; 
    reg axis_rx_tlast_reg ; 
    reg axis_rx_arb_hold_reg ; 
    reg axis_rx_arb_hold2_reg ; 
    // ------------------------------------------------------------------------------
    // AXI4-Stream Logic
    // ------------------------------------------------------------------------------
    always
        @(posedge axis_rx_aclk_i or 
            negedge axis_rx_aresetn_i)
        if ((~axis_rx_aresetn_i)) 
            axis_rx_wr_en_reg <=  1'b0 ;
        else
            if ((axis_rx_tvalid_i && axis_rx_tready_reg)) 
                axis_rx_wr_en_reg <=  1'b1 ;
            else
                axis_rx_wr_en_reg <=  1'b0 ;
    always
        @(posedge axis_rx_aclk_i or 
            negedge axis_rx_aresetn_i)
        if ((~axis_rx_aresetn_i)) 
            axis_rx_wr_addr_reg <=  FIFO_START ;
        else
            if (axis_rx_tlast_reg) 
                axis_rx_wr_addr_reg <=  FIFO_START ;
            else
                if ((~axis_rx_tready_reg)) 
                    axis_rx_wr_addr_reg <=  axis_rx_wr_addr_reg ;
                else
                    if (axis_rx_wr_en_reg) 
                        axis_rx_wr_addr_reg <=  (axis_rx_wr_addr_reg + BYTE_WIDTH) ;
    always
        @(posedge axis_rx_aclk_i or 
            negedge axis_rx_aresetn_i)
        if ((~axis_rx_aresetn_i)) 
            axis_rx_wr_data_reg <=  {DATA_WIDTH{1'b0}} ;
        else
            if (axis_rx_tvalid_i) 
                axis_rx_wr_data_reg <=  axis_rx_tdata_i ;
    always
        @(posedge axis_rx_aclk_i or 
            negedge axis_rx_aresetn_i)
        if ((~axis_rx_aresetn_i)) 
            axis_rx_byte_en_reg <=  {BYTE_WIDTH{1'b0}} ;
        else
            if (axis_rx_tvalid_i) 
                axis_rx_byte_en_reg <=  axis_rx_tstrb_i ;
    always
        @(posedge axis_rx_aclk_i or 
            negedge axis_rx_aresetn_i)
        if ((~axis_rx_aresetn_i)) 
            axis_rx_tready_reg <=  1'b0 ;
        else
            if ((~axis_rx_arb_hold2_reg)) 
                axis_rx_tready_reg <=  1'b0 ;
            else
                axis_rx_tready_reg <=  1'b1 ;
    always
        @(posedge axis_rx_aclk_i or 
            negedge axis_rx_aresetn_i)
        if ((~axis_rx_aresetn_i)) 
            axis_rx_tlast_reg <=  1'b0 ;
        else
            if (((axis_rx_tlast_i && axis_rx_tvalid_i) && axis_rx_tready_reg)) 
                axis_rx_tlast_reg <=  1'b1 ;
            else
                axis_rx_tlast_reg <=  1'b0 ;
    always
        @(posedge axis_rx_aclk_i or 
            negedge axis_rx_aresetn_i)
        if ((~axis_rx_aresetn_i)) 
            axis_rx_arb_hold_reg <=  1'b1 ;
        else
            if (axis_rx_tvalid_i) 
                axis_rx_arb_hold_reg <=  1'b1 ;
            else
                axis_rx_arb_hold_reg <=  1'b0 ;
    always
        @(posedge axis_rx_aclk_i or 
            negedge axis_rx_aresetn_i)
        if ((~axis_rx_aresetn_i)) 
            axis_rx_arb_hold2_reg <=  1'b1 ;
        else
            if (axis_rx_tvalid_i) 
                axis_rx_arb_hold2_reg <=  1'b1 ;
            else
                if ((~axis_rx_arb_hold_reg)) 
                    axis_rx_arb_hold2_reg <=  1'b0 ;
    // ------------------------------------------------------------------------------
    // Output Declarations
    // ------------------------------------------------------------------------------
    assign axis_rx_wr_en_o = axis_rx_wr_en_reg ; 
    assign axis_rx_wr_data_o = axis_rx_wr_data_reg ; 
    assign axis_rx_byte_en_o = axis_rx_byte_en_reg ; 
    assign axis_rx_wr_addr_o = axis_rx_wr_addr_reg[31:ADDR_INCR_SIZE_WIDTH] ; 
    assign axis_rx_tready_o = axis_rx_tready_reg ; 
    assign axis_rx_arb_hold_o = axis_rx_arb_hold2_reg ; 
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
module sysmem_ipgen_lscc_fifo_streamer #(parameter ADDR_DEPTH = 16384, 
        parameter ADDR_WIDTH = clog2(ADDR_DEPTH), 
        parameter FIFO_START = 0, 
        parameter DATA_WIDTH = 32, 
        parameter BYTE_WIDTH = (DATA_WIDTH / 8), 
        parameter MEM_TYPE = "EBR") (
    input fifo_clk_i, 
    input fifo_wr_en_i, 
    input [7:0] fifo_wr_data_i, 
    input fifo_rst_i, 
    output reg fifo_full_o, 
    output [(DATA_WIDTH - 1):0] mem_wdata_o, 
    output mem_clk_en_o, 
    output [(ADDR_WIDTH - 1):0] mem_addr_o, 
    output [(BYTE_WIDTH - 1):0] mem_byte_en_o) ;
    reg fifo_full_int_r ; 
    reg [ADDR_WIDTH:0] mem_addr_r ; 
    reg [ADDR_WIDTH:0] mem_addr_nxt_c ; 
    reg fifo_full_nxt_c ; 
    reg [(BYTE_WIDTH - 1):0] mem_byte_en_r ; 
    reg [(BYTE_WIDTH - 1):0] mem_byte_en_nxt_c ; 
    assign mem_addr_o = mem_addr_r[(ADDR_WIDTH - 1):0] ; 
    assign mem_wdata_o = {BYTE_WIDTH{fifo_wr_data_i}} ; 
    assign mem_clk_en_o = ((~fifo_full_int_r) & fifo_wr_en_i) ; 
    if ((MEM_TYPE == "LRAM")) 
        begin : genblk1
            genvar i0 ; 
            for (i0 = 0;(i0 < BYTE_WIDTH);i0 = (i0 + 1))
            begin : genblk1
                assign mem_byte_en_o[i0] = (~mem_byte_en_r[i0]) ; 
            end
        end
    else
        begin : genblk1
            assign mem_byte_en_o = mem_byte_en_r ; 
        end
    if ((BYTE_WIDTH == 1)) 
        begin : genblk2
            always
                @(*)
                begin
                    mem_addr_nxt_c = mem_addr_r ;
                    if (mem_clk_en_o) 
                        begin
                            mem_addr_nxt_c = (mem_addr_r + 1'b1) ;
                        end
                end
            always
                @(*)
                begin
                    mem_byte_en_nxt_c = 1'b1 ;
                end
        end
    else
        begin : genblk2
            always
                @(*)
                begin
                    mem_addr_nxt_c = mem_addr_r ;
                    if ((mem_clk_en_o & mem_byte_en_r[(BYTE_WIDTH - 1)])) 
                        begin
                            mem_addr_nxt_c = (mem_addr_r + 1'b1) ;
                        end
                end
            always
                @(*)
                begin
                    mem_byte_en_nxt_c = (mem_clk_en_o ? {mem_byte_en_r[(BYTE_WIDTH - 2):0],
                            mem_byte_en_r[(BYTE_WIDTH - 1)]} : mem_byte_en_r) ;
                end
        end
    always
        @(*)
        begin
            fifo_full_nxt_c = (fifo_full_int_r | (fifo_wr_en_i && (mem_addr_nxt_c == ADDR_DEPTH))) ;
        end
    always
        @(posedge fifo_clk_i or 
            negedge fifo_rst_i)
        begin
            if ((~fifo_rst_i)) 
                begin
                    mem_addr_r <=  FIFO_START ;
                    mem_byte_en_r <=  4'h1 ;
                    fifo_full_o <=  1'b0 ;
                    fifo_full_int_r <=  1'b0 ;
                end
            else
                begin
                    mem_addr_r <=  mem_addr_nxt_c ;
                    mem_byte_en_r <=  mem_byte_en_nxt_c ;
                    fifo_full_o <=  fifo_full_nxt_c ;
                    fifo_full_int_r <=  fifo_full_nxt_c ;
                end
        end
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
module sysmem_ipgen_lscc_smem_lram #(parameter ADDR_DEPTH = 16384, 
        parameter ADDR_WIDTH = clog2(ADDR_DEPTH), 
        parameter DATA_WIDTH = 32, 
        parameter UNALIGNED_ACCESS_ENABLE = 0, 
        parameter BYTE_ENABLE_A = 0, 
        parameter BYTE_WIDTH_A = (((BYTE_ENABLE_A == 0) & (UNALIGNED_ACCESS_ENABLE == 0)) ? 1 : (DATA_WIDTH / 8)), 
        parameter BYTE_ENABLE_B = 0, 
        parameter BYTE_WIDTH_B = (((BYTE_ENABLE_B == 0) & (UNALIGNED_ACCESS_ENABLE == 0)) ? 1 : (DATA_WIDTH / 8)), 
        parameter ECC_ENABLE = 0, 
        parameter MEM_ID = "MEM0", 
        parameter MEM_SIZE = "32,16384", 
        parameter REGMODE_A = "reg", 
        parameter REGMODE_B = "reg", 
        parameter RESET_MODE = "sync", 
        parameter ASYNC_RST_RELEASE = "sync", 
        parameter READ_PIPELINE_S0 = 0, 
        parameter READ_PIPELINE_S1 = 0, 
        parameter INIT_MODE = "mem_file", 
        parameter INITVAL_00 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_01 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_02 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_03 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_04 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_05 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_06 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_07 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_08 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_09 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_10 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_11 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_12 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_13 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_14 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_15 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_16 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_17 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_18 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_19 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_20 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_21 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_22 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_23 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_24 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_25 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_26 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_27 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_28 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_29 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_30 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_31 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_32 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_33 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_34 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_35 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_36 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_37 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_38 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_39 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_40 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_41 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_42 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_43 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_44 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_45 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_46 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_47 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_48 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_49 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_4A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_4B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_4C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_4D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_4E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_4F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_50 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_51 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_52 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_53 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_54 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_55 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_56 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_57 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_58 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_59 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_5A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_5B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_5C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_5D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_5E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_5F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_60 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_61 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_62 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_63 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_64 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_65 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_66 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_67 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_68 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_69 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_6A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_6B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_6C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_6D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_6E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_6F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_70 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_71 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_72 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_73 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_74 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_75 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_76 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_77 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_78 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_79 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_7A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_7B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_7C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_7D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_7E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_7F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") (
    // ----------- input clock -----------
    input clk_i, 
    // ----------- LRAM port A -----------
    input [(ADDR_WIDTH - 1):0] addr_a_i, 
    input [(DATA_WIDTH - 1):0] wr_data_a_i, 
    input clk_en_a_i, 
    input wr_en_a_i, 
    input rst_a_i, 
    input [(BYTE_WIDTH_A - 1):0] ben_a_i, 
    output [(DATA_WIDTH - 1):0] rd_data_a_o, 
    // ----------- LRAM port B -----------
    input [(ADDR_WIDTH - 1):0] addr_b_i, 
    input [(DATA_WIDTH - 1):0] wr_data_b_i, 
    input clk_en_b_i, 
    input wr_en_b_i, 
    input rst_b_i, 
    input [(BYTE_WIDTH_B - 1):0] ben_b_i, 
    output [(DATA_WIDTH - 1):0] rd_data_b_o, 
    // --------- common signals ---------
    input dps_i, 
    output lramready_o, 
    output [1:0] errdet_a_o, 
    output [1:0] errdet_b_o) ;
    localparam STRING_LENGTH = 1282 ; 
    genvar i0 ; 
    generate
        localparam LRAM_ADDR = LRAM_USE(ADDR_DEPTH,
                    DATA_WIDTH) ; 
        localparam ADDR_IMPL = ((DATA_WIDTH == 32) ? 14 : ((DATA_WIDTH == 16) ? 15 : 16)) ; 
        wire [(ADDR_IMPL - 1):0] addr_a_w ; 
        wire [(ADDR_IMPL - 1):0] addr_b_w ; 
        if ((ADDR_WIDTH > ADDR_IMPL)) 
            begin : genblk1
                assign addr_a_w = addr_a_i[(ADDR_IMPL - 1):0] ; 
                assign addr_b_w = addr_b_i[(ADDR_IMPL - 1):0] ; 
            end
        else
            if ((ADDR_WIDTH == ADDR_IMPL)) 
                begin : genblk1
                    assign addr_a_w = addr_a_i ; 
                    assign addr_b_w = addr_b_i ; 
                end
            else
                begin : genblk1
                    assign addr_a_w[(ADDR_WIDTH - 1):0] = addr_a_i ; 
                    assign addr_a_w[(ADDR_IMPL - 1):ADDR_WIDTH] = {(ADDR_IMPL - ADDR_WIDTH){1'b0}} ; 
                    assign addr_b_w[(ADDR_WIDTH - 1):0] = addr_b_i ; 
                    assign addr_b_w[(ADDR_IMPL - 1):ADDR_WIDTH] = {(ADDR_IMPL - ADDR_WIDTH){1'b0}} ; 
                end
        wire [(DATA_WIDTH - 1):0] rd_data_a_raw_w [(LRAM_ADDR - 1):0] ; 
        wire [(DATA_WIDTH - 1):0] rd_data_b_raw_w [(LRAM_ADDR - 1):0] ; 
        wire [(LRAM_ADDR - 1):0] lramready_raw_w ; 
        wire [1:0] errdet_a_w [(LRAM_ADDR - 1):0] ; 
        wire [1:0] errdet_b_w [(LRAM_ADDR - 1):0] ; 
        assign lramready_o = (&lramready_raw_w) ; 
        for (i0 = 0;(i0 < LRAM_ADDR);i0 = (i0 + 1))
        begin : genblk2
            wire [1:0] errdet_a_lram_w ; 
            wire [1:0] errdet_b_lram_w ; 
            assign errdet_a_w[i0] = errdet_a_lram_w ; 
            assign errdet_b_w[i0] = errdet_b_lram_w ; 
            wire wr_en_a_w ; 
            if ((LRAM_ADDR == 1)) 
                begin : genblk1
                    assign wr_en_a_w = wr_en_a_i ; 
                end
            else
                begin : genblk1
                    assign wr_en_a_w = ((addr_a_i[(ADDR_WIDTH - 1):ADDR_IMPL] == i0) & wr_en_a_i) ; 
                end
            wire wr_en_b_w ; 
            if ((LRAM_ADDR == 1)) 
                begin : genblk2
                    assign wr_en_b_w = wr_en_b_i ; 
                end
            else
                begin : genblk2
                    assign wr_en_b_w = ((addr_b_i[(ADDR_WIDTH - 1):ADDR_IMPL] == i0) & wr_en_b_i) ; 
                end
            localparam OPT_DATA_WIDTH = DATA_WIDTH ; 
            localparam OPT_ADDR_DEPTH = data_to_addr(OPT_DATA_WIDTH) ; 
            localparam OPT_ADDR_WIDTH = clog2(OPT_ADDR_DEPTH) ; 
            localparam ECO_POSX = 0 ; 
            localparam ECO_POSY = (i0 * OPT_ADDR_DEPTH) ; 
            if ((INIT_MODE == "mem_file")) 
                begin : genblk3
                    sysmem_ipgen_lscc_lram_core #(.DATA_WIDTH(DATA_WIDTH),
                            .ADDR_WIDTH(ADDR_IMPL),
                            .BYTE_ENABLE_A(BYTE_ENABLE_A),
                            .BYTE_ENABLE_B(BYTE_ENABLE_B),
                            .REGMODE_A(REGMODE_A),
                            .REGMODE_B(REGMODE_B),
                            .RESET_MODE(RESET_MODE),
                            .ECC_ENABLE(ECC_ENABLE),
                            .MEM_ID(MEM_ID),
                            .MEM_SIZE(MEM_SIZE),
                            .POSx(ECO_POSX),
                            .POSy(ECO_POSY),
                            .ASYNC_RST_RELEASE(ASYNC_RST_RELEASE),
                            .UNALIGNED_ACCESS_ENABLE(UNALIGNED_ACCESS_ENABLE),
                            .INITVAL_00(INITVAL_00[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_01(INITVAL_01[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_02(INITVAL_02[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_03(INITVAL_03[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_04(INITVAL_04[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_05(INITVAL_05[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_06(INITVAL_06[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_07(INITVAL_07[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_08(INITVAL_08[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_09(INITVAL_09[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_0A(INITVAL_0A[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_0B(INITVAL_0B[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_0C(INITVAL_0C[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_0D(INITVAL_0D[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_0E(INITVAL_0E[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_0F(INITVAL_0F[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_10(INITVAL_10[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_11(INITVAL_11[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_12(INITVAL_12[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_13(INITVAL_13[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_14(INITVAL_14[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_15(INITVAL_15[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_16(INITVAL_16[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_17(INITVAL_17[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_18(INITVAL_18[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_19(INITVAL_19[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_1A(INITVAL_1A[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_1B(INITVAL_1B[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_1C(INITVAL_1C[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_1D(INITVAL_1D[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_1E(INITVAL_1E[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_1F(INITVAL_1F[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_20(INITVAL_20[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_21(INITVAL_21[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_22(INITVAL_22[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_23(INITVAL_23[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_24(INITVAL_24[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_25(INITVAL_25[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_26(INITVAL_26[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_27(INITVAL_27[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_28(INITVAL_28[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_29(INITVAL_29[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_2A(INITVAL_2A[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_2B(INITVAL_2B[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_2C(INITVAL_2C[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_2D(INITVAL_2D[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_2E(INITVAL_2E[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_2F(INITVAL_2F[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_30(INITVAL_30[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_31(INITVAL_31[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_32(INITVAL_32[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_33(INITVAL_33[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_34(INITVAL_34[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_35(INITVAL_35[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_36(INITVAL_36[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_37(INITVAL_37[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_38(INITVAL_38[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_39(INITVAL_39[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_3A(INITVAL_3A[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_3B(INITVAL_3B[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_3C(INITVAL_3C[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_3D(INITVAL_3D[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_3E(INITVAL_3E[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_3F(INITVAL_3F[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_40(INITVAL_40[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_41(INITVAL_41[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_42(INITVAL_42[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_43(INITVAL_43[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_44(INITVAL_44[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_45(INITVAL_45[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_46(INITVAL_46[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_47(INITVAL_47[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_48(INITVAL_48[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_49(INITVAL_49[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_4A(INITVAL_4A[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_4B(INITVAL_4B[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_4C(INITVAL_4C[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_4D(INITVAL_4D[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_4E(INITVAL_4E[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_4F(INITVAL_4F[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_50(INITVAL_50[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_51(INITVAL_51[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_52(INITVAL_52[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_53(INITVAL_53[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_54(INITVAL_54[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_55(INITVAL_55[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_56(INITVAL_56[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_57(INITVAL_57[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_58(INITVAL_58[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_59(INITVAL_59[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_5A(INITVAL_5A[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_5B(INITVAL_5B[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_5C(INITVAL_5C[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_5D(INITVAL_5D[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_5E(INITVAL_5E[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_5F(INITVAL_5F[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_60(INITVAL_60[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_61(INITVAL_61[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_62(INITVAL_62[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_63(INITVAL_63[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_64(INITVAL_64[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_65(INITVAL_65[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_66(INITVAL_66[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_67(INITVAL_67[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_68(INITVAL_68[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_69(INITVAL_69[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_6A(INITVAL_6A[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_6B(INITVAL_6B[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_6C(INITVAL_6C[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_6D(INITVAL_6D[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_6E(INITVAL_6E[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_6F(INITVAL_6F[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_70(INITVAL_70[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_71(INITVAL_71[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_72(INITVAL_72[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_73(INITVAL_73[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_74(INITVAL_74[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_75(INITVAL_75[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_76(INITVAL_76[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_77(INITVAL_77[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_78(INITVAL_78[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_79(INITVAL_79[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_7A(INITVAL_7A[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_7B(INITVAL_7B[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_7C(INITVAL_7C[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_7D(INITVAL_7D[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_7E(INITVAL_7E[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)]),
                            .INITVAL_7F(INITVAL_7F[((((i0 + 1) * STRING_LENGTH) * 8) - 1):((i0 * STRING_LENGTH) * 8)])) ulram_core0 (.clk_i(clk_i), 
                                .addr_a_i(addr_a_w), 
                                .wr_data_a_i(wr_data_a_i), 
                                .clk_en_a_i(clk_en_a_i), 
                                .wr_en_a_i(wr_en_a_w), 
                                .rst_a_i(rst_a_i), 
                                .ben_a_i(((BYTE_ENABLE_A || UNALIGNED_ACCESS_ENABLE) ? ben_a_i : 1'b1)), 
                                .rd_out_clk_en_a_i(clk_en_a_i), 
                                .rd_data_a_o(rd_data_a_raw_w[i0]), 
                                .rd_valid_a_o(), 
                                .addr_b_i(addr_b_w), 
                                .wr_data_b_i(wr_data_b_i), 
                                .clk_en_b_i(clk_en_b_i), 
                                .wr_en_b_i(wr_en_b_w), 
                                .rst_b_i(rst_b_i), 
                                .ben_b_i(((BYTE_ENABLE_B || UNALIGNED_ACCESS_ENABLE) ? ben_b_i : 1'b1)), 
                                .rd_out_clk_en_b_i(clk_en_b_i), 
                                .rd_data_b_o(rd_data_b_raw_w[i0]), 
                                .rd_valid_b_o(), 
                                .dps_i(), 
                                .lramready_o(lramready_raw_w[i0]), 
                                .errdet_a_o(errdet_a_lram_w), 
                                .errdet_b_o(errdet_b_lram_w)) ; 
                end
            else
                begin : genblk3
                    sysmem_ipgen_lscc_lram_core #(.DATA_WIDTH(DATA_WIDTH),
                            .ADDR_WIDTH(ADDR_IMPL),
                            .BYTE_ENABLE_A(BYTE_ENABLE_A),
                            .BYTE_ENABLE_B(BYTE_ENABLE_B),
                            .ECC_ENABLE(ECC_ENABLE),
                            .MEM_ID(MEM_ID),
                            .MEM_SIZE(MEM_SIZE),
                            .POSx(ECO_POSX),
                            .POSy(ECO_POSY),
                            .REGMODE_A(REGMODE_A),
                            .REGMODE_B(REGMODE_B),
                            .RESET_MODE(RESET_MODE),
                            .ASYNC_RST_RELEASE(ASYNC_RST_RELEASE),
                            .UNALIGNED_ACCESS_ENABLE(UNALIGNED_ACCESS_ENABLE)) ulram_core0 (.clk_i(clk_i), 
                                .addr_a_i(addr_a_w), 
                                .wr_data_a_i(wr_data_a_i), 
                                .clk_en_a_i(clk_en_a_i), 
                                .wr_en_a_i(wr_en_a_w), 
                                .rst_a_i(rst_a_i), 
                                .ben_a_i(((BYTE_ENABLE_A || UNALIGNED_ACCESS_ENABLE) ? ben_a_i : 1'b1)), 
                                .rd_out_clk_en_a_i(clk_en_a_i), 
                                .rd_data_a_o(rd_data_a_raw_w[i0]), 
                                .rd_valid_a_o(), 
                                .addr_b_i(addr_b_w), 
                                .wr_data_b_i(wr_data_b_i), 
                                .clk_en_b_i(clk_en_b_i), 
                                .wr_en_b_i(wr_en_b_w), 
                                .rst_b_i(rst_b_i), 
                                .ben_b_i(((BYTE_ENABLE_B || UNALIGNED_ACCESS_ENABLE) ? ben_b_i : 1'b1)), 
                                .rd_out_clk_en_b_i(clk_en_b_i), 
                                .rd_data_b_o(rd_data_b_raw_w[i0]), 
                                .rd_valid_b_o(), 
                                .dps_i(), 
                                .lramready_o(lramready_raw_w[i0]), 
                                .errdet_a_o(errdet_a_lram_w), 
                                .errdet_b_o(errdet_b_lram_w)) ; 
                end
        end
        if ((LRAM_ADDR == 1)) 
            begin : genblk3
                if ((READ_PIPELINE_S0 == 1)) 
                    begin : genblk1
                        reg [(DATA_WIDTH - 1):0] rd_data_a_r ; 
                        reg [1:0] errdet_a_r ; 
                        assign rd_data_a_o = rd_data_a_r ; 
                        assign errdet_a_o = ((ECC_ENABLE == 0) ? 2'b00 : errdet_a_r) ; 
                        always
                            @(posedge clk_i)
                            begin
                                rd_data_a_r <=  rd_data_a_raw_w[0] ;
                                errdet_a_r <=  errdet_a_w[0] ;
                            end
                    end
                else
                    begin : genblk1
                        assign rd_data_a_o = rd_data_a_raw_w[0] ; 
                        assign errdet_a_o = ((ECC_ENABLE == 0) ? 2'b00 : errdet_a_w[0]) ; 
                    end
                if ((READ_PIPELINE_S1 == 1)) 
                    begin : genblk2
                        reg [(DATA_WIDTH - 1):0] rd_data_b_r ; 
                        reg [1:0] errdet_b_r ; 
                        assign rd_data_b_o = rd_data_b_r ; 
                        assign errdet_b_o = ((ECC_ENABLE == 0) ? 2'b00 : errdet_b_r) ; 
                        always
                            @(posedge clk_i)
                            begin
                                rd_data_b_r <=  rd_data_b_raw_w[0] ;
                                errdet_b_r <=  errdet_b_w[0] ;
                            end
                    end
                else
                    begin : genblk2
                        assign rd_data_b_o = rd_data_b_raw_w[0] ; 
                        assign errdet_b_o = ((ECC_ENABLE == 0) ? 2'b00 : errdet_b_w[0]) ; 
                    end
            end
        else
            begin : genblk3
                // port A out
                reg [(ADDR_WIDTH - 1):0] addr_a_p_r ; 
                reg [(DATA_WIDTH - 1):0] rd_data_a_r ; 
                reg [1:0] errdet_a_r ; 
                assign rd_data_a_o = rd_data_a_r ; 
                assign errdet_a_o = ((ECC_ENABLE == 0) ? 2'b00 : errdet_a_r) ; 
                if ((REGMODE_A == "noreg")) 
                    begin : genblk1
                        if ((RESET_MODE == "sync")) 
                            begin : genblk1
                                always
                                    @(posedge clk_i)
                                    begin
                                        if (rst_a_i) 
                                            begin
                                                addr_a_p_r <=  {ADDR_WIDTH{1'b0}} ;
                                            end
                                        else
                                            begin
                                                addr_a_p_r <=  addr_a_i ;
                                            end
                                    end
                            end
                        else
                            begin : genblk1
                                always
                                    @(posedge clk_i or 
                                        posedge rst_a_i)
                                    begin
                                        if (rst_a_i) 
                                            begin
                                                addr_a_p_r <=  {ADDR_WIDTH{1'b0}} ;
                                            end
                                        else
                                            begin
                                                addr_a_p_r <=  addr_a_i ;
                                            end
                                    end
                            end
                    end
                else
                    begin : genblk1
                        reg [(ADDR_WIDTH - 1):0] addr_a_p2_r ; 
                        if ((RESET_MODE == "sync")) 
                            begin : genblk1
                                always
                                    @(posedge clk_i)
                                    begin
                                        if (rst_a_i) 
                                            begin
                                                addr_a_p_r <=  {ADDR_WIDTH{1'b0}} ;
                                                addr_a_p2_r <=  {ADDR_WIDTH{1'b0}} ;
                                            end
                                        else
                                            begin
                                                addr_a_p_r <=  addr_a_p2_r ;
                                                addr_a_p2_r <=  addr_a_i ;
                                            end
                                    end
                            end
                        else
                            begin : genblk1
                                always
                                    @(posedge clk_i or 
                                        posedge rst_a_i)
                                    begin
                                        if (rst_a_i) 
                                            begin
                                                addr_a_p_r <=  {ADDR_WIDTH{1'b0}} ;
                                                addr_a_p2_r <=  {ADDR_WIDTH{1'b0}} ;
                                            end
                                        else
                                            begin
                                                addr_a_p_r <=  addr_a_p2_r ;
                                                addr_a_p2_r <=  addr_a_i ;
                                            end
                                    end
                            end
                    end
                if ((READ_PIPELINE_S0 == 1)) 
                    begin : genblk2
                        always
                            @(posedge clk_i)
                            begin
                                rd_data_a_r <=  rd_data_a_raw_w[addr_a_p_r[(ADDR_WIDTH - 1):ADDR_IMPL]] ;
                                errdet_a_r <=  errdet_a_w[addr_a_p_r[(ADDR_WIDTH - 1):ADDR_IMPL]] ;
                            end
                    end
                else
                    begin : genblk2
                        always
                            @(*)
                            begin
                                rd_data_a_r = rd_data_a_raw_w[addr_a_p_r[(ADDR_WIDTH - 1):ADDR_IMPL]] ;
                                errdet_a_r = errdet_a_w[addr_a_p_r[(ADDR_WIDTH - 1):ADDR_IMPL]] ;
                            end
                    end
                // port B out
                reg [(ADDR_WIDTH - 1):0] addr_b_p_r ; 
                reg [(DATA_WIDTH - 1):0] rd_data_b_r ; 
                reg [1:0] errdet_b_r ; 
                assign rd_data_b_o = rd_data_b_r ; 
                assign errdet_b_o = ((ECC_ENABLE == 0) ? 2'b00 : errdet_b_r) ; 
                if ((REGMODE_B == "noreg")) 
                    begin : genblk3
                        if ((RESET_MODE == "sync")) 
                            begin : genblk1
                                always
                                    @(posedge clk_i)
                                    begin
                                        if (rst_b_i) 
                                            begin
                                                addr_b_p_r <=  {ADDR_WIDTH{1'b0}} ;
                                            end
                                        else
                                            begin
                                                addr_b_p_r <=  addr_b_i ;
                                            end
                                    end
                            end
                        else
                            begin : genblk1
                                always
                                    @(posedge clk_i or 
                                        posedge rst_b_i)
                                    begin
                                        if (rst_b_i) 
                                            begin
                                                addr_b_p_r <=  {ADDR_WIDTH{1'b0}} ;
                                            end
                                        else
                                            begin
                                                addr_b_p_r <=  addr_b_i ;
                                            end
                                    end
                            end
                    end
                else
                    begin : genblk3
                        reg [(ADDR_WIDTH - 1):0] addr_b_p2_r ; 
                        if ((RESET_MODE == "sync")) 
                            begin : genblk1
                                always
                                    @(posedge clk_i)
                                    begin
                                        if (rst_b_i) 
                                            begin
                                                addr_b_p_r <=  {ADDR_WIDTH{1'b0}} ;
                                                addr_b_p2_r <=  {ADDR_WIDTH{1'b0}} ;
                                            end
                                        else
                                            begin
                                                addr_b_p_r <=  addr_b_p2_r ;
                                                addr_b_p2_r <=  addr_b_i ;
                                            end
                                    end
                            end
                        else
                            begin : genblk1
                                always
                                    @(posedge clk_i or 
                                        posedge rst_b_i)
                                    begin
                                        if (rst_b_i) 
                                            begin
                                                addr_b_p_r <=  {ADDR_WIDTH{1'b0}} ;
                                                addr_b_p2_r <=  {ADDR_WIDTH{1'b0}} ;
                                            end
                                        else
                                            begin
                                                addr_b_p_r <=  addr_b_p2_r ;
                                                addr_b_p2_r <=  addr_b_i ;
                                            end
                                    end
                            end
                    end
                if ((READ_PIPELINE_S1 == 1)) 
                    begin : genblk4
                        always
                            @(posedge clk_i)
                            begin
                                rd_data_b_r <=  rd_data_b_raw_w[addr_b_p_r[(ADDR_WIDTH - 1):ADDR_IMPL]] ;
                                errdet_b_r <=  errdet_b_w[addr_b_p_r[(ADDR_WIDTH - 1):ADDR_IMPL]] ;
                            end
                    end
                else
                    begin : genblk4
                        always
                            @(*)
                            begin
                                rd_data_b_r = rd_data_b_raw_w[addr_b_p_r[(ADDR_WIDTH - 1):ADDR_IMPL]] ;
                                errdet_b_r = errdet_b_w[addr_b_p_r[(ADDR_WIDTH - 1):ADDR_IMPL]] ;
                            end
                    end
            end
    endgenerate
    function [31:0] LRAM_USE ; 
        input [31:0] adepth ; 
        input [31:0] dwid ; 
        begin
            case (dwid)
            32 : 
                LRAM_USE = roundUP(adepth,
                        16384) ;
            16 : 
                LRAM_USE = roundUP(adepth,
                        32768) ;
            default : 
                LRAM_USE = roundUP(adepth,
                        65536) ;
            endcase 
        end
    endfunction
    function [31:0] roundUP ; 
        input [31:0] dividend ; 
        input [31:0] divisor ; 
        begin
            if ((divisor == 1)) 
                begin
                    roundUP = dividend ;
                end
            else
                if ((divisor == dividend)) 
                    begin
                        roundUP = 1 ;
                    end
                else
                    begin
                        roundUP = ((dividend / divisor) + (((dividend % divisor) == 0) ? 0 : 1)) ;
                    end
        end
    endfunction
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
    function [31:0] data_to_addr ; 
        input [31:0] data_size ; 
        begin
            case (data_size)
            32 : 
                data_to_addr = 16384 ;
            16 : 
                data_to_addr = 32768 ;
            8 : 
                data_to_addr = 65536 ;
            default : 
                data_to_addr = 16384 ;
            endcase 
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_lram_core.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module sysmem_ipgen_lscc_lram_core #(parameter DATA_WIDTH = 32, 
        parameter ADDR_WIDTH = ((DATA_WIDTH == 32) ? 14 : ((DATA_WIDTH == 16) ? 15 : 16)), 
        parameter UNALIGNED_ACCESS_ENABLE = 0, 
        parameter BYTE_ENABLE_A = 0, 
        parameter BYTE_WIDTH_A = (((BYTE_ENABLE_A == 0) & (UNALIGNED_ACCESS_ENABLE == 0)) ? 1 : (DATA_WIDTH / 8)), 
        parameter BYTE_ENABLE_B = 0, 
        parameter BYTE_WIDTH_B = (((BYTE_ENABLE_B == 0) & (UNALIGNED_ACCESS_ENABLE == 0)) ? 1 : (DATA_WIDTH / 8)), 
        parameter ECC_ENABLE = 0, 
        parameter MEM_ID = "MEM0", 
        parameter MEM_SIZE = "32,16384", 
        parameter POSx = 0, 
        parameter POSy = 0, 
        parameter STRING_SIZE = calculateStringSize(POSx,
                POSy), 
        parameter REGMODE_A = "reg", 
        parameter REGMODE_B = "reg", 
        parameter RESET_MODE = "sync", 
        parameter ASYNC_RST_RELEASE = "sync", 
        parameter INITVAL_00 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_01 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_02 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_03 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_04 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_05 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_06 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_07 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_08 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_09 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_10 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_11 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_12 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_13 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_14 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_15 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_16 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_17 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_18 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_19 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_20 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_21 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_22 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_23 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_24 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_25 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_26 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_27 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_28 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_29 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_30 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_31 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_32 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_33 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_34 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_35 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_36 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_37 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_38 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_39 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_40 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_41 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_42 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_43 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_44 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_45 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_46 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_47 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_48 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_49 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_4A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_4B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_4C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_4D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_4E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_4F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_50 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_51 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_52 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_53 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_54 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_55 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_56 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_57 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_58 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_59 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_5A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_5B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_5C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_5D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_5E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_5F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_60 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_61 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_62 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_63 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_64 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_65 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_66 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_67 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_68 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_69 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_6A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_6B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_6C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_6D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_6E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_6F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_70 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_71 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_72 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_73 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_74 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_75 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_76 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_77 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_78 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_79 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_7A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_7B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_7C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_7D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_7E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_7F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") (
    // ----------- input clock -----------
    input clk_i, 
    // ----------- LRAM port A -----------
    input [(ADDR_WIDTH - 1):0] addr_a_i, 
    input [(DATA_WIDTH - 1):0] wr_data_a_i, 
    input clk_en_a_i, 
    input wr_en_a_i, 
    input rst_a_i, 
    input [(BYTE_WIDTH_A - 1):0] ben_a_i, 
    input rd_out_clk_en_a_i, 
    output rd_valid_a_o, 
    output [(DATA_WIDTH - 1):0] rd_data_a_o, 
    // ----------- LRAM port B -----------
    input [(ADDR_WIDTH - 1):0] addr_b_i, 
    input [(DATA_WIDTH - 1):0] wr_data_b_i, 
    input clk_en_b_i, 
    input wr_en_b_i, 
    input rst_b_i, 
    input [(BYTE_WIDTH_B - 1):0] ben_b_i, 
    input rd_out_clk_en_b_i, 
    output rd_valid_b_o, 
    output [(DATA_WIDTH - 1):0] rd_data_b_o, 
    // --------- common signals ---------
    input dps_i, 
    output lramready_o, 
    output [1:0] errdet_a_o, 
    output [1:0] errdet_b_o) ;
    wire [13:0] addr_a_w ; 
    wire [31:0] wr_data_a_w ; 
    wire [3:0] ben_a_w ; 
    wire [31:0] rd_data_a_w ; 
    wire [13:0] addr_b_w ; 
    wire [31:0] wr_data_b_w ; 
    wire [3:0] ben_b_w ; 
    wire [31:0] rd_data_b_w ; 
    generate
        if ((DATA_WIDTH == 32)) 
            begin : genblk1
                assign wr_data_a_w = wr_data_a_i ; 
                assign addr_a_w = addr_a_i ; 
                assign ben_a_w = (((BYTE_ENABLE_A == 1) || (UNALIGNED_ACCESS_ENABLE == 1)) ? ben_a_i : 4'b0000) ; 
                assign rd_data_a_o = rd_data_a_w ; 
                assign wr_data_b_w = wr_data_b_i ; 
                assign addr_b_w = addr_b_i ; 
                assign ben_b_w = (((BYTE_ENABLE_B == 1) || (UNALIGNED_ACCESS_ENABLE == 1)) ? ben_b_i : 4'b0000) ; 
                assign rd_data_b_o = rd_data_b_w ; 
            end
        else
            if ((DATA_WIDTH == 16)) 
                begin : genblk1
                    reg [14:0] addr_a_p_r = {15{1'b0}} ; 
                    if ((REGMODE_A == "noreg")) 
                        begin : genblk1
                            if ((RESET_MODE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge clk_i)
                                        begin
                                            if (rst_a_i) 
                                                begin
                                                    addr_a_p_r <=  {15{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_a_p_r <=  addr_a_i ;
                                                end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(posedge clk_i or 
                                            posedge rst_a_i)
                                        begin
                                            if (rst_a_i) 
                                                begin
                                                    addr_a_p_r <=  {15{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_a_p_r <=  addr_a_i ;
                                                end
                                        end
                                end
                        end
                    else
                        begin : genblk1
                            reg [14:0] addr_a_p2_r = {15{1'b0}} ; 
                            if ((RESET_MODE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge clk_i)
                                        begin
                                            if (rst_a_i) 
                                                begin
                                                    addr_a_p_r <=  {15{1'b0}} ;
                                                    addr_a_p2_r <=  {15{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_a_p_r <=  addr_a_p2_r ;
                                                    addr_a_p2_r <=  addr_a_i ;
                                                end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(posedge clk_i or 
                                            posedge rst_a_i)
                                        begin
                                            if (rst_a_i) 
                                                begin
                                                    addr_a_p_r <=  {15{1'b0}} ;
                                                    addr_a_p2_r <=  {15{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_a_p_r <=  addr_a_p2_r ;
                                                    addr_a_p2_r <=  addr_a_i ;
                                                end
                                        end
                                end
                        end
                    reg [31:0] wr_data_a_r ; 
                    assign wr_data_a_w = wr_data_a_r ; 
                    always
                        @(*)
                        begin
                            if ((addr_a_i[0] == 1'b0)) 
                                begin
                                    wr_data_a_r = {{16{1'b0}},
                                            wr_data_a_i} ;
                                end
                            else
                                begin
                                    wr_data_a_r = {wr_data_a_i,
                                            {16{1'b0}}} ;
                                end
                        end
                    assign addr_a_w = addr_a_i[14:1] ; 
                    reg [3:0] ben_a_r ; 
                    assign ben_a_w = ben_a_r ; 
                    if ((BYTE_ENABLE_A == 0)) 
                        begin : genblk2
                            always
                                @(*)
                                begin
                                    if ((addr_a_i[0] == 1'b0)) 
                                        begin
                                            ben_a_r = {2'b11,
                                                    2'b00} ;
                                        end
                                    else
                                        begin
                                            ben_a_r = {2'b11,
                                                    2'b00} ;
                                        end
                                end
                        end
                    else
                        begin : genblk2
                            always
                                @(*)
                                begin
                                    if ((addr_a_i[0] == 1'b0)) 
                                        begin
                                            ben_a_r = {2'b11,
                                                    ben_a_i} ;
                                        end
                                    else
                                        begin
                                            ben_a_r = {ben_a_i,
                                                    2'b11} ;
                                        end
                                end
                        end
                    reg [15:0] rd_data_a_r = {16{1'b0}} ; 
                    assign rd_data_a_o = rd_data_a_r ; 
                    always
                        @(*)
                        begin
                            case (addr_a_p_r[0])
                            0 : 
                                rd_data_a_r = rd_data_a_w[15:0] ;
                            1 : 
                                rd_data_a_r = rd_data_a_w[31:16] ;
                            endcase 
                        end
                    // port B
                    reg [14:0] addr_b_p_r = {15{1'b0}} ; 
                    if ((REGMODE_B == "noreg")) 
                        begin : genblk3
                            if ((RESET_MODE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge clk_i)
                                        begin
                                            if (rst_b_i) 
                                                begin
                                                    addr_b_p_r <=  {15{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_b_p_r <=  addr_b_i ;
                                                end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(posedge clk_i or 
                                            posedge rst_b_i)
                                        begin
                                            if (rst_b_i) 
                                                begin
                                                    addr_b_p_r <=  {15{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_b_p_r <=  addr_b_i ;
                                                end
                                        end
                                end
                        end
                    else
                        begin : genblk3
                            reg [14:0] addr_b_p2_r = {15{1'b0}} ; 
                            if ((RESET_MODE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge clk_i)
                                        begin
                                            if (rst_b_i) 
                                                begin
                                                    addr_b_p_r <=  {15{1'b0}} ;
                                                    addr_b_p2_r <=  {15{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_b_p_r <=  addr_b_p2_r ;
                                                    addr_b_p2_r <=  addr_b_i ;
                                                end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(posedge clk_i or 
                                            posedge rst_b_i)
                                        begin
                                            if (rst_b_i) 
                                                begin
                                                    addr_b_p_r <=  {15{1'b0}} ;
                                                    addr_b_p2_r <=  {15{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_b_p_r <=  addr_b_p2_r ;
                                                    addr_b_p2_r <=  addr_b_i ;
                                                end
                                        end
                                end
                        end
                    reg [31:0] wr_data_b_r = {32{1'b0}} ; 
                    assign wr_data_b_w = wr_data_b_r ; 
                    always
                        @(*)
                        begin
                            if ((addr_b_i[0] == 1'b0)) 
                                begin
                                    wr_data_b_r = {{16{1'b0}},
                                            wr_data_b_i} ;
                                end
                            else
                                begin
                                    wr_data_b_r = {wr_data_b_i,
                                            {16{1'b0}}} ;
                                end
                        end
                    assign addr_b_w = addr_b_i[14:1] ; 
                    reg [3:0] ben_b_r ; 
                    assign ben_b_w = ben_b_r ; 
                    if ((BYTE_ENABLE_B == 0)) 
                        begin : genblk4
                            always
                                @(*)
                                begin
                                    if ((addr_b_i[0] == 1'b0)) 
                                        begin
                                            ben_b_r = {2'b11,
                                                    2'b00} ;
                                        end
                                    else
                                        begin
                                            ben_b_r = {2'b11,
                                                    2'b00} ;
                                        end
                                end
                        end
                    else
                        begin : genblk4
                            always
                                @(*)
                                begin
                                    if ((addr_b_i[0] == 1'b0)) 
                                        begin
                                            ben_b_r = {2'b11,
                                                    ben_b_i} ;
                                        end
                                    else
                                        begin
                                            ben_b_r = {ben_b_i,
                                                    2'b11} ;
                                        end
                                end
                        end
                    reg [15:0] rd_data_b_r ; 
                    assign rd_data_b_o = rd_data_b_r ; 
                    always
                        @(*)
                        begin
                            case (addr_b_p_r[0])
                            0 : 
                                rd_data_b_r = rd_data_b_w[15:0] ;
                            1 : 
                                rd_data_b_r = rd_data_b_w[31:16] ;
                            endcase 
                        end
                end
            else
                begin : genblk1
                    reg [15:0] addr_a_p_r = {16{1'b0}} ; 
                    if ((REGMODE_A == "noreg")) 
                        begin : genblk1
                            if ((RESET_MODE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge clk_i)
                                        begin
                                            if (rst_a_i) 
                                                begin
                                                    addr_a_p_r <=  {16{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_a_p_r <=  addr_a_i ;
                                                end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(posedge clk_i or 
                                            posedge rst_a_i)
                                        begin
                                            if (rst_a_i) 
                                                begin
                                                    addr_a_p_r <=  {16{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_a_p_r <=  addr_a_i ;
                                                end
                                        end
                                end
                        end
                    else
                        begin : genblk1
                            reg [15:0] addr_a_p2_r ; 
                            if ((RESET_MODE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge clk_i)
                                        begin
                                            if (rst_a_i) 
                                                begin
                                                    addr_a_p_r <=  {16{1'b0}} ;
                                                    addr_a_p2_r <=  {16{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_a_p_r <=  addr_a_p2_r ;
                                                    addr_a_p2_r <=  addr_a_i ;
                                                end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(posedge clk_i or 
                                            posedge rst_a_i)
                                        begin
                                            if (rst_a_i) 
                                                begin
                                                    addr_a_p_r <=  {16{1'b0}} ;
                                                    addr_a_p2_r <=  {16{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_a_p_r <=  addr_a_p2_r ;
                                                    addr_a_p2_r <=  addr_a_i ;
                                                end
                                        end
                                end
                        end
                    reg [31:0] wr_data_a_r = {32{1'b0}} ; 
                    assign wr_data_a_w = wr_data_a_r ; 
                    always
                        @(*)
                        begin
                            case (addr_a_i[1:0])
                            2'b00 : 
                                wr_data_a_r = {{24{1'b0}},
                                        wr_data_a_i} ;
                            2'b01 : 
                                wr_data_a_r = {{16{1'b0}},
                                        wr_data_a_i,
                                        {8{1'b0}}} ;
                            2'b10 : 
                                wr_data_a_r = {{8{1'b0}},
                                        wr_data_a_i,
                                        {16{1'b0}}} ;
                            2'b11 : 
                                wr_data_a_r = {wr_data_a_i,
                                        {24{1'b0}}} ;
                            endcase 
                        end
                    assign addr_a_w = addr_a_i[15:2] ; 
                    reg [3:0] ben_a_r = {4{1'b1}} ; 
                    assign ben_a_w = ben_a_r ; 
                    always
                        @(*)
                        begin
                            case (addr_a_i[1:0])
                            2'b00 : 
                                ben_a_r = 4'b1110 ;
                            2'b01 : 
                                ben_a_r = 4'b1101 ;
                            2'b10 : 
                                ben_a_r = 4'b1011 ;
                            2'b11 : 
                                ben_a_r = 4'b0111 ;
                            endcase 
                        end
                    reg [7:0] rd_data_a_r = {8{1'b0}} ; 
                    assign rd_data_a_o = rd_data_a_r ; 
                    always
                        @(*)
                        begin
                            case (addr_a_p_r[1:0])
                            2'b00 : 
                                rd_data_a_r = rd_data_a_w[7:0] ;
                            2'b01 : 
                                rd_data_a_r = rd_data_a_w[15:8] ;
                            2'b10 : 
                                rd_data_a_r = rd_data_a_w[23:16] ;
                            2'b11 : 
                                rd_data_a_r = rd_data_a_w[31:24] ;
                            endcase 
                        end
                    reg [15:0] addr_b_p_r = {16{1'b0}} ; 
                    if ((REGMODE_A == "noreg")) 
                        begin : genblk2
                            if ((RESET_MODE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge clk_i)
                                        begin
                                            if (rst_b_i) 
                                                begin
                                                    addr_b_p_r <=  {16{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_b_p_r <=  addr_b_i ;
                                                end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(posedge clk_i or 
                                            posedge rst_b_i)
                                        begin
                                            if (rst_b_i) 
                                                begin
                                                    addr_b_p_r <=  {16{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_b_p_r <=  addr_b_i ;
                                                end
                                        end
                                end
                        end
                    else
                        begin : genblk2
                            reg [15:0] addr_b_p2_r ; 
                            if ((RESET_MODE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge clk_i)
                                        begin
                                            if (rst_b_i) 
                                                begin
                                                    addr_b_p_r <=  {16{1'b0}} ;
                                                    addr_b_p2_r <=  {16{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_b_p_r <=  addr_b_p2_r ;
                                                    addr_b_p2_r <=  addr_b_i ;
                                                end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(posedge clk_i or 
                                            posedge rst_b_i)
                                        begin
                                            if (rst_b_i) 
                                                begin
                                                    addr_b_p_r <=  {16{1'b0}} ;
                                                    addr_b_p2_r <=  {16{1'b0}} ;
                                                end
                                            else
                                                begin
                                                    addr_b_p_r <=  addr_b_p2_r ;
                                                    addr_b_p2_r <=  addr_b_i ;
                                                end
                                        end
                                end
                        end
                    reg [31:0] wr_data_b_r = {32{1'b0}} ; 
                    assign wr_data_b_w = wr_data_b_r ; 
                    always
                        @(*)
                        begin
                            case (addr_b_i[1:0])
                            2'b00 : 
                                wr_data_b_r = {{24{1'b0}},
                                        wr_data_b_i} ;
                            2'b01 : 
                                wr_data_b_r = {{16{1'b0}},
                                        wr_data_b_i,
                                        {8{1'b0}}} ;
                            2'b10 : 
                                wr_data_b_r = {{8{1'b0}},
                                        wr_data_b_i,
                                        {16{1'b0}}} ;
                            2'b11 : 
                                wr_data_b_r = {wr_data_b_i,
                                        {24{1'b0}}} ;
                            endcase 
                        end
                    assign addr_b_w = addr_b_i[15:2] ; 
                    reg [3:0] ben_b_r = {4{1'b1}} ; 
                    assign ben_b_w = ben_b_r ; 
                    always
                        @(*)
                        begin
                            case (addr_b_i[1:0])
                            2'b00 : 
                                ben_b_r = 4'b1110 ;
                            2'b01 : 
                                ben_b_r = 4'b1101 ;
                            2'b10 : 
                                ben_b_r = 4'b1011 ;
                            2'b11 : 
                                ben_b_r = 4'b0111 ;
                            endcase 
                        end
                    reg [7:0] rd_data_b_r = {8{1'b0}} ; 
                    assign rd_data_b_o = rd_data_b_r ; 
                    always
                        @(*)
                        begin
                            case (addr_b_p_r[1:0])
                            2'b00 : 
                                rd_data_b_r = rd_data_b_w[7:0] ;
                            2'b01 : 
                                rd_data_b_r = rd_data_b_w[15:8] ;
                            2'b10 : 
                                rd_data_b_r = rd_data_b_w[23:16] ;
                            2'b11 : 
                                rd_data_b_r = rd_data_b_w[31:24] ;
                            endcase 
                        end
                end
    endgenerate
    localparam T_RST_MODE = ((RESET_MODE == "sync") ? "SYNC" : "ASYNC") ; 
    localparam T_ECC_SEL = ((ECC_ENABLE == 1) ? "ECC_EN" : "BYTE_EN") ; 
    localparam T_REG_A = ((REGMODE_A == "noreg") ? "NO_REG" : "OUT_REG") ; 
    localparam T_REG_B = ((REGMODE_B == "noreg") ? "NO_REG" : "OUT_REG") ; 
    localparam T_DATA_PRESERVE = "ENABLE" ; 
    localparam T_RST_REL = ((ASYNC_RST_RELEASE == "sync") ? "SYNC" : "ASYNC") ; 
    localparam T_UNALIGNED = ((UNALIGNED_ACCESS_ENABLE == 1) ? "ENABLE" : "DISABLE") ; 
    localparam T_RST_AB_EN = "RESET_AB_ENABLE" ; 
    localparam MEM_TYPE = "LRAM" ; 
    localparam T_MEM_SIZE = {"[",
                MEM_SIZE,
                "]"} ; 
    localparam BLOCK_SIZE = "[32,16384]" ; 
    localparam POS_X0 = (POSx % 10) ; 
    localparam POS_X1 = ((POSx / 10) % 10) ; 
    localparam POS_X2 = ((POSx / 100) % 10) ; 
    localparam POS_X3 = ((POSx / 1000) % 10) ; 
    localparam POS_X4 = ((POSx / 10000) % 10) ; 
    localparam POS_X5 = ((POSx / 100000) % 10) ; 
    localparam POS_X6 = ((POSx / 1000000) % 10) ; 
    localparam POS_X7 = ((POSx / 10000000) % 10) ; 
    localparam POS_Y0 = (POSy % 10) ; 
    localparam POS_Y1 = ((POSy / 10) % 10) ; 
    localparam POS_Y2 = ((POSy / 100) % 10) ; 
    localparam POS_Y3 = ((POSy / 1000) % 10) ; 
    localparam POS_Y4 = ((POSy / 10000) % 10) ; 
    localparam POS_Y5 = ((POSy / 100000) % 10) ; 
    localparam POS_Y6 = ((POSy / 1000000) % 10) ; 
    localparam POS_Y7 = ((POSy / 10000000) % 10) ; 
    localparam [79:0] NUM_STRING = "9876543210" ; 
    localparam BLOCK_POS = getStringFromPos(POSx,
                POSy) ; 
    (* ECO_MEM_TYPE=MEM_TYPE, ECO_MEM_ID=MEM_ID, ECO_MEM_SIZE=T_MEM_SIZE, ECO_MEM_BLOCK_SIZE=BLOCK_SIZE, ECO_MEM_BLOCK_POS=BLOCK_POS *) LRAM #(.RESETMODE(T_RST_MODE),
            .ECC_BYTE_SEL(T_ECC_SEL),
            .OUT_REGMODE_A(T_REG_A),
            .OUT_REGMODE_B(T_REG_B),
            .DATA_PRESERVE(T_DATA_PRESERVE),
            .RST_AB_EN(T_RST_AB_EN),
            .ASYNC_RST_RELEASE(T_RST_REL),
            .UNALIGNED_READ(T_UNALIGNED),
            .INITVAL_00(INITVAL_00),
            .INITVAL_01(INITVAL_01),
            .INITVAL_02(INITVAL_02),
            .INITVAL_03(INITVAL_03),
            .INITVAL_04(INITVAL_04),
            .INITVAL_05(INITVAL_05),
            .INITVAL_06(INITVAL_06),
            .INITVAL_07(INITVAL_07),
            .INITVAL_08(INITVAL_08),
            .INITVAL_09(INITVAL_09),
            .INITVAL_0A(INITVAL_0A),
            .INITVAL_0B(INITVAL_0B),
            .INITVAL_0C(INITVAL_0C),
            .INITVAL_0D(INITVAL_0D),
            .INITVAL_0E(INITVAL_0E),
            .INITVAL_0F(INITVAL_0F),
            .INITVAL_10(INITVAL_10),
            .INITVAL_11(INITVAL_11),
            .INITVAL_12(INITVAL_12),
            .INITVAL_13(INITVAL_13),
            .INITVAL_14(INITVAL_14),
            .INITVAL_15(INITVAL_15),
            .INITVAL_16(INITVAL_16),
            .INITVAL_17(INITVAL_17),
            .INITVAL_18(INITVAL_18),
            .INITVAL_19(INITVAL_19),
            .INITVAL_1A(INITVAL_1A),
            .INITVAL_1B(INITVAL_1B),
            .INITVAL_1C(INITVAL_1C),
            .INITVAL_1D(INITVAL_1D),
            .INITVAL_1E(INITVAL_1E),
            .INITVAL_1F(INITVAL_1F),
            .INITVAL_20(INITVAL_20),
            .INITVAL_21(INITVAL_21),
            .INITVAL_22(INITVAL_22),
            .INITVAL_23(INITVAL_23),
            .INITVAL_24(INITVAL_24),
            .INITVAL_25(INITVAL_25),
            .INITVAL_26(INITVAL_26),
            .INITVAL_27(INITVAL_27),
            .INITVAL_28(INITVAL_28),
            .INITVAL_29(INITVAL_29),
            .INITVAL_2A(INITVAL_2A),
            .INITVAL_2B(INITVAL_2B),
            .INITVAL_2C(INITVAL_2C),
            .INITVAL_2D(INITVAL_2D),
            .INITVAL_2E(INITVAL_2E),
            .INITVAL_2F(INITVAL_2F),
            .INITVAL_30(INITVAL_30),
            .INITVAL_31(INITVAL_31),
            .INITVAL_32(INITVAL_32),
            .INITVAL_33(INITVAL_33),
            .INITVAL_34(INITVAL_34),
            .INITVAL_35(INITVAL_35),
            .INITVAL_36(INITVAL_36),
            .INITVAL_37(INITVAL_37),
            .INITVAL_38(INITVAL_38),
            .INITVAL_39(INITVAL_39),
            .INITVAL_3A(INITVAL_3A),
            .INITVAL_3B(INITVAL_3B),
            .INITVAL_3C(INITVAL_3C),
            .INITVAL_3D(INITVAL_3D),
            .INITVAL_3E(INITVAL_3E),
            .INITVAL_3F(INITVAL_3F),
            .INITVAL_40(INITVAL_40),
            .INITVAL_41(INITVAL_41),
            .INITVAL_42(INITVAL_42),
            .INITVAL_43(INITVAL_43),
            .INITVAL_44(INITVAL_44),
            .INITVAL_45(INITVAL_45),
            .INITVAL_46(INITVAL_46),
            .INITVAL_47(INITVAL_47),
            .INITVAL_48(INITVAL_48),
            .INITVAL_49(INITVAL_49),
            .INITVAL_4A(INITVAL_4A),
            .INITVAL_4B(INITVAL_4B),
            .INITVAL_4C(INITVAL_4C),
            .INITVAL_4D(INITVAL_4D),
            .INITVAL_4E(INITVAL_4E),
            .INITVAL_4F(INITVAL_4F),
            .INITVAL_50(INITVAL_50),
            .INITVAL_51(INITVAL_51),
            .INITVAL_52(INITVAL_52),
            .INITVAL_53(INITVAL_53),
            .INITVAL_54(INITVAL_54),
            .INITVAL_55(INITVAL_55),
            .INITVAL_56(INITVAL_56),
            .INITVAL_57(INITVAL_57),
            .INITVAL_58(INITVAL_58),
            .INITVAL_59(INITVAL_59),
            .INITVAL_5A(INITVAL_5A),
            .INITVAL_5B(INITVAL_5B),
            .INITVAL_5C(INITVAL_5C),
            .INITVAL_5D(INITVAL_5D),
            .INITVAL_5E(INITVAL_5E),
            .INITVAL_5F(INITVAL_5F),
            .INITVAL_60(INITVAL_60),
            .INITVAL_61(INITVAL_61),
            .INITVAL_62(INITVAL_62),
            .INITVAL_63(INITVAL_63),
            .INITVAL_64(INITVAL_64),
            .INITVAL_65(INITVAL_65),
            .INITVAL_66(INITVAL_66),
            .INITVAL_67(INITVAL_67),
            .INITVAL_68(INITVAL_68),
            .INITVAL_69(INITVAL_69),
            .INITVAL_6A(INITVAL_6A),
            .INITVAL_6B(INITVAL_6B),
            .INITVAL_6C(INITVAL_6C),
            .INITVAL_6D(INITVAL_6D),
            .INITVAL_6E(INITVAL_6E),
            .INITVAL_6F(INITVAL_6F),
            .INITVAL_70(INITVAL_70),
            .INITVAL_71(INITVAL_71),
            .INITVAL_72(INITVAL_72),
            .INITVAL_73(INITVAL_73),
            .INITVAL_74(INITVAL_74),
            .INITVAL_75(INITVAL_75),
            .INITVAL_76(INITVAL_76),
            .INITVAL_77(INITVAL_77),
            .INITVAL_78(INITVAL_78),
            .INITVAL_79(INITVAL_79),
            .INITVAL_7A(INITVAL_7A),
            .INITVAL_7B(INITVAL_7B),
            .INITVAL_7C(INITVAL_7C),
            .INITVAL_7D(INITVAL_7D),
            .INITVAL_7E(INITVAL_7E),
            .INITVAL_7F(INITVAL_7F)) u_lram0 (.ADA(addr_a_w), 
                .ADB(addr_b_w), 
                .BENA_N(ben_a_w), 
                .BENB_N(ben_b_w), 
                .CEA(1'b1), 
                .CEB(1'b1), 
                .CLK(clk_i), 
                .CSA(clk_en_a_i), 
                .CSB(clk_en_b_i), 
                .DIA(wr_data_a_w), 
                .DIB(wr_data_b_w), 
                .DPS(1'b0), 
                .OCEA(1'b1), 
                .OCEB(1'b1), 
                .RSTA(rst_a_i), 
                .RSTB(rst_b_i), 
                .WEA(wr_en_a_i), 
                .WEB(wr_en_b_i), 
                .DOA(rd_data_a_w), 
                .DOB(rd_data_b_w), 
                .OEA(rd_valid_a_o), 
                .OEB(rd_valid_b_o), 
                .ERRDECA(errdet_a_o), 
                .ERRDECB(errdet_b_o), 
                .ERRDET(), 
                .LRAMREADY(lramready_o)) ; 
    function [31:0] calculateStringSize ; 
        input [31:0] x_calc ; 
        input [31:0] y_calc ; 
        reg [31:0] x_func ; 
        reg [31:0] y_func ; 
        begin
            if ((x_calc >= 10000000)) 
                begin
                    x_func = 8 ;
                end
            else
                if ((x_calc >= 1000000)) 
                    begin
                        x_func = 7 ;
                    end
                else
                    if ((x_calc >= 100000)) 
                        begin
                            x_func = 6 ;
                        end
                    else
                        if ((x_calc >= 10000)) 
                            begin
                                x_func = 5 ;
                            end
                        else
                            if ((x_calc >= 1000)) 
                                begin
                                    x_func = 4 ;
                                end
                            else
                                if ((x_calc >= 100)) 
                                    begin
                                        x_func = 3 ;
                                    end
                                else
                                    if ((x_calc >= 10)) 
                                        begin
                                            x_func = 2 ;
                                        end
                                    else
                                        begin
                                            x_func = 1 ;
                                        end
            if ((y_calc >= 10000000)) 
                begin
                    y_func = 8 ;
                end
            else
                if ((y_calc >= 1000000)) 
                    begin
                        y_func = 7 ;
                    end
                else
                    if ((y_calc >= 100000)) 
                        begin
                            y_func = 6 ;
                        end
                    else
                        if ((y_calc >= 10000)) 
                            begin
                                y_func = 5 ;
                            end
                        else
                            if ((y_calc >= 1000)) 
                                begin
                                    y_func = 4 ;
                                end
                            else
                                if ((y_calc >= 100)) 
                                    begin
                                        y_func = 3 ;
                                    end
                                else
                                    if ((y_calc >= 10)) 
                                        begin
                                            y_func = 2 ;
                                        end
                                    else
                                        begin
                                            y_func = 1 ;
                                        end
            calculateStringSize = (((3 + x_func) + y_func) * 8) ;
        end
    endfunction
    function [(STRING_SIZE - 1):0] getStringFromPos ; 
        input [31:0] x ; 
        input [31:0] y ; 
        begin
            if ((y >= 10000000)) 
                begin
                    if ((x >= 10000000)) 
                        begin
                            getStringFromPos = {"[",
                                    NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                    NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                    ",",
                                    NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                    NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                    "]"} ;
                        end
                    else
                        if ((x >= 1000000)) 
                            begin
                                getStringFromPos = {"[",
                                        NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                        ",",
                                        NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                        NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                        "]"} ;
                            end
                        else
                            if ((x >= 100000)) 
                                begin
                                    getStringFromPos = {"[",
                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                            ",",
                                            NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                            "]"} ;
                                end
                            else
                                if ((x >= 10000)) 
                                    begin
                                        getStringFromPos = {"[",
                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                ",",
                                                NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                "]"} ;
                                    end
                                else
                                    if ((x >= 1000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                    NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 100)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                        NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 10)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                end
            else
                if ((y >= 1000000)) 
                    begin
                        if ((x >= 10000000)) 
                            begin
                                getStringFromPos = {"[",
                                        NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                        NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                        ",",
                                        NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                        "]"} ;
                            end
                        else
                            if ((x >= 1000000)) 
                                begin
                                    getStringFromPos = {"[",
                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                            ",",
                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                            "]"} ;
                                end
                            else
                                if ((x >= 100000)) 
                                    begin
                                        getStringFromPos = {"[",
                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                ",",
                                                NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                "]"} ;
                                    end
                                else
                                    if ((x >= 10000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 1000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 100)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 10)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                    end
                else
                    if ((y >= 100000)) 
                        begin
                            if ((x >= 10000000)) 
                                begin
                                    getStringFromPos = {"[",
                                            NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                            ",",
                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                            "]"} ;
                                end
                            else
                                if ((x >= 1000000)) 
                                    begin
                                        getStringFromPos = {"[",
                                                NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                ",",
                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                "]"} ;
                                    end
                                else
                                    if ((x >= 100000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 10000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 1000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 100)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 10)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                        end
                    else
                        if ((y >= 10000)) 
                            begin
                                if ((x >= 10000000)) 
                                    begin
                                        getStringFromPos = {"[",
                                                NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                ",",
                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                "]"} ;
                                    end
                                else
                                    if ((x >= 1000000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 100000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 10000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 1000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 100)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 10)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                            end
                        else
                            if ((y >= 1000)) 
                                begin
                                    if ((x >= 10000000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                    NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 1000000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 100000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 10000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 1000)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 100)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            if ((x >= 10)) 
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                                            else
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                end
                            else
                                if ((y >= 100)) 
                                    begin
                                        if ((x >= 10000000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                        NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 1000000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 100000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 10000)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 1000)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            if ((x >= 100)) 
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                                            else
                                                                if ((x >= 10)) 
                                                                    begin
                                                                        getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                    end
                                                                else
                                                                    begin
                                                                        getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                    end
                                    end
                                else
                                    if ((y >= 10)) 
                                        begin
                                            if ((x >= 10000000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 1000000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 100000)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 10000)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            if ((x >= 1000)) 
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                                            else
                                                                if ((x >= 100)) 
                                                                    begin
                                                                        getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                    end
                                                                else
                                                                    if ((x >= 10)) 
                                                                        begin
                                                                            getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                        end
                                        end
                                    else
                                        begin
                                            if ((x >= 10000000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 1000000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 100000)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 10000)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            if ((x >= 1000)) 
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                                            else
                                                                if ((x >= 100)) 
                                                                    begin
                                                                        getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                    end
                                                                else
                                                                    if ((x >= 10)) 
                                                                        begin
                                                                            getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                        end
                                        end
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
module sysmem_ipgen_lscc_ahblmem_arbiter #(parameter PORT_TYPE_S0 = "R/W", 
        parameter PORT_TYPE_S1 = "R/W", 
        parameter ADDR_WIDTH = 32, 
        parameter RESET_MODE = "async", 
        parameter ARBITER_EN = 0) (
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input clk_i, 
    input rst_i, 
    // ------------------------------------------------------------------------------
    // Port S0 Signals
    // ------------------------------------------------------------------------------
    input [(ADDR_WIDTH - 1):0] addr_s0_i, 
    input mem_wr_rdn_s0_i, 
    input mem_req_s0_i, 
    output mem_wr_rdn_s0_o, 
    output mem_req_s0_o, 
    // ------------------------------------------------------------------------------
    // Port S1 Signals
    // ------------------------------------------------------------------------------
    input [(ADDR_WIDTH - 1):0] addr_s1_i, 
    input mem_wr_rdn_s1_i, 
    input mem_req_s1_i, 
    output mem_wr_rdn_s1_o, 
    output mem_req_s1_o) ;
    localparam DUAL_WRITE = (((PORT_TYPE_S0 == "R/W") && ((PORT_TYPE_S1 == "R/W") || (PORT_TYPE_S1 == "W/O"))) ? ARBITER_EN : (((PORT_TYPE_S0 == "W/O") && ((PORT_TYPE_S1 == "R/W") || (PORT_TYPE_S1 == "W/O"))) ? ARBITER_EN : 0)) ; 
    // -----------------------------------------------------------------------------
    // Generate Blocks
    // -----------------------------------------------------------------------------
    generate
        if ((DUAL_WRITE == 1)) 
            begin : dual_write
                reg mem_wr_rdn_s0_r ; 
                reg mem_wr_rdn_s1_r ; 
                reg mem_req_s1_r ; 
                reg mem_req_s0_r ; 
                assign mem_wr_rdn_s0_o = mem_wr_rdn_s0_r ; 
                assign mem_wr_rdn_s1_o = mem_wr_rdn_s1_r ; 
                assign mem_req_s0_o = mem_req_s0_r ; 
                assign mem_req_s1_o = mem_req_s1_r ; 
                always
                    @(*)
                    begin
                        if ((((((addr_s0_i == addr_s1_i) && (mem_wr_rdn_s0_i == 1'b1)) && (mem_wr_rdn_s1_i == 1'b1)) && (mem_req_s0_i == 1'b1)) && (mem_req_s1_i == 1'b1))) 
                            begin
                                mem_wr_rdn_s0_r = 1'b1 ;
                                mem_wr_rdn_s1_r = 1'b0 ;
                                mem_req_s0_r = 1'b1 ;
                                mem_req_s1_r = 1'b0 ;
                            end
                        else
                            begin
                                mem_wr_rdn_s0_r = mem_wr_rdn_s0_i ;
                                mem_wr_rdn_s1_r = mem_wr_rdn_s1_i ;
                                mem_req_s0_r = mem_req_s0_i ;
                                mem_req_s1_r = mem_req_s1_i ;
                            end
                    end
            end
        else
            begin : single_write
                assign mem_wr_rdn_s0_o = ((PORT_TYPE_S0 == "R/O") ? 1'b0 : mem_wr_rdn_s0_i) ; 
                assign mem_wr_rdn_s1_o = ((PORT_TYPE_S1 == "R/O") ? 1'b0 : mem_wr_rdn_s1_i) ; 
                assign mem_req_s0_o = mem_req_s0_i ; 
                assign mem_req_s1_o = mem_req_s1_i ; 
            end
    endgenerate
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
module sysmem_ipgen_lscc_axi4mem_arbiter #(parameter PORT_TYPE_S0 = "R/W", 
        parameter PORT_TYPE_S1 = "R/W", 
        parameter DATA_WIDTH = 32, 
        parameter ADDR_WIDTH = 32, 
        parameter BYTE_WIDTH = (DATA_WIDTH / 8), 
        parameter ARBITER_EN = 0) (
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input clk_i, 
    input rstn_i, 
    // ------------------------------------------------------------------------------
    // Port S0 Signals
    // ------------------------------------------------------------------------------
    input axi_s0_awvalid_i, 
    input axi_s0_wvalid_i, 
    input axi_s0_awpipeline_i, 
    input [(ADDR_WIDTH - 1):0] axi_s0_awaddr_i, 
    input axi_s0_wr_en_i, 
    input [(BYTE_WIDTH - 1):0] axi_s0_byte_en_i, 
    input [(DATA_WIDTH - 1):0] axi_s0_wdata_i, 
    output axi_s0_awready_o, 
    output axi_s0_wready_o, 
    input axi_s0_arvalid_i, 
    input axi_s0_arpipeline_i, 
    input axi_s0_rd_en_i, 
    input [(ADDR_WIDTH - 1):0] axi_s0_araddr_i, 
    output axi_s0_arready_o, 
    // ------------------------------------------------------------------------------
    // Port S1 Signals
    // ------------------------------------------------------------------------------
    input axi_s1_awvalid_i, 
    input axi_s1_wvalid_i, 
    input axi_s1_awpipeline_i, 
    input [(ADDR_WIDTH - 1):0] axi_s1_awaddr_i, 
    input axi_s1_wr_en_i, 
    input [(BYTE_WIDTH - 1):0] axi_s1_byte_en_i, 
    input [(DATA_WIDTH - 1):0] axi_s1_wdata_i, 
    output axi_s1_awready_o, 
    output axi_s1_wready_o, 
    input axi_s1_arvalid_i, 
    input axi_s1_arpipeline_i, 
    input axi_s1_rd_en_i, 
    input [(ADDR_WIDTH - 1):0] axi_s1_araddr_i, 
    output axi_s1_arready_o, 
    // ------------------------------------------------------------------------------
    // Arbitration
    // ------------------------------------------------------------------------------
    output [(ADDR_WIDTH - 1):0] arb_mem_awaddr_o, 
    output [(DATA_WIDTH - 1):0] arb_mem_wdata_o, 
    output arb_mem_wr_en_o, 
    output [(BYTE_WIDTH - 1):0] arb_mem_byte_en_o, 
    output [(ADDR_WIDTH - 1):0] arb_mem_araddr_o, 
    output arb_mem_rd_en_o) ;
    // ------------------------------------------------------------------------------
    // Registers
    // ------------------------------------------------------------------------------
    reg axi_s0_awready_reg ; 
    reg axi_s0_wready_reg ; 
    reg axi_s1_awready_reg ; 
    reg axi_s1_wready_reg ; 
    reg axi_s0_arready_reg ; 
    reg axi_s1_arready_reg ; 
    // ------------------------------------------------------------------------------
    // State Machine Parameters
    // ------------------------------------------------------------------------------
    localparam IDLE = 2'd0 ; 
    localparam GRANT_S0 = 2'd1 ; 
    localparam GRANT_S1 = 2'd2 ; 
    // -----------------------------------------------------------------------------
    // Generate Blocks
    // -----------------------------------------------------------------------------
    //------------------------------
    // AXI Interfaces Arbiteration
    //------------------------------
    generate
        if ((PORT_TYPE_S1 == "DISABLED")) 
            begin : _single_port
                always
                    @(posedge clk_i or 
                        negedge rstn_i)
                    begin
                        if ((~rstn_i)) 
                            begin
                                axi_s0_awready_reg = 1'b0 ;
                                axi_s0_wready_reg = 1'b0 ;
                                axi_s1_awready_reg = 1'b0 ;
                                axi_s1_wready_reg = 1'b0 ;
                                axi_s0_arready_reg = 1'b0 ;
                                axi_s1_arready_reg = 1'b0 ;
                            end
                        else
                            begin
                                axi_s0_awready_reg = 1'b1 ;
                                axi_s0_wready_reg = 1'b1 ;
                                axi_s1_awready_reg = 1'b0 ;
                                axi_s1_wready_reg = 1'b0 ;
                                axi_s0_arready_reg = 1'b1 ;
                                axi_s1_arready_reg = 1'b0 ;
                            end
                    end
                assign arb_mem_awaddr_o = axi_s0_awaddr_i ; 
                assign arb_mem_wdata_o = axi_s0_wdata_i ; 
                assign arb_mem_wr_en_o = axi_s0_wr_en_i ; 
                assign arb_mem_byte_en_o = axi_s0_byte_en_i ; 
                assign arb_mem_araddr_o = axi_s0_araddr_i ; 
                assign arb_mem_rd_en_o = axi_s0_rd_en_i ; 
            end
        else
            begin : _axi_arbitration
                reg [1:0] aw_nstate ; 
                reg [1:0] aw_cstate_reg ; 
                reg [1:0] ar_nstate ; 
                reg [1:0] ar_cstate_reg ; 
                //------------------------------
                // Write
                //------------------------------
                always
                    @(posedge clk_i or 
                        negedge rstn_i)
                    begin
                        if ((~rstn_i)) 
                            aw_cstate_reg <=  IDLE ;
                        else
                            aw_cstate_reg <=  aw_nstate ;
                    end
                always
                    @(*)
                    begin
                        aw_nstate = aw_cstate_reg ;
                        case (aw_cstate_reg)
                        IDLE : 
                            aw_nstate = GRANT_S0 ;
                        GRANT_S0 : 
                            begin
                                if (axi_s0_awpipeline_i) 
                                    aw_nstate = GRANT_S0 ;
                                else
                                    if (((~axi_s0_awvalid_i) && axi_s1_awvalid_i)) 
                                        aw_nstate = GRANT_S1 ;
                            end
                        GRANT_S1 : 
                            begin
                                if ((axi_s1_awpipeline_i || axi_s1_awvalid_i)) 
                                    aw_nstate = GRANT_S1 ;
                                else
                                    aw_nstate = GRANT_S0 ;
                            end
                        default : 
                            aw_nstate = IDLE ;
                        endcase 
                    end
                always
                    @(*)
                    begin
                        if ((~rstn_i)) 
                            begin
                                axi_s0_awready_reg = 1'b0 ;
                                axi_s0_wready_reg = 1'b0 ;
                                axi_s1_awready_reg = 1'b0 ;
                                axi_s1_wready_reg = 1'b0 ;
                            end
                        else
                            begin
                                axi_s0_awready_reg = 1'b1 ;
                                axi_s0_wready_reg = 1'b1 ;
                                axi_s1_awready_reg = 1'b0 ;
                                axi_s1_wready_reg = 1'b0 ;
                                case (aw_nstate)
                                IDLE : 
                                    ; 
                                GRANT_S0 : 
                                    ; 
                                GRANT_S1 : 
                                    begin
                                        axi_s0_awready_reg = 1'b0 ;
                                        axi_s0_wready_reg = 1'b0 ;
                                        axi_s1_awready_reg = 1'b1 ;
                                        axi_s1_wready_reg = 1'b1 ;
                                    end
                                default : 
                                    begin
                                        axi_s0_awready_reg = 1'bx ;
                                        axi_s0_wready_reg = 1'bx ;
                                        axi_s1_awready_reg = 1'bx ;
                                        axi_s1_wready_reg = 1'bx ;
                                    end
                                endcase 
                            end
                    end
                //------------------------------
                // Read
                //------------------------------
                always
                    @(posedge clk_i or 
                        negedge rstn_i)
                    begin
                        if ((~rstn_i)) 
                            ar_cstate_reg <=  IDLE ;
                        else
                            ar_cstate_reg <=  ar_nstate ;
                    end
                always
                    @(*)
                    begin
                        ar_nstate = ar_cstate_reg ;
                        case (ar_cstate_reg)
                        IDLE : 
                            ar_nstate = GRANT_S0 ;
                        GRANT_S0 : 
                            begin
                                if (axi_s0_arpipeline_i) 
                                    ar_nstate = GRANT_S0 ;
                                else
                                    if (((~axi_s0_arvalid_i) && axi_s1_arvalid_i)) 
                                        ar_nstate = GRANT_S1 ;
                            end
                        GRANT_S1 : 
                            begin
                                if ((axi_s1_arpipeline_i || axi_s1_arvalid_i)) 
                                    ar_nstate = GRANT_S1 ;
                                else
                                    ar_nstate = GRANT_S0 ;
                            end
                        default : 
                            ar_nstate = IDLE ;
                        endcase 
                    end
                always
                    @(*)
                    begin
                        if ((~rstn_i)) 
                            begin
                                axi_s0_arready_reg = 1'b0 ;
                                axi_s1_arready_reg = 1'b0 ;
                            end
                        else
                            begin
                                axi_s0_arready_reg = 1'b1 ;
                                axi_s1_arready_reg = 1'b0 ;
                                case (ar_nstate)
                                IDLE : 
                                    ; 
                                GRANT_S0 : 
                                    ; 
                                GRANT_S1 : 
                                    begin
                                        axi_s0_arready_reg = 1'b0 ;
                                        axi_s1_arready_reg = 1'b1 ;
                                    end
                                default : 
                                    begin
                                        axi_s0_arready_reg = 1'bx ;
                                        axi_s1_arready_reg = 1'bx ;
                                    end
                                endcase 
                            end
                    end
                assign arb_mem_awaddr_o = ((aw_cstate_reg == GRANT_S1) ? axi_s1_awaddr_i : axi_s0_awaddr_i) ; 
                assign arb_mem_wdata_o = ((aw_cstate_reg == GRANT_S1) ? axi_s1_wdata_i : axi_s0_wdata_i) ; 
                assign arb_mem_wr_en_o = ((aw_cstate_reg == GRANT_S1) ? axi_s1_wr_en_i : axi_s0_wr_en_i) ; 
                assign arb_mem_byte_en_o = ((aw_cstate_reg == GRANT_S1) ? axi_s1_byte_en_i : axi_s0_byte_en_i) ; 
                assign arb_mem_araddr_o = ((ar_cstate_reg == GRANT_S1) ? axi_s1_araddr_i : axi_s0_araddr_i) ; 
                assign arb_mem_rd_en_o = ((ar_cstate_reg == GRANT_S1) ? axi_s1_rd_en_i : axi_s0_rd_en_i) ; 
            end
    endgenerate
    // -----------------------------------------------------------------------------
    // Output Assignments
    // -----------------------------------------------------------------------------
    assign axi_s0_awready_o = axi_s0_awready_reg ; 
    assign axi_s0_wready_o = axi_s0_wready_reg ; 
    assign axi_s0_arready_o = axi_s0_arready_reg ; 
    assign axi_s1_awready_o = axi_s1_awready_reg ; 
    assign axi_s1_wready_o = axi_s1_wready_reg ; 
    assign axi_s1_arready_o = axi_s1_arready_reg ; 
endmodule



`timescale 1ns/1ps
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
module sysmem_ipgen_lscc_ahblmem_subordinate #(parameter DATA_WIDTH = 32, 
        parameter ADDR_DEPTH = 16384, 
        parameter ADDR_WIDTH = clog2(ADDR_DEPTH), 
        parameter REG_MODE = "noreg", 
        parameter BYTE_ENABLE = 1, 
        parameter START_ADDR = 0, 
        parameter END_ADDR = (((ADDR_DEPTH * DATA_WIDTH) / 8) - 1), 
        parameter PORT_TYPE = "R/W", 
        parameter RESET_MODE = "sync", 
        parameter BYTE_WIDTH = (DATA_WIDTH / 8), 
        parameter UNALIGNED_EN = 0, 
        parameter UNALIGNED_DIR = "none", 
        parameter READ_PIPELINE = 0, 
        parameter MEMORY_TYPE = "EBR") (
    input ahbl_hclk_i, 
    input ahbl_hresetn_i, 
    // ------------------------   
    // AHB-Lite Interface         
    // ------------------------   
    input ahbl_hsel_i, 
    input ahbl_hready_i, 
    input [31:0] ahbl_haddr_i, 
    input [2:0] ahbl_hburst_i, 
    input [2:0] ahbl_hsize_i, 
    input ahbl_hmastlock_i,  // currently not used
    input [3:0] ahbl_hprot_i,  // currently not used
    input [1:0] ahbl_htrans_i, 
    input ahbl_hwrite_i, 
    input [(DATA_WIDTH - 1):0] ahbl_hwdata_i, 
    output ahbl_hreadyout_o, 
    output ahbl_hresp_o, 
    output [(DATA_WIDTH - 1):0] ahbl_hrdata_o, 
    // ------------------------
    // Memory Interface           
    // ------------------------
    input [(DATA_WIDTH - 1):0] mem_rdata_i, 
    input mem_error_i, 
    output mem_request_o, 
    output mem_wr_rdn_o, 
    output [(ADDR_WIDTH - 1):0] mem_addr_o, 
    output [(DATA_WIDTH - 1):0] mem_wdata_o, 
    output [(BYTE_WIDTH - 1):0] mem_byte_en_o) ;
    // ------------------------------------------------------------------------------
    // Local Parameters
    // ------------------------------------------------------------------------------
    // AHBL_MEM_STATE
    localparam ERR_STATE_SIZE = 3 ; 
    localparam [(ERR_STATE_SIZE - 1):0] ERR_NORMAL_MODE = 3'b001 ; // 8'h01
    localparam [(ERR_STATE_SIZE - 1):0] ERR_T1 = 3'b010 ; // 8'h02
    localparam [(ERR_STATE_SIZE - 1):0] ERR_T2 = 3'b100 ; // 8'h04
    // AHBL_MEM_STATE
    localparam STATE_SIZE = 14 ; 
    localparam [(STATE_SIZE - 1):0] SM_IDLE = 14'b00000000000001 ; //32'h0001
    localparam [(STATE_SIZE - 1):0] SM_WRITE_NSEQ = 14'b00000000000010 ; //32'h0002
    localparam [(STATE_SIZE - 1):0] SM_WRITE_SEQ = 14'b00000000000100 ; //32'h0004
    localparam [(STATE_SIZE - 1):0] SM_READ_NSEQ = 14'b00000000001000 ; //32'h0008
    localparam [(STATE_SIZE - 1):0] SM_READ_SEQ = 14'b00000000010000 ; //32'h0010
    localparam [(STATE_SIZE - 1):0] SM_READ_NSEQ_WAIT = 14'b00000000100000 ; //32'h0020
    localparam [(STATE_SIZE - 1):0] SM_READ_NSEQ_RESULT = 14'b00000001000000 ; //32'h0040
    localparam [(STATE_SIZE - 1):0] SM_READ_SEQ_INIT = 14'b00000010000000 ; //32'h0080
    localparam [(STATE_SIZE - 1):0] SM_READ_SEQ_BURST = 14'b00000100000000 ; //32'h0100
    localparam [(STATE_SIZE - 1):0] SM_WRITE_TO_READ = 14'b00001000000000 ; //32'h0200
    localparam [(STATE_SIZE - 1):0] SM_BUSY = 14'b00010000000000 ; //32'h0400
    localparam [(STATE_SIZE - 1):0] SM_ERROR = 14'b00100000000000 ; //32'h0800
    localparam [(STATE_SIZE - 1):0] SM_READ_NSEQ_WAIT2 = 14'b01000000000000 ; //32'h1000
    localparam [(STATE_SIZE - 1):0] SM_READ_SEQ_WAIT = 14'b10000000000000 ; //32'h2000
    // HBURST commands                         
    localparam [2:0] SINGLE = 3'b000 ; 
    localparam [2:0] INCR = 3'b001 ; 
    localparam [2:0] WRAP4 = 3'b010 ; 
    localparam [2:0] INCR4 = 3'b011 ; 
    localparam [2:0] WRAP8 = 3'b100 ; 
    localparam [2:0] INCR8 = 3'b101 ; 
    localparam [2:0] WRAP16 = 3'b110 ; 
    localparam [2:0] INCR16 = 3'b111 ; 
    // HTRANS commands
    localparam [1:0] IDLE = 2'b00 ; 
    localparam [1:0] BUSY = 2'b01 ; 
    localparam [1:0] NSEQ = 2'b10 ; 
    localparam [1:0] SEQ = 2'b11 ; 
    // HSIZE transactions
    localparam [2:0] X32_WORD = 3'b010 ; 
    localparam [2:0] X16_HALFWORD = 3'b001 ; 
    localparam [2:0] X8_BYTE = 3'b000 ; 
    // Default Values
    localparam [2:0] HDATA_SIZE_DEF = ((DATA_WIDTH == 32) ? X32_WORD : ((DATA_WIDTH == 16) ? X16_HALFWORD : X8_BYTE)) ; 
    localparam BYTE_EN_POL = ((MEMORY_TYPE == "LRAM") ? 1'b0 : 1'b1) ; 
    localparam BYTE_EN_NEG = ((MEMORY_TYPE == "LRAM") ? 1'b1 : 1'b0) ; 
    localparam MEM_END_ADDR_LIMIT = ((END_ADDR + 1) / 1024) ; 
    // ------------------------------------------------------------------------------
    // Wire and Register Declarations
    // ------------------------------------------------------------------------------
    // Select Signal
    wire slv_sel = (ahbl_hsel_i & (ahbl_htrans_i != IDLE)) ; 
    // System State Machine   
    reg [(STATE_SIZE - 1):0] bridge_sm_nxt_r = SM_IDLE ; 
    reg [(STATE_SIZE - 1):0] bridge_sm_r = SM_IDLE ; 
    reg [(ERR_STATE_SIZE - 1):0] err_sm_r = ERR_NORMAL_MODE ; 
    reg [(ERR_STATE_SIZE - 1):0] err_sm_nxt_r = ERR_NORMAL_MODE ; 
    // Sampled Signals (1st sample)
    reg ahbl_hsel_p_r = 1'b0 ; 
    reg [1:0] ahbl_htrans_p_r = IDLE ; 
    reg [2:0] ahbl_hsize_p_r = HDATA_SIZE_DEF ; 
    reg [31:0] ahbl_haddr_p_r = START_ADDR ; 
    // Sampled Signals (2nd sample)
    reg ahbl_hsel_p2_r = 1'b0 ; 
    reg [1:0] ahbl_htrans_p2_r = IDLE ; 
    // Memory Address and Control Assignments
    reg [31:0] rd_burst_r = START_ADDR ; 
    reg [31:0] rd_prev_r = START_ADDR ; 
    wire [31:0] rd_addr_w ; 
    wire rd_mem_req_w = ((ahbl_hsel_i | ahbl_hsel_p_r) | ahbl_hsel_p2_r) ; 
    wire rd_mem_en_w = ((((((ahbl_htrans_i == NSEQ) | (ahbl_htrans_i == SEQ)) | (ahbl_htrans_p_r == NSEQ)) | (ahbl_htrans_p_r == SEQ)) | (ahbl_htrans_p2_r == NSEQ)) | (ahbl_htrans_p2_r == SEQ)) ; 
    reg [31:0] wr_addr_r = START_ADDR ; 
    wire [31:0] wr_addr_w = wr_addr_r ; 
    wire wr_mem_req_w = ahbl_hsel_p_r ; 
    wire wr_mem_en_w = ((ahbl_htrans_p_r == NSEQ) | (ahbl_htrans_p_r == SEQ)) ; 
    wire [2:0] addr_add_w = ((ahbl_hsize_i == X32_WORD) ? 3'b100 : ((ahbl_hsize_i == X16_HALFWORD) ? 3'b010 : 3'b001)) ; 
    wire [31:0] mem_addr_w = (((bridge_sm_r == SM_WRITE_NSEQ) || (bridge_sm_r == SM_WRITE_SEQ)) ? wr_addr_w : rd_addr_w) ; 
    // Output Control Signals
    wire [3:0] unaligned_ctrl_w = ((UNALIGNED_EN == 1) ? ((UNALIGNED_DIR == "right") ? {{2'b00},
                {rd_addr_w[1:0]}} : ((UNALIGNED_DIR == "left") ? {{2'b01},
                {rd_addr_w[1:0]}} : 4'b0000)) : ((MEMORY_TYPE == "EBR") ? 4'b1111 : 4'b0000)) ; 
    wire [(BYTE_WIDTH - 1):0] ben_w = ((BYTE_ENABLE == 1) ? ((DATA_WIDTH == 32) ? ((ahbl_hsize_p_r == X32_WORD) ? {4{BYTE_EN_POL}} : ((ahbl_hsize_p_r == X16_HALFWORD) ? ((wr_addr_w[1] == 1) ? {{2{BYTE_EN_POL}},
                {2{BYTE_EN_NEG}}} : {{2{BYTE_EN_NEG}},
                {2{BYTE_EN_POL}}}) : ((wr_addr_w[1:0] == 3) ? {/*(ahbl_hsize_p_r == X8_BYTE) ? */ BYTE_EN_POL,
                {3{BYTE_EN_NEG}}} : ((wr_addr_w[1:0] == 2) ? {BYTE_EN_NEG,
                BYTE_EN_POL,
                {2{BYTE_EN_NEG}}} : ((wr_addr_w[1:0] == 1) ? {{2{BYTE_EN_NEG}},
                BYTE_EN_POL,
                BYTE_EN_NEG} : {{3{BYTE_EN_NEG}},
                BYTE_EN_POL}))))) : ((DATA_WIDTH == 16) ? ((ahbl_hsize_p_r == X16_HALFWORD) ? {2{BYTE_EN_POL}} : ((wr_addr_w[0] == 1) ? {/*(ahbl_hsize_p_r == X8_BYTE) ? */ BYTE_EN_POL,
                BYTE_EN_NEG} : {BYTE_EN_NEG,
                BYTE_EN_POL})) : {BYTE_WIDTH{BYTE_EN_POL}})) : {BYTE_WIDTH{BYTE_EN_POL}}) ; 
    reg ahbl_hreadyout_ext_r = 1'b1 ; 
    reg ahbl_hreadyout_r = 1'b1 ; 
    reg ahbl_hresp_r = 1'b0 ; 
    // Next Register Signals
    reg ahbl_hreadyout_nxt_r = 1'b1 ; 
    wire ahbl_hresp_nxt_r = ((err_sm_nxt_r == ERR_NORMAL_MODE) ? 1'b0 : 1'b1) ; 
    reg ahbl_hsel_p_nxt_r = 1'b0 ; 
    // Error Signals
    wire AHBL_unaligned_w = ((DATA_WIDTH == 32) ? ((ahbl_hsize_i == X32_WORD) ? ((ahbl_haddr_i[1:0] == 2'b00) ? 1'b1 : (~slv_sel)) : ((ahbl_hsize_i == X16_HALFWORD) ? ((ahbl_haddr_i[0] == 1'b0) ? 1'b1 : (~slv_sel)) : 1'b1)) : ((DATA_WIDTH == 16) ? ((ahbl_hsize_i == X16_HALFWORD) ? ((ahbl_haddr_i[0] == 1'b0) ? 1'b1 : (~slv_sel)) : 1'b1) : 1'b1)) ; 
    wire AHBL_overflow_w ; 
    wire AHBL_misaccess_w = ((PORT_TYPE == "W/O") ? ((ahbl_hwrite_i == 1'b1) ? 1'b1 : (~slv_sel)) : ((PORT_TYPE == "R/O") ? ((ahbl_hwrite_i == 1'b0) ? 1'b1 : (~slv_sel)) : 1'b1)) ; 
    wire AHBL_overwidth_w = ((DATA_WIDTH == 32) ? 1'b1 : ((DATA_WIDTH == 16) ? ((ahbl_hsize_i == X32_WORD) ? (~slv_sel) : 1'b1) : ((ahbl_hsize_i == X8_BYTE) ? 1'b1 : (~slv_sel)))) ; 
    wire AHBL_reg_wrap_w = (((REG_MODE == "reg") && (ahbl_hwrite_i == 1'b0)) && (((ahbl_hburst_i == WRAP4) | (ahbl_hburst_i == WRAP8)) | (ahbl_hburst_i == WRAP16))) ; 
    wire AHBL_ok_w = ((((AHBL_unaligned_w & AHBL_overflow_w) & AHBL_misaccess_w) & AHBL_overwidth_w) && (~AHBL_reg_wrap_w)) ; 
    // Output Assignments
    assign ahbl_hreadyout_o = ahbl_hreadyout_ext_r ; 
    assign ahbl_hresp_o = ahbl_hresp_r ; 
    assign ahbl_hrdata_o = mem_rdata_i ; 
    assign mem_wdata_o = ahbl_hwdata_i ; 
    assign mem_addr_o = ((DATA_WIDTH == 32) ? mem_addr_w[(ADDR_WIDTH + 1):2] : ((DATA_WIDTH == 16) ? mem_addr_w[ADDR_WIDTH:1] : mem_addr_w[(ADDR_WIDTH - 1):0])) ; 
    assign mem_byte_en_o = ((MEMORY_TYPE == "LRAM") ? (((bridge_sm_r == SM_WRITE_NSEQ) || (bridge_sm_r == SM_WRITE_SEQ)) ? ben_w : unaligned_ctrl_w) : ben_w) ; 
    generate
        if ((READ_PIPELINE == 1)) 
            begin : gen_LRAM_pipe
                reg mem_wr_rdn_r ; 
                assign mem_request_o = 1'b1 ; 
                assign mem_wr_rdn_o = mem_wr_rdn_r ; 
                assign rd_addr_w = ((REG_MODE == "noreg") ? ((bridge_sm_r == SM_WRITE_TO_READ) ? rd_prev_r : (ahbl_haddr_i + START_ADDR)) : (((bridge_sm_r == SM_READ_SEQ_BURST) || (bridge_sm_r == SM_READ_SEQ_WAIT)) ? ((ahbl_htrans_i == NSEQ) ? (ahbl_haddr_i + START_ADDR) : rd_burst_r) : ((bridge_sm_r == SM_WRITE_TO_READ) ? rd_prev_r : (ahbl_haddr_i + START_ADDR)))) ; 
                always
                    @(posedge ahbl_hclk_i)
                    mem_wr_rdn_r <=  ((err_sm_nxt_r == ERR_NORMAL_MODE) & ((bridge_sm_nxt_r == SM_WRITE_NSEQ) || (bridge_sm_nxt_r == SM_WRITE_SEQ))) ;
            end
        else
            begin : genblk1
                assign mem_request_o = ((err_sm_r == ERR_NORMAL_MODE) & ((bridge_sm_r != SM_IDLE) || ((ahbl_hsel_i == 1'b1) && (ahbl_htrans_i == NSEQ)))) ; 
                assign mem_wr_rdn_o = ((bridge_sm_r == SM_WRITE_NSEQ) || (bridge_sm_r == SM_WRITE_SEQ)) ; 
                assign rd_addr_w = ((REG_MODE == "noreg") ? ((bridge_sm_r == SM_WRITE_TO_READ) ? rd_prev_r : (ahbl_haddr_i + START_ADDR)) : ((bridge_sm_r == SM_READ_SEQ_BURST) ? ((ahbl_htrans_i == NSEQ) ? (ahbl_haddr_i + START_ADDR) : rd_burst_r) : ((bridge_sm_r == SM_WRITE_TO_READ) ? rd_prev_r : (ahbl_haddr_i + START_ADDR)))) ; 
            end
    endgenerate
    // ------------------------------------------------------------------------------
    // Initialize Registers for Simulation
    // ------------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Combinational Logic
    // ------------------------------------------------------------------------------
    generate
        if ((ADDR_WIDTH <= 10)) 
            begin : genblk2
                assign AHBL_overflow_w = 1'b1 ; 
            end
        else
            begin : genblk2
                assign AHBL_overflow_w = ((ahbl_haddr_i[31:10] < MEM_END_ADDR_LIMIT) | (~(ahbl_hreadyout_r & slv_sel))) ; 
            end
        if ((REG_MODE == "noreg")) 
            begin : _nreg
                always
                    @(*)
                    begin
                        bridge_sm_nxt_r = bridge_sm_r ;
                        case (bridge_sm_r)
                        SM_IDLE : 
                            begin
                                if (((ahbl_hsel_i & (ahbl_htrans_i == NSEQ)) & ahbl_hready_i)) 
                                    begin
                                        bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ) ;
                                    end
                                else
                                    begin
                                        bridge_sm_nxt_r = SM_IDLE ;
                                    end
                            end
                        SM_WRITE_NSEQ : 
                            begin
                                if (ahbl_hsel_i) 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_WRITE_TO_READ) ;
                                        SEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_SEQ : SM_WRITE_TO_READ) ;
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_IDLE ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_BUSY ;
                                        endcase 
                                    end
                                else
                                    begin
                                        bridge_sm_nxt_r = SM_IDLE ;
                                    end
                            end
                        SM_WRITE_SEQ : 
                            begin
                                if (ahbl_hsel_i) 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_WRITE_TO_READ) ;
                                        SEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_SEQ : SM_WRITE_TO_READ) ;
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_IDLE ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_BUSY ;
                                        endcase 
                                    end
                                else
                                    begin
                                        bridge_sm_nxt_r = SM_IDLE ;
                                    end
                            end
                        SM_WRITE_TO_READ : 
                            begin
                                case (ahbl_htrans_i)
                                NSEQ : 
                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ) ;
                                SEQ : 
                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_SEQ : SM_READ_SEQ) ;
                                IDLE : 
                                    bridge_sm_nxt_r = SM_IDLE ;
                                BUSY : 
                                    bridge_sm_nxt_r = SM_BUSY ;
                                endcase 
                            end
                        SM_READ_NSEQ : 
                            begin
                                if (ahbl_hsel_i) 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ) ;
                                        SEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_SEQ : SM_READ_SEQ) ;
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_IDLE ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_BUSY ;
                                        endcase 
                                    end
                                else
                                    begin
                                        bridge_sm_nxt_r = SM_IDLE ;
                                    end
                            end
                        SM_READ_SEQ : 
                            begin
                                if (ahbl_hsel_i) 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ) ;
                                        SEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_SEQ : SM_READ_SEQ) ;
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_IDLE ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_BUSY ;
                                        endcase 
                                    end
                                else
                                    begin
                                        bridge_sm_nxt_r = SM_IDLE ;
                                    end
                            end
                        SM_BUSY : 
                            begin
                                if (ahbl_hsel_i) 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ) ;
                                        SEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_SEQ : SM_WRITE_TO_READ) ;
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_IDLE ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_BUSY ;
                                        endcase 
                                    end
                                else
                                    begin
                                        bridge_sm_nxt_r = SM_BUSY ;
                                    end
                            end
                        default : 
                            bridge_sm_nxt_r = SM_IDLE ;
                        endcase 
                    end
            end
        else
            begin : _reg
                if ((READ_PIPELINE == 1)) 
                    begin : __READ_PIPELINE
                        always
                            @(*)
                            begin
                                bridge_sm_nxt_r = bridge_sm_r ;
                                case (bridge_sm_r)
                                SM_IDLE : 
                                    begin
                                        if (((ahbl_hsel_i & (ahbl_htrans_i == NSEQ)) & ahbl_hready_i)) 
                                            begin
                                                bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_WAIT) ;
                                            end
                                        else
                                            begin
                                                bridge_sm_nxt_r = SM_IDLE ;
                                            end
                                    end
                                SM_WRITE_NSEQ : 
                                    begin
                                        if (ahbl_hsel_i) 
                                            begin
                                                case (ahbl_htrans_i)
                                                NSEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_WRITE_TO_READ) ;
                                                SEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_SEQ : SM_WRITE_TO_READ) ;
                                                IDLE : 
                                                    bridge_sm_nxt_r = SM_IDLE ;
                                                BUSY : 
                                                    bridge_sm_nxt_r = SM_BUSY ;
                                                endcase 
                                            end
                                        else
                                            begin
                                                bridge_sm_nxt_r = SM_IDLE ;
                                            end
                                    end
                                SM_WRITE_SEQ : 
                                    begin
                                        if (ahbl_hsel_i) 
                                            begin
                                                case (ahbl_htrans_i)
                                                NSEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_WRITE_TO_READ) ;
                                                SEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_SEQ : SM_WRITE_TO_READ) ;
                                                IDLE : 
                                                    bridge_sm_nxt_r = SM_IDLE ;
                                                BUSY : 
                                                    bridge_sm_nxt_r = SM_BUSY ;
                                                endcase 
                                            end
                                        else
                                            begin
                                                bridge_sm_nxt_r = SM_IDLE ;
                                            end
                                    end
                                SM_WRITE_TO_READ : 
                                    begin
                                        bridge_sm_nxt_r = SM_READ_NSEQ_WAIT ;
                                    end
                                SM_READ_NSEQ_WAIT : 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_WAIT2) ;
                                        SEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_WAIT) ;
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_READ_NSEQ_WAIT2 ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_READ_NSEQ_WAIT2 ;
                                        endcase 
                                    end
                                SM_READ_NSEQ_WAIT2 : 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_RESULT) ;
                                        SEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_BURST) ;
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_IDLE ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_BUSY ;
                                        endcase 
                                    end
                                SM_READ_NSEQ_RESULT : 
                                    begin
                                        if (ahbl_hsel_i) 
                                            begin
                                                case (ahbl_htrans_i)
                                                NSEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_WAIT) ;
                                                SEQ : 
                                                    begin
                                                        case (ahbl_hburst_i)
                                                        SINGLE : 
                                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_INIT) ;
                                                        INCR : 
                                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_INIT) ;
                                                        default : 
                                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_BURST) ;
                                                        endcase 
                                                    end
                                                IDLE : 
                                                    bridge_sm_nxt_r = SM_IDLE ;
                                                BUSY : 
                                                    bridge_sm_nxt_r = SM_BUSY ;
                                                endcase 
                                            end
                                        else
                                            begin
                                                bridge_sm_nxt_r = SM_IDLE ;
                                            end
                                    end
                                SM_READ_SEQ_INIT : 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_WAIT2) ;
                                        SEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_WAIT) ;
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_READ_SEQ_WAIT ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_READ_SEQ_WAIT ;
                                        endcase 
                                    end
                                SM_READ_SEQ_WAIT : 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_RESULT) ;
                                        SEQ : 
                                            begin
                                                case (ahbl_hburst_i)
                                                SINGLE : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_BURST) ;
                                                INCR : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_BURST) ;
                                                INCR8 : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_BURST) ;
                                                default : 
                                                    bridge_sm_nxt_r = SM_IDLE ;
                                                endcase 
                                            end
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_IDLE ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_BUSY ;
                                        endcase 
                                    end
                                SM_READ_SEQ_BURST : 
                                    begin
                                        if (ahbl_hsel_i) 
                                            begin
                                                case (ahbl_htrans_i)
                                                NSEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_WAIT) ;
                                                SEQ : 
                                                    begin
                                                        case (ahbl_hburst_i)
                                                        SINGLE : 
                                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_INIT) ;
                                                        default : 
                                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_BURST) ;
                                                        endcase 
                                                    end
                                                IDLE : 
                                                    bridge_sm_nxt_r = SM_IDLE ;
                                                BUSY : 
                                                    bridge_sm_nxt_r = SM_BUSY ;
                                                endcase 
                                            end
                                        else
                                            begin
                                                bridge_sm_nxt_r = SM_IDLE ;
                                            end
                                    end
                                SM_BUSY : 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_WAIT) ;
                                        SEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_SEQ : SM_WRITE_TO_READ) ;
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_IDLE ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_BUSY ;
                                        endcase 
                                    end
                                default : 
                                    bridge_sm_nxt_r = SM_IDLE ;
                                endcase 
                            end
                    end
                else
                    begin : genblk1
                        always
                            @(*)
                            begin
                                bridge_sm_nxt_r = bridge_sm_r ;
                                case (bridge_sm_r)
                                SM_IDLE : 
                                    begin
                                        if (((ahbl_hsel_i & (ahbl_htrans_i == NSEQ)) & ahbl_hready_i)) 
                                            begin
                                                bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_WAIT) ;
                                            end
                                        else
                                            begin
                                                bridge_sm_nxt_r = SM_IDLE ;
                                            end
                                    end
                                SM_WRITE_NSEQ : 
                                    begin
                                        if (ahbl_hsel_i) 
                                            begin
                                                case (ahbl_htrans_i)
                                                NSEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_WRITE_TO_READ) ;
                                                SEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_SEQ : SM_WRITE_TO_READ) ;
                                                IDLE : 
                                                    bridge_sm_nxt_r = SM_IDLE ;
                                                BUSY : 
                                                    bridge_sm_nxt_r = SM_BUSY ;
                                                endcase 
                                            end
                                        else
                                            begin
                                                bridge_sm_nxt_r = SM_IDLE ;
                                            end
                                    end
                                SM_WRITE_SEQ : 
                                    begin
                                        if (ahbl_hsel_i) 
                                            begin
                                                case (ahbl_htrans_i)
                                                NSEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_WRITE_TO_READ) ;
                                                SEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_SEQ : SM_WRITE_TO_READ) ;
                                                IDLE : 
                                                    bridge_sm_nxt_r = SM_IDLE ;
                                                BUSY : 
                                                    bridge_sm_nxt_r = SM_BUSY ;
                                                endcase 
                                            end
                                        else
                                            begin
                                                bridge_sm_nxt_r = SM_IDLE ;
                                            end
                                    end
                                SM_WRITE_TO_READ : 
                                    begin
                                        bridge_sm_nxt_r = SM_READ_NSEQ_WAIT ;
                                    end
                                SM_READ_NSEQ_WAIT : 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_RESULT) ;
                                        SEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_BURST) ;
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_IDLE ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_BUSY ;
                                        endcase 
                                    end
                                SM_READ_NSEQ_RESULT : 
                                    begin
                                        if (ahbl_hsel_i) 
                                            begin
                                                case (ahbl_htrans_i)
                                                NSEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_WAIT) ;
                                                SEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_BURST) ;
                                                IDLE : 
                                                    bridge_sm_nxt_r = SM_IDLE ;
                                                BUSY : 
                                                    bridge_sm_nxt_r = SM_BUSY ;
                                                endcase 
                                            end
                                        else
                                            begin
                                                bridge_sm_nxt_r = SM_IDLE ;
                                            end
                                    end
                                SM_READ_SEQ_INIT : 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_RESULT) ;
                                        SEQ : 
                                            begin
                                                case (ahbl_hburst_i)
                                                SINGLE : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_BURST) ;
                                                default : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_BURST) ;
                                                endcase 
                                            end
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_IDLE ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_BUSY ;
                                        endcase 
                                    end
                                SM_READ_SEQ_BURST : 
                                    begin
                                        if (ahbl_hsel_i) 
                                            begin
                                                case (ahbl_htrans_i)
                                                NSEQ : 
                                                    bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_WAIT) ;
                                                SEQ : 
                                                    begin
                                                        case (ahbl_hburst_i)
                                                        SINGLE : 
                                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_INIT) ;
                                                        INCR : 
                                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_BURST) ;
                                                        INCR8 : 
                                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_SEQ_BURST) ;
                                                        default : 
                                                            bridge_sm_nxt_r = SM_READ_SEQ_INIT ;
                                                        endcase 
                                                    end
                                                IDLE : 
                                                    bridge_sm_nxt_r = SM_IDLE ;
                                                BUSY : 
                                                    bridge_sm_nxt_r = SM_BUSY ;
                                                endcase 
                                            end
                                        else
                                            begin
                                                bridge_sm_nxt_r = SM_IDLE ;
                                            end
                                    end
                                SM_BUSY : 
                                    begin
                                        case (ahbl_htrans_i)
                                        NSEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_NSEQ : SM_READ_NSEQ_WAIT) ;
                                        SEQ : 
                                            bridge_sm_nxt_r = ((ahbl_hwrite_i == 1'b1) ? SM_WRITE_SEQ : SM_WRITE_TO_READ) ;
                                        IDLE : 
                                            bridge_sm_nxt_r = SM_IDLE ;
                                        BUSY : 
                                            bridge_sm_nxt_r = SM_BUSY ;
                                        endcase 
                                    end
                                default : 
                                    bridge_sm_nxt_r = SM_IDLE ;
                                endcase 
                            end
                    end
            end
    endgenerate
    always
        @(*)
        begin
            err_sm_nxt_r = err_sm_r ;
            case (err_sm_r)
            ERR_NORMAL_MODE : 
                err_sm_nxt_r = ((AHBL_ok_w == 1'b0) ? ERR_T1 : ERR_NORMAL_MODE) ;
            ERR_T1 : 
                err_sm_nxt_r = ERR_T2 ;
            ERR_T2 : 
                err_sm_nxt_r = ERR_NORMAL_MODE ;
            endcase 
        end
    generate
        if ((READ_PIPELINE == 1)) 
            begin : _LRAM_pipe
                always
                    @(*)
                    begin
                        ahbl_hreadyout_nxt_r = ahbl_hreadyout_r ;
                        case (err_sm_nxt_r)
                        ERR_NORMAL_MODE : 
                            ahbl_hreadyout_nxt_r = (~(((((bridge_sm_nxt_r == SM_WRITE_TO_READ) | (bridge_sm_nxt_r == SM_READ_NSEQ_WAIT)) | (bridge_sm_nxt_r == SM_READ_SEQ_INIT)) | (bridge_sm_nxt_r == SM_READ_NSEQ_WAIT2)) | (bridge_sm_nxt_r == SM_READ_SEQ_WAIT))) ;
                        ERR_T1 : 
                            ahbl_hreadyout_nxt_r = 1'b0 ;
                        ERR_T2 : 
                            ahbl_hreadyout_nxt_r = 1'b1 ;
                        endcase 
                    end
            end
        else
            begin : genblk4
                always
                    @(*)
                    begin
                        ahbl_hreadyout_nxt_r = ahbl_hreadyout_r ;
                        case (err_sm_nxt_r)
                        ERR_NORMAL_MODE : 
                            ahbl_hreadyout_nxt_r = (~(((bridge_sm_nxt_r == SM_WRITE_TO_READ) | (bridge_sm_nxt_r == SM_READ_NSEQ_WAIT)) | (bridge_sm_nxt_r == SM_READ_SEQ_INIT))) ;
                        ERR_T1 : 
                            ahbl_hreadyout_nxt_r = 1'b0 ;
                        ERR_T2 : 
                            ahbl_hreadyout_nxt_r = 1'b1 ;
                        endcase 
                    end
            end
    endgenerate
    // ------------------------------------------------------------------------------
    // Sequential Logic
    // ------------------------------------------------------------------------------
    if ((RESET_MODE == "sync")) 
        begin : genblk5
            // Register for AHB-L interface (1st sample)
            always
                @(posedge ahbl_hclk_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            ahbl_hsel_p_r <=  1'b0 ;
                            ahbl_htrans_p_r <=  IDLE ;
                            ahbl_hsize_p_r <=  HDATA_SIZE_DEF ;
                            ahbl_haddr_p_r <=  START_ADDR ;
                        end
                    else
                        begin
                            ahbl_htrans_p_r <=  ahbl_htrans_i ;
                            ahbl_hsize_p_r <=  ahbl_hsize_i ;
                            ahbl_haddr_p_r <=  ahbl_haddr_i ;
                            ahbl_hsel_p_r <=  ahbl_hsel_i ;
                        end
                end
            if ((REG_MODE == "reg")) 
                begin : genblk1
                    always
                        @(posedge ahbl_hclk_i)
                        begin
                            if ((ahbl_hresetn_i == 1'b0)) 
                                begin
                                    ahbl_hsel_p2_r <=  1'b0 ;
                                    ahbl_htrans_p2_r <=  IDLE ;
                                end
                            else
                                begin
                                    ahbl_htrans_p2_r <=  ahbl_htrans_p_r ;
                                    ahbl_hsel_p2_r <=  ahbl_hsel_p_r ;
                                end
                        end
                end
            // Address Registers
            always
                @(posedge ahbl_hclk_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            rd_prev_r <=  START_ADDR ;
                        end
                    else
                        begin
                            rd_prev_r <=  (ahbl_haddr_i + START_ADDR) ;
                        end
                end
            if ((REG_MODE == "reg")) 
                begin : genblk2
                    always
                        @(posedge ahbl_hclk_i)
                        begin
                            if ((ahbl_hresetn_i == 1'b0)) 
                                begin
                                    rd_burst_r <=  START_ADDR ;
                                end
                            else
                                begin
                                    rd_burst_r <=  (rd_addr_w + addr_add_w) ;
                                end
                        end
                end
            always
                @(posedge ahbl_hclk_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            wr_addr_r <=  START_ADDR ;
                        end
                    else
                        begin
                            wr_addr_r <=  (ahbl_haddr_i + START_ADDR) ;
                        end
                end
            // Subordinate State Machine & Error Generator
            always
                @(posedge ahbl_hclk_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            bridge_sm_r <=  SM_IDLE ;
                        end
                    else
                        begin
                            bridge_sm_r <=  bridge_sm_nxt_r ;
                        end
                end
            always
                @(posedge ahbl_hclk_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            err_sm_r <=  ERR_NORMAL_MODE ;
                        end
                    else
                        begin
                            err_sm_r <=  err_sm_nxt_r ;
                        end
                end
            // HREADY signal 
            always
                @(posedge ahbl_hclk_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            ahbl_hreadyout_r <=  1'b1 ;
                            ahbl_hreadyout_ext_r <=  1'b1 ;
                        end
                    else
                        begin
                            ahbl_hreadyout_r <=  ahbl_hreadyout_nxt_r ;
                            ahbl_hreadyout_ext_r <=  ahbl_hreadyout_nxt_r ;
                        end
                end
            // HRESP signal 
            always
                @(posedge ahbl_hclk_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            ahbl_hresp_r <=  1'b0 ;
                        end
                    else
                        begin
                            ahbl_hresp_r <=  ahbl_hresp_nxt_r ;
                        end
                end
        end
    else
        begin : genblk5
            // Register for AHB-L interface (1st sample)
            always
                @(posedge ahbl_hclk_i or 
                    negedge ahbl_hresetn_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            ahbl_hsel_p_r <=  1'b0 ;
                            ahbl_htrans_p_r <=  IDLE ;
                            ahbl_hsize_p_r <=  HDATA_SIZE_DEF ;
                            ahbl_haddr_p_r <=  START_ADDR ;
                        end
                    else
                        begin
                            ahbl_htrans_p_r <=  ahbl_htrans_i ;
                            ahbl_hsize_p_r <=  ahbl_hsize_i ;
                            ahbl_haddr_p_r <=  ahbl_haddr_i ;
                            ahbl_hsel_p_r <=  ahbl_hsel_i ;
                        end
                end
            if ((REG_MODE == "reg")) 
                begin : genblk1
                    always
                        @(posedge ahbl_hclk_i or 
                            negedge ahbl_hresetn_i)
                        begin
                            if ((ahbl_hresetn_i == 1'b0)) 
                                begin
                                    ahbl_hsel_p2_r <=  1'b0 ;
                                    ahbl_htrans_p2_r <=  IDLE ;
                                end
                            else
                                begin
                                    ahbl_htrans_p2_r <=  ahbl_htrans_p_r ;
                                    ahbl_hsel_p2_r <=  ahbl_hsel_p_r ;
                                end
                        end
                end
            // Address Registers
            always
                @(posedge ahbl_hclk_i or 
                    negedge ahbl_hresetn_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            rd_prev_r <=  START_ADDR ;
                        end
                    else
                        begin
                            rd_prev_r <=  (ahbl_haddr_i + START_ADDR) ;
                        end
                end
            if ((REG_MODE == "reg")) 
                begin : genblk2
                    always
                        @(posedge ahbl_hclk_i or 
                            negedge ahbl_hresetn_i)
                        begin
                            if ((ahbl_hresetn_i == 1'b0)) 
                                begin
                                    rd_burst_r <=  START_ADDR ;
                                end
                            else
                                begin
                                    rd_burst_r <=  (rd_addr_w + addr_add_w) ;
                                end
                        end
                end
            always
                @(posedge ahbl_hclk_i or 
                    negedge ahbl_hresetn_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            wr_addr_r <=  START_ADDR ;
                        end
                    else
                        begin
                            wr_addr_r <=  (ahbl_haddr_i + START_ADDR) ;
                        end
                end
            // Subordinate State Machine & Error Generator
            always
                @(posedge ahbl_hclk_i or 
                    negedge ahbl_hresetn_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            bridge_sm_r <=  SM_IDLE ;
                        end
                    else
                        begin
                            bridge_sm_r <=  bridge_sm_nxt_r ;
                        end
                end
            always
                @(posedge ahbl_hclk_i or 
                    negedge ahbl_hresetn_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            err_sm_r <=  ERR_NORMAL_MODE ;
                        end
                    else
                        begin
                            err_sm_r <=  err_sm_nxt_r ;
                        end
                end
            // HREADY signal 
            always
                @(posedge ahbl_hclk_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            ahbl_hreadyout_r <=  1'b1 ;
                            ahbl_hreadyout_ext_r <=  1'b1 ;
                        end
                    else
                        begin
                            ahbl_hreadyout_r <=  ahbl_hreadyout_nxt_r ;
                            ahbl_hreadyout_ext_r <=  ahbl_hreadyout_nxt_r ;
                        end
                end
            // HRESP signal 
            always
                @(posedge ahbl_hclk_i or 
                    negedge ahbl_hresetn_i)
                begin
                    if ((ahbl_hresetn_i == 1'b0)) 
                        begin
                            ahbl_hresp_r <=  1'b0 ;
                        end
                    else
                        begin
                            ahbl_hresp_r <=  ahbl_hresp_nxt_r ;
                        end
                end
        end
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



`timescale 1ns/1ps
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
module sysmem_ipgen_lscc_axi4mem_subordinate #(parameter DATA_WIDTH = 32, 
        parameter ADDR_WIDTH = 32, 
        parameter ID_WIDTH = 4, 
        parameter MEMORY_TYPE = "EBR", 
        parameter ACCESS_TYPE = "R/W", 
        parameter BYTE_WIDTH = (DATA_WIDTH / 8), 
        parameter REG_MODE = "noreg", 
        parameter START_ADDR = 0, 
        parameter END_ADDR = 4096) (
    // -----------------------------------------------------------------------------
    // Parameters
    // -----------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    //Clock and Reset
    input aclk_i, 
    input aresetn_i, 
    //Write Address Channel (AW)
    input [(ID_WIDTH - 1):0] axi_awid_i, 
    input [31:0] axi_awaddr_i, 
    input [7:0] axi_awlen_i, 
    input [2:0] axi_awsize_i, 
    input [1:0] axi_awburst_i, 
    input axi_awlock_i, 
    input [3:0] axi_awcache_i, 
    input [2:0] axi_awprot_i, 
    input axi_awvalid_i, 
    output axi_awready_o, 
    //Write Data Channel (W)
    input [(DATA_WIDTH - 1):0] axi_wdata_i, 
    input [(BYTE_WIDTH - 1):0] axi_wstrb_i, 
    input axi_wlast_i, 
    input axi_wvalid_i, 
    output axi_wready_o, 
    //Write Response Channel (B)
    output [(ID_WIDTH - 1):0] axi_bid_o, 
    output [1:0] axi_bresp_o, 
    output axi_bvalid_o, 
    input axi_bready_i, 
    //Read Address Channel (AR)
    input [(ID_WIDTH - 1):0] axi_arid_i, 
    input [31:0] axi_araddr_i, 
    input [7:0] axi_arlen_i, 
    input [2:0] axi_arsize_i, 
    input [1:0] axi_arburst_i, 
    input axi_arlock_i, 
    input [3:0] axi_arcache_i, 
    input [2:0] axi_arprot_i, 
    input axi_arvalid_i, 
    output axi_arready_o, 
    //Read Data Channel (R)
    output [(ID_WIDTH - 1):0] axi_rid_o, 
    output [(DATA_WIDTH - 1):0] axi_rdata_o, 
    output [1:0] axi_rresp_o, 
    output axi_rlast_o, 
    output axi_rvalid_o, 
    input axi_rready_i, 
    // Arbiter
    input arb_awready_i, 
    input arb_wready_i, 
    input arb_arready_i, 
    output arb_awpipe_en, 
    output arb_arpipe_en, 
    // Memory Interface           
    input [(DATA_WIDTH - 1):0] mem_rdata_i, 
    input mem_error_i, 
    output mem_wr_en_o, 
    output [(ADDR_WIDTH - 1):0] mem_waddr_o, 
    output [(DATA_WIDTH - 1):0] mem_wdata_o, 
    output [(BYTE_WIDTH - 1):0] mem_byte_en_o, 
    output mem_rd_en_o, 
    output [(ADDR_WIDTH - 1):0] mem_raddr_o) ;
    // ------------------------------------------------------------------------------
    // Local Parameters
    // ------------------------------------------------------------------------------
    localparam ADDR_INCR_SIZE_WIDTH = clog2((DATA_WIDTH / 8)) ; 
    // AWBURST
    localparam [1:0] FIXED = 2'b00 ; 
    localparam [1:0] INCR = 2'b01 ; 
    localparam [1:0] WRAP = 2'b10 ; 
    localparam [1:0] RSRV = 2'b11 ; 
    // ------------------------------------------------------------------------------
    // Register Declarations
    // ------------------------------------------------------------------------------
    reg axi_awready_r ; 
    reg [(ID_WIDTH - 1):0] awid_in_r ; 
    reg [31:0] awaddr_in_r ; 
    reg [2:0] awsize_in_r ; 
    reg [1:0] awburst_in_r ; 
    reg [31:0] awaddr_pipe_r ; 
    reg [2:0] awsize_pipe_r ; 
    reg [1:0] awburst_pipe_r ; 
    reg [1:0] awpipeline_depth_r ; 
    reg axi_wready_r ; 
    reg delayed_write_r ; 
    reg delayed_wlast_r ; 
    reg [1:0] wlast_pipecnt_r ; 
    reg [(ID_WIDTH - 1):0] axi_bid_r ; 
    (* syn_preserve=1 *) reg [1:0] axi_bresp_r ; 
    reg axi_slverr_r ; 
    reg axi_bvalid_r ; 
    reg axi_arready_r ; 
    reg axi_rready_dly_r ; 
    reg [(ID_WIDTH - 1):0] arid_pipe_r ; 
    reg [31:0] araddr_pipe_r ; 
    reg [7:0] arlen_pipe_r ; 
    reg [2:0] arsize_pipe_r ; 
    reg [1:0] arburst_pipe_r ; 
    reg [1:0] arpipeline_depth_r ; 
    reg [(ID_WIDTH - 1):0] axi_rid_r ; 
    reg [(DATA_WIDTH - 1):0] axi_rdata_r ; 
    reg [(DATA_WIDTH - 1):0] axi_rdata_rready_r ; 
    reg [(DATA_WIDTH - 1):0] axi_rdata_c ; 
    (* syn_preserve=1 *) reg [1:0] axi_rresp_r ; 
    reg axi_rvalid_r ; 
    reg mem_rdata_valid_r ; 
    wire mem_rdata_valid_w ; 
    reg axi_rlast_r ; 
    reg mem_wr_en_r ; 
    reg [31:0] mem_waddr_r ; 
    reg [2:0] mem_wsize_r ; 
    reg [2:0] wincr_size_r ; 
    reg wlast_r ; 
    reg [(DATA_WIDTH - 1):0] mem_wdata_r ; 
    reg [(BYTE_WIDTH - 1):0] mem_byte_en_r ; 
    reg mem_rd_en_r ; 
    reg [8:0] mem_rd_cnt_r ; 
    reg [8:0] mem_rd_cnt_c ; 
    wire mem_rlast_w ; 
    reg mem_rlast_r ; 
    reg [7:0] mem_arlen_r ; 
    reg [7:0] mem_arsize_r ; 
    reg [1:0] mem_arburst_r ; 
    reg [(ID_WIDTH - 1):0] mem_arid_r ; 
    reg [31:0] mem_araddr_wrap_lower_r ; 
    reg [31:0] mem_raddr_r ; 
    reg [(BYTE_WIDTH - 1):0] araddr_narrow_strb ; 
    reg [(BYTE_WIDTH - 1):0] araddr_narrow_strb_r ; 
    reg [(BYTE_WIDTH - 1):0] arradr_narrow_to_add ; 
    reg arradr_unalign_chk ; 
    reg [31:0] araddr_wrap_lower ; 
    reg [31:0] araddr_wrap_lower_pipe_r ; 
    reg araddr_wrap_len_chk ; 
    reg araddr_wrap_chk ; 
    integer i ; 
    // ------------------------------------------------------------------------------
    // AWREADY, Pipeline Depth = 2
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            axi_awready_r <=  1'b0 ;
        else
            if ((~arb_awready_i)) 
                axi_awready_r <=  1'b0 ;
            else
                if ((((|awpipeline_depth_r) && axi_awvalid_i) && axi_awready_r)) 
                    axi_awready_r <=  1'b0 ;
                else
                    if ((((|awpipeline_depth_r) && axi_bvalid_r) && axi_bready_i)) 
                        axi_awready_r <=  1'b1 ;
                    else
                        if ((awpipeline_depth_r < 2'd2)) 
                            axi_awready_r <=  1'b1 ;
                        else
                            axi_awready_r <=  1'b0 ;
    // ------------------------------------------------------------------------------
    // AW Pipeline Depth
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            awpipeline_depth_r <=  2'd0 ;
        else
            if ((((((|awpipeline_depth_r) && axi_awvalid_i) && axi_awready_r) && axi_bvalid_r) && axi_bready_i)) 
                awpipeline_depth_r <=  awpipeline_depth_r ;
            else
                if ((((awpipeline_depth_r < 2'd2) && axi_awvalid_i) && axi_awready_r)) 
                    awpipeline_depth_r <=  (awpipeline_depth_r + 2'd1) ;
                else
                    if ((((|awpipeline_depth_r) && axi_bvalid_r) && axi_bready_i)) 
                        awpipeline_depth_r <=  (awpipeline_depth_r - 2'd1) ;
    // ------------------------------------------------------------------------------
    // AWADDR, AWSIZE, AWBURST Valid Data
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            begin
                awaddr_in_r <=  32'd0 ;
                awsize_in_r <=  3'd0 ;
                awburst_in_r <=  2'd0 ;
            end
        else
            if (((((awpipeline_depth_r == 2'd1) && axi_awvalid_i) && axi_awready_r) && axi_bvalid_r)) 
                begin
                    awaddr_in_r <=  axi_awaddr_i ;
                    awsize_in_r <=  axi_awsize_i ;
                    awburst_in_r <=  axi_awburst_i ;
                end
            else
                if (((awpipeline_depth_r == 2'd2) && axi_bvalid_r)) 
                    begin
                        awaddr_in_r <=  awaddr_pipe_r ;
                        awsize_in_r <=  awsize_pipe_r ;
                        awburst_in_r <=  awburst_pipe_r ;
                    end
                else
                    if ((axi_awvalid_i && axi_awready_r)) 
                        begin
                            awaddr_in_r <=  axi_awaddr_i ;
                            awsize_in_r <=  axi_awsize_i ;
                            awburst_in_r <=  axi_awburst_i ;
                        end
    // ------------------------------------------------------------------------------
    // AWADDR, AWSIZE, AWBURST Pipeline Data
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            begin
                awaddr_pipe_r <=  32'd0 ;
                awsize_pipe_r <=  3'd0 ;
                awburst_pipe_r <=  2'd0 ;
            end
        else
            if ((((awpipeline_depth_r == 2'd1) && axi_awvalid_i) && axi_awready_r)) 
                begin
                    awaddr_pipe_r <=  axi_awaddr_i ;
                    awsize_pipe_r <=  axi_awsize_i ;
                    awburst_pipe_r <=  axi_awburst_i ;
                end
    // ------------------------------------------------------------------------------
    // WREADY, Delayed Write Address consideration
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            axi_wready_r <=  1'b0 ;
        else
            if ((~arb_wready_i)) 
                axi_wready_r <=  1'b0 ;
            else
                if (delayed_write_r) 
                    axi_wready_r <=  1'b0 ;
                else
                    if (((((~|awpipeline_depth_r) && axi_wready_r) && axi_wvalid_i) && (~(axi_awvalid_i && axi_awready_r)))) 
                        axi_wready_r <=  1'b0 ;
                    else
                        if (((((awpipeline_depth_r == 2'd1) && axi_wready_r) && axi_wvalid_i) && delayed_wlast_r)) 
                            axi_wready_r <=  1'b0 ;
                        else
                            if (((((((awpipeline_depth_r == 2'd1) && axi_wready_r) && axi_wvalid_i) && axi_wlast_i) && wlast_r) && (~(axi_awvalid_i && axi_awready_r)))) 
                                axi_wready_r <=  1'b0 ;
                            else
                                if (((wlast_pipecnt_r >= 2'd2) && axi_wvalid_i)) 
                                    axi_wready_r <=  1'b0 ;
                                else
                                    axi_wready_r <=  1'b1 ;
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            delayed_write_r <=  1'b0 ;
        else
            if (((axi_awvalid_i && axi_awready_r) && delayed_write_r)) 
                delayed_write_r <=  1'b0 ;
            else
                if (((((~|awpipeline_depth_r) && axi_wready_r) && axi_wvalid_i) && (~(axi_awvalid_i && axi_awready_r)))) 
                    delayed_write_r <=  1'b1 ;
                else
                    if ((((((awpipeline_depth_r == 2'd1) && axi_wready_r) && axi_wvalid_i) && wlast_r) && (~(axi_awvalid_i && axi_awready_r)))) 
                        delayed_write_r <=  1'b1 ;
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            delayed_wlast_r <=  1'b0 ;
        else
            if (((delayed_wlast_r && (|awpipeline_depth_r)) && (~delayed_write_r))) 
                delayed_wlast_r <=  1'b0 ;
            else
                if ((((((~|awpipeline_depth_r) && axi_wready_r) && axi_wvalid_i) && (~(axi_awvalid_i && axi_awready_r))) && axi_wlast_i)) 
                    delayed_wlast_r <=  1'b1 ;
                else
                    if (((((((awpipeline_depth_r == 2'd1) && axi_wready_r) && axi_wvalid_i) && wlast_r) && (~(axi_awvalid_i && axi_awready_r))) && axi_wlast_i)) 
                        delayed_wlast_r <=  1'b1 ;
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            wlast_pipecnt_r <=  2'd0 ;
        else
            if (((((((|wlast_pipecnt_r) && axi_wvalid_i) && axi_wready_r) && axi_wlast_i) && axi_bvalid_r) && axi_bready_i)) 
                wlast_pipecnt_r <=  wlast_pipecnt_r ;
            else
                if (((((wlast_pipecnt_r < 2'd2) && axi_wvalid_i) && axi_wready_r) && axi_wlast_i)) 
                    wlast_pipecnt_r <=  (wlast_pipecnt_r + 2'd1) ;
                else
                    if ((((|wlast_pipecnt_r) && axi_bvalid_r) && axi_bready_i)) 
                        wlast_pipecnt_r <=  (wlast_pipecnt_r - 2'd1) ;
    // ------------------------------------------------------------------------------
    // WLAST usage
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            wlast_r <=  1'b0 ;
        else
            if ((axi_wvalid_i && axi_wready_r)) 
                wlast_r <=  axi_wlast_i ;
            else
                wlast_r <=  1'b0 ;
    // ------------------------------------------------------------------------------
    // BVALID
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            axi_bvalid_r <=  1'b0 ;
        else
            if ((((~delayed_write_r) && delayed_wlast_r) && (|awpipeline_depth_r))) 
                axi_bvalid_r <=  1'b1 ;
            else
                if (((~delayed_write_r) && wlast_r)) 
                    axi_bvalid_r <=  1'b1 ;
                else
                    if (axi_bready_i) 
                        axi_bvalid_r <=  1'b0 ;
    // ------------------------------------------------------------------------------
    // AWID to BID
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            awid_in_r <=  {ID_WIDTH{1'b0}} ;
        else
            if ((((awpipeline_depth_r == 2'd1) && axi_awvalid_i) && axi_awready_r)) 
                awid_in_r <=  axi_awid_i ;
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            axi_bid_r <=  {ID_WIDTH{1'b0}} ;
        else
            if ((((awpipeline_depth_r == 2'd0) && axi_awvalid_i) && axi_awready_r)) 
                axi_bid_r <=  axi_awid_i ;
            else
                if (((awpipeline_depth_r == 2'd1) && axi_bvalid_r)) 
                    axi_bid_r <=  axi_awid_i ;
                else
                    if (((awpipeline_depth_r == 2'd2) && axi_bvalid_r)) 
                        axi_bid_r <=  awid_in_r ;
    // ------------------------------------------------------------------------------
    // BRESP
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            axi_bresp_r <=  2'b00 ;
        else
            if (((awburst_in_r == WRAP) || (awburst_in_r == RSRV))) 
                // Burst is not FIXED or INCR
                axi_bresp_r <=  2'b10 ;
            else
                if ((wlast_r || delayed_wlast_r)) 
                    begin
                        if (axi_slverr_r) 
                            axi_bresp_r <=  2'b10 ;
                        else
                            if (((MEMORY_TYPE == "Distributed_RAM") && (~((~|axi_wstrb_i) || (&axi_wstrb_i))))) 
                                // DistributedRAM only support Full Data strobes
                                axi_bresp_r <=  2'b10 ;
                            else
                                axi_bresp_r <=  2'b00 ;
                    end
                else
                    if (axi_bready_i) 
                        axi_bresp_r <=  2'b00 ;
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            axi_slverr_r <=  1'b0 ;
        else
            if ((ACCESS_TYPE == "R/O")) 
                // Write on R/O Port
                axi_slverr_r <=  1'b1 ;
            else
                if ((mem_wr_en_r && (mem_waddr_r >= END_ADDR))) 
                    // Exceeded End Address from User
                    axi_slverr_r <=  1'b1 ;
                else
                    if (((MEMORY_TYPE == "Distributed_RAM") && (~((~|axi_wstrb_i) || (&axi_wstrb_i))))) 
                        // DistributedRAM only support Full Data strobes
                        axi_slverr_r <=  1'b1 ;
                    else
                        if ((axi_bready_i && axi_bvalid_r)) 
                            axi_slverr_r <=  1'b0 ;
    // ------------------------------------------------------------------------------
    // Memory Write Enable
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            mem_wr_en_r <=  1'b0 ;
        else
            if ((ACCESS_TYPE == "R/O")) 
                mem_wr_en_r <=  1'b0 ;
            else
                if ((((((awpipeline_depth_r == 2'd0) && axi_awvalid_i) && axi_awready_r) && axi_wvalid_i) && axi_wready_r)) 
                    mem_wr_en_r <=  1'b1 ;
                else
                    if (((((awpipeline_depth_r == 2'd0) && axi_awvalid_i) && axi_awready_r) && delayed_write_r)) 
                        mem_wr_en_r <=  1'b1 ;
                    else
                        if ((((((awpipeline_depth_r == 2'd1) && axi_wvalid_i) && axi_wready_r) && wlast_r) && (~(axi_awvalid_i && axi_awready_r)))) 
                            mem_wr_en_r <=  1'b0 ;
                        else
                            if ((((|awpipeline_depth_r) && axi_wvalid_i) && axi_wready_r)) 
                                mem_wr_en_r <=  1'b1 ;
                            else
                                mem_wr_en_r <=  1'b0 ;
    // ------------------------------------------------------------------------------
    // Memory Write Address
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            mem_waddr_r <=  {32{1'b0}} ;
        else
            if ((((awpipeline_depth_r == 2'd0) && axi_awvalid_i) && axi_awready_r)) 
                mem_waddr_r <=  (axi_awaddr_i + START_ADDR) ;
            else
                if (((((awpipeline_depth_r == 2'd1) && axi_bvalid_r) && axi_awvalid_i) && axi_awready_r)) 
                    mem_waddr_r <=  (axi_awaddr_i + START_ADDR) ;
                else
                    if ((((|awpipeline_depth_r) && axi_bvalid_r) && wlast_r)) 
                        mem_waddr_r <=  (axi_awaddr_i + START_ADDR) ;
                    else
                        if (((((|awpipeline_depth_r) && axi_awvalid_i) && axi_awready_r) && (wlast_r || ((~delayed_write_r) && delayed_wlast_r)))) 
                            mem_waddr_r <=  (axi_awaddr_i + START_ADDR) ;
                        else
                            if (((|awpipeline_depth_r) && wlast_r)) 
                                mem_waddr_r <=  (awaddr_in_r + START_ADDR) ;
                            else
                                if ((awburst_in_r == FIXED)) 
                                    mem_waddr_r <=  mem_waddr_r ;
                                else
                                    if (mem_wr_en_r) 
                                        mem_waddr_r <=  (mem_waddr_r + wincr_size_r) ;
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            mem_wsize_r <=  3'd0 ;
        else
            if ((((awpipeline_depth_r == 2'd0) && axi_awvalid_i) && axi_awready_r)) 
                mem_wsize_r <=  axi_awsize_i ;
            else
                if (((((awpipeline_depth_r == 2'd1) && axi_bvalid_r) && axi_awvalid_i) && axi_awready_r)) 
                    mem_wsize_r <=  axi_awsize_i ;
                else
                    if (((awpipeline_depth_r == 2'd1) && (wlast_r || ((~delayed_write_r) && delayed_wlast_r)))) 
                        mem_wsize_r <=  axi_awsize_i ;
                    else
                        if (((awpipeline_depth_r == 2'd2) && wlast_r)) 
                            mem_wsize_r <=  awsize_in_r ;
    generate
        if ((DATA_WIDTH == 8)) 
            begin : genblk1
                always
                    @(*)
                    case (mem_wsize_r)
                    3'd0 : 
                        wincr_size_r = 3'd1 ;
                    default : 
                        wincr_size_r = 3'd1 ;
                    endcase 
            end
        else
            if ((DATA_WIDTH == 16)) 
                begin : genblk1
                    always
                        @(*)
                        case (mem_wsize_r)
                        3'd0 : 
                            wincr_size_r = 3'd1 ;
                        3'd1 : 
                            wincr_size_r = (3'd2 - mem_waddr_r[0]) ;
                        default : 
                            wincr_size_r = 3'd1 ;
                        endcase 
                end
            else
                begin : genblk1
                    // (DATA_WIDTH == 32)
                    always
                        @(*)
                        case (mem_wsize_r)
                        3'd0 : 
                            wincr_size_r = 3'd1 ;
                        3'd1 : 
                            wincr_size_r = (3'd2 - mem_waddr_r[0]) ;
                        3'd2 : 
                            wincr_size_r = (3'd4 - mem_waddr_r[1:0]) ;
                        default : 
                            wincr_size_r = 3'd1 ;
                        endcase 
                end
    endgenerate
    // ------------------------------------------------------------------------------
    // Memory Write Data
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            mem_wdata_r <=  {DATA_WIDTH{1'b0}} ;
        else
            if ((axi_wvalid_i && axi_wready_r)) 
                mem_wdata_r <=  axi_wdata_i ;
    // ------------------------------------------------------------------------------
    // Memory Write Byte Enable
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            mem_byte_en_r <=  {BYTE_WIDTH{1'b0}} ;
        else
            if ((axi_wvalid_i && axi_wready_r)) 
                mem_byte_en_r <=  axi_wstrb_i ;
    // ------------------------------------------------------------------------------
    // ARREADY, Pipeline Depth = 2
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            axi_arready_r <=  1'b0 ;
        else
            if ((~arb_arready_i)) 
                axi_arready_r <=  1'b0 ;
            else
                if ((((|arpipeline_depth_r) && axi_arvalid_i) && axi_arready_r)) 
                    axi_arready_r <=  1'b0 ;
                else
                    if (((((|arpipeline_depth_r) && axi_rlast_r) && axi_rvalid_r) && axi_rready_i)) 
                        axi_arready_r <=  1'b1 ;
                    else
                        if ((arpipeline_depth_r < 2'd2)) 
                            axi_arready_r <=  1'b1 ;
                        else
                            axi_arready_r <=  1'b0 ;
    // ------------------------------------------------------------------------------
    // AR Pipeline
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            arpipeline_depth_r <=  2'd0 ;
        else
            if (((((((|arpipeline_depth_r) && axi_rvalid_r) && axi_rlast_r) && axi_rready_i) && axi_arvalid_i) && axi_arready_r)) 
                arpipeline_depth_r <=  arpipeline_depth_r ;
            else
                if ((((arpipeline_depth_r < 2'd2) && axi_arvalid_i) && axi_arready_r)) 
                    arpipeline_depth_r <=  (arpipeline_depth_r + 2'd1) ;
                else
                    if (((((|arpipeline_depth_r) && axi_rlast_r) && axi_rvalid_r) && axi_rready_i)) 
                        arpipeline_depth_r <=  (arpipeline_depth_r - 2'd1) ;
    // ------------------------------------------------------------------------------
    // ARID, ARADDR, ARLEN, ARSIZE, ARBURST Pipeline Data
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            begin
                araddr_pipe_r <=  32'd0 ;
                arlen_pipe_r <=  8'd0 ;
                arsize_pipe_r <=  3'd0 ;
                arburst_pipe_r <=  2'd0 ;
                arid_pipe_r <=  {ID_WIDTH{1'b0}} ;
                araddr_wrap_lower_pipe_r <=  32'd0 ;
            end
        else
            if ((((arpipeline_depth_r >= 2'd1) && axi_arvalid_i) && axi_arready_r)) 
                begin
                    araddr_pipe_r <=  axi_araddr_i ;
                    arlen_pipe_r <=  axi_arlen_i ;
                    arsize_pipe_r <=  axi_arsize_i ;
                    arburst_pipe_r <=  axi_arburst_i ;
                    arid_pipe_r <=  axi_arid_i ;
                    araddr_wrap_lower_pipe_r <=  araddr_wrap_lower ;
                end
    // ------------------------------------------------------------------------------
    // Memory Read Enable and Counter
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            mem_rd_en_r <=  1'b0 ;
        else
            if ((((~|arpipeline_depth_r) && axi_arvalid_i) && axi_arready_r)) 
                mem_rd_en_r <=  1'b1 ;
            else
                if (((|arpipeline_depth_r) & (~axi_rlast_r))) 
                    mem_rd_en_r <=  1'b1 ;
                else
                    if ((~|arpipeline_depth_r)) 
                        mem_rd_en_r <=  1'b0 ;
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            mem_rd_cnt_r <=  8'd0 ;
        else
            if (((((arpipeline_depth_r == 2'd1) && axi_rvalid_r) && axi_rlast_r) && axi_rready_i)) 
                mem_rd_cnt_r <=  8'd0 ;
            else
                if ((((arpipeline_depth_r >= 2'd2) && mem_rlast_r) && axi_rready_i)) 
                    mem_rd_cnt_r <=  8'd0 ;
                else
                    if ((mem_rlast_r && axi_rready_i)) 
                        mem_rd_cnt_r <=  8'd0 ;
                    else
                        if ((mem_rdata_valid_w && axi_rready_i)) 
                            mem_rd_cnt_r <=  mem_rd_cnt_c ;
    always
        @(*)
        begin
            if (((mem_rdata_valid_w && (~mem_rlast_r)) && axi_rready_i)) 
                mem_rd_cnt_c = (mem_rd_cnt_r + 8'd1) ;
            else
                mem_rd_cnt_c = mem_rd_cnt_r ;
        end
    assign mem_rlast_w = (mem_rd_cnt_c >= mem_arlen_r) ; 
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            mem_rlast_r <=  1'b0 ;
        else
            if (((((((arpipeline_depth_r >= 2'd2) && mem_rlast_r) && mem_rlast_w) && (|arlen_pipe_r)) && axi_rvalid_r) && axi_rready_i)) 
                mem_rlast_r <=  1'b0 ;
            else
                if (((((((arpipeline_depth_r >= 2'd2) && mem_rlast_r) && mem_rlast_w) && (~|mem_arlen_r)) && axi_rvalid_r) && axi_rready_i)) 
                    mem_rlast_r <=  1'b0 ;
                else
                    if ((((((arpipeline_depth_r == 2'd1) && mem_rlast_r) && axi_rvalid_r) && axi_rlast_r) && axi_rready_i)) 
                        mem_rlast_r <=  1'b0 ;
                    else
                        if ((mem_rdata_valid_w && mem_rlast_w)) 
                            mem_rlast_r <=  1'b1 ;
                        else
                            mem_rlast_r <=  1'b0 ;
    // ------------------------------------------------------------------------------
    // Memory Length, Burst, Size
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            begin
                mem_arlen_r <=  {8{1'b0}} ;
                mem_arburst_r <=  {2{1'b0}} ;
                mem_arsize_r <=  {8{1'b0}} ;
                mem_arid_r <=  {ID_WIDTH{1'b0}} ;
                mem_araddr_wrap_lower_r <=  32'd0 ;
            end
        else
            if ((((~|arpipeline_depth_r) && axi_arvalid_i) && axi_arready_r)) 
                begin
                    mem_arlen_r <=  axi_arlen_i ;
                    mem_arburst_r <=  axi_arburst_i ;
                    mem_arsize_r <=  axi_arsize_i ;
                    mem_arid_r <=  axi_arid_i ;
                    mem_araddr_wrap_lower_r <=  araddr_wrap_lower ;
                end
            else
                if (((((((arpipeline_depth_r >= 2'd1) && axi_rvalid_r) && axi_rlast_r) && axi_rready_i) && axi_arvalid_i) && axi_arready_r)) 
                    begin
                        mem_arlen_r <=  axi_arlen_i ;
                        mem_arburst_r <=  axi_arburst_i ;
                        mem_arsize_r <=  axi_arsize_i ;
                        mem_arid_r <=  axi_arid_i ;
                        mem_araddr_wrap_lower_r <=  araddr_wrap_lower ;
                    end
                else
                    if ((((arpipeline_depth_r >= 2'd2) && mem_rlast_w) && (~mem_rlast_r))) 
                        begin
                            mem_arlen_r <=  arlen_pipe_r ;
                            mem_arburst_r <=  arburst_pipe_r ;
                            mem_arsize_r <=  arsize_pipe_r ;
                            mem_arid_r <=  arid_pipe_r ;
                            mem_araddr_wrap_lower_r <=  araddr_wrap_lower_pipe_r ;
                        end
                    else
                        if (((((arpipeline_depth_r == 2'd1) && mem_rlast_w) && axi_arvalid_i) && axi_arready_r)) 
                            begin
                                mem_arlen_r <=  axi_arlen_i ;
                                mem_arburst_r <=  axi_arburst_i ;
                                mem_arsize_r <=  axi_arsize_i ;
                                mem_arid_r <=  axi_arid_i ;
                                mem_araddr_wrap_lower_r <=  araddr_wrap_lower ;
                            end
    // ------------------------------------------------------------------------------
    // Memory Read Address
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            mem_raddr_r <=  {32{1'b0}} ;
        else
            if ((((~|arpipeline_depth_r) && axi_arvalid_i) && axi_arready_r)) 
                mem_raddr_r <=  (axi_araddr_i + START_ADDR) ;
            else
                if (((~axi_rready_i) && mem_rdata_valid_w)) 
                    mem_raddr_r <=  mem_raddr_r ;
                else
                    if (((((((arpipeline_depth_r >= 2'd1) && axi_rvalid_r) && axi_rlast_r) && axi_rready_i) && axi_arvalid_i) && axi_arready_r)) 
                        mem_raddr_r <=  (axi_araddr_i + START_ADDR) ;
                    else
                        if ((((arpipeline_depth_r >= 2'd2) && mem_rlast_w) && (~mem_rlast_r))) 
                            mem_raddr_r <=  (araddr_pipe_r + START_ADDR) ;
                        else
                            if (((((arpipeline_depth_r == 2'd1) && mem_rlast_w) && axi_arvalid_i) && axi_arready_r)) 
                                mem_raddr_r <=  (axi_araddr_i + START_ADDR) ;
                            else
                                if ((mem_arburst_r == FIXED)) 
                                    mem_raddr_r <=  mem_raddr_r ;
                                else
                                    if ((mem_rd_en_r && (|mem_arlen_r))) 
                                        begin
                                            if (((mem_arburst_r == WRAP) && araddr_wrap_chk)) 
                                                mem_raddr_r <=  mem_araddr_wrap_lower_r ;
                                            else
                                                mem_raddr_r <=  (mem_raddr_r + arradr_narrow_to_add) ;
                                        end
    // ------------------------------------------------------------------------------
    // RLAST
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            axi_rlast_r <=  1'b0 ;
        else
            if (((((((arpipeline_depth_r == 2'd1) && axi_rvalid_r) && axi_rlast_r) && axi_rready_i) && mem_rlast_r) && (~|mem_arlen_r))) 
                axi_rlast_r <=  1'b0 ;
            else
                if (((((mem_rlast_r && mem_rdata_valid_w) && axi_rready_i) && (~axi_rready_dly_r)) && (|mem_arlen_r))) 
                    axi_rlast_r <=  1'b1 ;
                else
                    if (((((mem_rlast_w && mem_rdata_valid_w) && (~|mem_arlen_r)) && axi_rready_i) && (~axi_rlast_r))) 
                        axi_rlast_r <=  1'b1 ;
                    else
                        if (((((mem_rlast_w && mem_rlast_r) && mem_rdata_valid_w) && axi_rready_i) && axi_rready_dly_r)) 
                            axi_rlast_r <=  1'b1 ;
                        else
                            if (axi_rready_i) 
                                axi_rlast_r <=  1'b0 ;
    // ------------------------------------------------------------------------------
    // RVALID
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            axi_rvalid_r <=  1'b0 ;
        else
            if (((((arpipeline_depth_r == 2'd1) && axi_rvalid_r) && axi_rlast_r) && axi_rready_i)) 
                axi_rvalid_r <=  1'b0 ;
            else
                if ((((axi_rvalid_r && axi_rready_i) && (~|mem_arlen_r)) && axi_rlast_r)) 
                    axi_rvalid_r <=  1'b0 ;
                else
                    if (((|arpipeline_depth_r) && mem_rdata_valid_w)) 
                        axi_rvalid_r <=  1'b1 ;
                    else
                        if (axi_rready_i) 
                            axi_rvalid_r <=  1'b0 ;
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            axi_rready_dly_r <=  1'b0 ;
        else
            if ((axi_rready_dly_r && axi_rready_i)) 
                axi_rready_dly_r <=  1'b0 ;
            else
                if ((axi_rvalid_r && (~axi_rready_i))) 
                    axi_rready_dly_r <=  1'b1 ;
    // ------------------------------------------------------------------------------
    // ARID to RID
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            axi_rid_r <=  {ID_WIDTH{1'b0}} ;
        else
            if ((((arpipeline_depth_r == 2'd0) && axi_arvalid_i) && axi_arready_r)) 
                axi_rid_r <=  axi_arid_i ;
            else
                if (((((((arpipeline_depth_r == 2'd1) && axi_arvalid_i) && axi_arready_r) && axi_rvalid_r) && axi_rlast_r) && axi_rready_i)) 
                    axi_rid_r <=  axi_arid_i ;
                else
                    if (((axi_rvalid_r && axi_rlast_r) && axi_rready_i)) 
                        axi_rid_r <=  mem_arid_r ;
    // ------------------------------------------------------------------------------
    // RRESP
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            begin
                axi_rresp_r <=  2'd0 ;
            end
        else
            if ((mem_rdata_valid_w && (ACCESS_TYPE == "W/O"))) 
                axi_rresp_r <=  2'b10 ;
            else
                if ((mem_raddr_r >= END_ADDR)) 
                    axi_rresp_r <=  2'b10 ;
                else
                    if ((mem_arburst_r == RSRV)) 
                        axi_rresp_r <=  2'b10 ;
                    else
                        if (((mem_arburst_r == WRAP) && (arradr_unalign_chk || araddr_wrap_len_chk))) 
                            axi_rresp_r <=  2'b10 ;
                        else
                            if (mem_rdata_valid_w) 
                                axi_rresp_r <=  2'b00 ;
    // ------------------------------------------------------------------------------
    // RDATA (with Unaligned Read and Throttling support)
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            begin
                axi_rdata_r <=  {DATA_WIDTH{1'b0}} ;
            end
        else
            if ((ACCESS_TYPE == "W/O")) 
                axi_rdata_r <=  {DATA_WIDTH{1'b0}} ;
            else
                if (((((arpipeline_depth_r == 2'd1) && axi_rvalid_r) && axi_rlast_r) && axi_rready_i)) 
                    axi_rdata_r <=  {DATA_WIDTH{1'b0}} ;
                else
                    if (axi_rready_dly_r) 
                        axi_rdata_r <=  axi_rdata_r ;
                    else
                        if (mem_rdata_valid_w) 
                            begin
                                for (i = 0 ; (i < BYTE_WIDTH) ; i = (i + 1))
                                    begin
                                        if (araddr_narrow_strb_r[i]) 
                                            axi_rdata_r[(8 * i) +: 8] <=  mem_rdata_i[(8 * i) +: 8] ;
                                        else
                                            axi_rdata_r[(8 * i) +: 8] <=  8'h00 ;
                                    end
                            end
                        else
                            axi_rdata_r <=  {DATA_WIDTH{1'b0}} ;
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            axi_rdata_rready_r <=  {DATA_WIDTH{1'b0}} ;
        else
            if ((~|arpipeline_depth_r)) 
                axi_rdata_rready_r <=  {DATA_WIDTH{1'b0}} ;
            else
                if (((axi_rready_dly_r && axi_rvalid_r) && axi_rready_i)) 
                    axi_rdata_rready_r <=  axi_rdata_r ;
                else
                    if (axi_rready_i) 
                        begin
                            for (i = 0 ; (i < BYTE_WIDTH) ; i = (i + 1))
                                begin
                                    if (araddr_narrow_strb_r[i]) 
                                        axi_rdata_rready_r[(8 * i) +: 8] <=  mem_rdata_i[(8 * i) +: 8] ;
                                    else
                                        axi_rdata_rready_r[(8 * i) +: 8] <=  8'h00 ;
                                end
                        end
    always
        @(*)
        begin
            if (axi_rready_dly_r) 
                axi_rdata_c = axi_rdata_rready_r ;
            else
                axi_rdata_c = axi_rdata_r ;
        end
    // ------------------------------------------------------------------------------
    // Memory Read Data Output Timing
    // ------------------------------------------------------------------------------
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            mem_rdata_valid_r <=  1'b0 ;
        else
            if (((arpipeline_depth_r > 2'd1) && (~|mem_arlen_r))) 
                mem_rdata_valid_r <=  1'b0 ;
            else
                if ((arpipeline_depth_r > 2'd1)) 
                    mem_rdata_valid_r <=  1'b1 ;
                else
                    if (((mem_rdata_valid_r && mem_rlast_r) && axi_rready_i)) 
                        mem_rdata_valid_r <=  1'b0 ;
                    else
                        if (((((arpipeline_depth_r == 2'd1) && axi_rvalid_r) && axi_rlast_r) && axi_rready_i)) 
                            mem_rdata_valid_r <=  1'b0 ;
                        else
                            if (((|arpipeline_depth_r) && (~mem_rlast_r))) 
                                mem_rdata_valid_r <=  1'b1 ;
    assign mem_rdata_valid_w = mem_rdata_valid_r ; 
    // ------------------------------------------------------------------------------
    // Unaligned Read Support
    // ------------------------------------------------------------------------------
    generate
        always
            @(*)
            begin
                if ((DATA_WIDTH == 8)) 
                    begin
                        araddr_narrow_strb = 1'h1 ;
                        arradr_narrow_to_add = 1'd1 ;
                        arradr_unalign_chk = 1'b0 ;
                    end
                else
                    if ((DATA_WIDTH == 16)) 
                        begin
                            if ((mem_arsize_r == 3'd0)) 
                                begin
                                    araddr_narrow_strb = (2'h1 << mem_raddr_r[0]) ;
                                    arradr_narrow_to_add = 2'd1 ;
                                    arradr_unalign_chk = 1'b0 ;
                                end
                            else
                                if ((mem_arsize_r == 3'd1)) 
                                    begin
                                        araddr_narrow_strb = (2'h3 << mem_raddr_r[0]) ;
                                        arradr_narrow_to_add = (2'd2 - mem_raddr_r[0]) ;
                                        arradr_unalign_chk = mem_raddr_r[0] ;
                                    end
                                else
                                    begin
                                        araddr_narrow_strb = (2'h3 << mem_raddr_r[0]) ;
                                        arradr_narrow_to_add = (2'd2 - mem_raddr_r[0]) ;
                                        arradr_unalign_chk = (|mem_raddr_r[0]) ;
                                    end
                        end
                    else
                        begin
                            // DATA_WIDTH == 32
                            if ((mem_arsize_r == 3'd0)) 
                                begin
                                    araddr_narrow_strb = (4'h1 << mem_raddr_r[1:0]) ;
                                    arradr_narrow_to_add = 4'd1 ;
                                    arradr_unalign_chk = 1'b0 ;
                                end
                            else
                                if ((mem_arsize_r == 3'd1)) 
                                    begin
                                        araddr_narrow_strb = (4'h3 << mem_raddr_r[1:0]) ;
                                        arradr_narrow_to_add = (4'd2 - mem_raddr_r[0]) ;
                                        arradr_unalign_chk = mem_raddr_r[0] ;
                                    end
                                else
                                    if ((mem_arsize_r == 3'd2)) 
                                        begin
                                            araddr_narrow_strb = (4'hF << mem_raddr_r[1:0]) ;
                                            arradr_narrow_to_add = (4'd4 - mem_raddr_r[1:0]) ;
                                            arradr_unalign_chk = (|mem_raddr_r[1:0]) ;
                                        end
                                    else
                                        begin
                                            araddr_narrow_strb = (4'hF << mem_raddr_r[1:0]) ;
                                            arradr_narrow_to_add = (4'd4 - mem_raddr_r[1:0]) ;
                                            arradr_unalign_chk = (|mem_raddr_r[1:0]) ;
                                        end
                        end
            end
    endgenerate
    always
        @(posedge aclk_i or 
            negedge aresetn_i)
        if ((~aresetn_i)) 
            araddr_narrow_strb_r <=  1'b0 ;
        else
            if (mem_rd_en_r) 
                araddr_narrow_strb_r <=  araddr_narrow_strb ;
    // ------------------------------------------------------------------------------
    // WRAP Read Support
    // ------------------------------------------------------------------------------
    generate
        always
            @(*)
            begin
                if ((DATA_WIDTH == 8)) 
                    begin
                        araddr_wrap_lower = 32'd0 ;
                        case (axi_arlen_i)
                        8'd1 : 
                            araddr_wrap_lower = {axi_araddr_i[31:1],
                                    1'd0} ;
                        8'd3 : 
                            araddr_wrap_lower = {axi_araddr_i[31:2],
                                    2'd0} ;
                        8'd7 : 
                            araddr_wrap_lower = {axi_araddr_i[31:3],
                                    3'd0} ;
                        8'd15 : 
                            araddr_wrap_lower = {axi_araddr_i[31:4],
                                    4'd0} ;
                        default : 
                            araddr_wrap_lower = axi_araddr_i ;
                        endcase 
                    end
                else
                    if ((DATA_WIDTH == 16)) 
                        begin
                            araddr_wrap_lower = 32'd0 ;
                            if ((axi_arsize_i == 3'd0)) 
                                begin
                                    case (axi_arlen_i)
                                    8'd1 : 
                                        araddr_wrap_lower = {axi_araddr_i[31:1],
                                                1'd0} ;
                                    8'd3 : 
                                        araddr_wrap_lower = {axi_araddr_i[31:2],
                                                2'd0} ;
                                    8'd7 : 
                                        araddr_wrap_lower = {axi_araddr_i[31:3],
                                                3'd0} ;
                                    8'd15 : 
                                        araddr_wrap_lower = {axi_araddr_i[31:4],
                                                4'd0} ;
                                    default : 
                                        araddr_wrap_lower = axi_araddr_i ;
                                    endcase 
                                end
                            else
                                if ((axi_arsize_i == 3'd1)) 
                                    begin
                                        case (axi_arlen_i)
                                        8'd1 : 
                                            araddr_wrap_lower = {axi_araddr_i[31:2],
                                                    2'd0} ;
                                        8'd3 : 
                                            araddr_wrap_lower = {axi_araddr_i[31:3],
                                                    3'd0} ;
                                        8'd7 : 
                                            araddr_wrap_lower = {axi_araddr_i[31:4],
                                                    4'd0} ;
                                        8'd15 : 
                                            araddr_wrap_lower = {axi_araddr_i[31:5],
                                                    5'd0} ;
                                        default : 
                                            araddr_wrap_lower = axi_araddr_i ;
                                        endcase 
                                    end
                                else
                                    araddr_wrap_lower = axi_araddr_i ;
                        end
                    else
                        begin
                            // DATA_WIDTH == 32
                            araddr_wrap_lower = 32'd0 ;
                            if ((axi_arsize_i == 3'd0)) 
                                begin
                                    case (axi_arlen_i)
                                    8'd1 : 
                                        araddr_wrap_lower = {axi_araddr_i[31:1],
                                                1'd0} ;
                                    8'd3 : 
                                        araddr_wrap_lower = {axi_araddr_i[31:2],
                                                2'd0} ;
                                    8'd7 : 
                                        araddr_wrap_lower = {axi_araddr_i[31:3],
                                                3'd0} ;
                                    8'd15 : 
                                        araddr_wrap_lower = {axi_araddr_i[31:4],
                                                4'd0} ;
                                    default : 
                                        araddr_wrap_lower = axi_araddr_i ;
                                    endcase 
                                end
                            else
                                if ((axi_arsize_i == 3'd1)) 
                                    begin
                                        case (axi_arlen_i)
                                        8'd1 : 
                                            araddr_wrap_lower = {axi_araddr_i[31:2],
                                                    2'd0} ;
                                        8'd3 : 
                                            araddr_wrap_lower = {axi_araddr_i[31:3],
                                                    3'd0} ;
                                        8'd7 : 
                                            araddr_wrap_lower = {axi_araddr_i[31:4],
                                                    4'd0} ;
                                        8'd15 : 
                                            araddr_wrap_lower = {axi_araddr_i[31:5],
                                                    5'd0} ;
                                        default : 
                                            araddr_wrap_lower = axi_araddr_i ;
                                        endcase 
                                    end
                                else
                                    if ((axi_arsize_i == 3'd2)) 
                                        begin
                                            case (axi_arlen_i)
                                            8'd1 : 
                                                araddr_wrap_lower = {axi_araddr_i[31:3],
                                                        3'd0} ;
                                            8'd3 : 
                                                araddr_wrap_lower = {axi_araddr_i[31:4],
                                                        4'd0} ;
                                            8'd7 : 
                                                araddr_wrap_lower = {axi_araddr_i[31:5],
                                                        5'd0} ;
                                            8'd15 : 
                                                araddr_wrap_lower = {axi_araddr_i[31:6],
                                                        6'd0} ;
                                            default : 
                                                araddr_wrap_lower = axi_araddr_i ;
                                            endcase 
                                        end
                                    else
                                        araddr_wrap_lower = axi_araddr_i ;
                        end
            end
    endgenerate
    generate
        always
            @(*)
            begin
                if ((DATA_WIDTH == 8)) 
                    begin
                        araddr_wrap_len_chk = 1'b0 ;
                        case (mem_arlen_r)
                        8'd1 : 
                            araddr_wrap_len_chk = 1'b0 ;
                        8'd3 : 
                            araddr_wrap_len_chk = 1'b0 ;
                        8'd7 : 
                            araddr_wrap_len_chk = 1'b0 ;
                        8'd15 : 
                            araddr_wrap_len_chk = 1'b0 ;
                        default : 
                            araddr_wrap_len_chk = 1'b1 ;
                        endcase 
                    end
                else
                    if ((DATA_WIDTH == 16)) 
                        begin
                            araddr_wrap_len_chk = 1'b0 ;
                            if ((mem_arsize_r == 3'd0)) 
                                begin
                                    case (mem_arlen_r)
                                    8'd1 : 
                                        araddr_wrap_len_chk = 1'b0 ;
                                    8'd3 : 
                                        araddr_wrap_len_chk = 1'b0 ;
                                    8'd7 : 
                                        araddr_wrap_len_chk = 1'b0 ;
                                    8'd15 : 
                                        araddr_wrap_len_chk = 1'b0 ;
                                    default : 
                                        araddr_wrap_len_chk = 1'b1 ;
                                    endcase 
                                end
                            else
                                if ((mem_arsize_r == 3'd1)) 
                                    begin
                                        case (mem_arlen_r)
                                        8'd1 : 
                                            araddr_wrap_len_chk = 1'b0 ;
                                        8'd3 : 
                                            araddr_wrap_len_chk = 1'b0 ;
                                        8'd7 : 
                                            araddr_wrap_len_chk = 1'b0 ;
                                        8'd15 : 
                                            araddr_wrap_len_chk = 1'b0 ;
                                        default : 
                                            araddr_wrap_len_chk = 1'b1 ;
                                        endcase 
                                    end
                                else
                                    araddr_wrap_len_chk = 1'b1 ;
                        end
                    else
                        begin
                            // DATA_WIDTH == 32
                            araddr_wrap_len_chk = 1'b0 ;
                            if ((mem_arsize_r == 3'd0)) 
                                begin
                                    case (mem_arlen_r)
                                    8'd1 : 
                                        araddr_wrap_len_chk = 1'b0 ;
                                    8'd3 : 
                                        araddr_wrap_len_chk = 1'b0 ;
                                    8'd7 : 
                                        araddr_wrap_len_chk = 1'b0 ;
                                    8'd15 : 
                                        araddr_wrap_len_chk = 1'b0 ;
                                    default : 
                                        araddr_wrap_len_chk = 1'b1 ;
                                    endcase 
                                end
                            else
                                if ((mem_arsize_r == 3'd1)) 
                                    begin
                                        case (mem_arlen_r)
                                        8'd1 : 
                                            araddr_wrap_len_chk = 1'b0 ;
                                        8'd3 : 
                                            araddr_wrap_len_chk = 1'b0 ;
                                        8'd7 : 
                                            araddr_wrap_len_chk = 1'b0 ;
                                        8'd15 : 
                                            araddr_wrap_len_chk = 1'b0 ;
                                        default : 
                                            araddr_wrap_len_chk = 1'b1 ;
                                        endcase 
                                    end
                                else
                                    if ((mem_arsize_r == 3'd2)) 
                                        begin
                                            case (mem_arlen_r)
                                            8'd1 : 
                                                araddr_wrap_len_chk = 1'b0 ;
                                            8'd3 : 
                                                araddr_wrap_len_chk = 1'b0 ;
                                            8'd7 : 
                                                araddr_wrap_len_chk = 1'b0 ;
                                            8'd15 : 
                                                araddr_wrap_len_chk = 1'b0 ;
                                            default : 
                                                araddr_wrap_len_chk = 1'b1 ;
                                            endcase 
                                        end
                                    else
                                        araddr_wrap_len_chk = 1'b1 ;
                        end
            end
    endgenerate
    generate
        always
            @(*)
            begin
                if ((DATA_WIDTH == 8)) 
                    begin
                        araddr_wrap_chk = 1'b0 ;
                        case (mem_arlen_r)
                        8'd1 : 
                            araddr_wrap_chk = mem_raddr_r[0] ;
                        8'd3 : 
                            araddr_wrap_chk = (&mem_raddr_r[1:0]) ;
                        8'd7 : 
                            araddr_wrap_chk = (&mem_raddr_r[2:0]) ;
                        8'd15 : 
                            araddr_wrap_chk = (&mem_raddr_r[3:0]) ;
                        default : 
                            araddr_wrap_chk = 1'b0 ;
                        endcase 
                    end
                else
                    if ((DATA_WIDTH == 16)) 
                        begin
                            araddr_wrap_chk = 1'b0 ;
                            if ((mem_arsize_r == 3'd0)) 
                                begin
                                    case (mem_arlen_r)
                                    8'd1 : 
                                        araddr_wrap_chk = mem_raddr_r[0] ;
                                    8'd3 : 
                                        araddr_wrap_chk = (&mem_raddr_r[1:0]) ;
                                    8'd7 : 
                                        araddr_wrap_chk = (&mem_raddr_r[2:0]) ;
                                    8'd15 : 
                                        araddr_wrap_chk = (&mem_raddr_r[3:0]) ;
                                    default : 
                                        araddr_wrap_chk = 1'b0 ;
                                    endcase 
                                end
                            else
                                if ((mem_arsize_r == 3'd1)) 
                                    begin
                                        case (mem_arlen_r)
                                        8'd1 : 
                                            araddr_wrap_chk = mem_raddr_r[1] ;
                                        8'd3 : 
                                            araddr_wrap_chk = (&mem_raddr_r[2:1]) ;
                                        8'd7 : 
                                            araddr_wrap_chk = (&mem_raddr_r[3:1]) ;
                                        8'd15 : 
                                            araddr_wrap_chk = (&mem_raddr_r[4:1]) ;
                                        default : 
                                            araddr_wrap_chk = 1'b0 ;
                                        endcase 
                                    end
                                else
                                    begin
                                        araddr_wrap_chk = 1'b0 ;
                                    end
                        end
                    else
                        begin
                            // DATA_WIDTH == 32
                            araddr_wrap_chk = 1'b0 ;
                            if ((mem_arsize_r == 3'd0)) 
                                begin
                                    case (mem_arlen_r)
                                    8'd1 : 
                                        araddr_wrap_chk = mem_raddr_r[0] ;
                                    8'd3 : 
                                        araddr_wrap_chk = (&mem_raddr_r[1:0]) ;
                                    8'd7 : 
                                        araddr_wrap_chk = (&mem_raddr_r[2:0]) ;
                                    8'd15 : 
                                        araddr_wrap_chk = (&mem_raddr_r[3:0]) ;
                                    default : 
                                        araddr_wrap_chk = 1'b0 ;
                                    endcase 
                                end
                            else
                                if ((mem_arsize_r == 3'd1)) 
                                    begin
                                        case (mem_arlen_r)
                                        8'd1 : 
                                            araddr_wrap_chk = mem_raddr_r[1] ;
                                        8'd3 : 
                                            araddr_wrap_chk = (&mem_raddr_r[2:1]) ;
                                        8'd7 : 
                                            araddr_wrap_chk = (&mem_raddr_r[3:1]) ;
                                        8'd15 : 
                                            araddr_wrap_chk = (&mem_raddr_r[4:1]) ;
                                        default : 
                                            araddr_wrap_chk = 1'b0 ;
                                        endcase 
                                    end
                                else
                                    if ((mem_arsize_r == 3'd2)) 
                                        begin
                                            case (mem_arlen_r)
                                            8'd1 : 
                                                araddr_wrap_chk = (&mem_raddr_r[2]) ;
                                            8'd3 : 
                                                araddr_wrap_chk = (&mem_raddr_r[3:2]) ;
                                            8'd7 : 
                                                araddr_wrap_chk = (&mem_raddr_r[4:2]) ;
                                            8'd15 : 
                                                araddr_wrap_chk = (&mem_raddr_r[5:2]) ;
                                            default : 
                                                araddr_wrap_chk = 1'b0 ;
                                            endcase 
                                        end
                                    else
                                        begin
                                            araddr_wrap_chk = 1'b0 ;
                                        end
                        end
            end
    endgenerate
    // ------------------------------------------------------------------------------
    // Outputs
    // ------------------------------------------------------------------------------
    assign axi_awready_o = axi_awready_r ; 
    assign axi_wready_o = axi_wready_r ; 
    assign axi_bid_o = axi_bid_r ; 
    assign axi_bresp_o = axi_bresp_r ; 
    assign axi_bvalid_o = axi_bvalid_r ; 
    assign axi_arready_o = axi_arready_r ; 
    assign axi_rid_o = axi_rid_r ; 
    assign axi_rdata_o = axi_rdata_c ; 
    assign axi_rresp_o = axi_rresp_r ; 
    assign axi_rlast_o = axi_rlast_r ; 
    assign axi_rvalid_o = axi_rvalid_r ; 
    assign arb_awpipe_en = (|awpipeline_depth_r) ; 
    assign arb_arpipe_en = (|arpipeline_depth_r) ; 
    assign mem_wr_en_o = (((MEMORY_TYPE == "LRAM") && (DATA_WIDTH == 8)) ? (mem_wr_en_r && mem_byte_en_r) : mem_wr_en_r) ; 
    assign mem_waddr_o = mem_waddr_r[31:ADDR_INCR_SIZE_WIDTH] ; 
    assign mem_wdata_o = mem_wdata_r ; 
    assign mem_byte_en_o = ((MEMORY_TYPE == "LRAM") ? (~mem_byte_en_r) : mem_byte_en_r) ; 
    assign mem_rd_en_o = ((ACCESS_TYPE == "W/O") ? 1'b0 : mem_rd_en_r) ; 
    assign mem_raddr_o = mem_raddr_r[31:ADDR_INCR_SIZE_WIDTH] ; 
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



`timescale 1ns/1ps
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
module sysmem_ipgen_lscc_mem #(parameter INTERFACE = "AHBL", 
        parameter ADDR_DEPTH = 16384, 
        parameter DATA_WIDTH = 32, 
        parameter ADDR_WIDTH = clog2(ADDR_DEPTH), 
        parameter ECC_ENABLE = 0, 
        parameter MEMORY_TYPE = "EBR", 
        parameter MEM_REGMODE_A = "noreg", 
        parameter MEM_REGMODE_B = "noreg", 
        parameter RESET_MODE_S0 = "async", 
        parameter RESET_MODE_S1 = "async", 
        parameter BYTE_ENABLE_S0 = 0, 
        parameter BYTE_ENABLE_S1 = 0, 
        parameter ACCESS_TYPE_S0 = "R/W", 
        parameter ACCESS_TYPE_S1 = "R/W", 
        parameter UNALIGNED_ACCESS_ENABLE = 0, 
        parameter READ_PIPELINE_S0 = 0, 
        parameter READ_PIPELINE_S1 = 0, 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "hex", 
        parameter FAMILY = "common", 
        parameter BYTE_WIDTH = (DATA_WIDTH / 8), 
        parameter MEM_SIZE = "1024,18", 
        parameter MEM_ID = "MEM0", 
        parameter INIT_VALUE_00 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_01 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_02 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_03 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_04 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_05 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_06 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_07 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_08 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_09 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_10 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_11 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_12 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_13 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_14 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_15 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_16 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_17 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_18 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_19 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_20 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_21 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_22 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_23 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_24 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_25 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_26 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_27 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_28 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_29 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_30 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_31 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_32 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_33 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_34 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_35 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_36 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_37 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_38 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_39 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_40 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_41 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_42 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_43 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_44 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_45 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_46 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_47 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_48 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_49 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4A = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4B = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4C = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4D = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4E = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4F = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_50 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_51 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_52 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_53 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_54 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_55 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_56 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_57 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_58 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_59 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5A = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5B = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5C = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5D = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5E = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5F = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_60 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_61 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_62 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_63 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_64 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_65 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_66 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_67 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_68 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_69 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6A = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6B = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6C = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6D = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6E = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6F = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_70 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_71 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_72 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_73 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_74 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_75 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_76 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_77 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_78 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_79 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7A = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7B = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7C = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7D = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7E = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7F = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    // ------------------------
    // Port A Memory Interface
    // ------------------------
    input mem_clk_a_i, 
    input mem_rst_n_a_i, 
    input mem_request_a_i, 
    input mem_wr_rdn_a_i, 
    input [(ADDR_WIDTH - 1):0] mem_addr_a_i, 
    input [(DATA_WIDTH - 1):0] mem_wdata_a_i, 
    input [(BYTE_WIDTH - 1):0] mem_byte_en_a_i, 
    output wire [(DATA_WIDTH - 1):0] mem_rdata_a_o, 
    output wire [1:0] mem_error_a_o, 
    // ------------------------
    // Port B Memory Interface
    // ------------------------
    input mem_clk_b_i, 
    input mem_rst_n_b_i, 
    input mem_request_b_i, 
    input mem_wr_rdn_b_i, 
    input [(ADDR_WIDTH - 1):0] mem_addr_b_i, 
    input [(DATA_WIDTH - 1):0] mem_wdata_b_i, 
    input [(BYTE_WIDTH - 1):0] mem_byte_en_b_i, 
    output wire [(DATA_WIDTH - 1):0] mem_rdata_b_o, 
    output wire [1:0] mem_error_b_o) ;
    // -----------------------------------------------------------------------------
    // Local Parameters
    // -----------------------------------------------------------------------------
    localparam MEM_RESETMODE_A = RESET_MODE_S0 ; // "async" | "sync"
    localparam MEM_RESETMODE_B = RESET_MODE_S1 ; // "async" | "sync"
    localparam MEM_OPTIMIZATION = "speed" ; 
    localparam DEVICE = FAMILY ; 
    localparam PORT_TYPE = ((INTERFACE == "AXI4") ? ((MEMORY_TYPE == "Distributed_RAM") ? "pdp" : "dp") : ((ACCESS_TYPE_S0 == "R/W") ? ((ACCESS_TYPE_S1 == "DISABLED") ? "sp" : "dp") : ((ACCESS_TYPE_S0 == "W/O") ? (((ACCESS_TYPE_S1 == "R/W") || (ACCESS_TYPE_S1 == "W/O")) ? "dp" : ((ACCESS_TYPE_S1 == "R/O") ? "pdp" : "sp")) : ((ACCESS_TYPE_S0 == "R/O") ? (((ACCESS_TYPE_S1 == "R/W") || (ACCESS_TYPE_S1 == "R/O")) ? "dp" : ((ACCESS_TYPE_S1 == "W/O") ? "pdp" : "sp")) : "sp")))) ; 
    localparam PDP_REGMODE = (((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) ? MEM_REGMODE_A : MEM_REGMODE_B) ; 
    // -----------------------------------------------------------------------------
    // Wire Declarations
    // -----------------------------------------------------------------------------
    wire sp_clock ; 
    wire sp_reset ; 
    wire sp_we ; 
    wire sp_clocken ; 
    wire [(DATA_WIDTH - 1):0] sp_data ; 
    wire [(ADDR_WIDTH - 1):0] sp_address ; 
    wire [(DATA_WIDTH - 1):0] sp_q ; 
    wire [(BYTE_WIDTH - 1):0] sp_byteen ; 
    wire pdp_wr_en ; 
    wire pdp_reset ; 
    wire pdp_we ; 
    wire pdp_wrclock ; 
    wire pdp_wrclocken ; 
    wire pdp_rdclock ; 
    wire pdp_rdclocken ; 
    wire [(DATA_WIDTH - 1):0] pdp_data ; 
    wire [(ADDR_WIDTH - 1):0] pdp_wraddress ; 
    wire [(ADDR_WIDTH - 1):0] pdp_rdaddress ; 
    wire [(DATA_WIDTH - 1):0] pdp_q ; 
    wire [(BYTE_WIDTH - 1):0] pdp_byteen ; 
    wire [1:0] pdp_err_det ; 
    wire dp_reset_a ; 
    wire dp_wr_a ; 
    wire dp_clock_a ; 
    wire dp_clocken_a ; 
    wire dp_reset_b ; 
    wire dp_wr_b ; 
    wire dp_clock_b ; 
    wire dp_clocken_b ; 
    wire [(DATA_WIDTH - 1):0] dp_datain_a ; 
    wire [(ADDR_WIDTH - 1):0] dp_address_a ; 
    wire [(DATA_WIDTH - 1):0] dp_q_a ; 
    wire [(DATA_WIDTH - 1):0] dp_datain_b ; 
    wire [(ADDR_WIDTH - 1):0] dp_address_b ; 
    wire [(DATA_WIDTH - 1):0] dp_q_b ; 
    wire [(BYTE_WIDTH - 1):0] dp_byteen_a ; 
    wire [(BYTE_WIDTH - 1):0] dp_byteen_b ; 
    // -----------------------------------------------------------------------------
    // Generate Blocks
    // -----------------------------------------------------------------------------
    generate
        if ((PORT_TYPE == "sp")) 
            begin : genblk1
                // Input
                assign sp_clock = mem_clk_a_i ; 
                assign sp_reset = (~mem_rst_n_a_i) ; 
                assign sp_we = (mem_request_a_i && mem_wr_rdn_a_i) ; 
                assign sp_clocken = ((MEMORY_TYPE == "LRAM") ? 1'b1 : mem_request_a_i) ; 
                assign sp_data[(DATA_WIDTH - 1):0] = mem_wdata_a_i[(DATA_WIDTH - 1):0] ; 
                assign sp_address[(ADDR_WIDTH - 1):0] = mem_addr_a_i[(ADDR_WIDTH - 1):0] ; 
                assign sp_byteen = mem_byte_en_a_i ; 
                // Output
                assign mem_rdata_a_o[(DATA_WIDTH - 1):0] = sp_q[(DATA_WIDTH - 1):0] ; 
            end
        else
            if ((PORT_TYPE == "pdp")) 
                begin : genblk1
                    // Input
                    assign pdp_wr_en = ((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "W/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? (mem_request_a_i && mem_wr_rdn_a_i) : (mem_request_b_i && mem_wr_rdn_b_i)) ; 
                    assign pdp_reset = (~mem_rst_n_a_i) ; 
                    assign pdp_we = pdp_wr_en ; 
                    assign pdp_wrclock = ((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "W/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? mem_clk_a_i : mem_clk_b_i) ; 
                    assign pdp_wrclocken = ((MEMORY_TYPE == "LRAM") ? 1'b1 : pdp_wr_en) ; 
                    assign pdp_wraddress[(ADDR_WIDTH - 1):0] = ((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "W/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? mem_addr_a_i[(ADDR_WIDTH - 1):0] : mem_addr_b_i[(ADDR_WIDTH - 1):0]) ; 
                    assign pdp_data[(DATA_WIDTH - 1):0] = ((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "W/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? mem_wdata_a_i[(DATA_WIDTH - 1):0] : mem_wdata_b_i[(DATA_WIDTH - 1):0]) ; 
                    assign pdp_rdclock = (((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED")) || (INTERFACE == "AXI4")) ? mem_clk_a_i : mem_clk_b_i) ; 
                    assign pdp_rdclocken = ((INTERFACE == "AXI4") ? (mem_request_b_i && (~mem_wr_rdn_b_i)) : ((MEMORY_TYPE == "LRAM") ? 1'b1 : ((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? (mem_request_a_i && (~mem_wr_rdn_a_i)) : (mem_request_b_i && (~mem_wr_rdn_b_i))))) ; 
                    assign pdp_rdaddress[(ADDR_WIDTH - 1):0] = ((INTERFACE == "AXI4") ? mem_addr_b_i[(ADDR_WIDTH - 1):0] : ((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? mem_addr_a_i[(ADDR_WIDTH - 1):0] : mem_addr_b_i[(ADDR_WIDTH - 1):0])) ; 
                    assign pdp_byteen = ((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "W/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? mem_byte_en_a_i : mem_byte_en_b_i) ; 
                    // Output
                    if ((INTERFACE == "AXI4")) 
                        begin : genblk1
                            assign mem_rdata_b_o[(DATA_WIDTH - 1):0] = pdp_q[(DATA_WIDTH - 1):0] ; 
                            assign mem_rdata_a_o[(DATA_WIDTH - 1):0] = {DATA_WIDTH{1'b0}} ; 
                        end
                    else
                        if ((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED"))) 
                            begin : genblk1
                                assign mem_rdata_a_o[(DATA_WIDTH - 1):0] = pdp_q[(DATA_WIDTH - 1):0] ; 
                                assign mem_rdata_b_o[(DATA_WIDTH - 1):0] = {DATA_WIDTH{1'b0}} ; 
                            end
                        else
                            begin : genblk1
                                assign mem_rdata_b_o[(DATA_WIDTH - 1):0] = pdp_q[(DATA_WIDTH - 1):0] ; 
                                assign mem_rdata_a_o[(DATA_WIDTH - 1):0] = {DATA_WIDTH{1'b0}} ; 
                            end
                    if ((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED"))) 
                        begin : genblk2
                            assign mem_error_a_o[1:0] = pdp_err_det[1:0] ; 
                            assign mem_error_b_o[1:0] = 2'b00 ; 
                        end
                    else
                        begin : genblk2
                            assign mem_error_b_o[1:0] = pdp_err_det[1:0] ; 
                            assign mem_error_a_o[1:0] = 2'b00 ; 
                        end
                end
            else
                if ((PORT_TYPE == "dp")) 
                    begin : genblk1
                        // Input   
                        assign dp_reset_a = (~mem_rst_n_a_i) ; 
                        assign dp_wr_a = (mem_request_a_i && mem_wr_rdn_a_i) ; 
                        assign dp_clock_a = mem_clk_a_i ; 
                        assign dp_clocken_a = ((MEMORY_TYPE == "LRAM") ? 1'b1 : ((INTERFACE == "AXI4") ? 1'b1 : mem_request_a_i)) ; 
                        assign dp_address_a[(ADDR_WIDTH - 1):0] = mem_addr_a_i[(ADDR_WIDTH - 1):0] ; 
                        assign dp_datain_a[(DATA_WIDTH - 1):0] = mem_wdata_a_i[(DATA_WIDTH - 1):0] ; 
                        assign dp_reset_b = (~mem_rst_n_b_i) ; 
                        assign dp_wr_b = (mem_request_b_i && mem_wr_rdn_b_i) ; 
                        assign dp_clock_b = mem_clk_b_i ; 
                        assign dp_clocken_b = ((MEMORY_TYPE == "LRAM") ? 1'b1 : ((INTERFACE == "AXI4") ? 1'b1 : mem_request_b_i)) ; 
                        assign dp_address_b[(ADDR_WIDTH - 1):0] = mem_addr_b_i[(ADDR_WIDTH - 1):0] ; 
                        assign dp_datain_b[(DATA_WIDTH - 1):0] = mem_wdata_b_i[(DATA_WIDTH - 1):0] ; 
                        assign dp_byteen_a = mem_byte_en_a_i ; 
                        assign dp_byteen_b = mem_byte_en_b_i ; 
                        // Output
                        assign mem_rdata_a_o[(DATA_WIDTH - 1):0] = dp_q_a[(DATA_WIDTH - 1):0] ; 
                        assign mem_rdata_b_o[(DATA_WIDTH - 1):0] = dp_q_b[(DATA_WIDTH - 1):0] ; 
                    end
    endgenerate
    // -----------------------------------------------------------------------------
    // Assign Statements
    // -----------------------------------------------------------------------------
    // -----------------------------------------------------------------------------
    // Generate Submodule Instantiations
    // -----------------------------------------------------------------------------
    generate
        if ((INTERFACE == "AXI4")) 
            begin : intf_AXI4
                localparam T_BYTE_AWID = (BYTE_ENABLE_S0 ? BYTE_WIDTH : 1) ; 
                localparam T_BYTE_BWID = (BYTE_ENABLE_S1 ? BYTE_WIDTH : 1) ; 
                wire [(T_BYTE_AWID - 1):0] dpben_a_w = (BYTE_ENABLE_S0 ? dp_byteen_a : {T_BYTE_AWID{1'b1}}) ; 
                wire [(T_BYTE_BWID - 1):0] dpben_b_w = (BYTE_ENABLE_S1 ? dp_byteen_b : {T_BYTE_BWID{1'b1}}) ; 
                if ((MEMORY_TYPE == "EBR")) 
                    begin : ebr
                        lscc_ram_dp_true #(.ADDR_DEPTH_A(ADDR_DEPTH),
                                .ADDR_WIDTH_A(ADDR_WIDTH),
                                .DATA_WIDTH_A(DATA_WIDTH),
                                .ADDR_DEPTH_B(ADDR_DEPTH),
                                .ADDR_WIDTH_B(ADDR_WIDTH),
                                .DATA_WIDTH_B(DATA_WIDTH),
                                .REGMODE_A(MEM_REGMODE_A),
                                .REGMODE_B(MEM_REGMODE_B),
                                .RESETMODE_A(MEM_RESETMODE_A),
                                .RESETMODE_B(MEM_RESETMODE_B),
                                .RESET_RELEASE_A("sync"),
                                .RESET_RELEASE_B("sync"),
                                .INIT_FILE(INIT_FILE),
                                .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                                .INIT_DATA_TYPE(1),
                                .FAMILY(FAMILY),
                                .INIT_MODE(((INIT_FILE == "none") ? "none" : "mem_file")),
                                .BYTE_ENABLE_A(BYTE_ENABLE_S0),
                                .BYTE_SIZE_A(8),
                                .BYTE_ENABLE_B(BYTE_ENABLE_S1),
                                .BYTE_SIZE_B(8),
                                .ECC_ENABLE(ECC_ENABLE),
                                .MEM_SIZE(MEM_SIZE),
                                .MEM_ID(MEM_ID),
                                .INIT_VALUE_00(INIT_VALUE_00),
                                .INIT_VALUE_01(INIT_VALUE_01),
                                .INIT_VALUE_02(INIT_VALUE_02),
                                .INIT_VALUE_03(INIT_VALUE_03),
                                .INIT_VALUE_04(INIT_VALUE_04),
                                .INIT_VALUE_05(INIT_VALUE_05),
                                .INIT_VALUE_06(INIT_VALUE_06),
                                .INIT_VALUE_07(INIT_VALUE_07),
                                .INIT_VALUE_08(INIT_VALUE_08),
                                .INIT_VALUE_09(INIT_VALUE_09),
                                .INIT_VALUE_0A(INIT_VALUE_0A),
                                .INIT_VALUE_0B(INIT_VALUE_0B),
                                .INIT_VALUE_0C(INIT_VALUE_0C),
                                .INIT_VALUE_0D(INIT_VALUE_0D),
                                .INIT_VALUE_0E(INIT_VALUE_0E),
                                .INIT_VALUE_0F(INIT_VALUE_0F),
                                .INIT_VALUE_10(INIT_VALUE_10),
                                .INIT_VALUE_11(INIT_VALUE_11),
                                .INIT_VALUE_12(INIT_VALUE_12),
                                .INIT_VALUE_13(INIT_VALUE_13),
                                .INIT_VALUE_14(INIT_VALUE_14),
                                .INIT_VALUE_15(INIT_VALUE_15),
                                .INIT_VALUE_16(INIT_VALUE_16),
                                .INIT_VALUE_17(INIT_VALUE_17),
                                .INIT_VALUE_18(INIT_VALUE_18),
                                .INIT_VALUE_19(INIT_VALUE_19),
                                .INIT_VALUE_1A(INIT_VALUE_1A),
                                .INIT_VALUE_1B(INIT_VALUE_1B),
                                .INIT_VALUE_1C(INIT_VALUE_1C),
                                .INIT_VALUE_1D(INIT_VALUE_1D),
                                .INIT_VALUE_1E(INIT_VALUE_1E),
                                .INIT_VALUE_1F(INIT_VALUE_1F),
                                .INIT_VALUE_20(INIT_VALUE_20),
                                .INIT_VALUE_21(INIT_VALUE_21),
                                .INIT_VALUE_22(INIT_VALUE_22),
                                .INIT_VALUE_23(INIT_VALUE_23),
                                .INIT_VALUE_24(INIT_VALUE_24),
                                .INIT_VALUE_25(INIT_VALUE_25),
                                .INIT_VALUE_26(INIT_VALUE_26),
                                .INIT_VALUE_27(INIT_VALUE_27),
                                .INIT_VALUE_28(INIT_VALUE_28),
                                .INIT_VALUE_29(INIT_VALUE_29),
                                .INIT_VALUE_2A(INIT_VALUE_2A),
                                .INIT_VALUE_2B(INIT_VALUE_2B),
                                .INIT_VALUE_2C(INIT_VALUE_2C),
                                .INIT_VALUE_2D(INIT_VALUE_2D),
                                .INIT_VALUE_2E(INIT_VALUE_2E),
                                .INIT_VALUE_2F(INIT_VALUE_2F),
                                .INIT_VALUE_30(INIT_VALUE_30),
                                .INIT_VALUE_31(INIT_VALUE_31),
                                .INIT_VALUE_32(INIT_VALUE_32),
                                .INIT_VALUE_33(INIT_VALUE_33),
                                .INIT_VALUE_34(INIT_VALUE_34),
                                .INIT_VALUE_35(INIT_VALUE_35),
                                .INIT_VALUE_36(INIT_VALUE_36),
                                .INIT_VALUE_37(INIT_VALUE_37),
                                .INIT_VALUE_38(INIT_VALUE_38),
                                .INIT_VALUE_39(INIT_VALUE_39),
                                .INIT_VALUE_3A(INIT_VALUE_3A),
                                .INIT_VALUE_3B(INIT_VALUE_3B),
                                .INIT_VALUE_3C(INIT_VALUE_3C),
                                .INIT_VALUE_3D(INIT_VALUE_3D),
                                .INIT_VALUE_3E(INIT_VALUE_3E),
                                .INIT_VALUE_3F(INIT_VALUE_3F),
                                .INIT_VALUE_40(INIT_VALUE_40),
                                .INIT_VALUE_41(INIT_VALUE_41),
                                .INIT_VALUE_42(INIT_VALUE_42),
                                .INIT_VALUE_43(INIT_VALUE_43),
                                .INIT_VALUE_44(INIT_VALUE_44),
                                .INIT_VALUE_45(INIT_VALUE_45),
                                .INIT_VALUE_46(INIT_VALUE_46),
                                .INIT_VALUE_47(INIT_VALUE_47),
                                .INIT_VALUE_48(INIT_VALUE_48),
                                .INIT_VALUE_49(INIT_VALUE_49),
                                .INIT_VALUE_4A(INIT_VALUE_4A),
                                .INIT_VALUE_4B(INIT_VALUE_4B),
                                .INIT_VALUE_4C(INIT_VALUE_4C),
                                .INIT_VALUE_4D(INIT_VALUE_4D),
                                .INIT_VALUE_4E(INIT_VALUE_4E),
                                .INIT_VALUE_4F(INIT_VALUE_4F),
                                .INIT_VALUE_50(INIT_VALUE_50),
                                .INIT_VALUE_51(INIT_VALUE_51),
                                .INIT_VALUE_52(INIT_VALUE_52),
                                .INIT_VALUE_53(INIT_VALUE_53),
                                .INIT_VALUE_54(INIT_VALUE_54),
                                .INIT_VALUE_55(INIT_VALUE_55),
                                .INIT_VALUE_56(INIT_VALUE_56),
                                .INIT_VALUE_57(INIT_VALUE_57),
                                .INIT_VALUE_58(INIT_VALUE_58),
                                .INIT_VALUE_59(INIT_VALUE_59),
                                .INIT_VALUE_5A(INIT_VALUE_5A),
                                .INIT_VALUE_5B(INIT_VALUE_5B),
                                .INIT_VALUE_5C(INIT_VALUE_5C),
                                .INIT_VALUE_5D(INIT_VALUE_5D),
                                .INIT_VALUE_5E(INIT_VALUE_5E),
                                .INIT_VALUE_5F(INIT_VALUE_5F),
                                .INIT_VALUE_60(INIT_VALUE_60),
                                .INIT_VALUE_61(INIT_VALUE_61),
                                .INIT_VALUE_62(INIT_VALUE_62),
                                .INIT_VALUE_63(INIT_VALUE_63),
                                .INIT_VALUE_64(INIT_VALUE_64),
                                .INIT_VALUE_65(INIT_VALUE_65),
                                .INIT_VALUE_66(INIT_VALUE_66),
                                .INIT_VALUE_67(INIT_VALUE_67),
                                .INIT_VALUE_68(INIT_VALUE_68),
                                .INIT_VALUE_69(INIT_VALUE_69),
                                .INIT_VALUE_6A(INIT_VALUE_6A),
                                .INIT_VALUE_6B(INIT_VALUE_6B),
                                .INIT_VALUE_6C(INIT_VALUE_6C),
                                .INIT_VALUE_6D(INIT_VALUE_6D),
                                .INIT_VALUE_6E(INIT_VALUE_6E),
                                .INIT_VALUE_6F(INIT_VALUE_6F),
                                .INIT_VALUE_70(INIT_VALUE_70),
                                .INIT_VALUE_71(INIT_VALUE_71),
                                .INIT_VALUE_72(INIT_VALUE_72),
                                .INIT_VALUE_73(INIT_VALUE_73),
                                .INIT_VALUE_74(INIT_VALUE_74),
                                .INIT_VALUE_75(INIT_VALUE_75),
                                .INIT_VALUE_76(INIT_VALUE_76),
                                .INIT_VALUE_77(INIT_VALUE_77),
                                .INIT_VALUE_78(INIT_VALUE_78),
                                .INIT_VALUE_79(INIT_VALUE_79),
                                .INIT_VALUE_7A(INIT_VALUE_7A),
                                .INIT_VALUE_7B(INIT_VALUE_7B),
                                .INIT_VALUE_7C(INIT_VALUE_7C),
                                .INIT_VALUE_7D(INIT_VALUE_7D),
                                .INIT_VALUE_7E(INIT_VALUE_7E),
                                .INIT_VALUE_7F(INIT_VALUE_7F)) u_mem (.addr_a_i(dp_address_a), 
                                    .addr_b_i(dp_address_b), 
                                    .wr_data_a_i(dp_datain_a), 
                                    .wr_data_b_i(dp_datain_b), 
                                    .clk_a_i(dp_clock_a), 
                                    .clk_b_i(dp_clock_b), 
                                    .clk_en_a_i(dp_clocken_a), 
                                    .clk_en_b_i(dp_clocken_b), 
                                    .wr_en_a_i(dp_wr_a), 
                                    .wr_en_b_i(dp_wr_b), 
                                    .rst_a_i(dp_reset_a), 
                                    .rst_b_i(dp_reset_b), 
                                    .ben_a_i(dpben_a_w), 
                                    .ben_b_i(dpben_b_w), 
                                    .rd_data_a_o(dp_q_a), 
                                    .rd_data_b_o(dp_q_b), 
                                    .ecc_one_err_a_o(), 
                                    .ecc_two_err_a_o(), 
                                    .ecc_one_err_b_o(), 
                                    .ecc_two_err_b_o()) ; 
                    end
                else
                    if ((MEMORY_TYPE == "LRAM")) 
                        begin : lram
                            localparam T_BYTE_WIDTH_A = ((BYTE_ENABLE_S0 || UNALIGNED_ACCESS_ENABLE) ? BYTE_WIDTH : 1) ; 
                            localparam T_BYTE_WIDTH_B = ((BYTE_ENABLE_S1 || UNALIGNED_ACCESS_ENABLE) ? BYTE_WIDTH : 1) ; 
                            wire [(T_BYTE_WIDTH_A - 1):0] t_dp_byteen_a = ((BYTE_ENABLE_S0 || UNALIGNED_ACCESS_ENABLE) ? dp_byteen_a : {T_BYTE_WIDTH_A{1'b1}}) ; 
                            wire [(T_BYTE_WIDTH_B - 1):0] t_dp_byteen_b = ((BYTE_ENABLE_S1 || UNALIGNED_ACCESS_ENABLE) ? dp_byteen_b : {T_BYTE_WIDTH_B{1'b1}}) ; 
                            sysmem_ipgen_lscc_smem_lram #(.ADDR_DEPTH(ADDR_DEPTH),
                                    .ADDR_WIDTH(ADDR_WIDTH),
                                    .DATA_WIDTH(DATA_WIDTH),
                                    .BYTE_ENABLE_A(BYTE_ENABLE_S0),
                                    .BYTE_ENABLE_B(BYTE_ENABLE_S1),
                                    .ECC_ENABLE(ECC_ENABLE),
                                    .MEM_ID(MEM_ID),
                                    .MEM_SIZE(MEM_SIZE),
                                    .REGMODE_A(MEM_REGMODE_A),
                                    .REGMODE_B(MEM_REGMODE_B),
                                    .RESET_MODE(MEM_RESETMODE_A),
                                    .ASYNC_RST_RELEASE("sync"),
                                    .UNALIGNED_ACCESS_ENABLE(UNALIGNED_ACCESS_ENABLE),
                                    .INIT_MODE((((INIT_FILE == "none") || (INIT_FILE_FORMAT == "none")) ? "none" : "mem_file")),
                                    .INITVAL_00(INIT_VALUE_00),
                                    .INITVAL_01(INIT_VALUE_01),
                                    .INITVAL_02(INIT_VALUE_02),
                                    .INITVAL_03(INIT_VALUE_03),
                                    .INITVAL_04(INIT_VALUE_04),
                                    .INITVAL_05(INIT_VALUE_05),
                                    .INITVAL_06(INIT_VALUE_06),
                                    .INITVAL_07(INIT_VALUE_07),
                                    .INITVAL_08(INIT_VALUE_08),
                                    .INITVAL_09(INIT_VALUE_09),
                                    .INITVAL_0A(INIT_VALUE_0A),
                                    .INITVAL_0B(INIT_VALUE_0B),
                                    .INITVAL_0C(INIT_VALUE_0C),
                                    .INITVAL_0D(INIT_VALUE_0D),
                                    .INITVAL_0E(INIT_VALUE_0E),
                                    .INITVAL_0F(INIT_VALUE_0F),
                                    .INITVAL_10(INIT_VALUE_10),
                                    .INITVAL_11(INIT_VALUE_11),
                                    .INITVAL_12(INIT_VALUE_12),
                                    .INITVAL_13(INIT_VALUE_13),
                                    .INITVAL_14(INIT_VALUE_14),
                                    .INITVAL_15(INIT_VALUE_15),
                                    .INITVAL_16(INIT_VALUE_16),
                                    .INITVAL_17(INIT_VALUE_17),
                                    .INITVAL_18(INIT_VALUE_18),
                                    .INITVAL_19(INIT_VALUE_19),
                                    .INITVAL_1A(INIT_VALUE_1A),
                                    .INITVAL_1B(INIT_VALUE_1B),
                                    .INITVAL_1C(INIT_VALUE_1C),
                                    .INITVAL_1D(INIT_VALUE_1D),
                                    .INITVAL_1E(INIT_VALUE_1E),
                                    .INITVAL_1F(INIT_VALUE_1F),
                                    .INITVAL_20(INIT_VALUE_20),
                                    .INITVAL_21(INIT_VALUE_21),
                                    .INITVAL_22(INIT_VALUE_22),
                                    .INITVAL_23(INIT_VALUE_23),
                                    .INITVAL_24(INIT_VALUE_24),
                                    .INITVAL_25(INIT_VALUE_25),
                                    .INITVAL_26(INIT_VALUE_26),
                                    .INITVAL_27(INIT_VALUE_27),
                                    .INITVAL_28(INIT_VALUE_28),
                                    .INITVAL_29(INIT_VALUE_29),
                                    .INITVAL_2A(INIT_VALUE_2A),
                                    .INITVAL_2B(INIT_VALUE_2B),
                                    .INITVAL_2C(INIT_VALUE_2C),
                                    .INITVAL_2D(INIT_VALUE_2D),
                                    .INITVAL_2E(INIT_VALUE_2E),
                                    .INITVAL_2F(INIT_VALUE_2F),
                                    .INITVAL_30(INIT_VALUE_30),
                                    .INITVAL_31(INIT_VALUE_31),
                                    .INITVAL_32(INIT_VALUE_32),
                                    .INITVAL_33(INIT_VALUE_33),
                                    .INITVAL_34(INIT_VALUE_34),
                                    .INITVAL_35(INIT_VALUE_35),
                                    .INITVAL_36(INIT_VALUE_36),
                                    .INITVAL_37(INIT_VALUE_37),
                                    .INITVAL_38(INIT_VALUE_38),
                                    .INITVAL_39(INIT_VALUE_39),
                                    .INITVAL_3A(INIT_VALUE_3A),
                                    .INITVAL_3B(INIT_VALUE_3B),
                                    .INITVAL_3C(INIT_VALUE_3C),
                                    .INITVAL_3D(INIT_VALUE_3D),
                                    .INITVAL_3E(INIT_VALUE_3E),
                                    .INITVAL_3F(INIT_VALUE_3F),
                                    .INITVAL_40(INIT_VALUE_40),
                                    .INITVAL_41(INIT_VALUE_41),
                                    .INITVAL_42(INIT_VALUE_42),
                                    .INITVAL_43(INIT_VALUE_43),
                                    .INITVAL_44(INIT_VALUE_44),
                                    .INITVAL_45(INIT_VALUE_45),
                                    .INITVAL_46(INIT_VALUE_46),
                                    .INITVAL_47(INIT_VALUE_47),
                                    .INITVAL_48(INIT_VALUE_48),
                                    .INITVAL_49(INIT_VALUE_49),
                                    .INITVAL_4A(INIT_VALUE_4A),
                                    .INITVAL_4B(INIT_VALUE_4B),
                                    .INITVAL_4C(INIT_VALUE_4C),
                                    .INITVAL_4D(INIT_VALUE_4D),
                                    .INITVAL_4E(INIT_VALUE_4E),
                                    .INITVAL_4F(INIT_VALUE_4F),
                                    .INITVAL_50(INIT_VALUE_50),
                                    .INITVAL_51(INIT_VALUE_51),
                                    .INITVAL_52(INIT_VALUE_52),
                                    .INITVAL_53(INIT_VALUE_53),
                                    .INITVAL_54(INIT_VALUE_54),
                                    .INITVAL_55(INIT_VALUE_55),
                                    .INITVAL_56(INIT_VALUE_56),
                                    .INITVAL_57(INIT_VALUE_57),
                                    .INITVAL_58(INIT_VALUE_58),
                                    .INITVAL_59(INIT_VALUE_59),
                                    .INITVAL_5A(INIT_VALUE_5A),
                                    .INITVAL_5B(INIT_VALUE_5B),
                                    .INITVAL_5C(INIT_VALUE_5C),
                                    .INITVAL_5D(INIT_VALUE_5D),
                                    .INITVAL_5E(INIT_VALUE_5E),
                                    .INITVAL_5F(INIT_VALUE_5F),
                                    .INITVAL_60(INIT_VALUE_60),
                                    .INITVAL_61(INIT_VALUE_61),
                                    .INITVAL_62(INIT_VALUE_62),
                                    .INITVAL_63(INIT_VALUE_63),
                                    .INITVAL_64(INIT_VALUE_64),
                                    .INITVAL_65(INIT_VALUE_65),
                                    .INITVAL_66(INIT_VALUE_66),
                                    .INITVAL_67(INIT_VALUE_67),
                                    .INITVAL_68(INIT_VALUE_68),
                                    .INITVAL_69(INIT_VALUE_69),
                                    .INITVAL_6A(INIT_VALUE_6A),
                                    .INITVAL_6B(INIT_VALUE_6B),
                                    .INITVAL_6C(INIT_VALUE_6C),
                                    .INITVAL_6D(INIT_VALUE_6D),
                                    .INITVAL_6E(INIT_VALUE_6E),
                                    .INITVAL_6F(INIT_VALUE_6F),
                                    .INITVAL_70(INIT_VALUE_70),
                                    .INITVAL_71(INIT_VALUE_71),
                                    .INITVAL_72(INIT_VALUE_72),
                                    .INITVAL_73(INIT_VALUE_73),
                                    .INITVAL_74(INIT_VALUE_74),
                                    .INITVAL_75(INIT_VALUE_75),
                                    .INITVAL_76(INIT_VALUE_76),
                                    .INITVAL_77(INIT_VALUE_77),
                                    .INITVAL_78(INIT_VALUE_78),
                                    .INITVAL_79(INIT_VALUE_79),
                                    .INITVAL_7A(INIT_VALUE_7A),
                                    .INITVAL_7B(INIT_VALUE_7B),
                                    .INITVAL_7C(INIT_VALUE_7C),
                                    .INITVAL_7D(INIT_VALUE_7D),
                                    .INITVAL_7E(INIT_VALUE_7E),
                                    .INITVAL_7F(INIT_VALUE_7F)) ulram_0 (.clk_i(dp_clock_a), 
                                        .addr_a_i(dp_address_a), 
                                        .wr_data_a_i(dp_datain_a), 
                                        .clk_en_a_i(dp_clocken_a), 
                                        .wr_en_a_i(dp_wr_a), 
                                        .rst_a_i(dp_reset_a), 
                                        .ben_a_i(t_dp_byteen_a), 
                                        .rd_data_a_o(dp_q_a), 
                                        .addr_b_i(dp_address_b), 
                                        .wr_data_b_i(dp_datain_b), 
                                        .clk_en_b_i(dp_clocken_b), 
                                        .wr_en_b_i(dp_wr_b), 
                                        .rst_b_i(dp_reset_b), 
                                        .ben_b_i(t_dp_byteen_b), 
                                        .rd_data_b_o(dp_q_b), 
                                        .dps_i(), 
                                        .lramready_o(), 
                                        .errdet_a_o(mem_error_a_o), 
                                        .errdet_b_o(mem_error_b_o)) ; 
                        end
                    else
                        begin : dist_mem
                            reg [(DATA_WIDTH - 1):0] pdp_q_r ; 
                            wire [(DATA_WIDTH - 1):0] pdp_q_w ; 
                            assign pdp_q = pdp_q_r ; 
                            always
                                @(posedge pdp_rdclock or 
                                    posedge pdp_reset)
                                begin
                                    if (pdp_reset) 
                                        begin
                                            pdp_q_r <=  {DATA_WIDTH{1'b0}} ;
                                        end
                                    else
                                        begin
                                            pdp_q_r <=  pdp_q_w ;
                                        end
                                end
                            lscc_distributed_dpram #(.FAMILY(FAMILY),
                                    .WADDR_DEPTH(ADDR_DEPTH),
                                    .WADDR_WIDTH(ADDR_WIDTH),
                                    .WDATA_WIDTH(DATA_WIDTH),
                                    .RADDR_DEPTH(ADDR_DEPTH),
                                    .RADDR_WIDTH(ADDR_WIDTH),
                                    .RDATA_WIDTH(DATA_WIDTH),
                                    .REGMODE(((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? MEM_REGMODE_A : MEM_REGMODE_B)),
                                    .RESETMODE(MEM_RESETMODE_A),
                                    .INIT_FILE(INIT_FILE),
                                    .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                                    .INIT_MODE(((INIT_FILE == "none") ? "none" : "mem_file"))) u_mem (.wr_clk_i(pdp_wrclock), 
                                        .rd_clk_i(pdp_rdclock), 
                                        .rst_i(pdp_reset), 
                                        .wr_clk_en_i(pdp_wrclocken), 
                                        .rd_clk_en_i(pdp_rdclocken), 
                                        .wr_en_i(pdp_wr_en), 
                                        .wr_data_i(pdp_data), 
                                        .wr_addr_i(pdp_wraddress), 
                                        .rd_en_i(pdp_rdclocken), 
                                        .rd_addr_i(pdp_rdaddress), 
                                        .rd_data_o(pdp_q_w)) ; 
                        end
            end
        else
            begin : intf_AHBL
                if ((((FAMILY == "LIFCL") || (FAMILY == "LAV-AT")) || (FAMILY == "iCE40UP"))) 
                    begin : lifcl_LAVAT
                        if ((MEMORY_TYPE == "EBR")) 
                            begin : ebr
                                if ((PORT_TYPE == "sp")) 
                                    begin : sp
                                        if ((FAMILY == "LIFCL")) 
                                            begin : lifcl
                                                lscc_ram_dq #(.FAMILY(FAMILY),
                                                        .ADDR_DEPTH(ADDR_DEPTH),
                                                        .ADDR_WIDTH(ADDR_WIDTH),
                                                        .DATA_WIDTH(DATA_WIDTH),
                                                        .REGMODE(MEM_REGMODE_A),
                                                        .RESETMODE(MEM_RESETMODE_A),
                                                        .INIT_FILE(INIT_FILE),
                                                        .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                                                        .WRITE_MODE("normal"),
                                                        .INIT_MODE(((INIT_FILE == "none") ? "none" : "mem_file")),
                                                        .BYTE_ENABLE(BYTE_ENABLE_S0),
                                                        .BYTE_SIZE(8),
                                                        .ASYNC_RST_RELEASE("sync"),
                                                        .ECC_ENABLE(ECC_ENABLE),
                                                        .MEM_SIZE(MEM_SIZE),
                                                        .MEM_ID(MEM_ID),
                                                        .INIT_VALUE_00(INIT_VALUE_00),
                                                        .INIT_VALUE_01(INIT_VALUE_01),
                                                        .INIT_VALUE_02(INIT_VALUE_02),
                                                        .INIT_VALUE_03(INIT_VALUE_03),
                                                        .INIT_VALUE_04(INIT_VALUE_04),
                                                        .INIT_VALUE_05(INIT_VALUE_05),
                                                        .INIT_VALUE_06(INIT_VALUE_06),
                                                        .INIT_VALUE_07(INIT_VALUE_07),
                                                        .INIT_VALUE_08(INIT_VALUE_08),
                                                        .INIT_VALUE_09(INIT_VALUE_09),
                                                        .INIT_VALUE_0A(INIT_VALUE_0A),
                                                        .INIT_VALUE_0B(INIT_VALUE_0B),
                                                        .INIT_VALUE_0C(INIT_VALUE_0C),
                                                        .INIT_VALUE_0D(INIT_VALUE_0D),
                                                        .INIT_VALUE_0E(INIT_VALUE_0E),
                                                        .INIT_VALUE_0F(INIT_VALUE_0F),
                                                        .INIT_VALUE_10(INIT_VALUE_10),
                                                        .INIT_VALUE_11(INIT_VALUE_11),
                                                        .INIT_VALUE_12(INIT_VALUE_12),
                                                        .INIT_VALUE_13(INIT_VALUE_13),
                                                        .INIT_VALUE_14(INIT_VALUE_14),
                                                        .INIT_VALUE_15(INIT_VALUE_15),
                                                        .INIT_VALUE_16(INIT_VALUE_16),
                                                        .INIT_VALUE_17(INIT_VALUE_17),
                                                        .INIT_VALUE_18(INIT_VALUE_18),
                                                        .INIT_VALUE_19(INIT_VALUE_19),
                                                        .INIT_VALUE_1A(INIT_VALUE_1A),
                                                        .INIT_VALUE_1B(INIT_VALUE_1B),
                                                        .INIT_VALUE_1C(INIT_VALUE_1C),
                                                        .INIT_VALUE_1D(INIT_VALUE_1D),
                                                        .INIT_VALUE_1E(INIT_VALUE_1E),
                                                        .INIT_VALUE_1F(INIT_VALUE_1F),
                                                        .INIT_VALUE_20(INIT_VALUE_20),
                                                        .INIT_VALUE_21(INIT_VALUE_21),
                                                        .INIT_VALUE_22(INIT_VALUE_22),
                                                        .INIT_VALUE_23(INIT_VALUE_23),
                                                        .INIT_VALUE_24(INIT_VALUE_24),
                                                        .INIT_VALUE_25(INIT_VALUE_25),
                                                        .INIT_VALUE_26(INIT_VALUE_26),
                                                        .INIT_VALUE_27(INIT_VALUE_27),
                                                        .INIT_VALUE_28(INIT_VALUE_28),
                                                        .INIT_VALUE_29(INIT_VALUE_29),
                                                        .INIT_VALUE_2A(INIT_VALUE_2A),
                                                        .INIT_VALUE_2B(INIT_VALUE_2B),
                                                        .INIT_VALUE_2C(INIT_VALUE_2C),
                                                        .INIT_VALUE_2D(INIT_VALUE_2D),
                                                        .INIT_VALUE_2E(INIT_VALUE_2E),
                                                        .INIT_VALUE_2F(INIT_VALUE_2F),
                                                        .INIT_VALUE_30(INIT_VALUE_30),
                                                        .INIT_VALUE_31(INIT_VALUE_31),
                                                        .INIT_VALUE_32(INIT_VALUE_32),
                                                        .INIT_VALUE_33(INIT_VALUE_33),
                                                        .INIT_VALUE_34(INIT_VALUE_34),
                                                        .INIT_VALUE_35(INIT_VALUE_35),
                                                        .INIT_VALUE_36(INIT_VALUE_36),
                                                        .INIT_VALUE_37(INIT_VALUE_37),
                                                        .INIT_VALUE_38(INIT_VALUE_38),
                                                        .INIT_VALUE_39(INIT_VALUE_39),
                                                        .INIT_VALUE_3A(INIT_VALUE_3A),
                                                        .INIT_VALUE_3B(INIT_VALUE_3B),
                                                        .INIT_VALUE_3C(INIT_VALUE_3C),
                                                        .INIT_VALUE_3D(INIT_VALUE_3D),
                                                        .INIT_VALUE_3E(INIT_VALUE_3E),
                                                        .INIT_VALUE_3F(INIT_VALUE_3F)) u_mem (.clk_i(sp_clock), 
                                                            .rst_i(sp_reset), 
                                                            .clk_en_i(sp_clocken), 
                                                            .rd_out_clk_en_i(1'b1), 
                                                            .wr_en_i(sp_we), 
                                                            .wr_data_i(sp_data[(DATA_WIDTH - 1):0]), 
                                                            .addr_i(sp_address[(ADDR_WIDTH - 1):0]), 
                                                            .ben_i(sp_byteen), 
                                                            .rd_data_o(sp_q[(DATA_WIDTH - 1):0]), 
                                                            .one_err_det_o(), 
                                                            .two_err_det_o()) ; 
                                            end
                                        else
                                            if ((FAMILY == "iCE40UP")) 
                                                begin : ice40
                                                    lscc_ram_dq #(.FAMILY(FAMILY),
                                                            .ADDR_DEPTH(ADDR_DEPTH),
                                                            .ADDR_WIDTH(ADDR_WIDTH),
                                                            .DATA_WIDTH(DATA_WIDTH),
                                                            .REGMODE(MEM_REGMODE_A),
                                                            .RESETMODE(MEM_RESETMODE_A),
                                                            .INIT_FILE(INIT_FILE),
                                                            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                                                            .WRITE_MODE("normal"),
                                                            .INIT_MODE(((INIT_FILE == "none") ? "none" : "mem_file")),
                                                            .BYTE_ENABLE(BYTE_ENABLE_S0),
                                                            .BYTE_SIZE(8),
                                                            .ASYNC_RST_RELEASE("sync"),
                                                            .ECC_ENABLE(ECC_ENABLE),
                                                            .MEM_SIZE(MEM_SIZE),
                                                            .MEM_ID(MEM_ID),
                                                            .INIT_VALUE_00(INIT_VALUE_00),
                                                            .INIT_VALUE_01(INIT_VALUE_01),
                                                            .INIT_VALUE_02(INIT_VALUE_02),
                                                            .INIT_VALUE_03(INIT_VALUE_03),
                                                            .INIT_VALUE_04(INIT_VALUE_04),
                                                            .INIT_VALUE_05(INIT_VALUE_05),
                                                            .INIT_VALUE_06(INIT_VALUE_06),
                                                            .INIT_VALUE_07(INIT_VALUE_07),
                                                            .INIT_VALUE_08(INIT_VALUE_08),
                                                            .INIT_VALUE_09(INIT_VALUE_09),
                                                            .INIT_VALUE_0A(INIT_VALUE_0A),
                                                            .INIT_VALUE_0B(INIT_VALUE_0B),
                                                            .INIT_VALUE_0C(INIT_VALUE_0C),
                                                            .INIT_VALUE_0D(INIT_VALUE_0D),
                                                            .INIT_VALUE_0E(INIT_VALUE_0E),
                                                            .INIT_VALUE_0F(INIT_VALUE_0F),
                                                            .INIT_VALUE_10(INIT_VALUE_10),
                                                            .INIT_VALUE_11(INIT_VALUE_11),
                                                            .INIT_VALUE_12(INIT_VALUE_12),
                                                            .INIT_VALUE_13(INIT_VALUE_13),
                                                            .INIT_VALUE_14(INIT_VALUE_14),
                                                            .INIT_VALUE_15(INIT_VALUE_15),
                                                            .INIT_VALUE_16(INIT_VALUE_16),
                                                            .INIT_VALUE_17(INIT_VALUE_17),
                                                            .INIT_VALUE_18(INIT_VALUE_18),
                                                            .INIT_VALUE_19(INIT_VALUE_19),
                                                            .INIT_VALUE_1A(INIT_VALUE_1A),
                                                            .INIT_VALUE_1B(INIT_VALUE_1B),
                                                            .INIT_VALUE_1C(INIT_VALUE_1C),
                                                            .INIT_VALUE_1D(INIT_VALUE_1D),
                                                            .INIT_VALUE_1E(INIT_VALUE_1E),
                                                            .INIT_VALUE_1F(INIT_VALUE_1F),
                                                            .INIT_VALUE_20(INIT_VALUE_20),
                                                            .INIT_VALUE_21(INIT_VALUE_21),
                                                            .INIT_VALUE_22(INIT_VALUE_22),
                                                            .INIT_VALUE_23(INIT_VALUE_23),
                                                            .INIT_VALUE_24(INIT_VALUE_24),
                                                            .INIT_VALUE_25(INIT_VALUE_25),
                                                            .INIT_VALUE_26(INIT_VALUE_26),
                                                            .INIT_VALUE_27(INIT_VALUE_27),
                                                            .INIT_VALUE_28(INIT_VALUE_28),
                                                            .INIT_VALUE_29(INIT_VALUE_29),
                                                            .INIT_VALUE_2A(INIT_VALUE_2A),
                                                            .INIT_VALUE_2B(INIT_VALUE_2B),
                                                            .INIT_VALUE_2C(INIT_VALUE_2C),
                                                            .INIT_VALUE_2D(INIT_VALUE_2D),
                                                            .INIT_VALUE_2E(INIT_VALUE_2E),
                                                            .INIT_VALUE_2F(INIT_VALUE_2F),
                                                            .INIT_VALUE_30(INIT_VALUE_30),
                                                            .INIT_VALUE_31(INIT_VALUE_31),
                                                            .INIT_VALUE_32(INIT_VALUE_32),
                                                            .INIT_VALUE_33(INIT_VALUE_33),
                                                            .INIT_VALUE_34(INIT_VALUE_34),
                                                            .INIT_VALUE_35(INIT_VALUE_35),
                                                            .INIT_VALUE_36(INIT_VALUE_36),
                                                            .INIT_VALUE_37(INIT_VALUE_37),
                                                            .INIT_VALUE_38(INIT_VALUE_38),
                                                            .INIT_VALUE_39(INIT_VALUE_39),
                                                            .INIT_VALUE_3A(INIT_VALUE_3A),
                                                            .INIT_VALUE_3B(INIT_VALUE_3B),
                                                            .INIT_VALUE_3C(INIT_VALUE_3C),
                                                            .INIT_VALUE_3D(INIT_VALUE_3D),
                                                            .INIT_VALUE_3E(INIT_VALUE_3E),
                                                            .INIT_VALUE_3F(INIT_VALUE_3F)) u_mem (.clk_i(sp_clock), 
                                                                .rst_i(sp_reset), 
                                                                .clk_en_i(sp_clocken), 
                                                                .rd_out_clk_en_i(1'b1), 
                                                                .wr_en_i(sp_we), 
                                                                .wr_data_i(sp_data[(DATA_WIDTH - 1):0]), 
                                                                .addr_i(sp_address[(ADDR_WIDTH - 1):0]), 
                                                                .ben_i(sp_byteen), 
                                                                .rd_data_o(sp_q[(DATA_WIDTH - 1):0]), 
                                                                .one_err_det_o(), 
                                                                .two_err_det_o()) ; 
                                                end
                                            else
                                                begin : LAVAT
                                                    lscc_ram_dq #(.FAMILY(FAMILY),
                                                            .ADDR_DEPTH(ADDR_DEPTH),
                                                            .ADDR_WIDTH(ADDR_WIDTH),
                                                            .DATA_WIDTH(DATA_WIDTH),
                                                            .REGMODE(MEM_REGMODE_A),
                                                            .RESETMODE(MEM_RESETMODE_A),
                                                            .INIT_FILE(INIT_FILE),
                                                            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                                                            .INIT_DATA_TYPE(1),
                                                            .WRITE_MODE("normal"),
                                                            .INIT_MODE(((INIT_FILE == "none") ? "none" : "mem_file")),
                                                            .BYTE_ENABLE(BYTE_ENABLE_S0),
                                                            .BYTE_SIZE(8),
                                                            .ASYNC_RST_RELEASE("sync"),
                                                            .ECC_ENABLE(ECC_ENABLE),
                                                            .MEM_SIZE(MEM_SIZE),
                                                            .MEM_ID(MEM_ID),
                                                            .INIT_VALUE_00(INIT_VALUE_00),
                                                            .INIT_VALUE_01(INIT_VALUE_01),
                                                            .INIT_VALUE_02(INIT_VALUE_02),
                                                            .INIT_VALUE_03(INIT_VALUE_03),
                                                            .INIT_VALUE_04(INIT_VALUE_04),
                                                            .INIT_VALUE_05(INIT_VALUE_05),
                                                            .INIT_VALUE_06(INIT_VALUE_06),
                                                            .INIT_VALUE_07(INIT_VALUE_07),
                                                            .INIT_VALUE_08(INIT_VALUE_08),
                                                            .INIT_VALUE_09(INIT_VALUE_09),
                                                            .INIT_VALUE_0A(INIT_VALUE_0A),
                                                            .INIT_VALUE_0B(INIT_VALUE_0B),
                                                            .INIT_VALUE_0C(INIT_VALUE_0C),
                                                            .INIT_VALUE_0D(INIT_VALUE_0D),
                                                            .INIT_VALUE_0E(INIT_VALUE_0E),
                                                            .INIT_VALUE_0F(INIT_VALUE_0F),
                                                            .INIT_VALUE_10(INIT_VALUE_10),
                                                            .INIT_VALUE_11(INIT_VALUE_11),
                                                            .INIT_VALUE_12(INIT_VALUE_12),
                                                            .INIT_VALUE_13(INIT_VALUE_13),
                                                            .INIT_VALUE_14(INIT_VALUE_14),
                                                            .INIT_VALUE_15(INIT_VALUE_15),
                                                            .INIT_VALUE_16(INIT_VALUE_16),
                                                            .INIT_VALUE_17(INIT_VALUE_17),
                                                            .INIT_VALUE_18(INIT_VALUE_18),
                                                            .INIT_VALUE_19(INIT_VALUE_19),
                                                            .INIT_VALUE_1A(INIT_VALUE_1A),
                                                            .INIT_VALUE_1B(INIT_VALUE_1B),
                                                            .INIT_VALUE_1C(INIT_VALUE_1C),
                                                            .INIT_VALUE_1D(INIT_VALUE_1D),
                                                            .INIT_VALUE_1E(INIT_VALUE_1E),
                                                            .INIT_VALUE_1F(INIT_VALUE_1F),
                                                            .INIT_VALUE_20(INIT_VALUE_20),
                                                            .INIT_VALUE_21(INIT_VALUE_21),
                                                            .INIT_VALUE_22(INIT_VALUE_22),
                                                            .INIT_VALUE_23(INIT_VALUE_23),
                                                            .INIT_VALUE_24(INIT_VALUE_24),
                                                            .INIT_VALUE_25(INIT_VALUE_25),
                                                            .INIT_VALUE_26(INIT_VALUE_26),
                                                            .INIT_VALUE_27(INIT_VALUE_27),
                                                            .INIT_VALUE_28(INIT_VALUE_28),
                                                            .INIT_VALUE_29(INIT_VALUE_29),
                                                            .INIT_VALUE_2A(INIT_VALUE_2A),
                                                            .INIT_VALUE_2B(INIT_VALUE_2B),
                                                            .INIT_VALUE_2C(INIT_VALUE_2C),
                                                            .INIT_VALUE_2D(INIT_VALUE_2D),
                                                            .INIT_VALUE_2E(INIT_VALUE_2E),
                                                            .INIT_VALUE_2F(INIT_VALUE_2F),
                                                            .INIT_VALUE_30(INIT_VALUE_30),
                                                            .INIT_VALUE_31(INIT_VALUE_31),
                                                            .INIT_VALUE_32(INIT_VALUE_32),
                                                            .INIT_VALUE_33(INIT_VALUE_33),
                                                            .INIT_VALUE_34(INIT_VALUE_34),
                                                            .INIT_VALUE_35(INIT_VALUE_35),
                                                            .INIT_VALUE_36(INIT_VALUE_36),
                                                            .INIT_VALUE_37(INIT_VALUE_37),
                                                            .INIT_VALUE_38(INIT_VALUE_38),
                                                            .INIT_VALUE_39(INIT_VALUE_39),
                                                            .INIT_VALUE_3A(INIT_VALUE_3A),
                                                            .INIT_VALUE_3B(INIT_VALUE_3B),
                                                            .INIT_VALUE_3C(INIT_VALUE_3C),
                                                            .INIT_VALUE_3D(INIT_VALUE_3D),
                                                            .INIT_VALUE_3E(INIT_VALUE_3E),
                                                            .INIT_VALUE_3F(INIT_VALUE_3F),
                                                            .INIT_VALUE_40(INIT_VALUE_40),
                                                            .INIT_VALUE_41(INIT_VALUE_41),
                                                            .INIT_VALUE_42(INIT_VALUE_42),
                                                            .INIT_VALUE_43(INIT_VALUE_43),
                                                            .INIT_VALUE_44(INIT_VALUE_44),
                                                            .INIT_VALUE_45(INIT_VALUE_45),
                                                            .INIT_VALUE_46(INIT_VALUE_46),
                                                            .INIT_VALUE_47(INIT_VALUE_47),
                                                            .INIT_VALUE_48(INIT_VALUE_48),
                                                            .INIT_VALUE_49(INIT_VALUE_49),
                                                            .INIT_VALUE_4A(INIT_VALUE_4A),
                                                            .INIT_VALUE_4B(INIT_VALUE_4B),
                                                            .INIT_VALUE_4C(INIT_VALUE_4C),
                                                            .INIT_VALUE_4D(INIT_VALUE_4D),
                                                            .INIT_VALUE_4E(INIT_VALUE_4E),
                                                            .INIT_VALUE_4F(INIT_VALUE_4F),
                                                            .INIT_VALUE_50(INIT_VALUE_50),
                                                            .INIT_VALUE_51(INIT_VALUE_51),
                                                            .INIT_VALUE_52(INIT_VALUE_52),
                                                            .INIT_VALUE_53(INIT_VALUE_53),
                                                            .INIT_VALUE_54(INIT_VALUE_54),
                                                            .INIT_VALUE_55(INIT_VALUE_55),
                                                            .INIT_VALUE_56(INIT_VALUE_56),
                                                            .INIT_VALUE_57(INIT_VALUE_57),
                                                            .INIT_VALUE_58(INIT_VALUE_58),
                                                            .INIT_VALUE_59(INIT_VALUE_59),
                                                            .INIT_VALUE_5A(INIT_VALUE_5A),
                                                            .INIT_VALUE_5B(INIT_VALUE_5B),
                                                            .INIT_VALUE_5C(INIT_VALUE_5C),
                                                            .INIT_VALUE_5D(INIT_VALUE_5D),
                                                            .INIT_VALUE_5E(INIT_VALUE_5E),
                                                            .INIT_VALUE_5F(INIT_VALUE_5F),
                                                            .INIT_VALUE_60(INIT_VALUE_60),
                                                            .INIT_VALUE_61(INIT_VALUE_61),
                                                            .INIT_VALUE_62(INIT_VALUE_62),
                                                            .INIT_VALUE_63(INIT_VALUE_63),
                                                            .INIT_VALUE_64(INIT_VALUE_64),
                                                            .INIT_VALUE_65(INIT_VALUE_65),
                                                            .INIT_VALUE_66(INIT_VALUE_66),
                                                            .INIT_VALUE_67(INIT_VALUE_67),
                                                            .INIT_VALUE_68(INIT_VALUE_68),
                                                            .INIT_VALUE_69(INIT_VALUE_69),
                                                            .INIT_VALUE_6A(INIT_VALUE_6A),
                                                            .INIT_VALUE_6B(INIT_VALUE_6B),
                                                            .INIT_VALUE_6C(INIT_VALUE_6C),
                                                            .INIT_VALUE_6D(INIT_VALUE_6D),
                                                            .INIT_VALUE_6E(INIT_VALUE_6E),
                                                            .INIT_VALUE_6F(INIT_VALUE_6F),
                                                            .INIT_VALUE_70(INIT_VALUE_70),
                                                            .INIT_VALUE_71(INIT_VALUE_71),
                                                            .INIT_VALUE_72(INIT_VALUE_72),
                                                            .INIT_VALUE_73(INIT_VALUE_73),
                                                            .INIT_VALUE_74(INIT_VALUE_74),
                                                            .INIT_VALUE_75(INIT_VALUE_75),
                                                            .INIT_VALUE_76(INIT_VALUE_76),
                                                            .INIT_VALUE_77(INIT_VALUE_77),
                                                            .INIT_VALUE_78(INIT_VALUE_78),
                                                            .INIT_VALUE_79(INIT_VALUE_79),
                                                            .INIT_VALUE_7A(INIT_VALUE_7A),
                                                            .INIT_VALUE_7B(INIT_VALUE_7B),
                                                            .INIT_VALUE_7C(INIT_VALUE_7C),
                                                            .INIT_VALUE_7D(INIT_VALUE_7D),
                                                            .INIT_VALUE_7E(INIT_VALUE_7E),
                                                            .INIT_VALUE_7F(INIT_VALUE_7F)) u_mem (.clk_i(sp_clock), 
                                                                .rst_i(sp_reset), 
                                                                .clk_en_i(sp_clocken), 
                                                                .rd_out_clk_en_i(1'b1), 
                                                                .wr_en_i(sp_we), 
                                                                .wr_data_i(sp_data[(DATA_WIDTH - 1):0]), 
                                                                .addr_i(sp_address[(ADDR_WIDTH - 1):0]), 
                                                                .ben_i(sp_byteen), 
                                                                .rd_data_o(sp_q[(DATA_WIDTH - 1):0]), 
                                                                .one_err_det_o(), 
                                                                .two_err_det_o()) ; 
                                                end
                                    end
                                else
                                    if ((PORT_TYPE == "pdp")) 
                                        begin : pdp
                                            if ((FAMILY == "LIFCL")) 
                                                begin : lifcl
                                                    lscc_ram_dp #(.FAMILY(FAMILY),
                                                            .WADDR_DEPTH(ADDR_DEPTH),
                                                            .WADDR_WIDTH(ADDR_WIDTH),
                                                            .WDATA_WIDTH(DATA_WIDTH),
                                                            .RADDR_DEPTH(ADDR_DEPTH),
                                                            .RADDR_WIDTH(ADDR_WIDTH),
                                                            .RDATA_WIDTH(DATA_WIDTH),
                                                            .MEM_SIZE(MEM_SIZE),
                                                            .MEM_ID(MEM_ID),
                                                            .REGMODE(((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? MEM_REGMODE_A : MEM_REGMODE_B)),
                                                            .RESETMODE(((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? MEM_RESETMODE_A : MEM_RESETMODE_B)),
                                                            .RESET_RELEASE("sync"),
                                                            .INIT_FILE(INIT_FILE),
                                                            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                                                            .INIT_MODE(((INIT_FILE == "none") ? "none" : "mem_file")),
                                                            .BYTE_ENABLE(((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "W/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? BYTE_ENABLE_S0 : BYTE_ENABLE_S1)),
                                                            .BYTE_SIZE(8),
                                                            .ECC_ENABLE(ECC_ENABLE),
                                                            .INIT_VALUE_00(INIT_VALUE_00),
                                                            .INIT_VALUE_01(INIT_VALUE_01),
                                                            .INIT_VALUE_02(INIT_VALUE_02),
                                                            .INIT_VALUE_03(INIT_VALUE_03),
                                                            .INIT_VALUE_04(INIT_VALUE_04),
                                                            .INIT_VALUE_05(INIT_VALUE_05),
                                                            .INIT_VALUE_06(INIT_VALUE_06),
                                                            .INIT_VALUE_07(INIT_VALUE_07),
                                                            .INIT_VALUE_08(INIT_VALUE_08),
                                                            .INIT_VALUE_09(INIT_VALUE_09),
                                                            .INIT_VALUE_0A(INIT_VALUE_0A),
                                                            .INIT_VALUE_0B(INIT_VALUE_0B),
                                                            .INIT_VALUE_0C(INIT_VALUE_0C),
                                                            .INIT_VALUE_0D(INIT_VALUE_0D),
                                                            .INIT_VALUE_0E(INIT_VALUE_0E),
                                                            .INIT_VALUE_0F(INIT_VALUE_0F),
                                                            .INIT_VALUE_10(INIT_VALUE_10),
                                                            .INIT_VALUE_11(INIT_VALUE_11),
                                                            .INIT_VALUE_12(INIT_VALUE_12),
                                                            .INIT_VALUE_13(INIT_VALUE_13),
                                                            .INIT_VALUE_14(INIT_VALUE_14),
                                                            .INIT_VALUE_15(INIT_VALUE_15),
                                                            .INIT_VALUE_16(INIT_VALUE_16),
                                                            .INIT_VALUE_17(INIT_VALUE_17),
                                                            .INIT_VALUE_18(INIT_VALUE_18),
                                                            .INIT_VALUE_19(INIT_VALUE_19),
                                                            .INIT_VALUE_1A(INIT_VALUE_1A),
                                                            .INIT_VALUE_1B(INIT_VALUE_1B),
                                                            .INIT_VALUE_1C(INIT_VALUE_1C),
                                                            .INIT_VALUE_1D(INIT_VALUE_1D),
                                                            .INIT_VALUE_1E(INIT_VALUE_1E),
                                                            .INIT_VALUE_1F(INIT_VALUE_1F),
                                                            .INIT_VALUE_20(INIT_VALUE_20),
                                                            .INIT_VALUE_21(INIT_VALUE_21),
                                                            .INIT_VALUE_22(INIT_VALUE_22),
                                                            .INIT_VALUE_23(INIT_VALUE_23),
                                                            .INIT_VALUE_24(INIT_VALUE_24),
                                                            .INIT_VALUE_25(INIT_VALUE_25),
                                                            .INIT_VALUE_26(INIT_VALUE_26),
                                                            .INIT_VALUE_27(INIT_VALUE_27),
                                                            .INIT_VALUE_28(INIT_VALUE_28),
                                                            .INIT_VALUE_29(INIT_VALUE_29),
                                                            .INIT_VALUE_2A(INIT_VALUE_2A),
                                                            .INIT_VALUE_2B(INIT_VALUE_2B),
                                                            .INIT_VALUE_2C(INIT_VALUE_2C),
                                                            .INIT_VALUE_2D(INIT_VALUE_2D),
                                                            .INIT_VALUE_2E(INIT_VALUE_2E),
                                                            .INIT_VALUE_2F(INIT_VALUE_2F),
                                                            .INIT_VALUE_30(INIT_VALUE_30),
                                                            .INIT_VALUE_31(INIT_VALUE_31),
                                                            .INIT_VALUE_32(INIT_VALUE_32),
                                                            .INIT_VALUE_33(INIT_VALUE_33),
                                                            .INIT_VALUE_34(INIT_VALUE_34),
                                                            .INIT_VALUE_35(INIT_VALUE_35),
                                                            .INIT_VALUE_36(INIT_VALUE_36),
                                                            .INIT_VALUE_37(INIT_VALUE_37),
                                                            .INIT_VALUE_38(INIT_VALUE_38),
                                                            .INIT_VALUE_39(INIT_VALUE_39),
                                                            .INIT_VALUE_3A(INIT_VALUE_3A),
                                                            .INIT_VALUE_3B(INIT_VALUE_3B),
                                                            .INIT_VALUE_3C(INIT_VALUE_3C),
                                                            .INIT_VALUE_3D(INIT_VALUE_3D),
                                                            .INIT_VALUE_3E(INIT_VALUE_3E),
                                                            .INIT_VALUE_3F(INIT_VALUE_3F)) u_mem (.wr_clk_i(pdp_wrclock), 
                                                                .rd_clk_i(pdp_rdclock), 
                                                                .rst_i(pdp_reset), 
                                                                .wr_clk_en_i(pdp_wrclocken), 
                                                                .rd_clk_en_i(pdp_rdclocken), 
                                                                .ben_i(pdp_byteen), 
                                                                .rd_out_clk_en_i(1'b1), 
                                                                .wr_en_i(pdp_wr_en), 
                                                                .wr_data_i(pdp_data), 
                                                                .wr_addr_i(pdp_wraddress), 
                                                                .rd_en_i(pdp_rdclocken), 
                                                                .rd_addr_i(pdp_rdaddress), 
                                                                .rd_data_o(pdp_q), 
                                                                .one_err_det_o(pdp_err_det[0]), 
                                                                .two_err_det_o(pdp_err_det[1])) ; 
                                                end
                                            else
                                                begin : LAVAT
                                                    lscc_ram_dp #(.FAMILY(FAMILY),
                                                            .WADDR_DEPTH(ADDR_DEPTH),
                                                            .WADDR_WIDTH(ADDR_WIDTH),
                                                            .WDATA_WIDTH(DATA_WIDTH),
                                                            .RADDR_DEPTH(ADDR_DEPTH),
                                                            .RADDR_WIDTH(ADDR_WIDTH),
                                                            .RDATA_WIDTH(DATA_WIDTH),
                                                            .MEM_SIZE(MEM_SIZE),
                                                            .MEM_ID(MEM_ID),
                                                            .REGMODE(((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? MEM_REGMODE_A : MEM_REGMODE_B)),
                                                            .RESETMODE(((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? MEM_RESETMODE_A : MEM_RESETMODE_B)),
                                                            .RESET_RELEASE("sync"),
                                                            .INIT_FILE(INIT_FILE),
                                                            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                                                            .INIT_MODE(((INIT_FILE == "none") ? "none" : "mem_file")),
                                                            .INIT_DATA_TYPE(1),
                                                            .BYTE_ENABLE(((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "W/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? BYTE_ENABLE_S0 : BYTE_ENABLE_S1)),
                                                            .BYTE_SIZE(8),
                                                            .ECC_ENABLE(ECC_ENABLE),
                                                            .INIT_VALUE_00(INIT_VALUE_00),
                                                            .INIT_VALUE_01(INIT_VALUE_01),
                                                            .INIT_VALUE_02(INIT_VALUE_02),
                                                            .INIT_VALUE_03(INIT_VALUE_03),
                                                            .INIT_VALUE_04(INIT_VALUE_04),
                                                            .INIT_VALUE_05(INIT_VALUE_05),
                                                            .INIT_VALUE_06(INIT_VALUE_06),
                                                            .INIT_VALUE_07(INIT_VALUE_07),
                                                            .INIT_VALUE_08(INIT_VALUE_08),
                                                            .INIT_VALUE_09(INIT_VALUE_09),
                                                            .INIT_VALUE_0A(INIT_VALUE_0A),
                                                            .INIT_VALUE_0B(INIT_VALUE_0B),
                                                            .INIT_VALUE_0C(INIT_VALUE_0C),
                                                            .INIT_VALUE_0D(INIT_VALUE_0D),
                                                            .INIT_VALUE_0E(INIT_VALUE_0E),
                                                            .INIT_VALUE_0F(INIT_VALUE_0F),
                                                            .INIT_VALUE_10(INIT_VALUE_10),
                                                            .INIT_VALUE_11(INIT_VALUE_11),
                                                            .INIT_VALUE_12(INIT_VALUE_12),
                                                            .INIT_VALUE_13(INIT_VALUE_13),
                                                            .INIT_VALUE_14(INIT_VALUE_14),
                                                            .INIT_VALUE_15(INIT_VALUE_15),
                                                            .INIT_VALUE_16(INIT_VALUE_16),
                                                            .INIT_VALUE_17(INIT_VALUE_17),
                                                            .INIT_VALUE_18(INIT_VALUE_18),
                                                            .INIT_VALUE_19(INIT_VALUE_19),
                                                            .INIT_VALUE_1A(INIT_VALUE_1A),
                                                            .INIT_VALUE_1B(INIT_VALUE_1B),
                                                            .INIT_VALUE_1C(INIT_VALUE_1C),
                                                            .INIT_VALUE_1D(INIT_VALUE_1D),
                                                            .INIT_VALUE_1E(INIT_VALUE_1E),
                                                            .INIT_VALUE_1F(INIT_VALUE_1F),
                                                            .INIT_VALUE_20(INIT_VALUE_20),
                                                            .INIT_VALUE_21(INIT_VALUE_21),
                                                            .INIT_VALUE_22(INIT_VALUE_22),
                                                            .INIT_VALUE_23(INIT_VALUE_23),
                                                            .INIT_VALUE_24(INIT_VALUE_24),
                                                            .INIT_VALUE_25(INIT_VALUE_25),
                                                            .INIT_VALUE_26(INIT_VALUE_26),
                                                            .INIT_VALUE_27(INIT_VALUE_27),
                                                            .INIT_VALUE_28(INIT_VALUE_28),
                                                            .INIT_VALUE_29(INIT_VALUE_29),
                                                            .INIT_VALUE_2A(INIT_VALUE_2A),
                                                            .INIT_VALUE_2B(INIT_VALUE_2B),
                                                            .INIT_VALUE_2C(INIT_VALUE_2C),
                                                            .INIT_VALUE_2D(INIT_VALUE_2D),
                                                            .INIT_VALUE_2E(INIT_VALUE_2E),
                                                            .INIT_VALUE_2F(INIT_VALUE_2F),
                                                            .INIT_VALUE_30(INIT_VALUE_30),
                                                            .INIT_VALUE_31(INIT_VALUE_31),
                                                            .INIT_VALUE_32(INIT_VALUE_32),
                                                            .INIT_VALUE_33(INIT_VALUE_33),
                                                            .INIT_VALUE_34(INIT_VALUE_34),
                                                            .INIT_VALUE_35(INIT_VALUE_35),
                                                            .INIT_VALUE_36(INIT_VALUE_36),
                                                            .INIT_VALUE_37(INIT_VALUE_37),
                                                            .INIT_VALUE_38(INIT_VALUE_38),
                                                            .INIT_VALUE_39(INIT_VALUE_39),
                                                            .INIT_VALUE_3A(INIT_VALUE_3A),
                                                            .INIT_VALUE_3B(INIT_VALUE_3B),
                                                            .INIT_VALUE_3C(INIT_VALUE_3C),
                                                            .INIT_VALUE_3D(INIT_VALUE_3D),
                                                            .INIT_VALUE_3E(INIT_VALUE_3E),
                                                            .INIT_VALUE_3F(INIT_VALUE_3F),
                                                            .INIT_VALUE_40(INIT_VALUE_40),
                                                            .INIT_VALUE_41(INIT_VALUE_41),
                                                            .INIT_VALUE_42(INIT_VALUE_42),
                                                            .INIT_VALUE_43(INIT_VALUE_43),
                                                            .INIT_VALUE_44(INIT_VALUE_44),
                                                            .INIT_VALUE_45(INIT_VALUE_45),
                                                            .INIT_VALUE_46(INIT_VALUE_46),
                                                            .INIT_VALUE_47(INIT_VALUE_47),
                                                            .INIT_VALUE_48(INIT_VALUE_48),
                                                            .INIT_VALUE_49(INIT_VALUE_49),
                                                            .INIT_VALUE_4A(INIT_VALUE_4A),
                                                            .INIT_VALUE_4B(INIT_VALUE_4B),
                                                            .INIT_VALUE_4C(INIT_VALUE_4C),
                                                            .INIT_VALUE_4D(INIT_VALUE_4D),
                                                            .INIT_VALUE_4E(INIT_VALUE_4E),
                                                            .INIT_VALUE_4F(INIT_VALUE_4F),
                                                            .INIT_VALUE_50(INIT_VALUE_50),
                                                            .INIT_VALUE_51(INIT_VALUE_51),
                                                            .INIT_VALUE_52(INIT_VALUE_52),
                                                            .INIT_VALUE_53(INIT_VALUE_53),
                                                            .INIT_VALUE_54(INIT_VALUE_54),
                                                            .INIT_VALUE_55(INIT_VALUE_55),
                                                            .INIT_VALUE_56(INIT_VALUE_56),
                                                            .INIT_VALUE_57(INIT_VALUE_57),
                                                            .INIT_VALUE_58(INIT_VALUE_58),
                                                            .INIT_VALUE_59(INIT_VALUE_59),
                                                            .INIT_VALUE_5A(INIT_VALUE_5A),
                                                            .INIT_VALUE_5B(INIT_VALUE_5B),
                                                            .INIT_VALUE_5C(INIT_VALUE_5C),
                                                            .INIT_VALUE_5D(INIT_VALUE_5D),
                                                            .INIT_VALUE_5E(INIT_VALUE_5E),
                                                            .INIT_VALUE_5F(INIT_VALUE_5F),
                                                            .INIT_VALUE_60(INIT_VALUE_60),
                                                            .INIT_VALUE_61(INIT_VALUE_61),
                                                            .INIT_VALUE_62(INIT_VALUE_62),
                                                            .INIT_VALUE_63(INIT_VALUE_63),
                                                            .INIT_VALUE_64(INIT_VALUE_64),
                                                            .INIT_VALUE_65(INIT_VALUE_65),
                                                            .INIT_VALUE_66(INIT_VALUE_66),
                                                            .INIT_VALUE_67(INIT_VALUE_67),
                                                            .INIT_VALUE_68(INIT_VALUE_68),
                                                            .INIT_VALUE_69(INIT_VALUE_69),
                                                            .INIT_VALUE_6A(INIT_VALUE_6A),
                                                            .INIT_VALUE_6B(INIT_VALUE_6B),
                                                            .INIT_VALUE_6C(INIT_VALUE_6C),
                                                            .INIT_VALUE_6D(INIT_VALUE_6D),
                                                            .INIT_VALUE_6E(INIT_VALUE_6E),
                                                            .INIT_VALUE_6F(INIT_VALUE_6F),
                                                            .INIT_VALUE_70(INIT_VALUE_70),
                                                            .INIT_VALUE_71(INIT_VALUE_71),
                                                            .INIT_VALUE_72(INIT_VALUE_72),
                                                            .INIT_VALUE_73(INIT_VALUE_73),
                                                            .INIT_VALUE_74(INIT_VALUE_74),
                                                            .INIT_VALUE_75(INIT_VALUE_75),
                                                            .INIT_VALUE_76(INIT_VALUE_76),
                                                            .INIT_VALUE_77(INIT_VALUE_77),
                                                            .INIT_VALUE_78(INIT_VALUE_78),
                                                            .INIT_VALUE_79(INIT_VALUE_79),
                                                            .INIT_VALUE_7A(INIT_VALUE_7A),
                                                            .INIT_VALUE_7B(INIT_VALUE_7B),
                                                            .INIT_VALUE_7C(INIT_VALUE_7C),
                                                            .INIT_VALUE_7D(INIT_VALUE_7D),
                                                            .INIT_VALUE_7E(INIT_VALUE_7E),
                                                            .INIT_VALUE_7F(INIT_VALUE_7F)) u_mem (.wr_clk_i(pdp_wrclock), 
                                                                .rd_clk_i(pdp_rdclock), 
                                                                .rst_i(pdp_reset), 
                                                                .wr_clk_en_i(pdp_wrclocken), 
                                                                .rd_clk_en_i(pdp_rdclocken), 
                                                                .ben_i(pdp_byteen), 
                                                                .rd_out_clk_en_i(1'b1), 
                                                                .wr_en_i(pdp_wr_en), 
                                                                .wr_data_i(pdp_data), 
                                                                .wr_addr_i(pdp_wraddress), 
                                                                .rd_en_i(pdp_rdclocken), 
                                                                .rd_addr_i(pdp_rdaddress), 
                                                                .rd_data_o(pdp_q), 
                                                                .one_err_det_o(pdp_err_det[0]), 
                                                                .two_err_det_o(pdp_err_det[1])) ; 
                                                end
                                        end
                                    else
                                        begin : dp
                                            localparam T_BYTE_AWID = (BYTE_ENABLE_S0 ? BYTE_WIDTH : 1) ; 
                                            localparam T_BYTE_BWID = (BYTE_ENABLE_S1 ? BYTE_WIDTH : 1) ; 
                                            wire [(T_BYTE_AWID - 1):0] dpben_a_w = (BYTE_ENABLE_S0 ? dp_byteen_a : {T_BYTE_AWID{1'b1}}) ; 
                                            wire [(T_BYTE_BWID - 1):0] dpben_b_w = (BYTE_ENABLE_S1 ? dp_byteen_b : {T_BYTE_BWID{1'b1}}) ; 
                                            if ((FAMILY == "LIFCL")) 
                                                begin : LIFCL
                                                    lscc_ram_dp_true #(.ADDR_DEPTH_A(ADDR_DEPTH),
                                                            .ADDR_WIDTH_A(ADDR_WIDTH),
                                                            .DATA_WIDTH_A(DATA_WIDTH),
                                                            .ADDR_DEPTH_B(ADDR_DEPTH),
                                                            .ADDR_WIDTH_B(ADDR_WIDTH),
                                                            .DATA_WIDTH_B(DATA_WIDTH),
                                                            .REGMODE_A(MEM_REGMODE_A),
                                                            .REGMODE_B(MEM_REGMODE_B),
                                                            .RESETMODE_A(MEM_RESETMODE_A),
                                                            .RESETMODE_B(MEM_RESETMODE_B),
                                                            .RESET_RELEASE_A("sync"),
                                                            .RESET_RELEASE_B("sync"),
                                                            .INIT_FILE(INIT_FILE),
                                                            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                                                            .FAMILY(FAMILY),
                                                            .INIT_MODE(((INIT_FILE == "none") ? "none" : "mem_file")),
                                                            .BYTE_ENABLE_A(BYTE_ENABLE_S0),
                                                            .BYTE_SIZE_A(8),
                                                            .BYTE_ENABLE_B(BYTE_ENABLE_S1),
                                                            .BYTE_SIZE_B(8),
                                                            .ECC_ENABLE(ECC_ENABLE),
                                                            .MEM_SIZE(MEM_SIZE),
                                                            .MEM_ID(MEM_ID),
                                                            .INIT_VALUE_00(INIT_VALUE_00),
                                                            .INIT_VALUE_01(INIT_VALUE_01),
                                                            .INIT_VALUE_02(INIT_VALUE_02),
                                                            .INIT_VALUE_03(INIT_VALUE_03),
                                                            .INIT_VALUE_04(INIT_VALUE_04),
                                                            .INIT_VALUE_05(INIT_VALUE_05),
                                                            .INIT_VALUE_06(INIT_VALUE_06),
                                                            .INIT_VALUE_07(INIT_VALUE_07),
                                                            .INIT_VALUE_08(INIT_VALUE_08),
                                                            .INIT_VALUE_09(INIT_VALUE_09),
                                                            .INIT_VALUE_0A(INIT_VALUE_0A),
                                                            .INIT_VALUE_0B(INIT_VALUE_0B),
                                                            .INIT_VALUE_0C(INIT_VALUE_0C),
                                                            .INIT_VALUE_0D(INIT_VALUE_0D),
                                                            .INIT_VALUE_0E(INIT_VALUE_0E),
                                                            .INIT_VALUE_0F(INIT_VALUE_0F),
                                                            .INIT_VALUE_10(INIT_VALUE_10),
                                                            .INIT_VALUE_11(INIT_VALUE_11),
                                                            .INIT_VALUE_12(INIT_VALUE_12),
                                                            .INIT_VALUE_13(INIT_VALUE_13),
                                                            .INIT_VALUE_14(INIT_VALUE_14),
                                                            .INIT_VALUE_15(INIT_VALUE_15),
                                                            .INIT_VALUE_16(INIT_VALUE_16),
                                                            .INIT_VALUE_17(INIT_VALUE_17),
                                                            .INIT_VALUE_18(INIT_VALUE_18),
                                                            .INIT_VALUE_19(INIT_VALUE_19),
                                                            .INIT_VALUE_1A(INIT_VALUE_1A),
                                                            .INIT_VALUE_1B(INIT_VALUE_1B),
                                                            .INIT_VALUE_1C(INIT_VALUE_1C),
                                                            .INIT_VALUE_1D(INIT_VALUE_1D),
                                                            .INIT_VALUE_1E(INIT_VALUE_1E),
                                                            .INIT_VALUE_1F(INIT_VALUE_1F),
                                                            .INIT_VALUE_20(INIT_VALUE_20),
                                                            .INIT_VALUE_21(INIT_VALUE_21),
                                                            .INIT_VALUE_22(INIT_VALUE_22),
                                                            .INIT_VALUE_23(INIT_VALUE_23),
                                                            .INIT_VALUE_24(INIT_VALUE_24),
                                                            .INIT_VALUE_25(INIT_VALUE_25),
                                                            .INIT_VALUE_26(INIT_VALUE_26),
                                                            .INIT_VALUE_27(INIT_VALUE_27),
                                                            .INIT_VALUE_28(INIT_VALUE_28),
                                                            .INIT_VALUE_29(INIT_VALUE_29),
                                                            .INIT_VALUE_2A(INIT_VALUE_2A),
                                                            .INIT_VALUE_2B(INIT_VALUE_2B),
                                                            .INIT_VALUE_2C(INIT_VALUE_2C),
                                                            .INIT_VALUE_2D(INIT_VALUE_2D),
                                                            .INIT_VALUE_2E(INIT_VALUE_2E),
                                                            .INIT_VALUE_2F(INIT_VALUE_2F),
                                                            .INIT_VALUE_30(INIT_VALUE_30),
                                                            .INIT_VALUE_31(INIT_VALUE_31),
                                                            .INIT_VALUE_32(INIT_VALUE_32),
                                                            .INIT_VALUE_33(INIT_VALUE_33),
                                                            .INIT_VALUE_34(INIT_VALUE_34),
                                                            .INIT_VALUE_35(INIT_VALUE_35),
                                                            .INIT_VALUE_36(INIT_VALUE_36),
                                                            .INIT_VALUE_37(INIT_VALUE_37),
                                                            .INIT_VALUE_38(INIT_VALUE_38),
                                                            .INIT_VALUE_39(INIT_VALUE_39),
                                                            .INIT_VALUE_3A(INIT_VALUE_3A),
                                                            .INIT_VALUE_3B(INIT_VALUE_3B),
                                                            .INIT_VALUE_3C(INIT_VALUE_3C),
                                                            .INIT_VALUE_3D(INIT_VALUE_3D),
                                                            .INIT_VALUE_3E(INIT_VALUE_3E),
                                                            .INIT_VALUE_3F(INIT_VALUE_3F)) u_mem (.addr_a_i(dp_address_a), 
                                                                .addr_b_i(dp_address_b), 
                                                                .wr_data_a_i(dp_datain_a), 
                                                                .wr_data_b_i(dp_datain_b), 
                                                                .clk_a_i(dp_clock_a), 
                                                                .clk_b_i(dp_clock_b), 
                                                                .clk_en_a_i(dp_clocken_a), 
                                                                .clk_en_b_i(dp_clocken_b), 
                                                                .wr_en_a_i(dp_wr_a), 
                                                                .wr_en_b_i(dp_wr_b), 
                                                                .rst_a_i(dp_reset_a), 
                                                                .rst_b_i(dp_reset_b), 
                                                                .ben_a_i(dpben_a_w), 
                                                                .ben_b_i(dpben_b_w), 
                                                                .rd_data_a_o(dp_q_a), 
                                                                .rd_data_b_o(dp_q_b), 
                                                                .ecc_one_err_a_o(), 
                                                                .ecc_two_err_a_o(), 
                                                                .ecc_one_err_b_o(), 
                                                                .ecc_two_err_b_o()) ; 
                                                end
                                            else
                                                begin : LAVAT
                                                    lscc_ram_dp_true #(.ADDR_DEPTH_A(ADDR_DEPTH),
                                                            .ADDR_WIDTH_A(ADDR_WIDTH),
                                                            .DATA_WIDTH_A(DATA_WIDTH),
                                                            .ADDR_DEPTH_B(ADDR_DEPTH),
                                                            .ADDR_WIDTH_B(ADDR_WIDTH),
                                                            .DATA_WIDTH_B(DATA_WIDTH),
                                                            .REGMODE_A(MEM_REGMODE_A),
                                                            .REGMODE_B(MEM_REGMODE_B),
                                                            .RESETMODE_A(MEM_RESETMODE_A),
                                                            .RESETMODE_B(MEM_RESETMODE_B),
                                                            .RESET_RELEASE_A("sync"),
                                                            .RESET_RELEASE_B("sync"),
                                                            .INIT_FILE(INIT_FILE),
                                                            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                                                            .INIT_DATA_TYPE(1),
                                                            .FAMILY(FAMILY),
                                                            .INIT_MODE(((INIT_FILE == "none") ? "none" : "mem_file")),
                                                            .BYTE_ENABLE_A(BYTE_ENABLE_S0),
                                                            .BYTE_SIZE_A(8),
                                                            .BYTE_ENABLE_B(BYTE_ENABLE_S1),
                                                            .BYTE_SIZE_B(8),
                                                            .ECC_ENABLE(ECC_ENABLE),
                                                            .MEM_SIZE(MEM_SIZE),
                                                            .MEM_ID(MEM_ID),
                                                            .INIT_VALUE_00(INIT_VALUE_00),
                                                            .INIT_VALUE_01(INIT_VALUE_01),
                                                            .INIT_VALUE_02(INIT_VALUE_02),
                                                            .INIT_VALUE_03(INIT_VALUE_03),
                                                            .INIT_VALUE_04(INIT_VALUE_04),
                                                            .INIT_VALUE_05(INIT_VALUE_05),
                                                            .INIT_VALUE_06(INIT_VALUE_06),
                                                            .INIT_VALUE_07(INIT_VALUE_07),
                                                            .INIT_VALUE_08(INIT_VALUE_08),
                                                            .INIT_VALUE_09(INIT_VALUE_09),
                                                            .INIT_VALUE_0A(INIT_VALUE_0A),
                                                            .INIT_VALUE_0B(INIT_VALUE_0B),
                                                            .INIT_VALUE_0C(INIT_VALUE_0C),
                                                            .INIT_VALUE_0D(INIT_VALUE_0D),
                                                            .INIT_VALUE_0E(INIT_VALUE_0E),
                                                            .INIT_VALUE_0F(INIT_VALUE_0F),
                                                            .INIT_VALUE_10(INIT_VALUE_10),
                                                            .INIT_VALUE_11(INIT_VALUE_11),
                                                            .INIT_VALUE_12(INIT_VALUE_12),
                                                            .INIT_VALUE_13(INIT_VALUE_13),
                                                            .INIT_VALUE_14(INIT_VALUE_14),
                                                            .INIT_VALUE_15(INIT_VALUE_15),
                                                            .INIT_VALUE_16(INIT_VALUE_16),
                                                            .INIT_VALUE_17(INIT_VALUE_17),
                                                            .INIT_VALUE_18(INIT_VALUE_18),
                                                            .INIT_VALUE_19(INIT_VALUE_19),
                                                            .INIT_VALUE_1A(INIT_VALUE_1A),
                                                            .INIT_VALUE_1B(INIT_VALUE_1B),
                                                            .INIT_VALUE_1C(INIT_VALUE_1C),
                                                            .INIT_VALUE_1D(INIT_VALUE_1D),
                                                            .INIT_VALUE_1E(INIT_VALUE_1E),
                                                            .INIT_VALUE_1F(INIT_VALUE_1F),
                                                            .INIT_VALUE_20(INIT_VALUE_20),
                                                            .INIT_VALUE_21(INIT_VALUE_21),
                                                            .INIT_VALUE_22(INIT_VALUE_22),
                                                            .INIT_VALUE_23(INIT_VALUE_23),
                                                            .INIT_VALUE_24(INIT_VALUE_24),
                                                            .INIT_VALUE_25(INIT_VALUE_25),
                                                            .INIT_VALUE_26(INIT_VALUE_26),
                                                            .INIT_VALUE_27(INIT_VALUE_27),
                                                            .INIT_VALUE_28(INIT_VALUE_28),
                                                            .INIT_VALUE_29(INIT_VALUE_29),
                                                            .INIT_VALUE_2A(INIT_VALUE_2A),
                                                            .INIT_VALUE_2B(INIT_VALUE_2B),
                                                            .INIT_VALUE_2C(INIT_VALUE_2C),
                                                            .INIT_VALUE_2D(INIT_VALUE_2D),
                                                            .INIT_VALUE_2E(INIT_VALUE_2E),
                                                            .INIT_VALUE_2F(INIT_VALUE_2F),
                                                            .INIT_VALUE_30(INIT_VALUE_30),
                                                            .INIT_VALUE_31(INIT_VALUE_31),
                                                            .INIT_VALUE_32(INIT_VALUE_32),
                                                            .INIT_VALUE_33(INIT_VALUE_33),
                                                            .INIT_VALUE_34(INIT_VALUE_34),
                                                            .INIT_VALUE_35(INIT_VALUE_35),
                                                            .INIT_VALUE_36(INIT_VALUE_36),
                                                            .INIT_VALUE_37(INIT_VALUE_37),
                                                            .INIT_VALUE_38(INIT_VALUE_38),
                                                            .INIT_VALUE_39(INIT_VALUE_39),
                                                            .INIT_VALUE_3A(INIT_VALUE_3A),
                                                            .INIT_VALUE_3B(INIT_VALUE_3B),
                                                            .INIT_VALUE_3C(INIT_VALUE_3C),
                                                            .INIT_VALUE_3D(INIT_VALUE_3D),
                                                            .INIT_VALUE_3E(INIT_VALUE_3E),
                                                            .INIT_VALUE_3F(INIT_VALUE_3F),
                                                            .INIT_VALUE_40(INIT_VALUE_40),
                                                            .INIT_VALUE_41(INIT_VALUE_41),
                                                            .INIT_VALUE_42(INIT_VALUE_42),
                                                            .INIT_VALUE_43(INIT_VALUE_43),
                                                            .INIT_VALUE_44(INIT_VALUE_44),
                                                            .INIT_VALUE_45(INIT_VALUE_45),
                                                            .INIT_VALUE_46(INIT_VALUE_46),
                                                            .INIT_VALUE_47(INIT_VALUE_47),
                                                            .INIT_VALUE_48(INIT_VALUE_48),
                                                            .INIT_VALUE_49(INIT_VALUE_49),
                                                            .INIT_VALUE_4A(INIT_VALUE_4A),
                                                            .INIT_VALUE_4B(INIT_VALUE_4B),
                                                            .INIT_VALUE_4C(INIT_VALUE_4C),
                                                            .INIT_VALUE_4D(INIT_VALUE_4D),
                                                            .INIT_VALUE_4E(INIT_VALUE_4E),
                                                            .INIT_VALUE_4F(INIT_VALUE_4F),
                                                            .INIT_VALUE_50(INIT_VALUE_50),
                                                            .INIT_VALUE_51(INIT_VALUE_51),
                                                            .INIT_VALUE_52(INIT_VALUE_52),
                                                            .INIT_VALUE_53(INIT_VALUE_53),
                                                            .INIT_VALUE_54(INIT_VALUE_54),
                                                            .INIT_VALUE_55(INIT_VALUE_55),
                                                            .INIT_VALUE_56(INIT_VALUE_56),
                                                            .INIT_VALUE_57(INIT_VALUE_57),
                                                            .INIT_VALUE_58(INIT_VALUE_58),
                                                            .INIT_VALUE_59(INIT_VALUE_59),
                                                            .INIT_VALUE_5A(INIT_VALUE_5A),
                                                            .INIT_VALUE_5B(INIT_VALUE_5B),
                                                            .INIT_VALUE_5C(INIT_VALUE_5C),
                                                            .INIT_VALUE_5D(INIT_VALUE_5D),
                                                            .INIT_VALUE_5E(INIT_VALUE_5E),
                                                            .INIT_VALUE_5F(INIT_VALUE_5F),
                                                            .INIT_VALUE_60(INIT_VALUE_60),
                                                            .INIT_VALUE_61(INIT_VALUE_61),
                                                            .INIT_VALUE_62(INIT_VALUE_62),
                                                            .INIT_VALUE_63(INIT_VALUE_63),
                                                            .INIT_VALUE_64(INIT_VALUE_64),
                                                            .INIT_VALUE_65(INIT_VALUE_65),
                                                            .INIT_VALUE_66(INIT_VALUE_66),
                                                            .INIT_VALUE_67(INIT_VALUE_67),
                                                            .INIT_VALUE_68(INIT_VALUE_68),
                                                            .INIT_VALUE_69(INIT_VALUE_69),
                                                            .INIT_VALUE_6A(INIT_VALUE_6A),
                                                            .INIT_VALUE_6B(INIT_VALUE_6B),
                                                            .INIT_VALUE_6C(INIT_VALUE_6C),
                                                            .INIT_VALUE_6D(INIT_VALUE_6D),
                                                            .INIT_VALUE_6E(INIT_VALUE_6E),
                                                            .INIT_VALUE_6F(INIT_VALUE_6F),
                                                            .INIT_VALUE_70(INIT_VALUE_70),
                                                            .INIT_VALUE_71(INIT_VALUE_71),
                                                            .INIT_VALUE_72(INIT_VALUE_72),
                                                            .INIT_VALUE_73(INIT_VALUE_73),
                                                            .INIT_VALUE_74(INIT_VALUE_74),
                                                            .INIT_VALUE_75(INIT_VALUE_75),
                                                            .INIT_VALUE_76(INIT_VALUE_76),
                                                            .INIT_VALUE_77(INIT_VALUE_77),
                                                            .INIT_VALUE_78(INIT_VALUE_78),
                                                            .INIT_VALUE_79(INIT_VALUE_79),
                                                            .INIT_VALUE_7A(INIT_VALUE_7A),
                                                            .INIT_VALUE_7B(INIT_VALUE_7B),
                                                            .INIT_VALUE_7C(INIT_VALUE_7C),
                                                            .INIT_VALUE_7D(INIT_VALUE_7D),
                                                            .INIT_VALUE_7E(INIT_VALUE_7E),
                                                            .INIT_VALUE_7F(INIT_VALUE_7F)) u_mem (.addr_a_i(dp_address_a), 
                                                                .addr_b_i(dp_address_b), 
                                                                .wr_data_a_i(dp_datain_a), 
                                                                .wr_data_b_i(dp_datain_b), 
                                                                .clk_a_i(dp_clock_a), 
                                                                .clk_b_i(dp_clock_b), 
                                                                .clk_en_a_i(dp_clocken_a), 
                                                                .clk_en_b_i(dp_clocken_b), 
                                                                .wr_en_a_i(dp_wr_a), 
                                                                .wr_en_b_i(dp_wr_b), 
                                                                .rst_a_i(dp_reset_a), 
                                                                .rst_b_i(dp_reset_b), 
                                                                .ben_a_i(dpben_a_w), 
                                                                .ben_b_i(dpben_b_w), 
                                                                .rd_data_a_o(dp_q_a), 
                                                                .rd_data_b_o(dp_q_b), 
                                                                .ecc_one_err_a_o(), 
                                                                .ecc_two_err_a_o(), 
                                                                .ecc_one_err_b_o(), 
                                                                .ecc_two_err_b_o()) ; 
                                                end
                                        end
                            end
                        else
                            if ((MEMORY_TYPE == "LRAM")) 
                                begin : lram
                                    if ((PORT_TYPE == "sp")) 
                                        begin : sp
                                            localparam T_BYTE_WIDTH = ((BYTE_ENABLE_S0 || UNALIGNED_ACCESS_ENABLE) ? BYTE_WIDTH : 1) ; 
                                            wire [(T_BYTE_WIDTH - 1):0] sp_ben_t_w = ((BYTE_ENABLE_S0 || UNALIGNED_ACCESS_ENABLE) ? sp_byteen : 1'b1) ; 
                                            wire [(3 * UNALIGNED_ACCESS_ENABLE):0] msp_ben_t_w = {((3 * UNALIGNED_ACCESS_ENABLE) + 1){1'b1}} ; 
                                            sysmem_ipgen_lscc_smem_lram #(.ADDR_DEPTH(ADDR_DEPTH),
                                                    .ADDR_WIDTH(ADDR_WIDTH),
                                                    .DATA_WIDTH(DATA_WIDTH),
                                                    .BYTE_ENABLE_A(BYTE_ENABLE_S0),
                                                    .BYTE_ENABLE_B(0),
                                                    .ECC_ENABLE(ECC_ENABLE),
                                                    .MEM_ID(MEM_ID),
                                                    .MEM_SIZE(MEM_SIZE),
                                                    .REGMODE_A(MEM_REGMODE_A),
                                                    .RESET_MODE(MEM_RESETMODE_A),
                                                    .ASYNC_RST_RELEASE("sync"),
                                                    .UNALIGNED_ACCESS_ENABLE(UNALIGNED_ACCESS_ENABLE),
                                                    .READ_PIPELINE_S0(READ_PIPELINE_S0),
                                                    .READ_PIPELINE_S1(READ_PIPELINE_S1),
                                                    .INIT_MODE((((INIT_FILE == "none") || (INIT_FILE_FORMAT == "none")) ? "none" : "mem_file")),
                                                    .INITVAL_00(INIT_VALUE_00),
                                                    .INITVAL_01(INIT_VALUE_01),
                                                    .INITVAL_02(INIT_VALUE_02),
                                                    .INITVAL_03(INIT_VALUE_03),
                                                    .INITVAL_04(INIT_VALUE_04),
                                                    .INITVAL_05(INIT_VALUE_05),
                                                    .INITVAL_06(INIT_VALUE_06),
                                                    .INITVAL_07(INIT_VALUE_07),
                                                    .INITVAL_08(INIT_VALUE_08),
                                                    .INITVAL_09(INIT_VALUE_09),
                                                    .INITVAL_0A(INIT_VALUE_0A),
                                                    .INITVAL_0B(INIT_VALUE_0B),
                                                    .INITVAL_0C(INIT_VALUE_0C),
                                                    .INITVAL_0D(INIT_VALUE_0D),
                                                    .INITVAL_0E(INIT_VALUE_0E),
                                                    .INITVAL_0F(INIT_VALUE_0F),
                                                    .INITVAL_10(INIT_VALUE_10),
                                                    .INITVAL_11(INIT_VALUE_11),
                                                    .INITVAL_12(INIT_VALUE_12),
                                                    .INITVAL_13(INIT_VALUE_13),
                                                    .INITVAL_14(INIT_VALUE_14),
                                                    .INITVAL_15(INIT_VALUE_15),
                                                    .INITVAL_16(INIT_VALUE_16),
                                                    .INITVAL_17(INIT_VALUE_17),
                                                    .INITVAL_18(INIT_VALUE_18),
                                                    .INITVAL_19(INIT_VALUE_19),
                                                    .INITVAL_1A(INIT_VALUE_1A),
                                                    .INITVAL_1B(INIT_VALUE_1B),
                                                    .INITVAL_1C(INIT_VALUE_1C),
                                                    .INITVAL_1D(INIT_VALUE_1D),
                                                    .INITVAL_1E(INIT_VALUE_1E),
                                                    .INITVAL_1F(INIT_VALUE_1F),
                                                    .INITVAL_20(INIT_VALUE_20),
                                                    .INITVAL_21(INIT_VALUE_21),
                                                    .INITVAL_22(INIT_VALUE_22),
                                                    .INITVAL_23(INIT_VALUE_23),
                                                    .INITVAL_24(INIT_VALUE_24),
                                                    .INITVAL_25(INIT_VALUE_25),
                                                    .INITVAL_26(INIT_VALUE_26),
                                                    .INITVAL_27(INIT_VALUE_27),
                                                    .INITVAL_28(INIT_VALUE_28),
                                                    .INITVAL_29(INIT_VALUE_29),
                                                    .INITVAL_2A(INIT_VALUE_2A),
                                                    .INITVAL_2B(INIT_VALUE_2B),
                                                    .INITVAL_2C(INIT_VALUE_2C),
                                                    .INITVAL_2D(INIT_VALUE_2D),
                                                    .INITVAL_2E(INIT_VALUE_2E),
                                                    .INITVAL_2F(INIT_VALUE_2F),
                                                    .INITVAL_30(INIT_VALUE_30),
                                                    .INITVAL_31(INIT_VALUE_31),
                                                    .INITVAL_32(INIT_VALUE_32),
                                                    .INITVAL_33(INIT_VALUE_33),
                                                    .INITVAL_34(INIT_VALUE_34),
                                                    .INITVAL_35(INIT_VALUE_35),
                                                    .INITVAL_36(INIT_VALUE_36),
                                                    .INITVAL_37(INIT_VALUE_37),
                                                    .INITVAL_38(INIT_VALUE_38),
                                                    .INITVAL_39(INIT_VALUE_39),
                                                    .INITVAL_3A(INIT_VALUE_3A),
                                                    .INITVAL_3B(INIT_VALUE_3B),
                                                    .INITVAL_3C(INIT_VALUE_3C),
                                                    .INITVAL_3D(INIT_VALUE_3D),
                                                    .INITVAL_3E(INIT_VALUE_3E),
                                                    .INITVAL_3F(INIT_VALUE_3F),
                                                    .INITVAL_40(INIT_VALUE_40),
                                                    .INITVAL_41(INIT_VALUE_41),
                                                    .INITVAL_42(INIT_VALUE_42),
                                                    .INITVAL_43(INIT_VALUE_43),
                                                    .INITVAL_44(INIT_VALUE_44),
                                                    .INITVAL_45(INIT_VALUE_45),
                                                    .INITVAL_46(INIT_VALUE_46),
                                                    .INITVAL_47(INIT_VALUE_47),
                                                    .INITVAL_48(INIT_VALUE_48),
                                                    .INITVAL_49(INIT_VALUE_49),
                                                    .INITVAL_4A(INIT_VALUE_4A),
                                                    .INITVAL_4B(INIT_VALUE_4B),
                                                    .INITVAL_4C(INIT_VALUE_4C),
                                                    .INITVAL_4D(INIT_VALUE_4D),
                                                    .INITVAL_4E(INIT_VALUE_4E),
                                                    .INITVAL_4F(INIT_VALUE_4F),
                                                    .INITVAL_50(INIT_VALUE_50),
                                                    .INITVAL_51(INIT_VALUE_51),
                                                    .INITVAL_52(INIT_VALUE_52),
                                                    .INITVAL_53(INIT_VALUE_53),
                                                    .INITVAL_54(INIT_VALUE_54),
                                                    .INITVAL_55(INIT_VALUE_55),
                                                    .INITVAL_56(INIT_VALUE_56),
                                                    .INITVAL_57(INIT_VALUE_57),
                                                    .INITVAL_58(INIT_VALUE_58),
                                                    .INITVAL_59(INIT_VALUE_59),
                                                    .INITVAL_5A(INIT_VALUE_5A),
                                                    .INITVAL_5B(INIT_VALUE_5B),
                                                    .INITVAL_5C(INIT_VALUE_5C),
                                                    .INITVAL_5D(INIT_VALUE_5D),
                                                    .INITVAL_5E(INIT_VALUE_5E),
                                                    .INITVAL_5F(INIT_VALUE_5F),
                                                    .INITVAL_60(INIT_VALUE_60),
                                                    .INITVAL_61(INIT_VALUE_61),
                                                    .INITVAL_62(INIT_VALUE_62),
                                                    .INITVAL_63(INIT_VALUE_63),
                                                    .INITVAL_64(INIT_VALUE_64),
                                                    .INITVAL_65(INIT_VALUE_65),
                                                    .INITVAL_66(INIT_VALUE_66),
                                                    .INITVAL_67(INIT_VALUE_67),
                                                    .INITVAL_68(INIT_VALUE_68),
                                                    .INITVAL_69(INIT_VALUE_69),
                                                    .INITVAL_6A(INIT_VALUE_6A),
                                                    .INITVAL_6B(INIT_VALUE_6B),
                                                    .INITVAL_6C(INIT_VALUE_6C),
                                                    .INITVAL_6D(INIT_VALUE_6D),
                                                    .INITVAL_6E(INIT_VALUE_6E),
                                                    .INITVAL_6F(INIT_VALUE_6F),
                                                    .INITVAL_70(INIT_VALUE_70),
                                                    .INITVAL_71(INIT_VALUE_71),
                                                    .INITVAL_72(INIT_VALUE_72),
                                                    .INITVAL_73(INIT_VALUE_73),
                                                    .INITVAL_74(INIT_VALUE_74),
                                                    .INITVAL_75(INIT_VALUE_75),
                                                    .INITVAL_76(INIT_VALUE_76),
                                                    .INITVAL_77(INIT_VALUE_77),
                                                    .INITVAL_78(INIT_VALUE_78),
                                                    .INITVAL_79(INIT_VALUE_79),
                                                    .INITVAL_7A(INIT_VALUE_7A),
                                                    .INITVAL_7B(INIT_VALUE_7B),
                                                    .INITVAL_7C(INIT_VALUE_7C),
                                                    .INITVAL_7D(INIT_VALUE_7D),
                                                    .INITVAL_7E(INIT_VALUE_7E),
                                                    .INITVAL_7F(INIT_VALUE_7F)) ulram_0 (.clk_i(sp_clock), 
                                                        .addr_a_i(sp_address[(ADDR_WIDTH - 1):0]), 
                                                        .wr_data_a_i(sp_data[(DATA_WIDTH - 1):0]), 
                                                        .clk_en_a_i(sp_clocken), 
                                                        .wr_en_a_i(sp_we), 
                                                        .rst_a_i(sp_reset), 
                                                        .ben_a_i(sp_ben_t_w), 
                                                        .rd_data_a_o(sp_q[(DATA_WIDTH - 1):0]), 
                                                        .addr_b_i({ADDR_WIDTH{1'b0}}), 
                                                        .wr_data_b_i({DATA_WIDTH{1'b0}}), 
                                                        .clk_en_b_i(1'b0), 
                                                        .wr_en_b_i(1'b0), 
                                                        .rst_b_i(sp_reset), 
                                                        .ben_b_i(msp_ben_t_w), 
                                                        .rd_data_b_o(), 
                                                        .dps_i(), 
                                                        .lramready_o(), 
                                                        .errdet_a_o(mem_error_a_o), 
                                                        .errdet_b_o()) ; 
                                        end
                                    else
                                        if ((PORT_TYPE == "pdp")) 
                                            begin : pdp
                                                localparam T_BYTE_WIDTH = ((((ACCESS_TYPE_S0 == "W/O") & (BYTE_ENABLE_S0 == 1)) || ((ACCESS_TYPE_S1 == "W/O") & (BYTE_ENABLE_S1 == 1))) ? BYTE_WIDTH : ((((ACCESS_TYPE_S0 == "R/O") & UNALIGNED_ACCESS_ENABLE) || ((ACCESS_TYPE_S1 == "R/O") & UNALIGNED_ACCESS_ENABLE)) ? BYTE_WIDTH : 1)) ; 
                                                wire [(T_BYTE_WIDTH - 1):0] pdp_ben_t_w = ((((ACCESS_TYPE_S0 == "W/O") & (BYTE_ENABLE_S0 == 1)) || ((ACCESS_TYPE_S1 == "W/O") & (BYTE_ENABLE_S1 == 1))) ? pdp_byteen : ((((ACCESS_TYPE_S0 == "R/O") & UNALIGNED_ACCESS_ENABLE) || ((ACCESS_TYPE_S1 == "R/O") & UNALIGNED_ACCESS_ENABLE)) ? pdp_byteen : 1'b1)) ; 
                                                sysmem_ipgen_lscc_smem_lram #(.ADDR_DEPTH(ADDR_DEPTH),
                                                        .ADDR_WIDTH(ADDR_WIDTH),
                                                        .DATA_WIDTH(DATA_WIDTH),
                                                        .BYTE_ENABLE_A(((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "W/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? BYTE_ENABLE_S0 : BYTE_ENABLE_S1)),
                                                        .ECC_ENABLE(ECC_ENABLE),
                                                        .MEM_ID(MEM_ID),
                                                        .MEM_SIZE(MEM_SIZE),
                                                        .REGMODE_B(((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? MEM_REGMODE_A : MEM_REGMODE_B)),
                                                        .RESET_MODE(((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? MEM_RESETMODE_A : MEM_RESETMODE_B)),
                                                        .ASYNC_RST_RELEASE("sync"),
                                                        .UNALIGNED_ACCESS_ENABLE(UNALIGNED_ACCESS_ENABLE),
                                                        .READ_PIPELINE_S0(READ_PIPELINE_S0),
                                                        .READ_PIPELINE_S1(READ_PIPELINE_S1),
                                                        .INIT_MODE((((INIT_FILE == "none") || (INIT_FILE_FORMAT == "none")) ? "none" : "mem_file")),
                                                        .INITVAL_00(INIT_VALUE_00),
                                                        .INITVAL_01(INIT_VALUE_01),
                                                        .INITVAL_02(INIT_VALUE_02),
                                                        .INITVAL_03(INIT_VALUE_03),
                                                        .INITVAL_04(INIT_VALUE_04),
                                                        .INITVAL_05(INIT_VALUE_05),
                                                        .INITVAL_06(INIT_VALUE_06),
                                                        .INITVAL_07(INIT_VALUE_07),
                                                        .INITVAL_08(INIT_VALUE_08),
                                                        .INITVAL_09(INIT_VALUE_09),
                                                        .INITVAL_0A(INIT_VALUE_0A),
                                                        .INITVAL_0B(INIT_VALUE_0B),
                                                        .INITVAL_0C(INIT_VALUE_0C),
                                                        .INITVAL_0D(INIT_VALUE_0D),
                                                        .INITVAL_0E(INIT_VALUE_0E),
                                                        .INITVAL_0F(INIT_VALUE_0F),
                                                        .INITVAL_10(INIT_VALUE_10),
                                                        .INITVAL_11(INIT_VALUE_11),
                                                        .INITVAL_12(INIT_VALUE_12),
                                                        .INITVAL_13(INIT_VALUE_13),
                                                        .INITVAL_14(INIT_VALUE_14),
                                                        .INITVAL_15(INIT_VALUE_15),
                                                        .INITVAL_16(INIT_VALUE_16),
                                                        .INITVAL_17(INIT_VALUE_17),
                                                        .INITVAL_18(INIT_VALUE_18),
                                                        .INITVAL_19(INIT_VALUE_19),
                                                        .INITVAL_1A(INIT_VALUE_1A),
                                                        .INITVAL_1B(INIT_VALUE_1B),
                                                        .INITVAL_1C(INIT_VALUE_1C),
                                                        .INITVAL_1D(INIT_VALUE_1D),
                                                        .INITVAL_1E(INIT_VALUE_1E),
                                                        .INITVAL_1F(INIT_VALUE_1F),
                                                        .INITVAL_20(INIT_VALUE_20),
                                                        .INITVAL_21(INIT_VALUE_21),
                                                        .INITVAL_22(INIT_VALUE_22),
                                                        .INITVAL_23(INIT_VALUE_23),
                                                        .INITVAL_24(INIT_VALUE_24),
                                                        .INITVAL_25(INIT_VALUE_25),
                                                        .INITVAL_26(INIT_VALUE_26),
                                                        .INITVAL_27(INIT_VALUE_27),
                                                        .INITVAL_28(INIT_VALUE_28),
                                                        .INITVAL_29(INIT_VALUE_29),
                                                        .INITVAL_2A(INIT_VALUE_2A),
                                                        .INITVAL_2B(INIT_VALUE_2B),
                                                        .INITVAL_2C(INIT_VALUE_2C),
                                                        .INITVAL_2D(INIT_VALUE_2D),
                                                        .INITVAL_2E(INIT_VALUE_2E),
                                                        .INITVAL_2F(INIT_VALUE_2F),
                                                        .INITVAL_30(INIT_VALUE_30),
                                                        .INITVAL_31(INIT_VALUE_31),
                                                        .INITVAL_32(INIT_VALUE_32),
                                                        .INITVAL_33(INIT_VALUE_33),
                                                        .INITVAL_34(INIT_VALUE_34),
                                                        .INITVAL_35(INIT_VALUE_35),
                                                        .INITVAL_36(INIT_VALUE_36),
                                                        .INITVAL_37(INIT_VALUE_37),
                                                        .INITVAL_38(INIT_VALUE_38),
                                                        .INITVAL_39(INIT_VALUE_39),
                                                        .INITVAL_3A(INIT_VALUE_3A),
                                                        .INITVAL_3B(INIT_VALUE_3B),
                                                        .INITVAL_3C(INIT_VALUE_3C),
                                                        .INITVAL_3D(INIT_VALUE_3D),
                                                        .INITVAL_3E(INIT_VALUE_3E),
                                                        .INITVAL_3F(INIT_VALUE_3F),
                                                        .INITVAL_40(INIT_VALUE_40),
                                                        .INITVAL_41(INIT_VALUE_41),
                                                        .INITVAL_42(INIT_VALUE_42),
                                                        .INITVAL_43(INIT_VALUE_43),
                                                        .INITVAL_44(INIT_VALUE_44),
                                                        .INITVAL_45(INIT_VALUE_45),
                                                        .INITVAL_46(INIT_VALUE_46),
                                                        .INITVAL_47(INIT_VALUE_47),
                                                        .INITVAL_48(INIT_VALUE_48),
                                                        .INITVAL_49(INIT_VALUE_49),
                                                        .INITVAL_4A(INIT_VALUE_4A),
                                                        .INITVAL_4B(INIT_VALUE_4B),
                                                        .INITVAL_4C(INIT_VALUE_4C),
                                                        .INITVAL_4D(INIT_VALUE_4D),
                                                        .INITVAL_4E(INIT_VALUE_4E),
                                                        .INITVAL_4F(INIT_VALUE_4F),
                                                        .INITVAL_50(INIT_VALUE_50),
                                                        .INITVAL_51(INIT_VALUE_51),
                                                        .INITVAL_52(INIT_VALUE_52),
                                                        .INITVAL_53(INIT_VALUE_53),
                                                        .INITVAL_54(INIT_VALUE_54),
                                                        .INITVAL_55(INIT_VALUE_55),
                                                        .INITVAL_56(INIT_VALUE_56),
                                                        .INITVAL_57(INIT_VALUE_57),
                                                        .INITVAL_58(INIT_VALUE_58),
                                                        .INITVAL_59(INIT_VALUE_59),
                                                        .INITVAL_5A(INIT_VALUE_5A),
                                                        .INITVAL_5B(INIT_VALUE_5B),
                                                        .INITVAL_5C(INIT_VALUE_5C),
                                                        .INITVAL_5D(INIT_VALUE_5D),
                                                        .INITVAL_5E(INIT_VALUE_5E),
                                                        .INITVAL_5F(INIT_VALUE_5F),
                                                        .INITVAL_60(INIT_VALUE_60),
                                                        .INITVAL_61(INIT_VALUE_61),
                                                        .INITVAL_62(INIT_VALUE_62),
                                                        .INITVAL_63(INIT_VALUE_63),
                                                        .INITVAL_64(INIT_VALUE_64),
                                                        .INITVAL_65(INIT_VALUE_65),
                                                        .INITVAL_66(INIT_VALUE_66),
                                                        .INITVAL_67(INIT_VALUE_67),
                                                        .INITVAL_68(INIT_VALUE_68),
                                                        .INITVAL_69(INIT_VALUE_69),
                                                        .INITVAL_6A(INIT_VALUE_6A),
                                                        .INITVAL_6B(INIT_VALUE_6B),
                                                        .INITVAL_6C(INIT_VALUE_6C),
                                                        .INITVAL_6D(INIT_VALUE_6D),
                                                        .INITVAL_6E(INIT_VALUE_6E),
                                                        .INITVAL_6F(INIT_VALUE_6F),
                                                        .INITVAL_70(INIT_VALUE_70),
                                                        .INITVAL_71(INIT_VALUE_71),
                                                        .INITVAL_72(INIT_VALUE_72),
                                                        .INITVAL_73(INIT_VALUE_73),
                                                        .INITVAL_74(INIT_VALUE_74),
                                                        .INITVAL_75(INIT_VALUE_75),
                                                        .INITVAL_76(INIT_VALUE_76),
                                                        .INITVAL_77(INIT_VALUE_77),
                                                        .INITVAL_78(INIT_VALUE_78),
                                                        .INITVAL_79(INIT_VALUE_79),
                                                        .INITVAL_7A(INIT_VALUE_7A),
                                                        .INITVAL_7B(INIT_VALUE_7B),
                                                        .INITVAL_7C(INIT_VALUE_7C),
                                                        .INITVAL_7D(INIT_VALUE_7D),
                                                        .INITVAL_7E(INIT_VALUE_7E),
                                                        .INITVAL_7F(INIT_VALUE_7F)) ulram_0 (.clk_i(pdp_wrclock), 
                                                            .addr_a_i(pdp_wraddress), 
                                                            .wr_data_a_i(pdp_data), 
                                                            .clk_en_a_i(pdp_wrclocken), 
                                                            .wr_en_a_i(pdp_wr_en), 
                                                            .rst_a_i(pdp_reset), 
                                                            .ben_a_i(pdp_ben_t_w), 
                                                            .rd_data_a_o(), 
                                                            .addr_b_i(pdp_rdaddress), 
                                                            .wr_data_b_i({DATA_WIDTH{1'b0}}), 
                                                            .clk_en_b_i(pdp_rdclocken), 
                                                            .wr_en_b_i(1'b0), 
                                                            .rst_b_i(pdp_reset), 
                                                            .ben_b_i(1'b1), 
                                                            .rd_data_b_o(pdp_q), 
                                                            .dps_i(), 
                                                            .lramready_o(), 
                                                            .errdet_a_o(), 
                                                            .errdet_b_o(mem_error_b_o)) ; 
                                            end
                                        else
                                            begin : dp
                                                localparam T_BYTE_WIDTH_A = ((BYTE_ENABLE_S0 || UNALIGNED_ACCESS_ENABLE) ? BYTE_WIDTH : 1) ; 
                                                localparam T_BYTE_WIDTH_B = ((BYTE_ENABLE_S1 || UNALIGNED_ACCESS_ENABLE) ? BYTE_WIDTH : 1) ; 
                                                wire [(T_BYTE_WIDTH_A - 1):0] t_dp_byteen_a = ((BYTE_ENABLE_S0 || UNALIGNED_ACCESS_ENABLE) ? dp_byteen_a : {T_BYTE_WIDTH_A{1'b1}}) ; 
                                                wire [(T_BYTE_WIDTH_B - 1):0] t_dp_byteen_b = ((BYTE_ENABLE_S1 || UNALIGNED_ACCESS_ENABLE) ? dp_byteen_b : {T_BYTE_WIDTH_B{1'b1}}) ; 
                                                sysmem_ipgen_lscc_smem_lram #(.ADDR_DEPTH(ADDR_DEPTH),
                                                        .ADDR_WIDTH(ADDR_WIDTH),
                                                        .DATA_WIDTH(DATA_WIDTH),
                                                        .BYTE_ENABLE_A(BYTE_ENABLE_S0),
                                                        .BYTE_ENABLE_B(BYTE_ENABLE_S1),
                                                        .ECC_ENABLE(ECC_ENABLE),
                                                        .MEM_ID(MEM_ID),
                                                        .MEM_SIZE(MEM_SIZE),
                                                        .REGMODE_A(MEM_REGMODE_A),
                                                        .REGMODE_B(MEM_REGMODE_B),
                                                        .RESET_MODE(MEM_RESETMODE_A),
                                                        .ASYNC_RST_RELEASE("sync"),
                                                        .UNALIGNED_ACCESS_ENABLE(UNALIGNED_ACCESS_ENABLE),
                                                        .READ_PIPELINE_S0(READ_PIPELINE_S0),
                                                        .READ_PIPELINE_S1(READ_PIPELINE_S1),
                                                        .INIT_MODE((((INIT_FILE == "none") || (INIT_FILE_FORMAT == "none")) ? "none" : "mem_file")),
                                                        .INITVAL_00(INIT_VALUE_00),
                                                        .INITVAL_01(INIT_VALUE_01),
                                                        .INITVAL_02(INIT_VALUE_02),
                                                        .INITVAL_03(INIT_VALUE_03),
                                                        .INITVAL_04(INIT_VALUE_04),
                                                        .INITVAL_05(INIT_VALUE_05),
                                                        .INITVAL_06(INIT_VALUE_06),
                                                        .INITVAL_07(INIT_VALUE_07),
                                                        .INITVAL_08(INIT_VALUE_08),
                                                        .INITVAL_09(INIT_VALUE_09),
                                                        .INITVAL_0A(INIT_VALUE_0A),
                                                        .INITVAL_0B(INIT_VALUE_0B),
                                                        .INITVAL_0C(INIT_VALUE_0C),
                                                        .INITVAL_0D(INIT_VALUE_0D),
                                                        .INITVAL_0E(INIT_VALUE_0E),
                                                        .INITVAL_0F(INIT_VALUE_0F),
                                                        .INITVAL_10(INIT_VALUE_10),
                                                        .INITVAL_11(INIT_VALUE_11),
                                                        .INITVAL_12(INIT_VALUE_12),
                                                        .INITVAL_13(INIT_VALUE_13),
                                                        .INITVAL_14(INIT_VALUE_14),
                                                        .INITVAL_15(INIT_VALUE_15),
                                                        .INITVAL_16(INIT_VALUE_16),
                                                        .INITVAL_17(INIT_VALUE_17),
                                                        .INITVAL_18(INIT_VALUE_18),
                                                        .INITVAL_19(INIT_VALUE_19),
                                                        .INITVAL_1A(INIT_VALUE_1A),
                                                        .INITVAL_1B(INIT_VALUE_1B),
                                                        .INITVAL_1C(INIT_VALUE_1C),
                                                        .INITVAL_1D(INIT_VALUE_1D),
                                                        .INITVAL_1E(INIT_VALUE_1E),
                                                        .INITVAL_1F(INIT_VALUE_1F),
                                                        .INITVAL_20(INIT_VALUE_20),
                                                        .INITVAL_21(INIT_VALUE_21),
                                                        .INITVAL_22(INIT_VALUE_22),
                                                        .INITVAL_23(INIT_VALUE_23),
                                                        .INITVAL_24(INIT_VALUE_24),
                                                        .INITVAL_25(INIT_VALUE_25),
                                                        .INITVAL_26(INIT_VALUE_26),
                                                        .INITVAL_27(INIT_VALUE_27),
                                                        .INITVAL_28(INIT_VALUE_28),
                                                        .INITVAL_29(INIT_VALUE_29),
                                                        .INITVAL_2A(INIT_VALUE_2A),
                                                        .INITVAL_2B(INIT_VALUE_2B),
                                                        .INITVAL_2C(INIT_VALUE_2C),
                                                        .INITVAL_2D(INIT_VALUE_2D),
                                                        .INITVAL_2E(INIT_VALUE_2E),
                                                        .INITVAL_2F(INIT_VALUE_2F),
                                                        .INITVAL_30(INIT_VALUE_30),
                                                        .INITVAL_31(INIT_VALUE_31),
                                                        .INITVAL_32(INIT_VALUE_32),
                                                        .INITVAL_33(INIT_VALUE_33),
                                                        .INITVAL_34(INIT_VALUE_34),
                                                        .INITVAL_35(INIT_VALUE_35),
                                                        .INITVAL_36(INIT_VALUE_36),
                                                        .INITVAL_37(INIT_VALUE_37),
                                                        .INITVAL_38(INIT_VALUE_38),
                                                        .INITVAL_39(INIT_VALUE_39),
                                                        .INITVAL_3A(INIT_VALUE_3A),
                                                        .INITVAL_3B(INIT_VALUE_3B),
                                                        .INITVAL_3C(INIT_VALUE_3C),
                                                        .INITVAL_3D(INIT_VALUE_3D),
                                                        .INITVAL_3E(INIT_VALUE_3E),
                                                        .INITVAL_3F(INIT_VALUE_3F),
                                                        .INITVAL_40(INIT_VALUE_40),
                                                        .INITVAL_41(INIT_VALUE_41),
                                                        .INITVAL_42(INIT_VALUE_42),
                                                        .INITVAL_43(INIT_VALUE_43),
                                                        .INITVAL_44(INIT_VALUE_44),
                                                        .INITVAL_45(INIT_VALUE_45),
                                                        .INITVAL_46(INIT_VALUE_46),
                                                        .INITVAL_47(INIT_VALUE_47),
                                                        .INITVAL_48(INIT_VALUE_48),
                                                        .INITVAL_49(INIT_VALUE_49),
                                                        .INITVAL_4A(INIT_VALUE_4A),
                                                        .INITVAL_4B(INIT_VALUE_4B),
                                                        .INITVAL_4C(INIT_VALUE_4C),
                                                        .INITVAL_4D(INIT_VALUE_4D),
                                                        .INITVAL_4E(INIT_VALUE_4E),
                                                        .INITVAL_4F(INIT_VALUE_4F),
                                                        .INITVAL_50(INIT_VALUE_50),
                                                        .INITVAL_51(INIT_VALUE_51),
                                                        .INITVAL_52(INIT_VALUE_52),
                                                        .INITVAL_53(INIT_VALUE_53),
                                                        .INITVAL_54(INIT_VALUE_54),
                                                        .INITVAL_55(INIT_VALUE_55),
                                                        .INITVAL_56(INIT_VALUE_56),
                                                        .INITVAL_57(INIT_VALUE_57),
                                                        .INITVAL_58(INIT_VALUE_58),
                                                        .INITVAL_59(INIT_VALUE_59),
                                                        .INITVAL_5A(INIT_VALUE_5A),
                                                        .INITVAL_5B(INIT_VALUE_5B),
                                                        .INITVAL_5C(INIT_VALUE_5C),
                                                        .INITVAL_5D(INIT_VALUE_5D),
                                                        .INITVAL_5E(INIT_VALUE_5E),
                                                        .INITVAL_5F(INIT_VALUE_5F),
                                                        .INITVAL_60(INIT_VALUE_60),
                                                        .INITVAL_61(INIT_VALUE_61),
                                                        .INITVAL_62(INIT_VALUE_62),
                                                        .INITVAL_63(INIT_VALUE_63),
                                                        .INITVAL_64(INIT_VALUE_64),
                                                        .INITVAL_65(INIT_VALUE_65),
                                                        .INITVAL_66(INIT_VALUE_66),
                                                        .INITVAL_67(INIT_VALUE_67),
                                                        .INITVAL_68(INIT_VALUE_68),
                                                        .INITVAL_69(INIT_VALUE_69),
                                                        .INITVAL_6A(INIT_VALUE_6A),
                                                        .INITVAL_6B(INIT_VALUE_6B),
                                                        .INITVAL_6C(INIT_VALUE_6C),
                                                        .INITVAL_6D(INIT_VALUE_6D),
                                                        .INITVAL_6E(INIT_VALUE_6E),
                                                        .INITVAL_6F(INIT_VALUE_6F),
                                                        .INITVAL_70(INIT_VALUE_70),
                                                        .INITVAL_71(INIT_VALUE_71),
                                                        .INITVAL_72(INIT_VALUE_72),
                                                        .INITVAL_73(INIT_VALUE_73),
                                                        .INITVAL_74(INIT_VALUE_74),
                                                        .INITVAL_75(INIT_VALUE_75),
                                                        .INITVAL_76(INIT_VALUE_76),
                                                        .INITVAL_77(INIT_VALUE_77),
                                                        .INITVAL_78(INIT_VALUE_78),
                                                        .INITVAL_79(INIT_VALUE_79),
                                                        .INITVAL_7A(INIT_VALUE_7A),
                                                        .INITVAL_7B(INIT_VALUE_7B),
                                                        .INITVAL_7C(INIT_VALUE_7C),
                                                        .INITVAL_7D(INIT_VALUE_7D),
                                                        .INITVAL_7E(INIT_VALUE_7E),
                                                        .INITVAL_7F(INIT_VALUE_7F)) ulram_0 (.clk_i(dp_clock_a), 
                                                            .addr_a_i(dp_address_a), 
                                                            .wr_data_a_i(dp_datain_a), 
                                                            .clk_en_a_i(dp_clocken_a), 
                                                            .wr_en_a_i(dp_wr_a), 
                                                            .rst_a_i(dp_reset_a), 
                                                            .ben_a_i(t_dp_byteen_a), 
                                                            .rd_data_a_o(dp_q_a), 
                                                            .addr_b_i(dp_address_b), 
                                                            .wr_data_b_i(dp_datain_b), 
                                                            .clk_en_b_i(dp_clocken_b), 
                                                            .wr_en_b_i(dp_wr_b), 
                                                            .rst_b_i(dp_reset_b), 
                                                            .ben_b_i(t_dp_byteen_b), 
                                                            .rd_data_b_o(dp_q_b), 
                                                            .dps_i(), 
                                                            .lramready_o(), 
                                                            .errdet_a_o(mem_error_a_o), 
                                                            .errdet_b_o(mem_error_b_o)) ; 
                                            end
                                end
                            else
                                begin : dist_mem
                                    if ((PORT_TYPE == "sp")) 
                                        begin : sp
                                            reg [(DATA_WIDTH - 1):0] sp_q_r ; 
                                            wire [(DATA_WIDTH - 1):0] sp_q_w ; 
                                            assign sp_q = sp_q_r ; 
                                            always
                                                @(posedge sp_clock or 
                                                    posedge sp_reset)
                                                begin
                                                    if (sp_reset) 
                                                        begin
                                                            sp_q_r <=  {DATA_WIDTH{1'b0}} ;
                                                        end
                                                    else
                                                        begin
                                                            sp_q_r <=  sp_q_w ;
                                                        end
                                                end
                                            lscc_distributed_spram #(.ADDR_DEPTH(ADDR_DEPTH),
                                                    .DATA_WIDTH(DATA_WIDTH),
                                                    .REGMODE(MEM_REGMODE_A),
                                                    .GSR(""),
                                                    .RESETMODE(MEM_RESETMODE_A),
                                                    .INIT_FILE(INIT_FILE),
                                                    .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                                                    .FAMILY(FAMILY),
                                                    .INIT_MODE(((INIT_FILE == "none") ? "none" : "mem_file"))) u_mem (.clk_i(sp_clock), 
                                                        .rst_i(sp_reset), 
                                                        .clk_en_i(sp_clocken), 
                                                        .wr_en_i(sp_we), 
                                                        .wr_data_i(sp_data[(DATA_WIDTH - 1):0]), 
                                                        .addr_i(sp_address[(ADDR_WIDTH - 1):0]), 
                                                        .rd_data_o(sp_q_w)) ; 
                                        end
                                    else
                                        begin : pdp
                                            reg [(DATA_WIDTH - 1):0] pdp_q_r ; 
                                            wire [(DATA_WIDTH - 1):0] pdp_q_w ; 
                                            assign pdp_q = pdp_q_r ; 
                                            always
                                                @(posedge pdp_rdclock or 
                                                    posedge pdp_reset)
                                                begin
                                                    if (pdp_reset) 
                                                        begin
                                                            pdp_q_r <=  {DATA_WIDTH{1'b0}} ;
                                                        end
                                                    else
                                                        begin
                                                            pdp_q_r <=  pdp_q_w ;
                                                        end
                                                end
                                            lscc_distributed_dpram #(.FAMILY(FAMILY),
                                                    .WADDR_DEPTH(ADDR_DEPTH),
                                                    .WADDR_WIDTH(ADDR_WIDTH),
                                                    .WDATA_WIDTH(DATA_WIDTH),
                                                    .RADDR_DEPTH(ADDR_DEPTH),
                                                    .RADDR_WIDTH(ADDR_WIDTH),
                                                    .RDATA_WIDTH(DATA_WIDTH),
                                                    .REGMODE(((((ACCESS_TYPE_S0 == "R/W") || (ACCESS_TYPE_S0 == "R/O")) || (ACCESS_TYPE_S1 == "DISABLED")) ? MEM_REGMODE_A : MEM_REGMODE_B)),
                                                    .RESETMODE(MEM_RESETMODE_A),
                                                    .INIT_FILE(INIT_FILE),
                                                    .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                                                    .INIT_MODE(((INIT_FILE == "none") ? "none" : "mem_file"))) u_mem (.wr_clk_i(pdp_wrclock), 
                                                        .rd_clk_i(pdp_rdclock), 
                                                        .rst_i(pdp_reset), 
                                                        .wr_clk_en_i(pdp_wrclocken), 
                                                        .rd_clk_en_i(pdp_rdclocken), 
                                                        .wr_en_i(pdp_wr_en), 
                                                        .wr_data_i(pdp_data), 
                                                        .wr_addr_i(pdp_wraddress), 
                                                        .rd_en_i(pdp_rdclocken), 
                                                        .rd_addr_i(pdp_rdaddress), 
                                                        .rd_data_o(pdp_q_w)) ; 
                                        end
                                end
                    end
                else
                    begin : ecp_5
                        if ((PORT_TYPE == "sp")) 
                            begin : sp
                                if (BYTE_ENABLE_S0) 
                                    begin : ram_dq_be
                                        pmi_ram_dp_true_be #(.pmi_addr_depth_a(ADDR_DEPTH),
                                                .pmi_addr_width_a(ADDR_WIDTH),
                                                .pmi_data_width_a(DATA_WIDTH),
                                                .pmi_addr_depth_b(ADDR_DEPTH),
                                                .pmi_addr_width_b(ADDR_WIDTH),
                                                .pmi_data_width_b(DATA_WIDTH),
                                                .pmi_regmode_a(MEM_REGMODE_A),
                                                .pmi_regmode_b(MEM_REGMODE_B),
                                                .pmi_gsr("disable"),
                                                .pmi_resetmode(MEM_RESETMODE_A),
                                                .pmi_optimization(MEM_OPTIMIZATION),
                                                .pmi_init_file(INIT_FILE),
                                                .pmi_init_file_format(INIT_FILE_FORMAT),
                                                .pmi_write_mode_a("normal"),
                                                .pmi_write_mode_b("normal"),
                                                .pmi_byte_size(8),
                                                .pmi_family(DEVICE)) u_mem (//"reg", "noreg"
                                                //"enable", "disable"
                                                //"async", "sync"
                                                //"area", "speed"
                                                //"binary", "hex"
                                                //"normal", "writethrough", "readbeforewrite"
                                                //"normal", "writethrough", "readbeforewrite"
                                                .DataInA(sp_data[(DATA_WIDTH - 1):0]), 
                                                    .DataInB({DATA_WIDTH{1'b0}}), 
                                                    .AddressA(sp_address[(ADDR_WIDTH - 1):0]), 
                                                    .AddressB({ADDR_WIDTH{1'b0}}), 
                                                    .ClockA(sp_clock), 
                                                    .ClockB(1'b0), 
                                                    .ClockEnA(sp_clocken), 
                                                    .ClockEnB(1'b0), 
                                                    .WrA(sp_we), 
                                                    .WrB(1'b0), 
                                                    .ResetA(sp_reset), 
                                                    .ResetB(sp_reset), 
                                                    .ByteEnA(sp_byteen), 
                                                    .ByteEnB({BYTE_WIDTH{1'b0}}), 
                                                    .QA(sp_q[(DATA_WIDTH - 1):0]), 
                                                    .QB()) ; 
                                    end
                                else
                                    begin : ram_dq
                                        pmi_ram_dq #(.pmi_addr_depth(ADDR_DEPTH),
                                                .pmi_addr_width(ADDR_WIDTH),
                                                .pmi_data_width(DATA_WIDTH),
                                                .pmi_regmode(MEM_REGMODE_A),
                                                .pmi_gsr("disable"),
                                                .pmi_resetmode(MEM_RESETMODE_A),
                                                .pmi_optimization(MEM_OPTIMIZATION),
                                                .pmi_init_file(INIT_FILE),
                                                .pmi_init_file_format(INIT_FILE_FORMAT),
                                                .pmi_write_mode("normal"),
                                                .pmi_family(DEVICE)) u_mem (//"reg", "noreg"
                                                //"enable", "disable"
                                                //"async", "sync"
                                                //"area", "speed"
                                                //"binary", "hex"
                                                //"normal", "writethrough", "readbeforewrite"
                                                .Data(sp_data[(DATA_WIDTH - 1):0]), 
                                                    .Address(sp_address[(ADDR_WIDTH - 1):0]), 
                                                    .Clock(sp_clock), 
                                                    .ClockEn(sp_clocken), 
                                                    .WE(sp_we), 
                                                    .Reset(sp_reset), 
                                                    .Q(sp_q[(DATA_WIDTH - 1):0])) ; 
                                    end
                            end
                        else
                            if ((PORT_TYPE == "pdp")) 
                                begin : pdp
                                    if (BYTE_ENABLE_S0) 
                                        begin : ram_dp_be
                                            pmi_ram_dp_be #(.pmi_wr_addr_depth(ADDR_DEPTH),
                                                    .pmi_wr_addr_width(ADDR_WIDTH),
                                                    .pmi_wr_data_width(DATA_WIDTH),
                                                    .pmi_rd_addr_depth(ADDR_DEPTH),
                                                    .pmi_rd_addr_width(ADDR_WIDTH),
                                                    .pmi_rd_data_width(DATA_WIDTH),
                                                    .pmi_regmode(PDP_REGMODE),
                                                    .pmi_gsr("disable"),
                                                    .pmi_resetmode(MEM_RESETMODE_A),
                                                    .pmi_optimization(MEM_OPTIMIZATION),
                                                    .pmi_init_file(INIT_FILE),
                                                    .pmi_init_file_format(INIT_FILE_FORMAT),
                                                    .pmi_byte_size(8),
                                                    .pmi_family(DEVICE)) u_mem (//"reg", "noreg"
                                                    //"enable", "disable"
                                                    //"async", "sync"
                                                    //"speed", "area"
                                                    //"binary", "hex"
                                                    .Data(pdp_data[(DATA_WIDTH - 1):0]), 
                                                        .WrAddress(pdp_wraddress[(ADDR_WIDTH - 1):0]), 
                                                        .RdAddress(pdp_rdaddress[(ADDR_WIDTH - 1):0]), 
                                                        .WrClock(pdp_wrclock), 
                                                        .RdClock(pdp_rdclock), 
                                                        .WrClockEn(pdp_wrclocken), 
                                                        .RdClockEn(pdp_rdclocken), 
                                                        .WE(pdp_we), 
                                                        .Reset(pdp_reset), 
                                                        .ByteEn(pdp_byteen), 
                                                        .Q(pdp_q[(DATA_WIDTH - 1):0])) ; 
                                        end
                                    else
                                        begin : ram_dp
                                            pmi_ram_dp #(.pmi_wr_addr_depth(ADDR_DEPTH),
                                                    .pmi_wr_addr_width(ADDR_WIDTH),
                                                    .pmi_wr_data_width(DATA_WIDTH),
                                                    .pmi_rd_addr_depth(ADDR_DEPTH),
                                                    .pmi_rd_addr_width(ADDR_WIDTH),
                                                    .pmi_rd_data_width(DATA_WIDTH),
                                                    .pmi_regmode(PDP_REGMODE),
                                                    .pmi_gsr("disable"),
                                                    .pmi_resetmode(MEM_RESETMODE_A),
                                                    .pmi_optimization(MEM_OPTIMIZATION),
                                                    .pmi_init_file(INIT_FILE),
                                                    .pmi_init_file_format(INIT_FILE_FORMAT),
                                                    .pmi_family(DEVICE)) u_mem (//"reg", "noreg"
                                                    //"enable", "disable"
                                                    //"async", "sync"
                                                    //"speed", "area"
                                                    //"binary", "hex"
                                                    .Data(pdp_data[(DATA_WIDTH - 1):0]), 
                                                        .WrAddress(pdp_wraddress[(ADDR_WIDTH - 1):0]), 
                                                        .RdAddress(pdp_rdaddress[(ADDR_WIDTH - 1):0]), 
                                                        .WrClock(pdp_wrclock), 
                                                        .RdClock(pdp_rdclock), 
                                                        .WrClockEn(pdp_wrclocken), 
                                                        .RdClockEn(pdp_rdclocken), 
                                                        .WE(pdp_we), 
                                                        .Reset(pdp_reset), 
                                                        .Q(pdp_q[(DATA_WIDTH - 1):0])) ; 
                                        end
                                end
                            else
                                if ((PORT_TYPE == "dp")) 
                                    begin : dp
                                        if (BYTE_ENABLE_S0) 
                                            begin : ram_dp_true_be
                                                pmi_ram_dp_true_be #(.pmi_addr_depth_a(ADDR_DEPTH),
                                                        .pmi_addr_width_a(ADDR_WIDTH),
                                                        .pmi_data_width_a(DATA_WIDTH),
                                                        .pmi_addr_depth_b(ADDR_DEPTH),
                                                        .pmi_addr_width_b(ADDR_WIDTH),
                                                        .pmi_data_width_b(DATA_WIDTH),
                                                        .pmi_regmode_a(MEM_REGMODE_A),
                                                        .pmi_regmode_b(MEM_REGMODE_B),
                                                        .pmi_gsr("disable"),
                                                        .pmi_resetmode(MEM_RESETMODE_A),
                                                        .pmi_optimization(MEM_OPTIMIZATION),
                                                        .pmi_init_file(INIT_FILE),
                                                        .pmi_init_file_format(INIT_FILE_FORMAT),
                                                        .pmi_write_mode_a("normal"),
                                                        .pmi_write_mode_b("normal"),
                                                        .pmi_byte_size(8),
                                                        .pmi_family(DEVICE)) u_mem (//"reg", "noreg"
                                                        //"enable", "disable"
                                                        //"async", "sync"
                                                        //"area", "speed"
                                                        //"binary", "hex"
                                                        //"normal", "writethrough", "readbeforewrite"
                                                        //"normal", "writethrough", "readbeforewrite"
                                                        .DataInA(dp_datain_a[(DATA_WIDTH - 1):0]), 
                                                            .DataInB(dp_datain_b[(DATA_WIDTH - 1):0]), 
                                                            .AddressA(dp_address_a[(ADDR_WIDTH - 1):0]), 
                                                            .AddressB(dp_address_b[(ADDR_WIDTH - 1):0]), 
                                                            .ClockA(dp_clock_a), 
                                                            .ClockB(dp_clock_b), 
                                                            .ClockEnA(dp_clocken_a), 
                                                            .ClockEnB(dp_clocken_b), 
                                                            .WrA(dp_wr_a), 
                                                            .WrB(dp_wr_b), 
                                                            .ResetA(dp_reset_a), 
                                                            .ResetB(dp_reset_b), 
                                                            .ByteEnA(dp_byteen_a), 
                                                            .ByteEnB(dp_byteen_b), 
                                                            .QA(dp_q_a[(DATA_WIDTH - 1):0]), 
                                                            .QB(dp_q_b[(DATA_WIDTH - 1):0])) ; 
                                            end
                                        else
                                            begin : ram_dp_true
                                                pmi_ram_dp_true #(.pmi_addr_depth_a(ADDR_DEPTH),
                                                        .pmi_addr_width_a(ADDR_WIDTH),
                                                        .pmi_data_width_a(DATA_WIDTH),
                                                        .pmi_addr_depth_b(ADDR_DEPTH),
                                                        .pmi_addr_width_b(ADDR_WIDTH),
                                                        .pmi_data_width_b(DATA_WIDTH),
                                                        .pmi_regmode_a(MEM_REGMODE_A),
                                                        .pmi_regmode_b(MEM_REGMODE_B),
                                                        .pmi_gsr("disable"),
                                                        .pmi_resetmode(MEM_RESETMODE_A),
                                                        .pmi_optimization(MEM_OPTIMIZATION),
                                                        .pmi_init_file(INIT_FILE),
                                                        .pmi_init_file_format(INIT_FILE_FORMAT),
                                                        .pmi_write_mode_a("normal"),
                                                        .pmi_write_mode_b("normal"),
                                                        .pmi_family(DEVICE)) u_mem (//"reg", "noreg"
                                                        //"enable", "disable"
                                                        //"async", "sync"
                                                        //"area", "speed"
                                                        //"binary", "hex"
                                                        //"normal", "writethrough", "readbeforewrite"
                                                        //"normal", "writethrough", "readbeforewrite"
                                                        .DataInA(dp_datain_a[(DATA_WIDTH - 1):0]), 
                                                            .DataInB(dp_datain_b[(DATA_WIDTH - 1):0]), 
                                                            .AddressA(dp_address_a[(ADDR_WIDTH - 1):0]), 
                                                            .AddressB(dp_address_b[(ADDR_WIDTH - 1):0]), 
                                                            .ClockA(dp_clock_a), 
                                                            .ClockB(dp_clock_b), 
                                                            .ClockEnA(dp_clocken_a), 
                                                            .ClockEnB(dp_clocken_b), 
                                                            .WrA(dp_wr_a), 
                                                            .WrB(dp_wr_b), 
                                                            .ResetA(dp_reset_a), 
                                                            .ResetB(dp_reset_b), 
                                                            .QA(dp_q_a[(DATA_WIDTH - 1):0]), 
                                                            .QB(dp_q_b[(DATA_WIDTH - 1):0])) ; 
                                            end
                                    end
                    end
            end
    endgenerate
    // -----------------------------------------------------------------------------
    // Function Definition
    // -----------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



`timescale 1ns/1ps
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
module sysmem_ipgen_lscc_sys_mem #(parameter INTERFACE = "AHBL", 
        parameter ID_WIDTH = 4, 
        parameter ADDR_DEPTH = 16384, 
        parameter DATA_WIDTH = 32, 
        parameter MEMORY_TYPE = "EBR", 
        parameter PORT_COUNT = 2, 
        parameter ECC_ENABLE = 0, 
        parameter REGMODE_S0 = "noreg", 
        parameter READ_PIPELINE_S0 = 0, 
        parameter REGMODE_S1 = "noreg", 
        parameter READ_PIPELINE_S1 = 0, 
        parameter RESET_MODE_S0 = "async", 
        parameter RESET_MODE_S1 = "async", 
        parameter BYTE_ENABLE_S0 = 0, 
        parameter BYTE_ENABLE_S1 = 0, 
        parameter S0_START_ADDR = 0, 
        parameter S1_START_ADDR = 0, 
        parameter S0_END_ADDR = (ADDR_DEPTH - 1), 
        parameter S1_END_ADDR = (ADDR_DEPTH - 1), 
        parameter ACCESS_TYPE_S0 = "R/W", 
        parameter ACCESS_TYPE_S1 = "R/W", 
        parameter UNALIGNED_ACCESS_EN_S0 = 0, 
        parameter UNALIGNED_ACCESS_EN_S1 = 0, 
        parameter SHIFT_DIRECTION_S0 = "none", 
        parameter SHIFT_DIRECTION_S1 = "none", 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "hex", 
        parameter FAMILY = "common", 
        parameter DEVICE = "none", 
        parameter ARBITER_EN = 0, 
        parameter MEM_SIZE = "1024,18", 
        parameter MEM_ID = "MEM0", 
        parameter DATA_STREAMER_EN = 0, 
        parameter STREAMER_INTF = "FIFO", 
        parameter STREAMER_START_ADDR = 0, 
        parameter STREAMER_CLK_BYPASS = 0, 
        parameter INIT_VALUE_00 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_01 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_02 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_03 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_04 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_05 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_06 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_07 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_08 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_09 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_10 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_11 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_12 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_13 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_14 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_15 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_16 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_17 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_18 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_19 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_20 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_21 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_22 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_23 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_24 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_25 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_26 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_27 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_28 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_29 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_30 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_31 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_32 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_33 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_34 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_35 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_36 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_37 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_38 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_39 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_40 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_41 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_42 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_43 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_44 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_45 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_46 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_47 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_48 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_49 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4A = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4B = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4C = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4D = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4E = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4F = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_50 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_51 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_52 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_53 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_54 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_55 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_56 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_57 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_58 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_59 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5A = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5B = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5C = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5D = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5E = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5F = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_60 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_61 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_62 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_63 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_64 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_65 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_66 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_67 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_68 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_69 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6A = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6B = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6C = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6D = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6E = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6F = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_70 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_71 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_72 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_73 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_74 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_75 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_76 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_77 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_78 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_79 = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7A = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7B = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7C = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7D = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7E = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7F = "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input ahbl_hclk_i, 
    input ahbl_hresetn_i, 
    input axi_aclk_i, 
    input axi_resetn_i, 
    // ----------------------------
    // AHB-Lite Master Interface 0
    // ----------------------------
    input ahbl_s0_hsel_i, 
    input ahbl_s0_hready_i, 
    input [31:0] ahbl_s0_haddr_i, 
    input [2:0] ahbl_s0_hburst_i, 
    input [2:0] ahbl_s0_hsize_i, 
    input ahbl_s0_hmastlock_i, 
    input [3:0] ahbl_s0_hprot_i, 
    input [1:0] ahbl_s0_htrans_i, 
    input ahbl_s0_hwrite_i, 
    input [(DATA_WIDTH - 1):0] ahbl_s0_hwdata_i, 
    output wire ahbl_s0_hreadyout_o, 
    output wire ahbl_s0_hresp_o, 
    output wire [(DATA_WIDTH - 1):0] ahbl_s0_hrdata_o, 
    output wire ecc_sec_s0_o, 
    output wire ecc_ded_s0_o, 
    // ----------------------------
    // AHB-Lite Master Interface 1
    // ----------------------------
    input ahbl_s1_hsel_i, 
    input ahbl_s1_hready_i, 
    input [31:0] ahbl_s1_haddr_i, 
    input [2:0] ahbl_s1_hburst_i, 
    input [2:0] ahbl_s1_hsize_i, 
    input ahbl_s1_hmastlock_i, 
    input [3:0] ahbl_s1_hprot_i, 
    input [1:0] ahbl_s1_htrans_i, 
    input ahbl_s1_hwrite_i, 
    input [(DATA_WIDTH - 1):0] ahbl_s1_hwdata_i, 
    output wire ahbl_s1_hreadyout_o, 
    output wire ahbl_s1_hresp_o, 
    output wire [(DATA_WIDTH - 1):0] ahbl_s1_hrdata_o, 
    output wire ecc_sec_s1_o, 
    output wire ecc_ded_s1_o, 
    // ----------------------------
    // AXI4 Manager Interface 0
    // ----------------------------
    input [(ID_WIDTH - 1):0] axi_s0_awid_i, 
    input [31:0] axi_s0_awaddr_i, 
    input [7:0] axi_s0_awlen_i, 
    input [2:0] axi_s0_awsize_i, 
    input [1:0] axi_s0_awburst_i, 
    input axi_s0_awlock_i, 
    input [3:0] axi_s0_awcache_i, 
    input [3:0] axi_s0_awqos_i, 
    input [3:0] axi_s0_awregion_i, 
    input [2:0] axi_s0_awprot_i, 
    input axi_s0_awvalid_i, 
    output axi_s0_awready_o, 
    input [(DATA_WIDTH - 1):0] axi_s0_wdata_i, 
    input [((DATA_WIDTH / 8) - 1):0] axi_s0_wstrb_i, 
    input axi_s0_wlast_i, 
    input axi_s0_wvalid_i, 
    output axi_s0_wready_o, 
    output [(ID_WIDTH - 1):0] axi_s0_bid_o, 
    output [1:0] axi_s0_bresp_o, 
    output axi_s0_bvalid_o, 
    input axi_s0_bready_i, 
    input [(ID_WIDTH - 1):0] axi_s0_arid_i, 
    input [31:0] axi_s0_araddr_i, 
    input [7:0] axi_s0_arlen_i, 
    input [2:0] axi_s0_arsize_i, 
    input [1:0] axi_s0_arburst_i, 
    input axi_s0_arlock_i, 
    input [3:0] axi_s0_arcache_i, 
    input [3:0] axi_s0_arqos_i, 
    input [3:0] axi_s0_arregion_i, 
    input [2:0] axi_s0_arprot_i, 
    input axi_s0_arvalid_i, 
    output axi_s0_arready_o, 
    output [(ID_WIDTH - 1):0] axi_s0_rid_o, 
    output [(DATA_WIDTH - 1):0] axi_s0_rdata_o, 
    output [1:0] axi_s0_rresp_o, 
    output axi_s0_rlast_o, 
    output axi_s0_rvalid_o, 
    input axi_s0_rready_i, 
    // ----------------------------
    // AXI4 Manager Interface 1
    // ----------------------------
    input [(ID_WIDTH - 1):0] axi_s1_awid_i, 
    input [31:0] axi_s1_awaddr_i, 
    input [7:0] axi_s1_awlen_i, 
    input [2:0] axi_s1_awsize_i, 
    input [1:0] axi_s1_awburst_i, 
    input axi_s1_awlock_i, 
    input [3:0] axi_s1_awcache_i, 
    input [3:0] axi_s1_awqos_i, 
    input [3:0] axi_s1_awregion_i, 
    input [2:0] axi_s1_awprot_i, 
    input axi_s1_awvalid_i, 
    output axi_s1_awready_o, 
    input [(DATA_WIDTH - 1):0] axi_s1_wdata_i, 
    input [((DATA_WIDTH / 8) - 1):0] axi_s1_wstrb_i, 
    input axi_s1_wlast_i, 
    input axi_s1_wvalid_i, 
    output axi_s1_wready_o, 
    output [(ID_WIDTH - 1):0] axi_s1_bid_o, 
    output [1:0] axi_s1_bresp_o, 
    output axi_s1_bvalid_o, 
    input axi_s1_bready_i, 
    input [(ID_WIDTH - 1):0] axi_s1_arid_i, 
    input [31:0] axi_s1_araddr_i, 
    input [7:0] axi_s1_arlen_i, 
    input [2:0] axi_s1_arsize_i, 
    input [1:0] axi_s1_arburst_i, 
    input axi_s1_arlock_i, 
    input [3:0] axi_s1_arcache_i, 
    input [3:0] axi_s1_arqos_i, 
    input [3:0] axi_s1_arregion_i, 
    input [2:0] axi_s1_arprot_i, 
    input axi_s1_arvalid_i, 
    output axi_s1_arready_o, 
    output [(ID_WIDTH - 1):0] axi_s1_rid_o, 
    output [(DATA_WIDTH - 1):0] axi_s1_rdata_o, 
    output [1:0] axi_s1_rresp_o, 
    output axi_s1_rlast_o, 
    output axi_s1_rvalid_o, 
    input axi_s1_rready_i, 
    // ----------------------------
    // FIFO Interface
    // ----------------------------
    input fifo_clk_i, 
    input fifo_wr_en_i, 
    input [7:0] fifo_wr_data_i, 
    input fifo_interface_en_i, 
    input fifo_address_rst_i, 
    output fifo_full_o, 
    // ----------------------------
    // AXI4-Stream Interface
    // ----------------------------
    input axis_rx_aclk_i, 
    input axi_rx_tvalid_i, 
    input [(DATA_WIDTH - 1):0] axi_rx_tdata_i, 
    input [((DATA_WIDTH / 8) - 1):0] axi_rx_tstrb_i, 
    input axi_rx_tlast_i, 
    output axi_rx_tready_o) ;
    localparam ADDR_WIDTH = clog2((ADDR_DEPTH - 1)) ; 
    localparam BYTE_WIDTH = (DATA_WIDTH / 8) ; 
    localparam ADDR_WIDTH_S0_TAKE = clog2((S0_END_ADDR - S0_START_ADDR)) ; 
    localparam ADDR_WIDTH_S1_TAKE = clog2((S1_END_ADDR - S1_START_ADDR)) ; 
    localparam T_FAMILY = (((((((FAMILY == "LFCPNX") || (FAMILY == "LFD2NX")) || (FAMILY == "LFMNX")) || (FAMILY == "jd5r00")) || (FAMILY == "LFMXO5")) || (FAMILY == "LFMXO5D")) ? "LIFCL" : ((((FAMILY == "LAV-AT") || (FAMILY == "LN2-CT")) || (FAMILY == "LN2-MH")) ? "LAV-AT" : FAMILY)) ; 
    localparam T_BYTE_S0_EN = (DATA_STREAMER_EN ? 1 : (ECC_ENABLE ? 0 : BYTE_ENABLE_S0)) ; 
    localparam T_BYTE_S1_EN = (DATA_STREAMER_EN ? 1 : (ECC_ENABLE ? 0 : BYTE_ENABLE_S1)) ; 
    localparam T_ACCESS_TYPE_S1 = (DATA_STREAMER_EN ? ((ACCESS_TYPE_S1 == "DISABLED") ? "W/O" : ((ACCESS_TYPE_S1 == "R/O") ? "R/W" : ACCESS_TYPE_S1)) : ACCESS_TYPE_S1) ; 
    localparam AXI_REGMODE_S0 = "noreg" ; 
    localparam AXI_REGMODE_S1 = "noreg" ; 
    wire sys_clk_w ; 
    // ------------------           
    // Memory 0 Interface           
    // ------------------           
    wire [(DATA_WIDTH - 1):0] mem0_rdata_w ; 
    wire mem0_error_w = 1'b1 ; 
    wire mem0_request_w ; 
    wire mem0_req_arb_w ; 
    wire mem0_wr_rdn_w ; 
    wire mem0_wr_rdn_arb_w ; 
    wire [(ADDR_WIDTH - 1):0] mem0_addr_w ; 
    wire [(DATA_WIDTH - 1):0] mem0_wdata_w ; 
    wire [(BYTE_WIDTH - 1):0] mem0_byte_en_w ; 
    // wire [DATA_WIDTH-1:0] mem0_axi_rdata_i;
    wire mem0_axi_error_i ; 
    wire mem0_axi_wr_en_o ; 
    wire [(ADDR_WIDTH - 1):0] mem0_axi_waddr_o ; 
    wire [(DATA_WIDTH - 1):0] mem0_axi_wdata_o ; 
    wire [(BYTE_WIDTH - 1):0] mem0_axi_byte_en_o ; 
    wire mem0_axi_rd_en_o ; 
    wire [(ADDR_WIDTH - 1):0] mem0_axi_raddr_o ; 
    // ------------------ 
    // Memory 1 Interface 
    // ------------------ 
    wire mem1_request_w ; 
    wire mem1_req_arb_w ; 
    wire mem1_wr_rdn_w ; 
    wire mem1_wr_rdn_arb_w ; 
    wire [(ADDR_WIDTH - 1):0] mem1_addr_w ; 
    wire [(DATA_WIDTH - 1):0] mem1_wdata_w ; 
    wire [(BYTE_WIDTH - 1):0] mem1_byte_en_w ; 
    wire [(DATA_WIDTH - 1):0] mem1_axi_rdata_i ; 
    wire mem1_axi_error_i ; 
    wire mem1_axi_wr_en_o ; 
    wire [(ADDR_WIDTH - 1):0] mem1_axi_waddr_o ; 
    wire [(DATA_WIDTH - 1):0] mem1_axi_wdata_o ; 
    wire [(BYTE_WIDTH - 1):0] mem1_axi_byte_en_o ; 
    wire mem1_axi_rd_en_o ; 
    wire [(ADDR_WIDTH - 1):0] mem1_axi_raddr_o ; 
    // ------------------ 
    // Memory 1 Interface 
    // ------------------ 
    wire [(DATA_WIDTH - 1):0] mem1_rdata_w ; 
    wire mem1_error_w = 1'b1 ; 
    wire mem1_ahbl_request_w ; 
    wire mem1_ahbl_wr_rdn_w ; 
    wire [(ADDR_WIDTH - 1):0] mem1_ahbl_addr_w ; 
    wire [(DATA_WIDTH - 1):0] mem1_ahbl_wdata_w ; 
    wire [(BYTE_WIDTH - 1):0] mem1_ahbl_byte_en_w ; 
    // ------------------ 
    // AXI Memory Interface 
    // ------------------ 
    wire [(ADDR_WIDTH - 1):0] mem_axi_waddr_w ; 
    wire [(DATA_WIDTH - 1):0] mem_axi_wdata_w ; 
    wire mem_axi_wr_en_w ; 
    wire [(BYTE_WIDTH - 1):0] mem_axi_byte_en_w ; 
    wire axis_rx_wr_en_w ; 
    wire [(DATA_WIDTH - 1):0] axis_rx_wr_data_w ; 
    wire [(BYTE_WIDTH - 1):0] axis_rx_byte_en_w ; 
    wire [(ADDR_WIDTH - 1):0] axis_rx_wr_addr_w ; 
    wire axis_rx_arb_hold_w ; 
    wire axis_arb_s0_awready_o ; 
    wire axis_arb_s0_wready_o ; 
    wire axis_arb_s1_awready_o ; 
    wire axis_arb_s1_wready_o ; 
    // ------------------ 
    // Arbiter signals
    // ------------------ 
    wire arb_s0_awpipe_o ; 
    wire arb_s0_arpipe_o ; 
    wire arb_s1_awpipe_o ; 
    wire arb_s1_arpipe_o ; 
    wire arb_s0_awready_o ; 
    wire arb_s0_wready_o ; 
    wire arb_s0_arready_o ; 
    wire arb_s1_awready_o ; 
    wire arb_s1_wready_o ; 
    wire arb_s1_arready_o ; 
    wire [(ADDR_WIDTH - 1):0] arb_mem_awaddr_o ; 
    wire [(DATA_WIDTH - 1):0] arb_mem_wdata_o ; 
    wire arb_mem_wr_en_o ; 
    wire [(BYTE_WIDTH - 1):0] arb_mem_byte_en_o ; 
    wire [(ADDR_WIDTH - 1):0] arb_mem_araddr_o ; 
    wire arb_mem_rd_en_o ; 
    // ------------------ 
    // Memory FIFO Interface 
    // ------------------
    wire [(DATA_WIDTH - 1):0] mem_fifo_wdata_w ; 
    wire mem_fifo_clk_en_w ; 
    wire [(ADDR_WIDTH - 1):0] mem_fifo_addr_w ; 
    wire [(BYTE_WIDTH - 1):0] mem_fifo_byte_en_w ; 
    wire [31:0] t_ahbl_addr_s0_w = {{(32 - ADDR_WIDTH_S0_TAKE){1'b0}},
                ahbl_s0_haddr_i[(ADDR_WIDTH_S0_TAKE - 1):0]} ; 
    wire [31:0] t_ahbl_addr_s1_w = {{(32 - ADDR_WIDTH_S1_TAKE){1'b0}},
                ahbl_s1_haddr_i[(ADDR_WIDTH_S1_TAKE - 1):0]} ; 
    wire [31:0] t_axi4_waddr_s0_w = {{(32 - ADDR_WIDTH_S0_TAKE){1'b0}},
                axi_s0_awaddr_i[(ADDR_WIDTH_S0_TAKE - 1):0]} ; 
    wire [31:0] t_axi4_raddr_s0_w = {{(32 - ADDR_WIDTH_S0_TAKE){1'b0}},
                axi_s0_araddr_i[(ADDR_WIDTH_S0_TAKE - 1):0]} ; 
    wire [31:0] t_axi4_waddr_s1_w = {{(32 - ADDR_WIDTH_S1_TAKE){1'b0}},
                axi_s1_awaddr_i[(ADDR_WIDTH_S1_TAKE - 1):0]} ; 
    wire [31:0] t_axi4_raddr_s1_w = {{(32 - ADDR_WIDTH_S1_TAKE){1'b0}},
                axi_s1_araddr_i[(ADDR_WIDTH_S1_TAKE - 1):0]} ; 
    generate
        begin : bridge_s0
            if ((INTERFACE == "AXI4")) 
                begin : genblk1
                    sysmem_ipgen_lscc_axi4mem_subordinate #(.DATA_WIDTH(DATA_WIDTH),
                            .ADDR_WIDTH(ADDR_WIDTH),
                            .ID_WIDTH(ID_WIDTH),
                            .MEMORY_TYPE(MEMORY_TYPE),
                            .ACCESS_TYPE(ACCESS_TYPE_S0),
                            .REG_MODE(AXI_REGMODE_S0),
                            .START_ADDR(S0_START_ADDR),
                            .END_ADDR(S0_END_ADDR)) bridge_s0 (.aclk_i(axi_aclk_i), 
                                .aresetn_i(axi_resetn_i), 
                                //Write Address Channel (AW)
                            .axi_awid_i(axi_s0_awid_i), 
                                .axi_awaddr_i(t_axi4_waddr_s0_w), 
                                .axi_awlen_i(axi_s0_awlen_i), 
                                .axi_awsize_i(axi_s0_awsize_i), 
                                .axi_awburst_i(axi_s0_awburst_i), 
                                .axi_awlock_i(axi_s0_awlock_i), 
                                .axi_awcache_i(axi_s0_awcache_i), 
                                .axi_awprot_i(axi_s0_awprot_i), 
                                .axi_awvalid_i(axi_s0_awvalid_i), 
                                .axi_awready_o(axi_s0_awready_o), 
                                //Write Data Channel (W)
                            .axi_wdata_i(axi_s0_wdata_i), 
                                .axi_wstrb_i(axi_s0_wstrb_i), 
                                .axi_wlast_i(axi_s0_wlast_i), 
                                .axi_wvalid_i(axi_s0_wvalid_i), 
                                .axi_wready_o(axi_s0_wready_o), 
                                //Write Response Channel (B)
                            .axi_bid_o(axi_s0_bid_o), 
                                .axi_bresp_o(axi_s0_bresp_o), 
                                .axi_bvalid_o(axi_s0_bvalid_o), 
                                .axi_bready_i(axi_s0_bready_i), 
                                //Read Address Channel (AR)
                            .axi_arid_i(axi_s0_arid_i), 
                                .axi_araddr_i(t_axi4_raddr_s0_w), 
                                .axi_arlen_i(axi_s0_arlen_i), 
                                .axi_arsize_i(axi_s0_arsize_i), 
                                .axi_arburst_i(axi_s0_arburst_i), 
                                .axi_arlock_i(axi_s0_arlock_i), 
                                .axi_arcache_i(axi_s0_arcache_i), 
                                .axi_arprot_i(axi_s0_arprot_i), 
                                .axi_arvalid_i(axi_s0_arvalid_i), 
                                .axi_arready_o(axi_s0_arready_o), 
                                //Read Data Channel (R)
                            .axi_rid_o(axi_s0_rid_o), 
                                .axi_rdata_o(axi_s0_rdata_o), 
                                .axi_rresp_o(axi_s0_rresp_o), 
                                .axi_rlast_o(axi_s0_rlast_o), 
                                .axi_rvalid_o(axi_s0_rvalid_o), 
                                .axi_rready_i(axi_s0_rready_i), 
                                // Arbiter signals
                            .arb_awready_i(axis_arb_s0_awready_o), 
                                .arb_wready_i(axis_arb_s0_wready_o), 
                                .arb_arready_i(arb_s0_arready_o), 
                                .arb_awpipe_en(arb_s0_awpipe_o), 
                                .arb_arpipe_en(arb_s0_arpipe_o), 
                                // Memory Interface 
                            .mem_rdata_i(mem1_rdata_w), 
                                .mem_error_i(mem0_axi_error_i), 
                                .mem_wr_en_o(mem0_axi_wr_en_o), 
                                .mem_waddr_o(mem0_axi_waddr_o), 
                                .mem_wdata_o(mem0_axi_wdata_o), 
                                .mem_byte_en_o(mem0_axi_byte_en_o), 
                                .mem_rd_en_o(mem0_axi_rd_en_o), 
                                .mem_raddr_o(mem0_axi_raddr_o)) ; 
                end
            else
                begin : genblk1
                    // ----------------------------
                    // AHB-Lite Subordinate 0 Bridge
                    // ----------------------------
                    sysmem_ipgen_lscc_ahblmem_subordinate #(.DATA_WIDTH(DATA_WIDTH),
                            .ADDR_DEPTH(ADDR_DEPTH),
                            .REG_MODE(REGMODE_S0),
                            .READ_PIPELINE(READ_PIPELINE_S0),
                            .BYTE_ENABLE(T_BYTE_S0_EN),
                            .START_ADDR(S0_START_ADDR),
                            .END_ADDR(S0_END_ADDR),
                            .PORT_TYPE(ACCESS_TYPE_S0),
                            .RESET_MODE(RESET_MODE_S0),
                            .UNALIGNED_EN(UNALIGNED_ACCESS_EN_S0),
                            .UNALIGNED_DIR(SHIFT_DIRECTION_S0),
                            .MEMORY_TYPE(MEMORY_TYPE)) bridge_s0 (.ahbl_hclk_i(sys_clk_w), 
                                .ahbl_hresetn_i(ahbl_hresetn_i), 
                                // ------------------------   
                            // AHB-Lite S0 Interface         
                            // ------------------------   
                            .ahbl_hsel_i(ahbl_s0_hsel_i), 
                                .ahbl_hready_i(ahbl_s0_hready_i), 
                                .ahbl_haddr_i(t_ahbl_addr_s0_w), 
                                .ahbl_hburst_i(ahbl_s0_hburst_i), 
                                .ahbl_hsize_i(ahbl_s0_hsize_i), 
                                .ahbl_hmastlock_i(ahbl_s0_hmastlock_i), 
                                .ahbl_hprot_i(ahbl_s0_hprot_i), 
                                .ahbl_htrans_i(ahbl_s0_htrans_i), 
                                .ahbl_hwrite_i(ahbl_s0_hwrite_i), 
                                .ahbl_hwdata_i(ahbl_s0_hwdata_i), 
                                .ahbl_hreadyout_o(ahbl_s0_hreadyout_o), 
                                .ahbl_hresp_o(ahbl_s0_hresp_o), 
                                .ahbl_hrdata_o(ahbl_s0_hrdata_o), 
                                // ------------------------   
                            // Memory S0 Interface           
                            // ------------------------   
                            .mem_rdata_i(mem0_rdata_w), 
                                .mem_error_i(mem0_error_w), 
                                .mem_request_o(mem0_request_w), 
                                .mem_wr_rdn_o(mem0_wr_rdn_w), 
                                .mem_addr_o(mem0_addr_w), 
                                .mem_wdata_o(mem0_wdata_w), 
                                .mem_byte_en_o(mem0_byte_en_w)) ; 
                    if ((ACCESS_TYPE_S1 == "DISABLED")) 
                        begin : genblk1
                            assign ahbl_s1_hreadyout_o = 1'b1 ; 
                            assign ahbl_s1_hresp_o = 1'b0 ; 
                            assign ahbl_s1_hrdata_o = {DATA_WIDTH{1'b0}} ; 
                        end
                end
        end
        if ((((ACCESS_TYPE_S1 == "R/W") || (ACCESS_TYPE_S1 == "W/O")) || (ACCESS_TYPE_S1 == "R/O"))) 
            begin : bridge_s1
                if ((INTERFACE == "AXI4")) 
                    begin : genblk1
                        sysmem_ipgen_lscc_axi4mem_subordinate #(.DATA_WIDTH(DATA_WIDTH),
                                .ADDR_WIDTH(ADDR_WIDTH),
                                .ID_WIDTH(ID_WIDTH),
                                .MEMORY_TYPE(MEMORY_TYPE),
                                .ACCESS_TYPE(ACCESS_TYPE_S1),
                                .REG_MODE(AXI_REGMODE_S1),
                                .START_ADDR(S1_START_ADDR),
                                .END_ADDR(S1_END_ADDR)) bridge_s1 (.aclk_i(axi_aclk_i), 
                                    .aresetn_i(axi_resetn_i), 
                                    //Write Address Channel (AW)
                                .axi_awid_i(axi_s1_awid_i), 
                                    .axi_awaddr_i(t_axi4_waddr_s1_w), 
                                    .axi_awlen_i(axi_s1_awlen_i), 
                                    .axi_awsize_i(axi_s1_awsize_i), 
                                    .axi_awburst_i(axi_s1_awburst_i), 
                                    .axi_awlock_i(axi_s1_awlock_i), 
                                    .axi_awcache_i(axi_s1_awcache_i), 
                                    .axi_awprot_i(axi_s1_awprot_i), 
                                    .axi_awvalid_i(axi_s1_awvalid_i), 
                                    .axi_awready_o(axi_s1_awready_o), 
                                    //Write Data Channel (W)
                                .axi_wdata_i(axi_s1_wdata_i), 
                                    .axi_wstrb_i(axi_s1_wstrb_i), 
                                    .axi_wlast_i(axi_s1_wlast_i), 
                                    .axi_wvalid_i(axi_s1_wvalid_i), 
                                    .axi_wready_o(axi_s1_wready_o), 
                                    //Write Response Channel (B)
                                .axi_bid_o(axi_s1_bid_o), 
                                    .axi_bresp_o(axi_s1_bresp_o), 
                                    .axi_bvalid_o(axi_s1_bvalid_o), 
                                    .axi_bready_i(axi_s1_bready_i), 
                                    //Read Address Channel (AR)
                                .axi_arid_i(axi_s1_arid_i), 
                                    .axi_araddr_i(t_axi4_raddr_s1_w), 
                                    .axi_arlen_i(axi_s1_arlen_i), 
                                    .axi_arsize_i(axi_s1_arsize_i), 
                                    .axi_arburst_i(axi_s1_arburst_i), 
                                    .axi_arlock_i(axi_s1_arlock_i), 
                                    .axi_arcache_i(axi_s1_arcache_i), 
                                    .axi_arprot_i(axi_s1_arprot_i), 
                                    .axi_arvalid_i(axi_s1_arvalid_i), 
                                    .axi_arready_o(axi_s1_arready_o), 
                                    //Read Data Channel (R)
                                .axi_rid_o(axi_s1_rid_o), 
                                    .axi_rdata_o(axi_s1_rdata_o), 
                                    .axi_rresp_o(axi_s1_rresp_o), 
                                    .axi_rlast_o(axi_s1_rlast_o), 
                                    .axi_rvalid_o(axi_s1_rvalid_o), 
                                    .axi_rready_i(axi_s1_rready_i), 
                                    // Arbiter signals
                                .arb_awready_i(axis_arb_s1_awready_o), 
                                    .arb_wready_i(axis_arb_s1_wready_o), 
                                    .arb_arready_i(arb_s1_arready_o), 
                                    .arb_awpipe_en(arb_s1_awpipe_o), 
                                    .arb_arpipe_en(arb_s1_arpipe_o), 
                                    // Memory Interface 
                                .mem_rdata_i(mem1_rdata_w), 
                                    .mem_error_i(mem1_axi_error_i), 
                                    .mem_wr_en_o(mem1_axi_wr_en_o), 
                                    .mem_waddr_o(mem1_axi_waddr_o), 
                                    .mem_wdata_o(mem1_axi_wdata_o), 
                                    .mem_byte_en_o(mem1_axi_byte_en_o), 
                                    .mem_rd_en_o(mem1_axi_rd_en_o), 
                                    .mem_raddr_o(mem1_axi_raddr_o)) ; 
                    end
                else
                    begin : genblk1
                        // ----------------------------
                        // AHB-Lite Subordinate 1 Bridge
                        // ----------------------------
                        sysmem_ipgen_lscc_ahblmem_subordinate #(.DATA_WIDTH(DATA_WIDTH),
                                .ADDR_DEPTH(ADDR_DEPTH),
                                .REG_MODE(REGMODE_S1),
                                .READ_PIPELINE(READ_PIPELINE_S1),
                                .BYTE_ENABLE(T_BYTE_S1_EN),
                                .START_ADDR(S1_START_ADDR),
                                .END_ADDR(S1_END_ADDR),
                                .PORT_TYPE(ACCESS_TYPE_S1),
                                .RESET_MODE(RESET_MODE_S1),
                                .UNALIGNED_EN(UNALIGNED_ACCESS_EN_S1),
                                .UNALIGNED_DIR(SHIFT_DIRECTION_S1),
                                .MEMORY_TYPE(MEMORY_TYPE)) bridge_s1 (.ahbl_hclk_i(sys_clk_w), 
                                    .ahbl_hresetn_i(ahbl_hresetn_i), 
                                    // ------------------------   
                                // AHB-Lite S1 Interface         
                                // ------------------------   
                                .ahbl_hsel_i(ahbl_s1_hsel_i), 
                                    .ahbl_hready_i(ahbl_s1_hready_i), 
                                    .ahbl_haddr_i(t_ahbl_addr_s1_w), 
                                    .ahbl_hburst_i(ahbl_s1_hburst_i), 
                                    .ahbl_hsize_i(ahbl_s1_hsize_i), 
                                    .ahbl_hmastlock_i(ahbl_s1_hmastlock_i), 
                                    .ahbl_hprot_i(ahbl_s1_hprot_i), 
                                    .ahbl_htrans_i(ahbl_s1_htrans_i), 
                                    .ahbl_hwrite_i(ahbl_s1_hwrite_i), 
                                    .ahbl_hwdata_i(ahbl_s1_hwdata_i), 
                                    .ahbl_hreadyout_o(ahbl_s1_hreadyout_o), 
                                    .ahbl_hresp_o(ahbl_s1_hresp_o), 
                                    .ahbl_hrdata_o(ahbl_s1_hrdata_o), 
                                    // ------------------------   
                                // Memory S1 Interface           
                                // ------------------------   
                                .mem_rdata_i(mem1_rdata_w), 
                                    .mem_error_i(mem1_error_w), 
                                    .mem_request_o(mem1_ahbl_request_w), 
                                    .mem_wr_rdn_o(mem1_ahbl_wr_rdn_w), 
                                    .mem_addr_o(mem1_ahbl_addr_w), 
                                    .mem_wdata_o(mem1_ahbl_wdata_w), 
                                    .mem_byte_en_o(mem1_ahbl_byte_en_w)) ; 
                    end
            end
    endgenerate
    generate
        if (DATA_STREAMER_EN) 
            begin : _FIFO_EN
                if ((INTERFACE == "AXI4")) 
                    begin : genblk1
                        if ((STREAMER_INTF == "AXI4")) 
                            begin : genblk1
                                if (STREAMER_CLK_BYPASS) 
                                    begin : genblk1
                                        assign sys_clk_w = axi_aclk_i ; 
                                    end
                                else
                                    begin : genblk1
                                        assign sys_clk_w = axis_rx_aclk_i ; 
                                    end
                                sysmem_ipgen_lscc_axi4stream_rx #(.ADDR_DEPTH(ADDR_DEPTH),
                                        .ADDR_WIDTH(ADDR_WIDTH),
                                        .FIFO_START(STREAMER_START_ADDR),
                                        .DATA_WIDTH(DATA_WIDTH),
                                        .MEM_TYPE(MEMORY_TYPE)) u_axi4_stream_rx (.axis_rx_aclk_i(sys_clk_w), 
                                            .axis_rx_aresetn_i(axi_resetn_i), 
                                            .axis_rx_tvalid_i(axi_rx_tvalid_i), 
                                            .axis_rx_tdata_i(axi_rx_tdata_i), 
                                            .axis_rx_tstrb_i(axi_rx_tstrb_i), 
                                            .axis_rx_tlast_i(axi_rx_tlast_i), 
                                            .axis_rx_tready_o(axi_rx_tready_o), 
                                            .axis_rx_wr_en_o(axis_rx_wr_en_w), 
                                            .axis_rx_wr_data_o(axis_rx_wr_data_w), 
                                            .axis_rx_byte_en_o(axis_rx_byte_en_w), 
                                            .axis_rx_wr_addr_o(axis_rx_wr_addr_w), 
                                            .axis_rx_arb_hold_o(axis_rx_arb_hold_w)) ; 
                                assign mem_axi_waddr_w = (axis_rx_wr_en_w ? axis_rx_wr_addr_w : arb_mem_awaddr_o) ; 
                                assign mem_axi_wr_en_w = (axis_rx_wr_en_w ? axis_rx_wr_en_w : arb_mem_wr_en_o) ; 
                                assign mem_axi_byte_en_w = (axis_rx_wr_en_w ? axis_rx_byte_en_w : arb_mem_byte_en_o) ; 
                                assign mem_axi_wdata_w = (axis_rx_wr_en_w ? axis_rx_wr_data_w : arb_mem_wdata_o) ; 
                                assign axis_arb_s0_awready_o = ((axis_rx_arb_hold_w || axi_rx_tready_o) ? 1'b0 : arb_s0_awready_o) ; 
                                assign axis_arb_s0_wready_o = ((axis_rx_arb_hold_w || axi_rx_tready_o) ? 1'b0 : arb_s0_wready_o) ; 
                                assign axis_arb_s1_awready_o = ((axis_rx_arb_hold_w || axi_rx_tready_o) ? 1'b0 : arb_s1_awready_o) ; 
                                assign axis_arb_s1_wready_o = ((axis_rx_arb_hold_w || axi_rx_tready_o) ? 1'b0 : arb_s1_wready_o) ; 
                            end
                        else
                            begin : genblk1
                                wire fifo_rstn_w ; 
                                assign fifo_rstn_w = (axi_resetn_i | fifo_address_rst_i) ; 
                                sysmem_ipgen_lscc_fifo_streamer #(.ADDR_DEPTH(ADDR_DEPTH),
                                        .FIFO_START(STREAMER_START_ADDR),
                                        .DATA_WIDTH(DATA_WIDTH),
                                        .BYTE_WIDTH(BYTE_WIDTH),
                                        .MEM_TYPE(MEMORY_TYPE)) u_fifo (.fifo_clk_i(sys_clk_w), 
                                            .fifo_wr_en_i(fifo_wr_en_i), 
                                            .fifo_wr_data_i(fifo_wr_data_i), 
                                            .fifo_rst_i(fifo_rstn_w), 
                                            .fifo_full_o(fifo_full_o), 
                                            .mem_wdata_o(mem_fifo_wdata_w), 
                                            .mem_clk_en_o(mem_fifo_clk_en_w), 
                                            .mem_addr_o(mem_fifo_addr_w), 
                                            .mem_byte_en_o(mem_fifo_byte_en_w)) ; 
                                if (STREAMER_CLK_BYPASS) 
                                    begin : genblk1
                                        assign sys_clk_w = axi_aclk_i ; 
                                    end
                                else
                                    begin : genblk1
                                        if ((FAMILY == "LAV-AT")) 
                                            begin : genblk1
                                                DCSA dcs0 (.CLK0(axi_aclk_i), 
                                                            .CLK1(fifo_clk_i), 
                                                            .DCSOUT(sys_clk_w), 
                                                            .SEL(fifo_interface_en_i), 
                                                            .MODESEL(1'b1), 
                                                            .LSR(fifo_rstn_w)) ; 
                                            end
                                        else
                                            begin : genblk1
                                                DCS dcs0 (.CLK0(axi_aclk_i), 
                                                            .CLK1(fifo_clk_i), 
                                                            .DCSOUT(sys_clk_w), 
                                                            .SEL(fifo_interface_en_i), 
                                                            .SELFORCE(1'b1)) ; 
                                            end
                                    end
                                assign mem_axi_waddr_w = (fifo_interface_en_i ? mem_fifo_addr_w : arb_mem_awaddr_o) ; 
                                assign mem_axi_wr_en_w = (fifo_interface_en_i ? fifo_wr_en_i : arb_mem_wr_en_o) ; 
                                assign mem_axi_byte_en_w = (fifo_interface_en_i ? mem_fifo_byte_en_w : arb_mem_byte_en_o) ; 
                                assign mem_axi_wdata_w = (fifo_interface_en_i ? mem_fifo_wdata_w : arb_mem_wdata_o) ; 
                                assign axis_arb_s0_awready_o = (fifo_interface_en_i ? 1'b0 : arb_s0_awready_o) ; 
                                assign axis_arb_s0_wready_o = (fifo_interface_en_i ? 1'b0 : arb_s0_wready_o) ; 
                                assign axis_arb_s1_awready_o = (fifo_interface_en_i ? 1'b0 : arb_s1_awready_o) ; 
                                assign axis_arb_s1_wready_o = (fifo_interface_en_i ? 1'b0 : arb_s1_wready_o) ; 
                            end
                    end
                else
                    begin : genblk1
                        if (STREAMER_CLK_BYPASS) 
                            begin : genblk1
                                assign sys_clk_w = ahbl_hclk_i ; 
                            end
                        else
                            begin : genblk1
                                if ((FAMILY == "LAV-AT")) 
                                    begin : genblk1
                                        DCSA dcs0 (.CLK0(ahbl_hclk_i), 
                                                    .CLK1(fifo_clk_i), 
                                                    .DCSOUT(sys_clk_w), 
                                                    .SEL(fifo_interface_en_i), 
                                                    .MODESEL(1'b1), 
                                                    .LSR(fifo_rstn_w)) ; 
                                    end
                                else
                                    begin : genblk1
                                        DCS dcs0 (.CLK0(ahbl_hclk_i), 
                                                    .CLK1(fifo_clk_i), 
                                                    .DCSOUT(sys_clk_w), 
                                                    .SEL(fifo_interface_en_i), 
                                                    .SELFORCE(1'b1)) ; 
                                    end
                            end
                        wire fifo_rstn_w ; 
                        assign fifo_rstn_w = (ahbl_hresetn_i | fifo_address_rst_i) ; 
                        sysmem_ipgen_lscc_fifo_streamer #(.ADDR_DEPTH(ADDR_DEPTH),
                                .FIFO_START(STREAMER_START_ADDR),
                                .DATA_WIDTH(DATA_WIDTH),
                                .MEM_TYPE(MEMORY_TYPE),
                                .BYTE_WIDTH(BYTE_WIDTH)) u_fifo (.fifo_clk_i(sys_clk_w), 
                                    .fifo_wr_en_i(fifo_wr_en_i), 
                                    .fifo_wr_data_i(fifo_wr_data_i), 
                                    .fifo_rst_i(fifo_rstn_w), 
                                    .fifo_full_o(fifo_full_o), 
                                    .mem_wdata_o(mem_fifo_wdata_w), 
                                    .mem_clk_en_o(mem_fifo_clk_en_w), 
                                    .mem_addr_o(mem_fifo_addr_w), 
                                    .mem_byte_en_o(mem_fifo_byte_en_w)) ; 
                        if ((ACCESS_TYPE_S1 == "DISABLED")) 
                            begin : genblk2
                                assign mem1_request_w = fifo_interface_en_i ; 
                                assign mem1_wr_rdn_w = mem_fifo_clk_en_w ; 
                                assign mem1_addr_w = mem_fifo_addr_w ; 
                                assign mem1_wdata_w = mem_fifo_wdata_w ; 
                                assign mem1_byte_en_w = mem_fifo_byte_en_w ; 
                            end
                        else
                            begin : genblk2
                                assign mem1_request_w = (fifo_interface_en_i | mem1_ahbl_request_w) ; 
                                assign mem1_wr_rdn_w = (fifo_interface_en_i ? mem_fifo_clk_en_w : mem1_ahbl_wr_rdn_w) ; 
                                assign mem1_addr_w = (fifo_interface_en_i ? mem_fifo_addr_w : mem1_ahbl_addr_w) ; 
                                assign mem1_wdata_w = (fifo_interface_en_i ? mem_fifo_wdata_w : mem1_ahbl_wdata_w) ; 
                                assign mem1_byte_en_w = (fifo_interface_en_i ? mem_fifo_byte_en_w : mem1_ahbl_byte_en_w) ; 
                            end
                    end
            end
        else
            begin : _FIFO_DIS
                if ((INTERFACE == "AXI4")) 
                    begin : genblk1
                        assign sys_clk_w = axi_aclk_i ; 
                        assign mem_axi_waddr_w = arb_mem_awaddr_o ; 
                        assign mem_axi_wr_en_w = arb_mem_wr_en_o ; 
                        assign mem_axi_byte_en_w = arb_mem_byte_en_o ; 
                        assign mem_axi_wdata_w = arb_mem_wdata_o ; 
                        assign axis_arb_s0_awready_o = arb_s0_awready_o ; 
                        assign axis_arb_s0_wready_o = arb_s0_wready_o ; 
                        assign axis_arb_s1_awready_o = arb_s1_awready_o ; 
                        assign axis_arb_s1_wready_o = arb_s1_wready_o ; 
                    end
                else
                    begin : genblk1
                        assign sys_clk_w = ahbl_hclk_i ; 
                        assign mem1_request_w = mem1_ahbl_request_w ; 
                        assign mem1_wr_rdn_w = mem1_ahbl_wr_rdn_w ; 
                        assign mem1_addr_w = mem1_ahbl_addr_w ; 
                        assign mem1_wdata_w = mem1_ahbl_wdata_w ; 
                        assign mem1_byte_en_w = mem1_ahbl_byte_en_w ; 
                    end
            end
    endgenerate
    // ------------------------   
    // Core Memory           
    // ------------------------  
    generate
        begin : CORE_MEMORY
            if ((INTERFACE == "AXI4")) 
                begin : genblk1
                    sysmem_ipgen_lscc_mem #(.INTERFACE(INTERFACE),
                            .ADDR_DEPTH(ADDR_DEPTH),
                            .DATA_WIDTH(DATA_WIDTH),
                            .ECC_ENABLE(ECC_ENABLE),
                            .MEMORY_TYPE(MEMORY_TYPE),
                            .MEM_REGMODE_A(AXI_REGMODE_S0),
                            .MEM_REGMODE_B(AXI_REGMODE_S1),
                            .BYTE_ENABLE_S0(BYTE_ENABLE_S0),
                            .BYTE_ENABLE_S1(0),
                            .ACCESS_TYPE_S0(ACCESS_TYPE_S0),
                            .ACCESS_TYPE_S1(T_ACCESS_TYPE_S1),
                            .RESET_MODE_S0(RESET_MODE_S0),
                            .RESET_MODE_S1(RESET_MODE_S1),
                            .UNALIGNED_ACCESS_ENABLE((UNALIGNED_ACCESS_EN_S0 || UNALIGNED_ACCESS_EN_S1)),
                            .INIT_FILE(INIT_FILE),
                            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                            .FAMILY(T_FAMILY),
                            .MEM_SIZE(MEM_SIZE),
                            .MEM_ID(MEM_ID),
                            .INIT_VALUE_00(INIT_VALUE_00),
                            .INIT_VALUE_01(INIT_VALUE_01),
                            .INIT_VALUE_02(INIT_VALUE_02),
                            .INIT_VALUE_03(INIT_VALUE_03),
                            .INIT_VALUE_04(INIT_VALUE_04),
                            .INIT_VALUE_05(INIT_VALUE_05),
                            .INIT_VALUE_06(INIT_VALUE_06),
                            .INIT_VALUE_07(INIT_VALUE_07),
                            .INIT_VALUE_08(INIT_VALUE_08),
                            .INIT_VALUE_09(INIT_VALUE_09),
                            .INIT_VALUE_0A(INIT_VALUE_0A),
                            .INIT_VALUE_0B(INIT_VALUE_0B),
                            .INIT_VALUE_0C(INIT_VALUE_0C),
                            .INIT_VALUE_0D(INIT_VALUE_0D),
                            .INIT_VALUE_0E(INIT_VALUE_0E),
                            .INIT_VALUE_0F(INIT_VALUE_0F),
                            .INIT_VALUE_10(INIT_VALUE_10),
                            .INIT_VALUE_11(INIT_VALUE_11),
                            .INIT_VALUE_12(INIT_VALUE_12),
                            .INIT_VALUE_13(INIT_VALUE_13),
                            .INIT_VALUE_14(INIT_VALUE_14),
                            .INIT_VALUE_15(INIT_VALUE_15),
                            .INIT_VALUE_16(INIT_VALUE_16),
                            .INIT_VALUE_17(INIT_VALUE_17),
                            .INIT_VALUE_18(INIT_VALUE_18),
                            .INIT_VALUE_19(INIT_VALUE_19),
                            .INIT_VALUE_1A(INIT_VALUE_1A),
                            .INIT_VALUE_1B(INIT_VALUE_1B),
                            .INIT_VALUE_1C(INIT_VALUE_1C),
                            .INIT_VALUE_1D(INIT_VALUE_1D),
                            .INIT_VALUE_1E(INIT_VALUE_1E),
                            .INIT_VALUE_1F(INIT_VALUE_1F),
                            .INIT_VALUE_20(INIT_VALUE_20),
                            .INIT_VALUE_21(INIT_VALUE_21),
                            .INIT_VALUE_22(INIT_VALUE_22),
                            .INIT_VALUE_23(INIT_VALUE_23),
                            .INIT_VALUE_24(INIT_VALUE_24),
                            .INIT_VALUE_25(INIT_VALUE_25),
                            .INIT_VALUE_26(INIT_VALUE_26),
                            .INIT_VALUE_27(INIT_VALUE_27),
                            .INIT_VALUE_28(INIT_VALUE_28),
                            .INIT_VALUE_29(INIT_VALUE_29),
                            .INIT_VALUE_2A(INIT_VALUE_2A),
                            .INIT_VALUE_2B(INIT_VALUE_2B),
                            .INIT_VALUE_2C(INIT_VALUE_2C),
                            .INIT_VALUE_2D(INIT_VALUE_2D),
                            .INIT_VALUE_2E(INIT_VALUE_2E),
                            .INIT_VALUE_2F(INIT_VALUE_2F),
                            .INIT_VALUE_30(INIT_VALUE_30),
                            .INIT_VALUE_31(INIT_VALUE_31),
                            .INIT_VALUE_32(INIT_VALUE_32),
                            .INIT_VALUE_33(INIT_VALUE_33),
                            .INIT_VALUE_34(INIT_VALUE_34),
                            .INIT_VALUE_35(INIT_VALUE_35),
                            .INIT_VALUE_36(INIT_VALUE_36),
                            .INIT_VALUE_37(INIT_VALUE_37),
                            .INIT_VALUE_38(INIT_VALUE_38),
                            .INIT_VALUE_39(INIT_VALUE_39),
                            .INIT_VALUE_3A(INIT_VALUE_3A),
                            .INIT_VALUE_3B(INIT_VALUE_3B),
                            .INIT_VALUE_3C(INIT_VALUE_3C),
                            .INIT_VALUE_3D(INIT_VALUE_3D),
                            .INIT_VALUE_3E(INIT_VALUE_3E),
                            .INIT_VALUE_3F(INIT_VALUE_3F),
                            .INIT_VALUE_40(INIT_VALUE_40),
                            .INIT_VALUE_41(INIT_VALUE_41),
                            .INIT_VALUE_42(INIT_VALUE_42),
                            .INIT_VALUE_43(INIT_VALUE_43),
                            .INIT_VALUE_44(INIT_VALUE_44),
                            .INIT_VALUE_45(INIT_VALUE_45),
                            .INIT_VALUE_46(INIT_VALUE_46),
                            .INIT_VALUE_47(INIT_VALUE_47),
                            .INIT_VALUE_48(INIT_VALUE_48),
                            .INIT_VALUE_49(INIT_VALUE_49),
                            .INIT_VALUE_4A(INIT_VALUE_4A),
                            .INIT_VALUE_4B(INIT_VALUE_4B),
                            .INIT_VALUE_4C(INIT_VALUE_4C),
                            .INIT_VALUE_4D(INIT_VALUE_4D),
                            .INIT_VALUE_4E(INIT_VALUE_4E),
                            .INIT_VALUE_4F(INIT_VALUE_4F),
                            .INIT_VALUE_50(INIT_VALUE_50),
                            .INIT_VALUE_51(INIT_VALUE_51),
                            .INIT_VALUE_52(INIT_VALUE_52),
                            .INIT_VALUE_53(INIT_VALUE_53),
                            .INIT_VALUE_54(INIT_VALUE_54),
                            .INIT_VALUE_55(INIT_VALUE_55),
                            .INIT_VALUE_56(INIT_VALUE_56),
                            .INIT_VALUE_57(INIT_VALUE_57),
                            .INIT_VALUE_58(INIT_VALUE_58),
                            .INIT_VALUE_59(INIT_VALUE_59),
                            .INIT_VALUE_5A(INIT_VALUE_5A),
                            .INIT_VALUE_5B(INIT_VALUE_5B),
                            .INIT_VALUE_5C(INIT_VALUE_5C),
                            .INIT_VALUE_5D(INIT_VALUE_5D),
                            .INIT_VALUE_5E(INIT_VALUE_5E),
                            .INIT_VALUE_5F(INIT_VALUE_5F),
                            .INIT_VALUE_60(INIT_VALUE_60),
                            .INIT_VALUE_61(INIT_VALUE_61),
                            .INIT_VALUE_62(INIT_VALUE_62),
                            .INIT_VALUE_63(INIT_VALUE_63),
                            .INIT_VALUE_64(INIT_VALUE_64),
                            .INIT_VALUE_65(INIT_VALUE_65),
                            .INIT_VALUE_66(INIT_VALUE_66),
                            .INIT_VALUE_67(INIT_VALUE_67),
                            .INIT_VALUE_68(INIT_VALUE_68),
                            .INIT_VALUE_69(INIT_VALUE_69),
                            .INIT_VALUE_6A(INIT_VALUE_6A),
                            .INIT_VALUE_6B(INIT_VALUE_6B),
                            .INIT_VALUE_6C(INIT_VALUE_6C),
                            .INIT_VALUE_6D(INIT_VALUE_6D),
                            .INIT_VALUE_6E(INIT_VALUE_6E),
                            .INIT_VALUE_6F(INIT_VALUE_6F),
                            .INIT_VALUE_70(INIT_VALUE_70),
                            .INIT_VALUE_71(INIT_VALUE_71),
                            .INIT_VALUE_72(INIT_VALUE_72),
                            .INIT_VALUE_73(INIT_VALUE_73),
                            .INIT_VALUE_74(INIT_VALUE_74),
                            .INIT_VALUE_75(INIT_VALUE_75),
                            .INIT_VALUE_76(INIT_VALUE_76),
                            .INIT_VALUE_77(INIT_VALUE_77),
                            .INIT_VALUE_78(INIT_VALUE_78),
                            .INIT_VALUE_79(INIT_VALUE_79),
                            .INIT_VALUE_7A(INIT_VALUE_7A),
                            .INIT_VALUE_7B(INIT_VALUE_7B),
                            .INIT_VALUE_7C(INIT_VALUE_7C),
                            .INIT_VALUE_7D(INIT_VALUE_7D),
                            .INIT_VALUE_7E(INIT_VALUE_7E),
                            .INIT_VALUE_7F(INIT_VALUE_7F)) u_lscc_mem0 (// Outputs
                            .mem_rdata_a_o(mem0_rdata_w[(DATA_WIDTH - 1):0]), 
                                .mem_error_a_o({ecc_ded_s0_o,
                                    ecc_sec_s0_o}), 
                                .mem_rdata_b_o(mem1_rdata_w[(DATA_WIDTH - 1):0]), 
                                .mem_error_b_o({ecc_ded_s1_o,
                                    ecc_sec_s1_o}), 
                                // Inputs
                            .mem_clk_a_i(sys_clk_w), 
                                .mem_rst_n_a_i(axi_resetn_i), 
                                .mem_request_a_i(mem_axi_wr_en_w), 
                                .mem_wr_rdn_a_i(1'b1), 
                                .mem_addr_a_i(mem_axi_waddr_w), 
                                .mem_wdata_a_i(mem_axi_wdata_w), 
                                .mem_byte_en_a_i(mem_axi_byte_en_w), 
                                .mem_clk_b_i(sys_clk_w), 
                                .mem_rst_n_b_i(axi_resetn_i), 
                                .mem_request_b_i(arb_mem_rd_en_o), 
                                .mem_wr_rdn_b_i(1'b0), 
                                .mem_addr_b_i(arb_mem_araddr_o), 
                                .mem_wdata_b_i({DATA_WIDTH{1'b0}}), 
                                .mem_byte_en_b_i({BYTE_WIDTH{1'b0}})) ; 
                end
            else
                begin : genblk1
                    sysmem_ipgen_lscc_mem #(.ADDR_DEPTH(ADDR_DEPTH),
                            .DATA_WIDTH(DATA_WIDTH),
                            .ECC_ENABLE(ECC_ENABLE),
                            .MEMORY_TYPE(MEMORY_TYPE),
                            .MEM_REGMODE_A(REGMODE_S0),
                            .MEM_REGMODE_B(REGMODE_S1),
                            .BYTE_ENABLE_S0(T_BYTE_S0_EN),
                            .BYTE_ENABLE_S1(T_BYTE_S1_EN),
                            .ACCESS_TYPE_S0(ACCESS_TYPE_S0),
                            .ACCESS_TYPE_S1(T_ACCESS_TYPE_S1),
                            .RESET_MODE_S0(RESET_MODE_S0),
                            .RESET_MODE_S1(RESET_MODE_S1),
                            .UNALIGNED_ACCESS_ENABLE((UNALIGNED_ACCESS_EN_S0 || UNALIGNED_ACCESS_EN_S1)),
                            .READ_PIPELINE_S0(READ_PIPELINE_S0),
                            .READ_PIPELINE_S1(READ_PIPELINE_S1),
                            .INIT_FILE(INIT_FILE),
                            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
                            .FAMILY(T_FAMILY),
                            .MEM_SIZE(MEM_SIZE),
                            .MEM_ID(MEM_ID),
                            .INIT_VALUE_00(INIT_VALUE_00),
                            .INIT_VALUE_01(INIT_VALUE_01),
                            .INIT_VALUE_02(INIT_VALUE_02),
                            .INIT_VALUE_03(INIT_VALUE_03),
                            .INIT_VALUE_04(INIT_VALUE_04),
                            .INIT_VALUE_05(INIT_VALUE_05),
                            .INIT_VALUE_06(INIT_VALUE_06),
                            .INIT_VALUE_07(INIT_VALUE_07),
                            .INIT_VALUE_08(INIT_VALUE_08),
                            .INIT_VALUE_09(INIT_VALUE_09),
                            .INIT_VALUE_0A(INIT_VALUE_0A),
                            .INIT_VALUE_0B(INIT_VALUE_0B),
                            .INIT_VALUE_0C(INIT_VALUE_0C),
                            .INIT_VALUE_0D(INIT_VALUE_0D),
                            .INIT_VALUE_0E(INIT_VALUE_0E),
                            .INIT_VALUE_0F(INIT_VALUE_0F),
                            .INIT_VALUE_10(INIT_VALUE_10),
                            .INIT_VALUE_11(INIT_VALUE_11),
                            .INIT_VALUE_12(INIT_VALUE_12),
                            .INIT_VALUE_13(INIT_VALUE_13),
                            .INIT_VALUE_14(INIT_VALUE_14),
                            .INIT_VALUE_15(INIT_VALUE_15),
                            .INIT_VALUE_16(INIT_VALUE_16),
                            .INIT_VALUE_17(INIT_VALUE_17),
                            .INIT_VALUE_18(INIT_VALUE_18),
                            .INIT_VALUE_19(INIT_VALUE_19),
                            .INIT_VALUE_1A(INIT_VALUE_1A),
                            .INIT_VALUE_1B(INIT_VALUE_1B),
                            .INIT_VALUE_1C(INIT_VALUE_1C),
                            .INIT_VALUE_1D(INIT_VALUE_1D),
                            .INIT_VALUE_1E(INIT_VALUE_1E),
                            .INIT_VALUE_1F(INIT_VALUE_1F),
                            .INIT_VALUE_20(INIT_VALUE_20),
                            .INIT_VALUE_21(INIT_VALUE_21),
                            .INIT_VALUE_22(INIT_VALUE_22),
                            .INIT_VALUE_23(INIT_VALUE_23),
                            .INIT_VALUE_24(INIT_VALUE_24),
                            .INIT_VALUE_25(INIT_VALUE_25),
                            .INIT_VALUE_26(INIT_VALUE_26),
                            .INIT_VALUE_27(INIT_VALUE_27),
                            .INIT_VALUE_28(INIT_VALUE_28),
                            .INIT_VALUE_29(INIT_VALUE_29),
                            .INIT_VALUE_2A(INIT_VALUE_2A),
                            .INIT_VALUE_2B(INIT_VALUE_2B),
                            .INIT_VALUE_2C(INIT_VALUE_2C),
                            .INIT_VALUE_2D(INIT_VALUE_2D),
                            .INIT_VALUE_2E(INIT_VALUE_2E),
                            .INIT_VALUE_2F(INIT_VALUE_2F),
                            .INIT_VALUE_30(INIT_VALUE_30),
                            .INIT_VALUE_31(INIT_VALUE_31),
                            .INIT_VALUE_32(INIT_VALUE_32),
                            .INIT_VALUE_33(INIT_VALUE_33),
                            .INIT_VALUE_34(INIT_VALUE_34),
                            .INIT_VALUE_35(INIT_VALUE_35),
                            .INIT_VALUE_36(INIT_VALUE_36),
                            .INIT_VALUE_37(INIT_VALUE_37),
                            .INIT_VALUE_38(INIT_VALUE_38),
                            .INIT_VALUE_39(INIT_VALUE_39),
                            .INIT_VALUE_3A(INIT_VALUE_3A),
                            .INIT_VALUE_3B(INIT_VALUE_3B),
                            .INIT_VALUE_3C(INIT_VALUE_3C),
                            .INIT_VALUE_3D(INIT_VALUE_3D),
                            .INIT_VALUE_3E(INIT_VALUE_3E),
                            .INIT_VALUE_3F(INIT_VALUE_3F),
                            .INIT_VALUE_40(INIT_VALUE_40),
                            .INIT_VALUE_41(INIT_VALUE_41),
                            .INIT_VALUE_42(INIT_VALUE_42),
                            .INIT_VALUE_43(INIT_VALUE_43),
                            .INIT_VALUE_44(INIT_VALUE_44),
                            .INIT_VALUE_45(INIT_VALUE_45),
                            .INIT_VALUE_46(INIT_VALUE_46),
                            .INIT_VALUE_47(INIT_VALUE_47),
                            .INIT_VALUE_48(INIT_VALUE_48),
                            .INIT_VALUE_49(INIT_VALUE_49),
                            .INIT_VALUE_4A(INIT_VALUE_4A),
                            .INIT_VALUE_4B(INIT_VALUE_4B),
                            .INIT_VALUE_4C(INIT_VALUE_4C),
                            .INIT_VALUE_4D(INIT_VALUE_4D),
                            .INIT_VALUE_4E(INIT_VALUE_4E),
                            .INIT_VALUE_4F(INIT_VALUE_4F),
                            .INIT_VALUE_50(INIT_VALUE_50),
                            .INIT_VALUE_51(INIT_VALUE_51),
                            .INIT_VALUE_52(INIT_VALUE_52),
                            .INIT_VALUE_53(INIT_VALUE_53),
                            .INIT_VALUE_54(INIT_VALUE_54),
                            .INIT_VALUE_55(INIT_VALUE_55),
                            .INIT_VALUE_56(INIT_VALUE_56),
                            .INIT_VALUE_57(INIT_VALUE_57),
                            .INIT_VALUE_58(INIT_VALUE_58),
                            .INIT_VALUE_59(INIT_VALUE_59),
                            .INIT_VALUE_5A(INIT_VALUE_5A),
                            .INIT_VALUE_5B(INIT_VALUE_5B),
                            .INIT_VALUE_5C(INIT_VALUE_5C),
                            .INIT_VALUE_5D(INIT_VALUE_5D),
                            .INIT_VALUE_5E(INIT_VALUE_5E),
                            .INIT_VALUE_5F(INIT_VALUE_5F),
                            .INIT_VALUE_60(INIT_VALUE_60),
                            .INIT_VALUE_61(INIT_VALUE_61),
                            .INIT_VALUE_62(INIT_VALUE_62),
                            .INIT_VALUE_63(INIT_VALUE_63),
                            .INIT_VALUE_64(INIT_VALUE_64),
                            .INIT_VALUE_65(INIT_VALUE_65),
                            .INIT_VALUE_66(INIT_VALUE_66),
                            .INIT_VALUE_67(INIT_VALUE_67),
                            .INIT_VALUE_68(INIT_VALUE_68),
                            .INIT_VALUE_69(INIT_VALUE_69),
                            .INIT_VALUE_6A(INIT_VALUE_6A),
                            .INIT_VALUE_6B(INIT_VALUE_6B),
                            .INIT_VALUE_6C(INIT_VALUE_6C),
                            .INIT_VALUE_6D(INIT_VALUE_6D),
                            .INIT_VALUE_6E(INIT_VALUE_6E),
                            .INIT_VALUE_6F(INIT_VALUE_6F),
                            .INIT_VALUE_70(INIT_VALUE_70),
                            .INIT_VALUE_71(INIT_VALUE_71),
                            .INIT_VALUE_72(INIT_VALUE_72),
                            .INIT_VALUE_73(INIT_VALUE_73),
                            .INIT_VALUE_74(INIT_VALUE_74),
                            .INIT_VALUE_75(INIT_VALUE_75),
                            .INIT_VALUE_76(INIT_VALUE_76),
                            .INIT_VALUE_77(INIT_VALUE_77),
                            .INIT_VALUE_78(INIT_VALUE_78),
                            .INIT_VALUE_79(INIT_VALUE_79),
                            .INIT_VALUE_7A(INIT_VALUE_7A),
                            .INIT_VALUE_7B(INIT_VALUE_7B),
                            .INIT_VALUE_7C(INIT_VALUE_7C),
                            .INIT_VALUE_7D(INIT_VALUE_7D),
                            .INIT_VALUE_7E(INIT_VALUE_7E),
                            .INIT_VALUE_7F(INIT_VALUE_7F)) u_lscc_mem0 (// Outputs
                            .mem_rdata_a_o(mem0_rdata_w[(DATA_WIDTH - 1):0]), 
                                .mem_error_a_o({ecc_ded_s0_o,
                                    ecc_sec_s0_o}), 
                                .mem_rdata_b_o(mem1_rdata_w[(DATA_WIDTH - 1):0]), 
                                .mem_error_b_o({ecc_ded_s1_o,
                                    ecc_sec_s1_o}), 
                                // Inputs
                            .mem_clk_a_i(sys_clk_w), 
                                .mem_rst_n_a_i(ahbl_hresetn_i), 
                                .mem_request_a_i(mem0_req_arb_w), 
                                .mem_wr_rdn_a_i(mem0_wr_rdn_arb_w), 
                                .mem_addr_a_i(mem0_addr_w), 
                                .mem_wdata_a_i(mem0_wdata_w), 
                                .mem_byte_en_a_i(mem0_byte_en_w), 
                                .mem_clk_b_i(sys_clk_w), 
                                .mem_rst_n_b_i(ahbl_hresetn_i), 
                                .mem_request_b_i(mem1_req_arb_w), 
                                .mem_wr_rdn_b_i(mem1_wr_rdn_arb_w), 
                                .mem_addr_b_i(mem1_addr_w), 
                                .mem_wdata_b_i(mem1_wdata_w), 
                                .mem_byte_en_b_i(mem1_byte_en_w)) ; 
                end
        end
    endgenerate
    // ------------------------   
    // Arbiter           
    // ------------------------ 
    if ((INTERFACE == "AXI4")) 
        begin : AXI4_ARB
            sysmem_ipgen_lscc_axi4mem_arbiter #(.PORT_TYPE_S0(ACCESS_TYPE_S0),
                    .PORT_TYPE_S1(ACCESS_TYPE_S1),
                    .DATA_WIDTH(DATA_WIDTH),
                    .ADDR_WIDTH(ADDR_WIDTH),
                    .ARBITER_EN(ARBITER_EN)) u_arbiter (// Common Signal
                    .clk_i(axi_aclk_i), 
                        .rstn_i(axi_resetn_i), 
                        // Memory 0
                    .axi_s0_awvalid_i(axi_s0_awvalid_i), 
                        .axi_s0_wvalid_i(axi_s0_wvalid_i), 
                        .axi_s0_awpipeline_i(arb_s0_awpipe_o), 
                        .axi_s0_arvalid_i(axi_s0_arvalid_i), 
                        .axi_s0_arpipeline_i(arb_s0_arpipe_o), 
                        .axi_s0_awaddr_i(mem0_axi_waddr_o), 
                        .axi_s0_wr_en_i(mem0_axi_wr_en_o), 
                        .axi_s0_byte_en_i(mem0_axi_byte_en_o), 
                        .axi_s0_wdata_i(mem0_axi_wdata_o), 
                        .axi_s0_rd_en_i(mem0_axi_rd_en_o), 
                        .axi_s0_araddr_i(mem0_axi_raddr_o), 
                        .axi_s0_awready_o(arb_s0_awready_o), 
                        .axi_s0_wready_o(arb_s0_wready_o), 
                        .axi_s0_arready_o(arb_s0_arready_o), 
                        // Memory 1
                    .axi_s1_awvalid_i(axi_s1_awvalid_i), 
                        .axi_s1_wvalid_i(axi_s1_wvalid_i), 
                        .axi_s1_awpipeline_i(arb_s1_awpipe_o), 
                        .axi_s1_arvalid_i(axi_s1_arvalid_i), 
                        .axi_s1_arpipeline_i(arb_s1_arpipe_o), 
                        .axi_s1_awaddr_i(mem1_axi_waddr_o), 
                        .axi_s1_wr_en_i(mem1_axi_wr_en_o), 
                        .axi_s1_byte_en_i(mem1_axi_byte_en_o), 
                        .axi_s1_wdata_i(mem1_axi_wdata_o), 
                        .axi_s1_rd_en_i(mem1_axi_rd_en_o), 
                        .axi_s1_araddr_i(mem1_axi_raddr_o), 
                        .axi_s1_awready_o(arb_s1_awready_o), 
                        .axi_s1_wready_o(arb_s1_wready_o), 
                        .axi_s1_arready_o(arb_s1_arready_o), 
                        // Arbitration
                    .arb_mem_awaddr_o(arb_mem_awaddr_o), 
                        .arb_mem_wdata_o(arb_mem_wdata_o), 
                        .arb_mem_wr_en_o(arb_mem_wr_en_o), 
                        .arb_mem_byte_en_o(arb_mem_byte_en_o), 
                        .arb_mem_araddr_o(arb_mem_araddr_o), 
                        .arb_mem_rd_en_o(arb_mem_rd_en_o)) ; 
        end
    else
        begin : AHBL_ARB
            sysmem_ipgen_lscc_ahblmem_arbiter #(.PORT_TYPE_S0(ACCESS_TYPE_S0),
                    .PORT_TYPE_S1(ACCESS_TYPE_S1),
                    .ADDR_WIDTH(ADDR_WIDTH),
                    .RESET_MODE((((RESET_MODE_S0 == "async") || (RESET_MODE_S1 == "async")) ? "async" : "sync")),
                    .ARBITER_EN(ARBITER_EN)) u_arbiter (// Common Signal
                    .clk_i(ahbl_hclk_i), 
                        .rst_i(ahbl_hresetn_i), 
                        // Memory 0 Signal
                    .addr_s0_i(mem0_addr_w), 
                        .mem_wr_rdn_s0_i(mem0_wr_rdn_w), 
                        .mem_req_s0_i(mem0_request_w), 
                        .mem_wr_rdn_s0_o(mem0_wr_rdn_arb_w), 
                        .mem_req_s0_o(mem0_req_arb_w), 
                        // Memory 1 Signal
                    .addr_s1_i(mem1_addr_w), 
                        .mem_wr_rdn_s1_i(mem1_wr_rdn_w), 
                        .mem_req_s1_i(mem1_request_w), 
                        .mem_wr_rdn_s1_o(mem1_wr_rdn_arb_w), 
                        .mem_req_s1_o(mem1_req_arb_w)) ; 
        end
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule


