// >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
// ------------------------------------------------------------------
// Copyright (c) 2019-2024 by Lattice Semiconductor Corporation
// ALL RIGHTS RESERVED
// ------------------------------------------------------------------
//
// IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL
// DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.
//
// Lattice grants permission to use this code pursuant to the
// terms of the Lattice Propel License Agreement.
//
// DISCLAIMER:
//
//  LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER
//  EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE
//  PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE 
//  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR
//  FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE
//  FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT
//  LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE
//  OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS
//  HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR 
//  SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE
//  PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE
//  ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE
//  OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL 
//  ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR
//  ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE 
//  SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
//  INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST
//  PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF
//  LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S
//  SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  
//  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR
//  USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY
//  RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY
//  THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE
//  USE OF FORMAL SOFTWARE VALIDATION METHODS.
// ------------------------------------------------------------------

#include "hal.h"
#include "utils.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "sys_platform.h"
#include <riscv_errors.h>

#if REG_TEST_ENABLE
#include "reg_test.h"
#endif

#ifdef UART_INST_BASE_ADDR
#include "uart.h"

#ifndef _UART_NO_INTERRUPTS_
#include "pic.h"
#endif
#endif

#ifdef APB_GPIO_INST_BASE_ADDR
#include "gpio.h"
struct gpio_instance gpio_inst;
#endif


static uint8_t done_led = 0;
static uint8_t error_led = 1;

#if (defined UART_INST_BASE_ADDR)
struct uart_instance uart_core_uart;
#elif (defined LOCAL_UART_INST_BASE_ADDR)
struct local_uart_instance local_uart_core;
#endif

static int lscc_uart_putc(char c, FILE *file)
{
#ifdef LSCC_STDIO_UART_APB
		int ret = EOF;
#if (defined UART_INST_BASE_ADDR)
		ret = uart_putc(&uart_core_uart, c);
		if (c == '\n' && ret == 0)
			ret = uart_putc(&uart_core_uart, '\r');
#elif (defined LOCAL_UART_INST_BASE_ADDR)
		ret = local_uart_putc(&local_uart_core, c);
		if (c == '\n' && ret == 0)
			ret = local_uart_putc(&local_uart_core, '\r');
#endif
		return ret;
#else
		return EOF;
#endif
}


static int lscc_uart_getc(FILE *file)
{
	(void) file;
	return EOF;
}


static int lscc_uart_flush(FILE *file)
{
	(void) file;
	return 0;
}


static void bsp_init(void)
{
#if (defined UART_INST_BASE_ADDR)
#ifndef _UART_NO_INTERRUPTS_
	//setup uart IRQ
	pic_init(CPU0_INST_PICTIMER_START_ADDR);
	uart_core_uart.intrLevel = UART0_INST_IRQ;
	uart_core_uart.intrAvail = true;
	//pic_isr_register(UART0_INST_IRQ, uart_isr, (void *)&uart_core_uart);
#endif

	//initialize UART
	uart_init(&uart_core_uart, UART_INST_BASE_ADDR, UART_INST_SYS_CLK * 1000000, UART_INST_BAUD_RATE, 1, 8);
#elif (defined LOCAL_UART_INST_BASE_ADDR)
    local_uart_init(&local_uart_core, LOCAL_UART_INST_BASE_ADDR, CPU0_INST_SYS_CLOCK_FREQ * 1000000, CPU0_INST_BAUD_RATE, 1, 8);
#endif
//	iob_init(lscc_uart_putc, lscc_uart_getc, lscc_uart_flush);
	trap_init();

#if REG_TEST_ENABLE
	/* Used for register access test, If not sure how to use, disable it. */
	reg_test_assert(mem_access_test());
	printf("\nmem_access_test success!\n\n");
#endif

#ifdef APB_GPIO_INST_BASE_ADDR
	//initialize GPIO
	gpio_inst.instance_name = APB_GPIO_INST_NAME;
	gpio_init(&gpio_inst, APB_GPIO_INST_BASE_ADDR, APB_GPIO_INST_LINES_NUM, APB_GPIO_INST_GPIO_DIRS);
#endif

#ifdef RISCV_RX_DRV_VER
	/*If driver support, set global interrupt-enable bit to 1.*/
	plic_enable_global_interrupts(1);
#endif
}


/* function returning the max between two numbers */
int write_u8_test(volatile uint8_t *rpc, uint32_t count) {

	volatile uint8_t *address;
	uint32_t printcnt = 0;

//	printf("Starting U8 RPC Write Test\n");

	srand(0); //Manually initialize the randomness seed
	address = rpc;

	for(uint32_t i=0; i<count; i++){

		*address++ = (uint8_t) i; //(uint8_t)(rand() % (int)pow(2,8));

//		printcnt++;
//		if (printcnt == count/100) {
//			printf("\rWritting memory U8 %d %", 100 * i / count);
//			printcnt = 0;
//		}

	}
//	printf("\nDone Writting memory U8\n");
	return 0;
}

int write_u16_test(volatile uint16_t *rpc, uint32_t count) {

	volatile uint16_t *address;
	uint32_t printcnt = 0;

//	printf("Starting U16 RPC Write Test\n");

	srand(0); //Manually initialize the randomness seed
	address = rpc;

	for(uint32_t i=0; i<count; i++){

		*address++ = (uint16_t) i; //(uint16_t)(rand() % (int)pow(2,16));

//		printcnt++;
//		if (printcnt == count/100) {
//			printf("\rWritting memory U16 %d %", 100 * i / count);
//			printcnt = 0;
//		}

	}
//	printf("\nDone Writting memory U16\n");
	return 0;
}

int write_u32_test(volatile uint32_t *rpc, uint32_t count) {

	volatile uint32_t *address;
	uint32_t printcnt = 0;

//	printf("Starting U32 RPC Write Test\n");

	srand(0); //Manually initialize the randomness seed
	address = rpc;

	for(uint32_t i=0; i<count; i++){

		*address++ = i;//(uint32_t)(rand() % (int)pow(2,32));

//		printcnt++;
//		if (printcnt == count/100) {
//			printf("\rWritting memory U32 %d %", 100 * i / count);
//			printcnt = 0;
//		}

	}
//	printf("\nDone Writting memory U32\n");
	return 0;
}

int read_u8_test(volatile uint8_t *rpc, uint32_t count) {

	volatile uint8_t *address;
	uint32_t printcnt = 0;
	uint8_t value, gold = 0;

//	printf("Starting Byte U8 Read Test\n");

	srand(0); //Manually initialize the randomness seed
	address = rpc;

	for(uint32_t i=0; i<count; i++){

		value = *address;
		gold  = (uint8_t) i; //(uint32_t)(rand() % (int)pow(2,8));

		if(value != gold){
//			printf("ERROR!, offset: 0x%8X read: %d, expected: %d \n",address,value,gold);
			gpio_output_write(&gpio_inst, error_led, 0xff);
		}
		address++;

//		printcnt++;
//		if (printcnt == count/100) {
//			printf("\rReading memory U8 %d%", 100 * i / count);
//			printcnt = 0;
//		}

	}
//	printf("\nDone Reading memory U8\n");
	return 0;
}

int read_u16_test(volatile uint16_t *rpc, uint32_t count) {

	volatile uint16_t *address;
	uint32_t printcnt = 0;
	uint16_t value, gold = 0;

//	printf("Starting U16 RPC Read Test\n");

	srand(0); //Manually initialize the randomness seed
	address = rpc;

	for(uint32_t i=0; i<count; i++){

		value = *address;
		gold  = (uint16_t) i; //(uint32_t)(rand() % (int)pow(2,16));

		if(value != gold){
//			printf("ERROR!, offset: 0x%8X read: %d, expected: %d \n",address,value,gold);
			gpio_output_write(&gpio_inst, error_led, 0xff);
		}
		address++;

//		printcnt++;
//		if (printcnt == count/100) {
//			printf("\rReading memory U16 %d %", 100 * i / count);
//			printcnt = 0;
//		}

	}
//	printf("\nDone Reading memory U16\n");
	return 0;
}

int read_u32_test(volatile uint32_t *rpc, uint32_t count) {

	volatile uint32_t *address;
	uint32_t printcnt = 0;
	uint32_t value, gold = 0;

//	printf("Starting U32 RPC Read Test\n");

	srand(0); //Manually initialize the randomness seed
	address = rpc;

	for(uint32_t i=0; i<count; i++){

		value = *address;
		gold  = i; //(uint32_t)(rand() % (int)pow(2,32));

		if(value != gold){
//			printf("ERROR!, offset: 0x%8X read: %d, expected: %d \n",address,value,gold);
			gpio_output_write(&gpio_inst, error_led, 0xff);
		}
		address++;

//		printcnt++;
//		if (printcnt == count/100) {
//			printf("\rReading memory U32 %d %", 100 * i / count);
//			printcnt = 0;
//		}

	}
//	printf("\nDone Reading memory U32\n");
	return 0;
}


int main(void) {

	bsp_init();

	volatile uint8_t  *hpr8  = (uint8_t  *)HYPERRAM_INST_BASE_ADDR;
	volatile uint16_t *hpr16 = (uint16_t *)HYPERRAM_INST_BASE_ADDR;
	volatile uint32_t *hpr32 = (uint32_t *)HYPERRAM_INST_BASE_ADDR;

	uint32_t count8  = 8*1024*1024;
	uint32_t count16 = count8/2;
	uint32_t count32 = count8/4;

	gpio_output_write(&gpio_inst, done_led, 0x0);
	gpio_output_write(&gpio_inst, error_led, 0x0);

//  startup delay for debugging
//	for (uint32_t i = 0; i < 50000000; i++){
//	}

	write_u32_test(hpr32, count32);
	read_u32_test( hpr32, count32);

	write_u16_test(hpr16, count16);
	read_u16_test( hpr16, count16);

	write_u8_test( hpr8,  count8);
	read_u8_test(  hpr8,  count8);

	// indicate the all tests are done
	gpio_output_write(&gpio_inst, done_led, 0xff);

	while (true) {
	}

	return 0;
}

