/*   ==================================================================

     >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2025 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
       DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

    LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
    WHETHER EXPRESSED, IMPLIED, STATUTORY,
    OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
    COMMUNICATION WITH LICENSEE,
    AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
    LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
    LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
    SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
    UNINTERRUPTED OR ERROR FREE,
    OR THAT DEFECTS HEREIN WILL BE CORRECTED.
    LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
    ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
    AND RESULTS OBTAINED THEREFROM.
    LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
    DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
    LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
    CORRECTION,
    OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
    SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
    INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
    INCLUDING LOST PROFITS,
    ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
    EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
    LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
    IS SET FORTH ABOVE.
    LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
    ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
    INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
    RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
    FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
     ------------------------------------------------------------------

     ================================================================== */

#ifndef PIC_H_
#define PIC_H_

#include "util.h"
#include <stdint.h>

#if 0
struct pic_reg {
	volatile uint32_t isrc;
	volatile uint32_t isrs;
	volatile uint32_t isr;
	volatile uint32_t reserved1;
	volatile uint32_t ierc;
	volatile uint32_t iers;
	volatile uint32_t ier;
	volatile uint32_t reserved2;
	volatile uint32_t polc;
	volatile uint32_t pols;
	volatile uint32_t pol;
};
#endif

struct pic_reg {
	volatile uint32_t pic_status;
	volatile uint32_t pic_en;
	volatile uint32_t pic_set;
	volatile uint32_t pic_pol;
};


enum interrupt_src {
	S_INT_PIC0 = 0,
	S_INT_PIC1 = 1,
	S_INT_PIC2 = 2,
	S_INT_PIC3 = 3,
	S_INT_PIC4 = 4,
	S_INT_PIC5 = 5,
	S_INT_PIC6 = 6,
	S_INT_PIC7 = 7,
  S_INT_PIC8 = 8,
  S_INT_PIC9 = 9,
  S_INT_PIC10 = 10,
  S_INT_PIC11 = 11,
  S_INT_PIC12 = 12,
  S_INT_PIC13 = 13,
  S_INT_PIC14 = 14,
  S_INT_PIC15 = 15,
  S_INT_PIC16 = 16,
  S_INT_PIC17 = 17,
  S_INT_PIC18 = 18,
  S_INT_PIC19 = 19,
  S_INT_PIC20 = 20,
  S_INT_PIC21 = 21,
  S_INT_PIC22 = 22,
  S_INT_PIC23 = 23,
  S_INT_PIC24 = 24,
  S_INT_PIC25 = 25,
  S_INT_PIC26 = 26,
  S_INT_PIC27 = 27,
  S_INT_PIC28 = 28,
  S_INT_PIC29 = 29,
  S_INT_PIC30 = 30,
	S_INT_TIMER = 31,
	S_INT_NUM = 32,
};

struct interrupt_entry {
	void (*isr) (void *);	// ISR
	void *context;		// base address of IP
};

uint8_t pic_int_clear(uint8_t src);
uint8_t pic_int_enable(uint8_t src);
uint8_t pic_int_disable(uint8_t src);
uint8_t pic_int_pending(uint8_t src);
uint8_t pic_init(uint32_t base);
uint8_t pic_int_polarity_set(uint8_t src, uint8_t bit);
uint8_t pic_int_polarity_get(uint8_t src, uint8_t *pol);
uint8_t pic_int_status_get(uint32_t *status);
uint8_t pic_isr_register(uint8_t src, void (*isr) (void *),
			       void *context);

#endif				/* PIC_H_ */
